/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.List;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.resource.AnnotatedSpan;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Test;

public class GenericAnnotationsTest {
    @Test
    public void testAddAndRemove() {
        GenericAnnotations anns = new GenericAnnotations();
        Assert.assertFalse(anns.hasAnnotation("type1"));
        GenericAnnotation ann = anns.add("type1");
        Assert.assertTrue(anns.hasAnnotation("type1"));
        anns.remove(ann);
        Assert.assertFalse(anns.hasAnnotation("type1"));
    }

    @Test
    public void testConstructors() {
        GenericAnnotations anns = new GenericAnnotations();
        Assert.assertEquals(null, anns.getData());
        Assert.assertFalse(anns.hasAnnotation("type1"));
        anns = new GenericAnnotations(new GenericAnnotation("type1"));
        Assert.assertEquals(null, anns.getData());
        Assert.assertTrue(anns.hasAnnotation("type1"));
        String storage = anns.toString();
        anns = new GenericAnnotations(storage);
        Assert.assertEquals(null, anns.getData());
        Assert.assertTrue(anns.hasAnnotation("type1"));
    }

    @Test
    public void testToFromString() {
        GenericAnnotations anns1 = new GenericAnnotations(new GenericAnnotation("type1", "field1", "value1"));
        anns1.add("type2-no-fields");
        anns1.setData("dataText");
        String storage = anns1.toString();
        GenericAnnotations anns2 = new GenericAnnotations(storage);
        Assert.assertEquals("dataText", anns2.getData());
        Assert.assertEquals(2L, anns2.getAllAnnotations().size());
        GenericAnnotation ga = anns2.getFirstAnnotation("type1");
        Assert.assertEquals("value1", ga.getString("field1"));
        ga = anns2.getFirstAnnotation("type2-no-fields");
        Assert.assertNotNull(ga);
    }

    @Test
    public void testSeveral() {
        GenericAnnotations anns = new GenericAnnotations();
        GenericAnnotation ann1 = anns.add("type1");
        ann1.setString("name", "v1");
        GenericAnnotation ann2 = anns.add("type1");
        ann2.setString("name", "v2");
        List<GenericAnnotation> list = anns.getAnnotations("type1");
        Assert.assertEquals(2L, list.size());
        Assert.assertEquals("v2", list.get(1).getString("name"));
    }

    @Test
    public void testAddAnnotationsOnTU() {
        GenericAnnotations anns1 = new GenericAnnotations();
        GenericAnnotation ann11 = anns1.add("type1");
        ann11.setString("name1", "v1");
        GenericAnnotation ann12 = anns1.add("type1");
        ann12.setString("name2", "v2-not-over");
        TextUnit tu = new TextUnit("id");
        GenericAnnotations.addAnnotations(tu, anns1);
        GenericAnnotations res = tu.getAnnotation(GenericAnnotations.class);
        Assert.assertNotNull(res);
        Assert.assertEquals(res, anns1);
        GenericAnnotations anns2 = new GenericAnnotations();
        GenericAnnotation ann21 = anns2.add("type1");
        ann21.setString("name3", "v3");
        GenericAnnotation ann22 = anns2.add("type1");
        ann22.setString("name2", "another name2");
        GenericAnnotations.addAnnotations(tu, anns2);
        res = tu.getAnnotation(GenericAnnotations.class);
        Assert.assertNotNull(res);
        Assert.assertEquals(res, anns1);
        List<GenericAnnotation> list = res.getAnnotations("type1");
        Assert.assertEquals(4L, list.size());
        GenericAnnotation ann = list.get(1);
        Assert.assertEquals("v2-not-over", ann.getString("name2"));
    }

    @Test
    public void testAddAnnotationsOnTC() {
        GenericAnnotations anns1 = new GenericAnnotations();
        GenericAnnotation ann11 = anns1.add("type1");
        ann11.setString("name1", "v1");
        GenericAnnotation ann12 = anns1.add("type1");
        ann12.setString("name2", "v2-not-over");
        TextContainer tc = new TextContainer();
        GenericAnnotations.addAnnotations(tc, anns1);
        GenericAnnotations res = tc.getAnnotation(GenericAnnotations.class);
        Assert.assertNotNull(res);
        Assert.assertEquals(res, anns1);
        GenericAnnotations anns2 = new GenericAnnotations();
        GenericAnnotation ann21 = anns2.add("type1");
        ann21.setString("name3", "v3");
        GenericAnnotation ann22 = anns2.add("type1");
        ann22.setString("name2", "another name2");
        GenericAnnotations.addAnnotations(tc, anns2);
        res = tc.getAnnotation(GenericAnnotations.class);
        Assert.assertNotNull(res);
        Assert.assertEquals(res, anns1);
        List<GenericAnnotation> list = res.getAnnotations("type1");
        Assert.assertEquals(4L, list.size());
        GenericAnnotation ann = list.get(1);
        Assert.assertEquals("v2-not-over", ann.getString("name2"));
    }

    @Test
    public void testAddAnnotationsOnCode() {
        GenericAnnotations anns1 = new GenericAnnotations();
        GenericAnnotation ann11 = anns1.add("type1");
        ann11.setString("name1", "v1");
        GenericAnnotation ann12 = anns1.add("type1");
        ann12.setString("name2", "v2-not-over");
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, "z");
        GenericAnnotations.addAnnotations(code, anns1);
        GenericAnnotations res = (GenericAnnotations)code.getAnnotation("generic");
        Assert.assertNotNull(res);
        Assert.assertEquals(res, anns1);
        GenericAnnotations anns2 = new GenericAnnotations();
        GenericAnnotation ann21 = anns2.add("type1");
        ann21.setString("name3", "v3");
        GenericAnnotation ann22 = anns2.add("type1");
        ann22.setString("name2", "another name2");
        GenericAnnotations.addAnnotations(code, anns2);
        res = (GenericAnnotations)code.getAnnotation("generic");
        Assert.assertNotNull(res);
        Assert.assertEquals(res, anns1);
        List<GenericAnnotation> list = res.getAnnotations("type1");
        Assert.assertEquals(4L, list.size());
        GenericAnnotation ann = list.get(1);
        Assert.assertEquals("v2-not-over", ann.getString("name2"));
    }

    @Test
    public void testInContent() {
        GenericAnnotations anns = new GenericAnnotations();
        TextFragment tf = new TextFragment("This is a test.");
        tf.annotate(10, 14, "lqi", anns);
        List<AnnotatedSpan> list = tf.getAnnotatedSpans("lqi");
        Assert.assertEquals(1L, list.size());
        Assert.assertEquals("test", list.get((int)0).span.toString());
    }

    @Test
    public void testAddAll() {
        GenericAnnotations anns1 = new GenericAnnotations();
        GenericAnnotation ann1 = anns1.add("A1-type1");
        ann1.setString("f1", "v1");
        ann1 = anns1.add("A1-type2");
        ann1.setString("f1", "v1");
        GenericAnnotations anns2 = new GenericAnnotations();
        GenericAnnotation ann2 = anns2.add("A1-type1");
        ann2.setString("f1", "v1");
        ann2 = anns2.add("A1-type2");
        ann2.setString("f1", "v1");
        anns2.addAll(anns1);
        Assert.assertEquals(4L, anns2.size());
    }

    @Test
    public void testStorage() {
        GenericAnnotations anns1 = new GenericAnnotations();
        GenericAnnotation ann = anns1.add("type1");
        ann.setString("fs1", "value1");
        ann.setBoolean("fb1", true);
        ann = anns1.add("type1");
        ann.setString("fs1bis", "value1bis");
        ann.setBoolean("fb1bis", false);
        ann = anns1.add("type2");
        ann.setString("fs2", "value2");
        ann.setBoolean("fb2", false);
        anns1.add("typeNoData");
        String buf = anns1.toString();
        GenericAnnotations anns2 = new GenericAnnotations(buf);
        List<GenericAnnotation> list = anns2.getAnnotations("type1");
        Assert.assertEquals("value1", list.get(0).getString("fs1"));
        Assert.assertEquals(true, list.get(0).getBoolean("fb1"));
        Assert.assertEquals("value1bis", list.get(1).getString("fs1bis"));
        Assert.assertEquals(false, list.get(1).getBoolean("fb1bis"));
        Assert.assertEquals("value2", anns2.getAnnotations("type2").get(0).getString("fs2"));
        Assert.assertEquals(false, anns2.getAnnotations("type2").get(0).getBoolean("fb2"));
        Assert.assertEquals(1L, anns2.getAnnotations("typeNoData").size());
    }

    @Test
    public void testITS_LQI() {
        GenericAnnotations anns = new GenericAnnotations();
        GenericAnnotation ann = anns.add("its-lqi");
        ann.setString("lqiType", "typographical");
        ann.setString("lqiComment", "Sentence without capitalization");
        ann.setString("lqiProfileRef", "http://example.org/qaModel/v13");
        ann.setDouble("lqiSeverity", 50.0);
        ann.setBoolean("lqiEnabled", true);
        ann = anns.getAnnotations("its-lqi").get(0);
        Assert.assertEquals(50.0, (double)ann.getDouble("lqiSeverity"), 0.0);
        Assert.assertEquals("typographical", ann.getString("lqiType"));
        Assert.assertEquals("Sentence without capitalization", ann.getString("lqiComment"));
        Assert.assertEquals("http://example.org/qaModel/v13", ann.getString("lqiProfileRef"));
        Assert.assertEquals(true, ann.getBoolean("lqiEnabled"));
    }
}

