/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline;

import java.lang.reflect.Method;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.annotations.ConfigurationParameter;
import net.sf.okapi.common.pipeline.annotations.StepIntrospector;
import net.sf.okapi.common.resource.PipelineParameters;

public abstract class BasePipelineStep
implements IPipelineStep {
    private boolean isLastOutputStep = false;

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public String getHelpLocation() {
        return this.getName() + " Step";
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                event = this.handleStartBatch(event);
                break;
            }
            case END_BATCH: {
                event = this.handleEndBatch(event);
                break;
            }
            case START_BATCH_ITEM: {
                event = this.handleStartBatchItem(event);
                break;
            }
            case END_BATCH_ITEM: {
                event = this.handleEndBatchItem(event);
                break;
            }
            case RAW_DOCUMENT: {
                event = this.handleRawDocument(event);
                break;
            }
            case START_DOCUMENT: {
                event = this.handleStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                event = this.handleEndDocument(event);
                break;
            }
            case START_SUBDOCUMENT: {
                event = this.handleStartSubDocument(event);
                break;
            }
            case END_SUBDOCUMENT: {
                event = this.handleEndSubDocument(event);
                break;
            }
            case START_GROUP: {
                event = this.handleStartGroup(event);
                break;
            }
            case END_GROUP: {
                event = this.handleEndGroup(event);
                break;
            }
            case TEXT_UNIT: {
                event = this.handleTextUnit(event);
                break;
            }
            case DOCUMENT_PART: {
                event = this.handleDocumentPart(event);
                break;
            }
            case CUSTOM: {
                event = this.handleCustom(event);
                break;
            }
            case MULTI_EVENT: {
                event = this.handleMultiEvent(event);
                break;
            }
            case PIPELINE_PARAMETERS: {
                event = this.handlePipelineParameters(event);
                break;
            }
            case START_SUBFILTER: {
                event = this.handleStartSubfilter(event);
                break;
            }
            case END_SUBFILTER: {
                event = this.handleEndSubfilter(event);
                break;
            }
        }
        return event;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isLastOutputStep() {
        return this.isLastOutputStep;
    }

    @Override
    public void setLastOutputStep(boolean isLastStep) {
        this.isLastOutputStep = isLastStep;
    }

    protected Event handleStartBatch(Event event) {
        return event;
    }

    protected Event handleEndBatch(Event event) {
        return event;
    }

    protected Event handleStartBatchItem(Event event) {
        return event;
    }

    protected Event handleEndBatchItem(Event event) {
        return event;
    }

    protected Event handleRawDocument(Event event) {
        return event;
    }

    protected Event handleStartDocument(Event event) {
        return event;
    }

    protected Event handleEndDocument(Event event) {
        return event;
    }

    protected Event handleStartSubDocument(Event event) {
        return event;
    }

    protected Event handleEndSubDocument(Event event) {
        return event;
    }

    protected Event handleStartGroup(Event event) {
        return event;
    }

    protected Event handleEndGroup(Event event) {
        return event;
    }

    protected Event handleTextUnit(Event event) {
        return event;
    }

    protected Event handleDocumentPart(Event event) {
        return event;
    }

    protected Event handleCustom(Event event) {
        return event;
    }

    protected Event handleMultiEvent(Event event) {
        return event;
    }

    protected Event handleEndSubfilter(Event event) {
        return event;
    }

    protected Event handleStartSubfilter(Event event) {
        return event;
    }

    protected Event handlePipelineParameters(Event event) {
        PipelineParameters pp = event.getPipelineParameters();
        List<ConfigurationParameter> pList = StepIntrospector.getStepParameters(this);
        try {
            for (ConfigurationParameter param : pList) {
                Method method = param.getMethod();
                if (method == null) continue;
                switch (param.getParameterType()) {
                    case OUTPUT_URI: {
                        if (pp.getOutputURI() == null) break;
                        method.invoke((Object)param.getStep(), pp.getOutputURI());
                        break;
                    }
                    case FILTER_CONFIGURATION_ID: {
                        if (pp.getFilterConfigurationId() == null) break;
                        method.invoke((Object)param.getStep(), pp.getFilterConfigurationId());
                        break;
                    }
                    case FILTER_CONFIGURATION_MAPPER: {
                        if (pp.getFilterConfigurationMapper() == null) break;
                        method.invoke((Object)param.getStep(), pp.getFilterConfigurationMapper());
                        break;
                    }
                    case INPUT_RAWDOC: {
                        if (pp.getInputRawDocument() == null) break;
                        method.invoke((Object)param.getStep(), pp.getInputRawDocument());
                        break;
                    }
                    case INPUT_ROOT_DIRECTORY: {
                        if (pp.getInputRootDirectory() == null) break;
                        method.invoke((Object)param.getStep(), pp.getInputRootDirectory());
                        break;
                    }
                    case INPUT_URI: {
                        if (pp.getThirdInputRawDocument() == null) break;
                        method.invoke((Object)param.getStep(), pp.getThirdInputRawDocument());
                        break;
                    }
                    case OUTPUT_ENCODING: {
                        if (pp.getOutputEncoding() == null) break;
                        method.invoke((Object)param.getStep(), pp.getOutputEncoding());
                        break;
                    }
                    case ROOT_DIRECTORY: {
                        if (pp.getRootDirectory() == null) break;
                        method.invoke((Object)param.getStep(), pp.getRootDirectory());
                        break;
                    }
                    case SECOND_INPUT_RAWDOC: {
                        if (pp.getSecondInputRawDocument() == null) break;
                        method.invoke((Object)param.getStep(), pp.getSecondInputRawDocument());
                        break;
                    }
                    case SOURCE_LOCALE: {
                        if (pp.getSourceLocale() == null) break;
                        method.invoke((Object)param.getStep(), pp.getSourceLocale());
                        break;
                    }
                    case TARGET_LOCALE: {
                        if (pp.getTargetLocale() == null) break;
                        method.invoke((Object)param.getStep(), pp.getTargetLocale());
                        break;
                    }
                    case TARGET_LOCALES: {
                        if (pp.getTargetLocales() == null) break;
                        method.invoke((Object)param.getStep(), pp.getTargetLocales());
                        break;
                    }
                    case THIRD_INPUT_RAWDOC: {
                        if (pp.getThirdInputRawDocument() == null) break;
                        method.invoke((Object)param.getStep(), pp.getThirdInputRawDocument());
                        break;
                    }
                    case UI_PARENT: {
                        if (pp.getUIParent() == null) break;
                        method.invoke((Object)param.getStep(), pp.getUIParent());
                        break;
                    }
                    case EXECUTION_CONTEXT: {
                        if (pp.getExecutionContext() == null) break;
                        method.invoke((Object)param.getStep(), pp.getExecutionContext());
                        break;
                    }
                    case BATCH_INPUT_COUNT: {
                        if (pp.getBatchInputCount() == -1) break;
                        method.invoke((Object)param.getStep(), pp.getBatchInputCount());
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error when setting pipeline parameter.\n" + e.getMessage(), e);
        }
        return event;
    }
}

