/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline;

import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.Consumer;
import net.sf.okapi.common.pipeline.ConsumerProducer;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.pipeline.PipelineReturnValue;
import net.sf.okapi.common.pipeline.Producer;
import net.sf.okapi.common.resource.RawDocument;
import org.junit.Assert;
import org.junit.Test;

public class SimplePipelineWithCancelTest {
    @Test
    public void runPipelineAndCancel() throws URISyntaxException, InterruptedException {
        final Pipeline pipeline = new Pipeline();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                pipeline.addStep(new Producer());
                pipeline.addStep(new ConsumerProducer());
                pipeline.addStep(new Consumer());
                pipeline.process(new RawDocument("DUMMY", LocaleId.fromString("en")));
            }
        };
        ExecutorService e = Executors.newSingleThreadExecutor();
        e.execute(runnable);
        Thread.sleep(500L);
        pipeline.cancel();
        Assert.assertEquals((Object)PipelineReturnValue.CANCELLED, (Object)pipeline.getState());
        pipeline.destroy();
        e.shutdownNow();
        Assert.assertEquals((Object)PipelineReturnValue.DESTROYED, (Object)pipeline.getState());
    }
}

