/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodeTest {
    @Before
    public void setUp() {
    }

    @Test
    public void testAccess() {
        Code code = new Code(TextFragment.TagType.OPENING, "ctype", "data");
        Assert.assertEquals("data", code.getData());
        Assert.assertEquals("ctype", code.getType());
        Assert.assertEquals((Object)TextFragment.TagType.OPENING, (Object)code.getTagType());
        Assert.assertEquals("data", code.getOuterData());
        code.setOuterData("outerData");
        Assert.assertEquals("outerData", code.getOuterData());
        Assert.assertEquals("data", code.getData());
    }

    @Test
    public void testSimpleAnnotations() {
        Code code = new Code(TextFragment.TagType.OPENING, "ctype", "data");
        code.setAnnotation("displayText", new InlineAnnotation("[display]"));
        Assert.assertEquals("[display]", code.getAnnotation("displayText").getData());
        GenericAnnotation.addAnnotation(code, new GenericAnnotation("disp", "disp_value", "[display]"));
        Assert.assertEquals("[display]", code.getGenericAnnotationString("disp", "disp_value"));
    }

    @Test
    public void testFlags() {
        Code code = new Code(TextFragment.TagType.OPENING, "ctype", "data");
        Assert.assertFalse(code.isCloneable());
        Assert.assertFalse(code.isDeleteable());
        Assert.assertFalse(code.hasReference());
        code.setDeleteable(true);
        code.setCloneable(true);
        code.setReferenceFlag(true);
        Assert.assertTrue(code.isCloneable());
        Assert.assertTrue(code.isDeleteable());
        Assert.assertTrue(code.hasReference());
    }

    @Test
    public void testClone() {
        Code code = new Code(TextFragment.TagType.OPENING, "ctype", "data");
        code.setOuterData("out1");
        Code c2 = code.clone();
        Assert.assertNotSame(c2, code);
        Assert.assertEquals(c2.getId(), code.getId());
        Assert.assertEquals(c2.getData(), code.getData());
        Assert.assertNotSame(c2.data, code.data);
        Assert.assertEquals((Object)c2.getTagType(), (Object)code.getTagType());
        Assert.assertEquals(c2.getType(), code.getType());
        Assert.assertEquals(c2.getOuterData(), code.getOuterData());
        Assert.assertNotSame(c2.outerData, code.outerData);
    }

    @Test
    public void testStrings() {
        ArrayList<Code> codes = new ArrayList<Code>();
        codes.add(new Code(TextFragment.TagType.OPENING, "bold", "<b>"));
        codes.add(new Code(TextFragment.TagType.PLACEHOLDER, "break", "<br/>"));
        codes.add(new Code(TextFragment.TagType.CLOSING, "bold", "</b>"));
        String tmp = Code.codesToString(codes);
        Assert.assertNotNull(tmp);
        List<Code> codesAfter = Code.stringToCodes(tmp);
        Assert.assertEquals(3L, codesAfter.size());
        Code code = codesAfter.get(0);
        Assert.assertEquals("<b>", code.getData());
        Assert.assertEquals((Object)TextFragment.TagType.OPENING, (Object)code.getTagType());
        Assert.assertEquals("bold", code.getType());
        code = codesAfter.get(1);
        Assert.assertEquals("<br/>", code.getData());
        Assert.assertEquals((Object)TextFragment.TagType.PLACEHOLDER, (Object)code.getTagType());
        Assert.assertEquals("break", code.getType());
        code = codesAfter.get(2);
        Assert.assertEquals("</b>", code.getData());
        Assert.assertEquals((Object)TextFragment.TagType.CLOSING, (Object)code.getTagType());
        Assert.assertEquals("bold", code.getType());
    }

    @Test
    public void testCodeData() {
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, "type", null);
        Assert.assertEquals("", code.toString());
        code = new Code(TextFragment.TagType.PLACEHOLDER, "type", null);
        code.setOuterData("<x id=\"1\">");
        Assert.assertEquals("", code.toString());
        code.setOuterData(null);
        Assert.assertEquals("", code.toString());
    }
}

