/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.AnnotatedSpan;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.InvalidPositionException;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextFragmentTest {
    private GenericContent fmt;

    @Before
    public void setUp() throws Exception {
        this.fmt = new GenericContent();
    }

    @Test
    public void testConstructors() {
        TextFragment tf1 = new TextFragment();
        Assert.assertTrue(tf1.isEmpty());
        Assert.assertNotNull(tf1.toText());
        Assert.assertNotNull(tf1.getCodedText());
        tf1 = new TextFragment("text");
        Assert.assertFalse(tf1.isEmpty());
        TextFragment tf2 = new TextFragment(tf1);
        Assert.assertEquals(tf1.toText(), tf2.toText());
        Assert.assertNotSame(tf1, tf2);
    }

    @Test
    public void testAppend() {
        TextFragment tf1 = new TextFragment();
        tf1.append('c');
        Assert.assertEquals(tf1.toText(), "c");
        tf1 = new TextFragment();
        tf1.append("string");
        Assert.assertEquals(tf1.toText(), "string");
        tf1.append('c');
        Assert.assertEquals(tf1.toText(), "stringc");
        TextFragment tf2 = new TextFragment();
        tf2.append(tf1);
        Assert.assertEquals(tf2.toText(), "stringc");
        Assert.assertNotSame(tf1, tf2);
        Assert.assertFalse(tf1.hasCode());
        tf1 = new TextFragment("string");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        String s1 = tf1.getCodedText();
        s1 = s1.toUpperCase();
        Assert.assertEquals(tf1.toText(), "string<br/>");
        tf1.setCodedText(s1);
        Assert.assertEquals(tf1.toText(), "STRING<br/>");
        tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        Assert.assertTrue(tf1.hasCode());
        Code code = tf1.getCode(0);
        Assert.assertEquals(code.getData(), "<br/>");
        Assert.assertEquals(tf1.toText(), "<br/>");
    }

    @Test
    public void testAppend2() {
        TextFragment tf = new TextFragment();
        tf.append(new Code(TextFragment.TagType.OPENING, "x", "[1]"));
        tf.append("AAAA");
        tf.append(new Code(TextFragment.TagType.CLOSING, "x", "[/1]"));
        Assert.assertEquals("<1>AAAA</1>", new GenericContent(tf).toString());
        tf.append(new Code(TextFragment.TagType.OPENING, "x", "[2]"));
        tf.append(new Code(TextFragment.TagType.PLACEHOLDER, "x", "[3/]"));
        tf.append(new Code(TextFragment.TagType.CLOSING, "x", "[/2]"));
        Assert.assertEquals("<1>AAAA</1><2><3/></2>", new GenericContent(tf).toString());
        tf.append(new Code(TextFragment.TagType.OPENING, "x", "[4]"));
        tf.append("BBBB");
        tf.append(new Code(TextFragment.TagType.CLOSING, "x", "[/4]"));
        Assert.assertEquals("<1>AAAA</1><2><3/></2><4>BBBB</4>", new GenericContent(tf).toString());
        tf.append(new Code(TextFragment.TagType.OPENING, "x", "[5]"));
        tf.append(new Code(TextFragment.TagType.PLACEHOLDER, "x", "[6/]"));
        tf.append(new Code(TextFragment.TagType.CLOSING, "x", "[/5]"));
        Assert.assertEquals("<1>AAAA</1><2><3/></2><4>BBBB</4><5><6/></5>", new GenericContent(tf).toString());
        TextFragment tf2 = new TextFragment();
        tf2.append(new Code(TextFragment.TagType.OPENING, "x", "[7]"));
        tf2.append(tf);
        tf2.append(new Code(TextFragment.TagType.CLOSING, "x", "[/7]"));
        Assert.assertEquals("[7][1]AAAA[/1][2][3/][/2][4]BBBB[/4][5][6/][/5][/7]", new GenericContent(tf2).toString(true));
        Assert.assertEquals("<1><2>AAAA</2><3><4/></3><5>BBBB</5><6><7/></6></1>", new GenericContent(tf2).toString());
    }

    @Test
    public void testAppendWithDifferentCodeIDs() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "a", "[A/]");
        Assert.assertEquals(1L, tf1.getCode(0).getId());
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "b", "[B/]");
        Assert.assertEquals(1L, tf2.getCode(0).getId());
        tf1.append(' ');
        tf1.append(tf2);
        Assert.assertEquals("[A/] [B/]", tf1.toText());
        Assert.assertEquals(1L, tf1.getCode(0).getId());
        Assert.assertEquals(2L, tf1.getCode(1).getId());
    }

    @Test
    public void testInsertWithCodes_12_123_12345() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "a", "a");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "b", "b");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "c", "c");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "d", "d");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "e", "e");
        tf1.insert(-1, tf2);
        Assert.assertEquals("abcde", tf1.toText());
        Assert.assertEquals("<1/><2/><3/><4/><5/>", this.fmt.setContent(tf1).toString());
    }

    @Test
    public void testInsertWithCodes_145_134_145689() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "a", "a");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "b", "b", 4);
        tf1.append(TextFragment.TagType.PLACEHOLDER, "c", "c", 5);
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "d", "d");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "e", "e", 3);
        tf2.append(TextFragment.TagType.PLACEHOLDER, "f", "f", 4);
        tf1.insert(-1, tf2);
        Assert.assertEquals("abcdef", tf1.toText());
        Assert.assertEquals("<1/><4/><5/><6/><8/><9/>", this.fmt.setContent(tf1).toString());
    }

    @Test
    public void testInsertWithCodes_12_345_12345() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "a", "a");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "b", "b");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "c", "c", 3);
        tf2.append(TextFragment.TagType.PLACEHOLDER, "d", "d", 4);
        tf2.append(TextFragment.TagType.PLACEHOLDER, "e", "e", 5);
        tf1.insert(-1, tf2);
        Assert.assertEquals("abcde", tf1.toText());
        Assert.assertEquals("<1/><2/><3/><4/><5/>", this.fmt.setContent(tf1).toString());
    }

    @Test
    public void testInsertWithCodes_13_M3M_13768() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "a", "a");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "b", "b", 3);
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "C", "C", -2);
        tf2.append(TextFragment.TagType.PLACEHOLDER, "d", "d", 3);
        tf2.append(TextFragment.TagType.PLACEHOLDER, "E", "E", -3);
        tf1.insert(-1, tf2);
        Assert.assertEquals("abCdE", tf1.toText());
        Assert.assertEquals("<1/><3/><7/><6/><8/>", this.fmt.setContent(tf1).toString());
    }

    @Test
    public void testInsert() {
        TextFragment tf1 = new TextFragment();
        tf1.insert(0, new TextFragment("[ins1]"));
        Assert.assertEquals(tf1.toText(), "[ins1]");
        tf1.insert(4, new TextFragment("ertion"));
        Assert.assertEquals(tf1.toText(), "[insertion1]");
        tf1.insert(0, new TextFragment("<"));
        Assert.assertEquals(tf1.toText(), "<[insertion1]");
        tf1.insert(13, new TextFragment(">"));
        Assert.assertEquals(tf1.toText(), "<[insertion1]>");
        tf1.insert(-1, new TextFragment("$"));
        Assert.assertEquals(tf1.toText(), "<[insertion1]>$");
        tf1 = new TextFragment();
        tf1.insert(0, new TextFragment("abc"));
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        tf1.insert(1, tf2);
        Code code = tf1.getCode(0);
        Assert.assertEquals(code.getData(), "<br/>");
        Assert.assertEquals(this.fmt.setContent(tf1).toString(true), "a<br/>bc");
        tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf1.insert(4, tf2);
        tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf1.insert(7, tf2);
        tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf1.insert(-1, tf2);
        Assert.assertEquals(tf1.toText(), "a<br/>b<b>c</b><x/>");
    }

    @Test
    public void testAppendWithSameID() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf1.append("T1.");
        TextFragment tf2 = new TextFragment(" T2");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf2.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        Assert.assertEquals(tf1.getCodes().get((int)0).id, tf2.getCodes().get((int)0).id);
        Assert.assertEquals(2L, tf2.getCodes().get((int)1).id);
        tf1.append(tf2);
        List<Code> codes = tf1.getCodes();
        Assert.assertEquals(1L, codes.get((int)0).id);
        Assert.assertEquals(1L, codes.get((int)2).id);
    }

    @Test
    public void testRemove() {
        TextFragment tf1 = this.makeFragment1();
        Assert.assertEquals(this.fmt.setContent(tf1).toString(true), "[b]A[br/]B[/b]C");
        tf1.remove(2, 3);
        tf1.remove(4, 5);
        tf1.remove(6, 7);
        Assert.assertFalse(tf1.hasText(true));
        Assert.assertEquals(tf1.getCodedText().length(), 6L);
        Assert.assertEquals(tf1.toText(), "[b][br/][/b]");
        tf1 = this.makeFragment1();
        tf1.remove(0, 2);
        tf1.remove(1, 3);
        tf1.remove(2, 4);
        Assert.assertFalse(tf1.hasCode());
        Assert.assertEquals(tf1.getCodedText().length(), 3L);
        Assert.assertEquals(tf1.toText(), "ABC");
    }

    @Test
    public void testInlines() {
        TextFragment tf1 = this.makeFragment1();
        Assert.assertTrue(tf1.hasCode());
        Assert.assertEquals(tf1.toText(), "[b]A[br/]B[/b]C");
        Assert.assertEquals(tf1.getCode(0).getData(), "[b]");
        Assert.assertEquals(tf1.getCode(1).getData(), "[br/]");
        Assert.assertEquals(tf1.getCode(2).getData(), "[/b]");
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1>A<2/>B</1>C");
        tf1.remove(0, 2);
        Assert.assertEquals(tf1.toText(), "A[br/]B[/b]C");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf1.insert(0, tf2);
        Code code1 = new Code(TextFragment.TagType.PLACEHOLDER, "type", "data");
        code1.setReferenceFlag(true);
        code1.setId(100);
        code1.setOuterData("outer");
        Assert.assertEquals(code1.getType(), "type");
        Assert.assertEquals(code1.getData(), "data");
        Assert.assertEquals(code1.getOuterData(), "outer");
        Assert.assertEquals(code1.getId(), 100L);
        Assert.assertEquals((Object)code1.getTagType(), (Object)TextFragment.TagType.PLACEHOLDER);
        tf1 = new TextFragment();
        Code code2 = tf1.append(code1);
        Code code3 = tf1.getCode(0);
        Assert.assertSame(code1, code2);
        Assert.assertSame(code2, code3);
        code1 = null;
        Assert.assertEquals(code2.getType(), "type");
        Assert.assertEquals(code2.getData(), "data");
        Assert.assertEquals(code2.getOuterData(), "outer");
        Assert.assertEquals(code2.getId(), 100L);
        Assert.assertEquals((Object)code2.getTagType(), (Object)TextFragment.TagType.PLACEHOLDER);
        Code code4 = code2.clone();
        Assert.assertNotSame(code4, code2);
        Assert.assertEquals(code4.getType(), "type");
        Assert.assertEquals(code4.getData(), "data");
        Assert.assertEquals(code4.getOuterData(), "outer");
        Assert.assertEquals(code4.getId(), 100L);
        Assert.assertEquals((Object)code4.getTagType(), (Object)TextFragment.TagType.PLACEHOLDER);
        code1 = new Code(TextFragment.TagType.PLACEHOLDER, "t", "d");
        Assert.assertFalse(code1.hasReference());
        Assert.assertFalse(code1.isCloneable());
        Assert.assertFalse(code1.isDeleteable());
        code2 = code1.clone();
        Assert.assertFalse(code2.hasReference());
        Assert.assertFalse(code2.isCloneable());
        Assert.assertFalse(code2.isDeleteable());
        code1.setReferenceFlag(true);
        code1.setCloneable(true);
        code1.setDeleteable(true);
        Assert.assertTrue(code1.hasReference());
        Assert.assertTrue(code1.isCloneable());
        Assert.assertTrue(code1.isDeleteable());
        code1.setReferenceFlag(false);
        Assert.assertFalse(code1.hasReference());
        Assert.assertTrue(code1.isCloneable());
        Assert.assertTrue(code1.isDeleteable());
        code1.setCloneable(false);
        Assert.assertFalse(code1.hasReference());
        Assert.assertFalse(code1.isCloneable());
        Assert.assertTrue(code1.isDeleteable());
        code1.setDeleteable(false);
        Assert.assertFalse(code1.hasReference());
        Assert.assertFalse(code1.isCloneable());
        Assert.assertFalse(code1.isDeleteable());
        code1.setReferenceFlag(true);
        code1.setDeleteable(true);
        Assert.assertTrue(code1.hasReference());
        Assert.assertFalse(code1.isCloneable());
        Assert.assertTrue(code1.isDeleteable());
        tf1 = new TextFragment();
        tf1.append(code1);
        String codesStorage1 = Code.codesToString(tf1.getCodes());
        String textStorage1 = tf1.getCodedText();
        Assert.assertNotNull(codesStorage1);
        Assert.assertNotNull(textStorage1);
        tf2 = new TextFragment();
        tf2.setCodedText(textStorage1, Code.stringToCodes(codesStorage1));
        Assert.assertEquals(tf1.toText(), tf2.toText());
        String codesStorage2 = Code.codesToString(tf2.getCodes());
        String textStorage2 = tf2.getCodedText();
        Assert.assertEquals(codesStorage1, codesStorage2);
        Assert.assertEquals(textStorage1, textStorage2);
    }

    @Test
    public void testCodedText() {
        TextFragment tf1 = this.makeFragment1();
        Assert.assertEquals(tf1.getCodedText().length(), 9L);
        Assert.assertEquals(tf1.getCodedText(3, 5).length(), 2L);
        String codedText = tf1.getCodedText();
        List<Code> codes = tf1.getCodes();
        TextFragment tf2 = new TextFragment();
        tf2.setCodedText(codedText, codes);
        Assert.assertEquals(tf1.toText(), tf2.toText());
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), this.fmt.setContent(tf2).toString(false));
        Assert.assertNotSame(tf1, tf2);
        codes = null;
        codes = tf1.getCodes(0, 5);
        Assert.assertNotNull(codes);
        Assert.assertEquals(codes.size(), 2L);
        Assert.assertEquals(codes.get(0).getData(), "[b]");
        Assert.assertEquals(codes.get(1).getData(), "[br/]");
    }

    @Test
    public void testHasText() {
        TextFragment tf1 = new TextFragment();
        Assert.assertFalse(tf1.hasText(true));
        Assert.assertFalse(tf1.hasText(false));
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        Assert.assertFalse(tf1.hasText(true));
        Assert.assertFalse(tf1.hasText(false));
        tf1.append('\t');
        Assert.assertTrue(tf1.hasText(true));
        Assert.assertFalse(tf1.hasText(false));
        tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        tf1.append('c');
        Assert.assertTrue(tf1.hasText(true));
        Assert.assertTrue(tf1.hasText(false));
    }

    @Test
    public void testGetText() {
        TextFragment frag = new TextFragment("watch out for ");
        frag.append(TextFragment.TagType.OPENING, "b", "<b>");
        frag.append("the killer");
        frag.append(TextFragment.TagType.CLOSING, "b", "</b>");
        frag.append(" rabbit");
        Assert.assertEquals("watch out for the killer rabbit", frag.getText());
    }

    @Test
    public void testHasCode() {
        TextFragment tf1 = new TextFragment();
        Assert.assertFalse(tf1.hasCode());
        tf1.append('\t');
        Assert.assertFalse(tf1.hasCode());
        tf1.append('c');
        Assert.assertFalse(tf1.hasCode());
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        Assert.assertTrue(tf1.hasCode());
    }

    @Test
    public void testSubSequenceSimple() {
        TextFragment tf = new TextFragment("abc");
        Assert.assertEquals("a", tf.subSequence(0, 1).toText());
        Assert.assertEquals("b", tf.subSequence(1, 2).toText());
        Assert.assertEquals("c", tf.subSequence(2, 3).toText());
        Assert.assertEquals("bc", tf.subSequence(1, 3).toText());
        Assert.assertEquals("abc", tf.subSequence(0, -1).toText());
        TextFragment res = tf.subSequence(1, -1);
        Assert.assertEquals("bc", res.toText());
    }

    @Test
    public void testSubSequenceWithCodes() {
        TextFragment tf = this.makeFragment1();
        Assert.assertEquals("[b]A", tf.subSequence(0, 3).toText());
        TextFragment res = tf.subSequence(3, -1);
        Assert.assertEquals("[br/]B[/b]C", res.toText());
        Assert.assertEquals(2L, res.getCodes().size());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubSequenceError() {
        TextFragment tf = new TextFragment("abc");
        tf.subSequence(3, 4);
    }

    @Test
    public void testCharAt() {
        TextFragment tf = new TextFragment("abc");
        Assert.assertEquals(97L, tf.charAt(0));
        Assert.assertEquals(99L, tf.charAt(2));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCharAtError() {
        TextFragment tf = new TextFragment("");
        tf.charAt(1);
    }

    @Test
    public void testLengthSimple() {
        TextFragment tf = new TextFragment();
        Assert.assertEquals(0L, tf.length());
        tf.append("abc");
        Assert.assertEquals(3L, tf.length());
        Assert.assertEquals(tf.length(), tf.toText().length());
    }

    @Test
    public void testLengthWithCodes() {
        TextFragment tf = this.makeFragment1();
        Assert.assertEquals(9L, tf.length());
        Assert.assertEquals(15L, tf.toText().length());
    }

    @Test
    public void testCharSequence() {
        TextFragment tf = new TextFragment("ABC");
        Pattern pat = Pattern.compile("[bB]");
        Assert.assertTrue(pat.matcher(tf).find());
        Assert.assertNotNull(new StringBuilder(tf));
    }

    @Test
    public void testToStringNoCodes() {
        TextFragment tf = new TextFragment("abc");
        Assert.assertEquals(tf.toText(), tf.toString());
    }

    @Test
    public void testToStringWithCodes() {
        TextFragment tf = this.makeFragment1();
        Assert.assertFalse(tf.toText().equals(tf.toString()));
        Assert.assertEquals(tf.charAt(3), tf.toString().charAt(3));
    }

    @Test
    public void testAppendableSeparated() {
        TextFragment tf = new TextFragment();
        StringBuilder csq1 = new StringBuilder("bc");
        StringBuilder csq2 = new StringBuilder("[d]");
        tf.append('a');
        tf.append(csq1);
        tf.append(csq2, 1, 2);
        Assert.assertEquals("abcd", tf.toText());
    }

    @Test
    public void testAppendableTFInTF() {
        TextFragment tfA = new TextFragment("a");
        TextFragment tf1 = this.makeFragment1();
        TextFragment tfB = new TextFragment("b");
        Assert.assertEquals("a[b]A[br/]B[/b]Cb", tfA.append(tf1).append(tfB).toText());
    }

    @Test
    public void testAppendableTFInTFNested() {
        TextFragment tfA = new TextFragment("a");
        TextFragment tf1 = this.makeFragment1();
        TextFragment tfB = new TextFragment("b");
        Assert.assertEquals("a[b]A[br/]B[/b]Cb", tfA.append(tf1.append(tfB)).toText());
    }

    @Test
    public void testAppendableTFInSB() {
        TextFragment tf1 = this.makeFragment1();
        StringBuilder sb = new StringBuilder("xyz");
        TextFragment tfB = new TextFragment("b");
        sb.append(tf1.append(tfB));
        tf1.setCodedText(sb.toString());
        Assert.assertEquals("xyz[b]A[br/]B[/b]Cb", tf1.toText());
    }

    @Test
    public void testAppendableSelf() {
        TextFragment tf = this.makeFragment1();
        Assert.assertEquals("[b]A[br/]B[/b]C[b]A[br/]B[/b]C", tf.append(tf).toText());
        Code c1 = tf.codes.get(1);
        Code c2 = tf.codes.get(4);
        Assert.assertEquals(c1.toString(), c2.toString());
        Assert.assertFalse(c1 == c2);
    }

    @Test
    public void testAppendableTogether() throws IOException {
        TextFragment tf = new TextFragment();
        StringBuilder csq1 = new StringBuilder("bc");
        StringBuilder csq2 = new StringBuilder("[d]");
        tf.append('a').append(csq1).append(csq2, 1, 2);
        Assert.assertEquals("abcd", tf.toText());
    }

    @Test
    public void testAppendableNull() throws IOException {
        TextFragment tf = new TextFragment();
        CharSequence csq1 = null;
        tf.append('a').append(csq1).append(csq1, 1, 2);
        Assert.assertEquals("anullu", tf.toText());
    }

    @Test
    public void testTextCodesChanges() {
        TextFragment tf1 = new TextFragment("<b>New file:</b> %s");
        int diff = tf1.changeToCode(0, 3, TextFragment.TagType.OPENING, "b");
        diff += tf1.changeToCode(12 + diff, 16 + diff, TextFragment.TagType.CLOSING, "b");
        List<Code> list1 = tf1.getCodes();
        Assert.assertEquals(list1.get(0).getData(), "<b>");
        Assert.assertEquals(list1.get(1).getData(), "</b>");
        Assert.assertEquals(tf1.toText(), "<b>New file:</b> %s");
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1>New file:</1> %s");
        tf1.annotate(17 + diff, 19 + diff, "protected", null);
        Assert.assertEquals(tf1.toText(), "<b>New file:</b> %s");
        list1 = tf1.getCodes();
        Assert.assertTrue(list1.get(2).hasAnnotation());
        Assert.assertTrue(list1.get(2).hasAnnotation("protected"));
        Assert.assertEquals(this.fmt.setContent(tf1).toString(true), "<b>New file:</b> %s");
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1>New file:</1> <2>%s</2>");
        String codesStorage1 = Code.codesToString(tf1.getCodes());
        String textStorage1 = tf1.getCodedText();
        Assert.assertNotNull(codesStorage1);
        Assert.assertNotNull(textStorage1);
        TextFragment tf2 = new TextFragment();
        tf2.setCodedText(textStorage1, Code.stringToCodes(codesStorage1));
        Assert.assertEquals(tf1.toText(), tf2.toText());
        List<Code> list2 = tf2.getCodes();
        Assert.assertTrue(list1.get(2).hasAnnotation());
        Assert.assertTrue(list1.get(2).hasAnnotation("protected"));
        Assert.assertEquals(this.fmt.setContent(tf2).toString(true), "<b>New file:</b> %s");
        Assert.assertEquals(this.fmt.setContent(tf2).toString(false), "<1>New file:</1> <2>%s</2>");
        tf1.annotate(2, 5, "term", new InlineAnnotation("Nouveau"));
        Assert.assertEquals(this.fmt.setContent(tf1).toString(true), "<b>New file:</b> %s");
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1><3>New</3> file:</1> <2>%s</2>");
        InlineAnnotation annot1 = list1.get(4).getAnnotation("term");
        InlineAnnotation annot2 = list1.get(5).getAnnotation("term");
        Assert.assertSame(annot1, annot2);
        annot1.setData("new data");
        Assert.assertEquals(annot2.toString(), "new data");
        annot2.setData("Nouveau");
        Assert.assertEquals(annot1.toString(), "Nouveau");
        Assert.assertEquals(list1.get(4).getAnnotation("term").toString(), annot2.toString());
        Code c1 = list1.get(4);
        Code c2 = c1.clone();
        annot1 = c1.getAnnotation("term");
        annot2 = c2.getAnnotation("term");
        Assert.assertNotSame(annot1, annot2);
        tf2 = new TextFragment();
        tf2.setCodedText(tf1.getCodedText(), Code.stringToCodes(Code.codesToString(tf1.getCodes())));
        Assert.assertEquals(tf1.toText(), tf2.toText());
        list2 = tf2.getCodes();
        Assert.assertTrue(list2.get(2).hasAnnotation());
        Assert.assertTrue(list2.get(2).hasAnnotation("protected"));
        Assert.assertTrue(list2.get(4).hasAnnotation("term"));
        InlineAnnotation annotation = list2.get(4).getAnnotation("term");
        Assert.assertEquals(annotation.getData(), "Nouveau");
        annotation.setData("Neue");
        list1 = tf1.getCodes();
        Assert.assertEquals(list1.get(4).getAnnotation("term").getData(), "Nouveau");
        Assert.assertEquals(list2.get(4).getAnnotation("term").getData(), "Neue");
        tf1.annotate(2, 15, "mt", new InlineAnnotation("MT1"));
        tf1.annotate(2, 15, "term", new InlineAnnotation("TERM2"));
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1><3>New</3> file:</1> <2>%s</2>");
        list1 = tf1.getCodes();
        Assert.assertEquals(list1.get(0).getAnnotation("mt").getData(), "MT1");
        Assert.assertEquals(list1.get(0).getAnnotation("term").getData(), "TERM2");
        List<AnnotatedSpan> spans = tf1.getAnnotatedSpans("term");
        Assert.assertEquals(spans.size(), 2L);
        Assert.assertEquals(this.fmt.setContent(spans.get((int)0).span).toString(true), "New file:");
        Assert.assertEquals(this.fmt.setContent(spans.get((int)0).span).toString(false), "<3>New</3> file:");
        Assert.assertEquals(this.fmt.setContent(spans.get((int)1).span).toString(true), "New");
        Assert.assertEquals(this.fmt.setContent(spans.get((int)1).span).toString(false), "New");
        Assert.assertEquals(spans.get((int)0).range.start, 2L);
        Assert.assertEquals(spans.get((int)0).range.end, 15L);
        Assert.assertEquals(spans.get((int)1).range.start, 4L);
        Assert.assertEquals(spans.get((int)1).range.end, 7L);
        Assert.assertTrue(tf1.hasAnnotation());
        list1.get(0).removeAnnotations();
        Assert.assertTrue(tf1.hasAnnotation());
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1><3>New</3> file:</1> <2>%s</2>");
        Assert.assertFalse(list1.get(0).hasAnnotation());
        int n = list1.size();
        list1.get(4).removeAnnotations();
        Assert.assertEquals(list1.size(), n);
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1><3>New</3> file:</1> <2>%s</2>");
        tf1.removeAnnotations();
        Assert.assertFalse(tf1.hasAnnotation());
        Assert.assertEquals(this.fmt.setContent(tf1).toString(true), "<b>New file:</b> %s");
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1>New file:</1> %s");
        tf1 = new TextFragment("w1 ");
        tf1.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf1.append("w2 w3");
        tf1.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf1.append(" w4 ");
        tf1.append(TextFragment.TagType.OPENING, "i", "<i>");
        tf1.append("w5 w6");
        tf1.append(TextFragment.TagType.CLOSING, "i", "</i>");
        tf1.append(" w7");
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "w1 <1>w2 w3</1> w4 <2>w5 w6</2> w7");
        tf1.annotate(5, 10, "a1", null);
        Assert.assertTrue(tf1.hasAnnotation("a1"));
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "w1 <1>w2 w3</1> w4 <2>w5 w6</2> w7");
        tf1.annotate(3, 12, "a2", null);
        Assert.assertTrue(tf1.hasAnnotation("a2"));
        tf1.annotate(5, 7, "a3", null);
        Assert.assertTrue(tf1.hasAnnotation("a3"));
        tf1.annotate(12, 14, "a4", null);
        Assert.assertTrue(tf1.hasAnnotation("a4"));
        tf1.removeAnnotations();
        Assert.assertFalse(tf1.hasAnnotation());
        tf1.annotate(0, 7, "a5", null);
        spans = tf1.getAnnotatedSpans("a5");
    }

    @Test(expected=InvalidPositionException.class)
    public void testGetCodedTextWithBadRange() {
        TextFragment tf = this.makeFragment1();
        tf.getCodedText(1, 3);
    }

    @Test
    public void testCompareToSameString() {
        TextFragment tf = new TextFragment("text of the fragment");
        Assert.assertEquals(0L, tf.compareTo("text of the fragment"));
    }

    @Test
    public void testCompareToDifferentString() {
        TextFragment tf = new TextFragment("text of the fragment");
        Assert.assertFalse(0 == tf.compareTo("Text Of The Fragment"));
    }

    @Test
    public void testCompareToSameFragment() {
        TextFragment tf1 = new TextFragment("text of the fragment");
        TextFragment tf2 = new TextFragment("text of the fragment");
        Assert.assertEquals(0L, tf1.compareTo(tf2));
        Assert.assertEquals(0L, tf1.compareTo(tf2, true));
    }

    @Test
    public void testCompareToDifferentFragment() {
        TextFragment tf1 = new TextFragment("text of the fragment");
        TextFragment tf2 = new TextFragment("text Of The Fragment");
        Assert.assertFalse(0 == tf1.compareTo(tf2));
        Assert.assertFalse(0 == tf1.compareTo(tf2, true));
    }

    @Test
    public void testCompareToSameFragmentWithSameCodes() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment1();
        Assert.assertEquals(0L, tf1.compareTo(tf2, true));
    }

    @Test
    public void testCompareToWithNoCodesAndCodes() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = new TextFragment("ABC");
        Assert.assertEquals(0L, tf1.compareTo(tf2, false));
        Assert.assertTrue(0 != tf1.compareTo(tf2, true));
    }

    @Test
    public void testCloneCodes() {
        TextFragment tf = this.makeFragment3();
        List<Code> list1 = tf.getCodes();
        List<Code> list2 = tf.getClonedCodes();
        Assert.assertEquals(list1.size(), list2.size());
        for (int i = 0; i < list1.size(); ++i) {
            Code c1 = list1.get(i);
            Code c2 = list2.get(i);
            Assert.assertNotSame(c1, c2);
            Assert.assertEquals(c1.getId(), c2.getId());
            Assert.assertEquals(c1.getData(), c2.getData());
            Assert.assertEquals(c1.type, c2.getType());
        }
    }

    @Test
    public void testCompareToSameFragmentWithDifferentCodes() {
        TextFragment tf1 = this.makeFragment1();
        tf1.getCodes().get(0).setData("[zzz]");
        TextFragment tf2 = this.makeFragment1();
        Assert.assertTrue(0 == tf1.compareTo(tf2, false));
        Assert.assertFalse(0 == tf1.compareTo(tf2, true));
    }

    @Test
    public void testCompareWithSamePrefix() {
        TextFragment tf1 = new TextFragment("Message for ID name200");
        TextFragment tf2 = new TextFragment("Message for ID name200 (a nonmatch during diff)");
        Assert.assertFalse(0 == tf1.compareTo(tf2));
        Assert.assertFalse(0 == tf1.compareTo(tf2, true));
    }

    @Test
    public void testSynchronizeCodeIdentifiers() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment2();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1>A<2/>B</1>C");
        Assert.assertEquals(this.fmt.setContent(tf2).toString(false), "<2/>A<1>B</1>C");
    }

    @Test
    public void testSynchronizeCodeIdentifiersComplex() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment3();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1>A<2/>B</1>C");
        Assert.assertEquals(this.fmt.setContent(tf2).toString(false), "<3><2/>A</3>B<1>C</1>D<4/>");
    }

    @Test
    public void testSynchronizeCodeIdentifiersMoreComplex() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment4();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1>A<2/>B</1>C");
        Assert.assertEquals(this.fmt.setContent(tf2).toString(false), "<2/>A<3>B</3>C");
    }

    @Test
    public void testSynchronizeCodeIdentifiersMoreComplex2() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment3();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1>A<2/>B</1>C");
        Assert.assertEquals(this.fmt.setContent(tf2).toString(false), "<3><2/>A</3>B<1>C</1>D<4/>");
    }

    @Test
    public void testSynchronizeCodeIdentifiersPlaceholderOnly() {
        TextFragment tf1 = this.makeFragment5();
        TextFragment tf2 = this.makeFragment6();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals(this.fmt.setContent(tf1).toString(false), "<1/>A<2/>B<3/>C");
        Assert.assertEquals(this.fmt.setContent(tf2).toString(false), "<2/>A<1/>B<3/>C<4/>");
    }

    @Test
    public void testIndexOfNonWSEmpty() {
        Assert.assertEquals(-1L, TextFragment.indexOfLastNonWhitespace("", -1, 0, true, true, true, true));
        Assert.assertEquals(-1L, TextFragment.indexOfFirstNonWhitespace("", 0, -1, true, true, true, true));
    }

    @Test
    public void testIndexOfFirstNonWSSimple() {
        String text = " 12 4   ";
        Assert.assertEquals(1L, TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals(1L, TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals(1L, TextFragment.indexOfFirstNonWhitespace(text, 1, -1, true, true, true, true));
        Assert.assertEquals(2L, TextFragment.indexOfFirstNonWhitespace(text, 2, -1, true, true, true, true));
        Assert.assertEquals(4L, TextFragment.indexOfFirstNonWhitespace(text, 3, -1, true, true, true, true));
        Assert.assertEquals(-1L, TextFragment.indexOfFirstNonWhitespace(text, 5, -1, true, true, true, true));
        Assert.assertEquals(-1L, TextFragment.indexOfFirstNonWhitespace(text, 5, 6, true, true, true, true));
    }

    @Test
    public void testIndexOfLastNonWSSimple() {
        String text = "  23 5  8";
        Assert.assertEquals(8L, TextFragment.indexOfLastNonWhitespace(text, -1, 5, true, true, true, true));
        Assert.assertEquals(8L, TextFragment.indexOfLastNonWhitespace(text, 8, 0, true, true, true, true));
        Assert.assertEquals(5L, TextFragment.indexOfLastNonWhitespace(text, 7, 0, true, true, true, true));
        Assert.assertEquals(3L, TextFragment.indexOfLastNonWhitespace(text, 4, 0, true, true, true, true));
        Assert.assertEquals(3L, TextFragment.indexOfLastNonWhitespace(text, 3, 0, true, true, true, true));
        Assert.assertEquals(2L, TextFragment.indexOfLastNonWhitespace(text, 2, 0, true, true, true, true));
        Assert.assertEquals(-1L, TextFragment.indexOfLastNonWhitespace(text, 7, 6, true, true, true, true));
        Assert.assertEquals(-1L, TextFragment.indexOfLastNonWhitespace(text, 1, 0, true, true, true, true));
    }

    @Test
    public void textIndexOfFirstNonWSEmpty() {
        TextFragment tf = new TextFragment("  ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        String text = tf.getCodedText();
        Assert.assertEquals(-1L, TextFragment.indexOfFirstNonWhitespace(text, 0, 0, true, true, true, true));
        Assert.assertEquals(-1L, TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals(4L, TextFragment.indexOfFirstNonWhitespace(text, 2, 0, true, true, true, false));
    }

    @Test
    public void testIndexOfLastNonWSEmpty() {
        TextFragment tf = new TextFragment("  ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        String text = tf.getCodedText();
        Assert.assertEquals(-1L, TextFragment.indexOfLastNonWhitespace(text, -1, 0, true, true, true, true));
        Assert.assertEquals(-1L, TextFragment.indexOfLastNonWhitespace(text, 6, 0, true, true, true, true));
        Assert.assertEquals(-1L, TextFragment.indexOfLastNonWhitespace(text, 7, 0, true, true, true, true));
        Assert.assertEquals(7L, TextFragment.indexOfLastNonWhitespace(text, -1, 0, true, true, true, false));
    }

    @Test
    public void testIndexOfFirstNonWSWithCodes() {
        TextFragment tf = new TextFragment("  ab");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append("c");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        String text = tf.getCodedText();
        Assert.assertEquals(2L, TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals(2L, TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals(6L, TextFragment.indexOfFirstNonWhitespace(text, 4, -1, true, true, true, true));
        Assert.assertEquals(-1L, TextFragment.indexOfFirstNonWhitespace(text, 7, -1, true, true, true, true));
        Assert.assertEquals(9L, TextFragment.indexOfFirstNonWhitespace(text, 7, -1, true, true, true, false));
        Assert.assertEquals(7L, TextFragment.indexOfFirstNonWhitespace(text, 7, -1, true, true, false, true));
        Assert.assertEquals(10L, TextFragment.indexOfFirstNonWhitespace(text, 9, -1, true, true, false, true));
    }

    @Test
    public void testIndexOfLastNonWSWithCodes() {
        TextFragment tf = new TextFragment("  ab");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append("c");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" d");
        String text = tf.getCodedText();
        Assert.assertEquals(10L, TextFragment.indexOfLastNonWhitespace(text, -1, 0, true, true, true, true));
        Assert.assertEquals(6L, TextFragment.indexOfLastNonWhitespace(text, 9, 0, true, true, true, true));
        Assert.assertEquals(3L, TextFragment.indexOfLastNonWhitespace(text, 5, 0, true, true, true, true));
        Assert.assertEquals(9L, TextFragment.indexOfLastNonWhitespace(text, 9, 0, true, true, true, false));
        Assert.assertEquals(8L, TextFragment.indexOfLastNonWhitespace(text, 9, 0, true, true, false, true));
    }

    @Test
    public void testRemoveCode() {
        TextFragment f = this.makeFragment1();
        Code c = f.getCode(1);
        f.removeCode(c);
        Assert.assertEquals("[b]AB[/b]C", f.toText());
    }

    @Test
    public void testRenumberCodes() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "(1", "[(1]", 1);
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "1)", "[1)]", 1);
        tf.append(TextFragment.TagType.OPENING, "(2", "[(2]", 2);
        tf.append("AA");
        tf.append(TextFragment.TagType.CLOSING, "2)", "[2)]", 2);
        tf.append(TextFragment.TagType.OPENING, "(3", "[(3]", 3);
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "3)", "[3)]", 3);
        tf.append(TextFragment.TagType.OPENING, "(4", "[(4]", 4);
        tf.append("BB");
        tf.append(TextFragment.TagType.CLOSING, "4)", "[4)]", 4);
        tf.changeToCode(7, 9, TextFragment.TagType.PLACEHOLDER, "x");
        tf.changeToCode(18, 20, TextFragment.TagType.PLACEHOLDER, "x");
        GenericContent fmt = new GenericContent();
        fmt.setContent(tf);
        Assert.assertEquals("<b1/>A<e1/><b2/><5/><e2/><b3/>B<e3/><b4/><6/><e4/>", fmt.toString());
        tf.renumberCodes();
        Assert.assertEquals("[(1]A[1)][(2]AA[2)][(3]B[3)][(4]BB[4)]", tf.toText());
        Assert.assertEquals("<b1/>A<e1/><b2/><3/><e2/><b4/>B<e4/><b5/><6/><e5/>", fmt.toString());
        Assert.assertEquals(10L, tf.codes.size());
        Assert.assertEquals(1L, tf.codes.get((int)0).id);
        Assert.assertEquals(1L, tf.codes.get((int)1).id);
        Assert.assertEquals(2L, tf.codes.get((int)2).id);
        Assert.assertEquals(3L, tf.codes.get((int)3).id);
        Assert.assertEquals(2L, tf.codes.get((int)4).id);
        Assert.assertEquals(4L, tf.codes.get((int)5).id);
        Assert.assertEquals(4L, tf.codes.get((int)6).id);
        Assert.assertEquals(5L, tf.codes.get((int)7).id);
        Assert.assertEquals(5L, tf.codes.get((int)8).id);
        Assert.assertEquals(6L, tf.codes.get((int)9).id);
        fmt = new GenericContent();
        fmt.setContent(tf);
        Assert.assertEquals("<b1/>A<e1/><b2/><3/><e2/><b4/>B<e4/><b5/><6/><e5/>", fmt.toString());
        Assert.assertEquals("<b1/>A<e1/><b2/><x3/><e2/><b4/>B<e4/><b5/><x6/><e5/>", GenericContent.fromFragmentToLetterCoded(tf, true));
        tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "(4", "[(4]", 4);
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "4)", "[4)]", 4);
        tf.append(TextFragment.TagType.OPENING, "(2", "[(2]", 2);
        tf.append("AA");
        tf.append(TextFragment.TagType.CLOSING, "2)", "[2)]", 2);
        tf.append(TextFragment.TagType.OPENING, "(1", "[(1]", 1);
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "1)", "[1)]", 1);
        tf.append(TextFragment.TagType.OPENING, "(3", "[(3]", 3);
        tf.append("BB");
        tf.append(TextFragment.TagType.CLOSING, "3)", "[3)]", 3);
        tf.changeToCode(7, 9, TextFragment.TagType.PLACEHOLDER, "x");
        tf.changeToCode(18, 20, TextFragment.TagType.PLACEHOLDER, "x");
        fmt = new GenericContent();
        fmt.setContent(tf);
        Assert.assertEquals("<b4/>A<e4/><b2/><5/><e2/><b1/>B<e1/><b3/><6/><e3/>", fmt.toString());
        tf.renumberCodes();
        Assert.assertEquals("[(4]A[4)][(2]AA[2)][(1]B[1)][(3]BB[3)]", tf.toText());
        Assert.assertEquals("<b1/>A<e1/><b2/><3/><e2/><b4/>B<e4/><b5/><6/><e5/>", fmt.toString());
        Assert.assertEquals(10L, tf.codes.size());
        Assert.assertEquals(1L, tf.codes.get((int)0).id);
        Assert.assertEquals(1L, tf.codes.get((int)1).id);
        Assert.assertEquals(2L, tf.codes.get((int)2).id);
        Assert.assertEquals(3L, tf.codes.get((int)3).id);
        Assert.assertEquals(2L, tf.codes.get((int)4).id);
        Assert.assertEquals(4L, tf.codes.get((int)5).id);
        Assert.assertEquals(4L, tf.codes.get((int)6).id);
        Assert.assertEquals(5L, tf.codes.get((int)7).id);
        Assert.assertEquals(5L, tf.codes.get((int)8).id);
        Assert.assertEquals(6L, tf.codes.get((int)9).id);
        fmt = new GenericContent();
        fmt.setContent(tf);
        Assert.assertEquals("<b1/>A<e1/><b2/><3/><e2/><b4/>B<e4/><b5/><6/><e5/>", fmt.toString());
        Assert.assertEquals("<b1/>A<e1/><b2/><x3/><e2/><b4/>B<e4/><b5/><x6/><e5/>", GenericContent.fromFragmentToLetterCoded(tf, true));
    }

    @Test
    public void testManyNestedCodes1() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("Content");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals("<b><b><b><b><b><b><b><b><b><b><b>Content</b></b></b></b></b></b></b></b></b></b></b>", tf.toText());
        Assert.assertEquals("<1><2><3><4><5><6><7><8><9><10><11>Content</11></10></9></8></7></6></5></4></3></2></1>", this.fmt.setContent(tf).toString());
        String ct = tf.getCodedText();
        Assert.assertEquals(57601L, ct.charAt(0));
        Assert.assertEquals(57601L, ct.charAt(2));
        Assert.assertEquals(57601L, ct.charAt(4));
        Assert.assertEquals(57601L, ct.charAt(6));
        Assert.assertEquals(57601L, ct.charAt(8));
        Assert.assertEquals(57601L, ct.charAt(10));
        Assert.assertEquals(57601L, ct.charAt(12));
        Assert.assertEquals(57601L, ct.charAt(14));
        Assert.assertEquals(57601L, ct.charAt(16));
        Assert.assertEquals(57601L, ct.charAt(18));
        Assert.assertEquals(57601L, ct.charAt(20));
        Assert.assertEquals(57602L, ct.charAt(29));
        Assert.assertEquals(57602L, ct.charAt(31));
        Assert.assertEquals(57602L, ct.charAt(33));
        Assert.assertEquals(57602L, ct.charAt(35));
        Assert.assertEquals(57602L, ct.charAt(37));
        Assert.assertEquals(57602L, ct.charAt(39));
        Assert.assertEquals(57602L, ct.charAt(41));
        Assert.assertEquals(57602L, ct.charAt(43));
        Assert.assertEquals(57602L, ct.charAt(45));
        Assert.assertEquals(57602L, ct.charAt(47));
        Assert.assertEquals(57602L, ct.charAt(49));
    }

    @Test
    public void testManyNestedCodes2() {
        TextFragment tf = new TextFragment();
        tf.append("Content");
        for (int i = 0; i < 10; ++i) {
            TextFragment tf2 = new TextFragment();
            tf2.append(TextFragment.TagType.OPENING, "b" + i, "<b>");
            tf2.append(tf);
            tf2.append(TextFragment.TagType.CLOSING, "b" + i, "</b>");
            tf = tf2;
        }
        Assert.assertEquals("<1><2><3><4><5><6><7><8><9><10>Content</10></9></8></7></6></5></4></3></2></1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testManyNestedCodes3() {
        TextFragment tf = new TextFragment();
        tf.append("Content");
        for (int i = 0; i < 10; ++i) {
            TextFragment tf2 = new TextFragment();
            tf2.append(TextFragment.TagType.OPENING, "b", "<b>", 10 - i);
            tf.insert(0, tf2);
            tf2 = new TextFragment();
            tf2.append(TextFragment.TagType.CLOSING, "b", "</b>", 10 - i);
            tf.insert(-1, tf2);
        }
        Assert.assertEquals("<1><2><3><4><5><6><7><8><9><10>Content</10></9></8></7></6></5></4></3></2></1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testNormalizeCodeIds() {
        TextFragment tf = new TextFragment();
        Code code = new Code(TextFragment.TagType.OPENING, "x");
        code.setId(8);
        tf.append(code);
        code = new Code(TextFragment.TagType.CLOSING, "x");
        code.setId(8);
        tf.append(code);
        code = new Code(TextFragment.TagType.OPENING, "x");
        code.setId(5);
        tf.append(code);
        code = new Code(TextFragment.TagType.PLACEHOLDER, "x");
        code.setId(2);
        tf.append(code);
        code = new Code(TextFragment.TagType.CLOSING, "x");
        code.setId(5);
        tf.append(code);
        Assert.assertEquals("<8></8><5><2/></5>", this.fmt.setContent(tf).toString());
        Assert.assertEquals(3L, tf.renumberCodes(1, false));
        Assert.assertEquals("<3></3><2><1/></2>", this.fmt.setContent(tf).toString());
        Assert.assertEquals(9L, tf.renumberCodes(7, false));
        Assert.assertEquals("<9></9><8><7/></8>", this.fmt.setContent(tf).toString());
        Assert.assertEquals(3L, tf.renumberCodes(1));
        Assert.assertEquals("<1></1><2><3/></2>", this.fmt.setContent(tf).toString());
        Assert.assertEquals(89L, tf.renumberCodes(87));
        Assert.assertEquals("<87></87><88><89/></88>", this.fmt.setContent(tf).toString());
    }

    private TextFragment makeFragment1() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment2() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("A");
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment3() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "u", "[u]");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "u", "[/u]");
        tf.append("B");
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("C");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("D");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        return tf;
    }

    private TextFragment makeFragment4() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("A");
        tf.append(TextFragment.TagType.OPENING, "u", "[u]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "u", "[/u]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment5() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "1", "{1}");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "2", "{2}");
        tf.append("B");
        tf.append(TextFragment.TagType.PLACEHOLDER, "3", "{3}");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment6() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "2", "{2}");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "1", "{1}");
        tf.append("B");
        tf.append(TextFragment.TagType.PLACEHOLDER, "3", "{3}");
        tf.append("C");
        tf.append(TextFragment.TagType.PLACEHOLDER, "4", "{4}");
        return tf;
    }
}

