/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.VariantSources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VariantSourcesTest {
    private static final LocaleId locFR = LocaleId.FRENCH;
    private static final LocaleId locES = LocaleId.SPANISH;
    private static final LocaleId locDE = LocaleId.GERMAN;
    private static final String DEFAULT_SOURCE = "Default source text";
    private static final String FR_SOURCE = "Variant source text for French target";
    private static final String ES_SOURCE = "Variant source text for Spanish target";
    private static final String EMPTY_SOURCE = "";
    private static final String DEFAULT_SEG_1 = "first default segment.";
    private static final String DEFAULT_SEG_2 = "second default segment.";
    private static final String FR_SEG_1 = "first French segment.";
    private static final String FR_SEG_2 = "second French segment.";
    private static final String SEGMENT_2_ID = "s2";
    private TextFragment newDefaultFragment;
    private TextFragment newFRFragment;
    private TextFragment newESFragment;
    private TextContainer FR_SOURCE_CONT;
    private TextContainer ES_SOURCE_CONT;
    private TextContainer newDefaultContainer;
    private TextContainer newFRContainer;
    private TextContainer newESContainer;
    private Property dp1;
    private Property dp2;
    private Property fp1;
    private Property fp2;
    private VariantSources cs;
    private static final TextFragment NEW_DEFAULT_SOURCE = new TextFragment("New default source text");
    private static final TextFragment NEW_FR_SOURCE = new TextFragment("New variant source text for French target");
    private static final TextFragment NEW_ES_SOURCE = new TextFragment("New variant source text for Spanish target");

    @Before
    public void setUp() {
        this.cs = new VariantSources(new TextContainer(DEFAULT_SOURCE));
        this.FR_SOURCE_CONT = new TextContainer(FR_SOURCE);
        this.ES_SOURCE_CONT = new TextContainer(ES_SOURCE);
        this.newDefaultFragment = new TextFragment(NEW_DEFAULT_SOURCE);
        this.newFRFragment = new TextFragment(NEW_FR_SOURCE);
        this.newESFragment = new TextFragment(NEW_ES_SOURCE);
        this.newDefaultContainer = new TextContainer(this.newDefaultFragment);
        this.newFRContainer = new TextContainer(this.newFRFragment);
        this.newESContainer = new TextContainer(this.newESFragment);
        this.dp1 = new Property("property1", "default_value", true);
        this.dp2 = new Property("property2", "default_value_2", true);
        this.fp1 = new Property("property1", "french_value", true);
        this.fp2 = new Property("property2", "french_value_2", true);
    }

    @Test
    public void isSourceEmptyNull() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, EMPTY_SOURCE, null, null);
        Assert.assertFalse("isSourceEmpty(LocaleId) should return the empty status for the default source when passed a null locale id", this.cs.isEmpty(null));
        Assert.assertTrue("isSourceEmpty(LocaleId) should return the empty status for the variant source of the given target locale if a variant source exists", this.cs.isEmpty(locFR));
        Assert.assertFalse("isSourceEmpty(LocaleId) should return the empty status for the default source if there is no variant source for the given target locale", this.cs.isEmpty(locES));
    }

    @Test
    public void isSourceEmptyForLocaleDefaultTrue() {
        this.cs = this.createVariantSources(EMPTY_SOURCE, FR_SOURCE, null, null);
        Assert.assertTrue("isSourceEmpty(LocaleId) should return the empty status for the default source when passed a null locale id", this.cs.isEmpty(null));
        Assert.assertFalse("isSourceEmpty(LocaleId) should return the empty status for the variant source of the given target locale if a variant source exists", this.cs.isEmpty(locFR));
        Assert.assertTrue("isSourceEmpty(LocaleId) should return the empty status for the default source if there is no variant source for the given target locale", this.cs.isEmpty(locES));
    }

    @Test
    public void createVariantSourceNullLocale() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, null, null, null);
        this.cs.create(null, true, 0);
        Assert.assertEquals("no variant source should be created when a null locale is passed to createVariantSource", 0L, this.cs.getLocales().size());
    }

    @Test
    public void createVariantSourceUsesDefault() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, null, null, null);
        this.cs.create(locFR, true, 7);
        Assert.assertEquals("createVariantSource() should use the content of the default source if no source content is given", DEFAULT_SOURCE, this.cs.get(locFR).toString());
    }

    @Test
    public void createVariantSourceAlreadyExistsOverwriteExisting() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.create(locFR, true, 1);
        Assert.assertEquals("createVariantSource() should use the content of the default source when overwriting a variant source if no source content is given", DEFAULT_SOURCE, this.cs.get(locFR).toString());
    }

    @Test
    public void createVariantSourceAlreadyExistsDontOverwriteExisting() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.create(locFR, false, 1);
        Assert.assertEquals("createVariantSource() should use the content of the default source when overwriting a variant source if no source content is given", FR_SOURCE, this.cs.get(locFR).toString());
    }

    @Test
    public void createVariantSourceWithContentNullLocale() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, null, null, null);
        this.cs.create(this.FR_SOURCE_CONT, null, true);
        Assert.assertEquals("no variant source should be created when a null locale is passed to createVariantSource", 0L, this.cs.getLocales().size());
        Assert.assertEquals("the default source should not be changed by createVariantSource()", DEFAULT_SOURCE, this.cs.get(null).toString());
    }

    @Test
    public void createVariantSourceWithContentAlreadyExistsOverwriteExisting() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.create(this.ES_SOURCE_CONT, locFR, true);
        Assert.assertEquals("createVariantSource() should overwrite variant source content when the overwriteExisting flag is true", ES_SOURCE, this.cs.get(locFR).toString());
    }

    @Test
    public void createVariantSourceWithContentAlreadyExistsDontOverwriteExisting() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.create(this.ES_SOURCE_CONT, locFR, false);
        Assert.assertEquals("createVariantSource() should not overwrite variant source content when the overwriteExisting flag is false", FR_SOURCE, this.cs.get(locFR).toString());
    }

    @Test
    public void getSourceByLocale() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        Assert.assertEquals("getSource(LocaleId) should return the default source when given a null target locale", DEFAULT_SOURCE, this.cs.get(null).toString());
        Assert.assertEquals("getSource(LocaleId) should return a variant source if one exists for the given target locale", FR_SOURCE, this.cs.get(locFR).toString());
        Assert.assertEquals("getSource(LocaleId) should return the default source when there is no variant source for the given target locale", DEFAULT_SOURCE, this.cs.get(locES).toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setSourceNullLocaleThrowsException() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.set(null, this.newDefaultContainer);
    }

    @Test
    public void setSourceReplacesExisting() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.set(locFR, this.newFRContainer);
        Assert.assertEquals("setSource() should replace any existing variant source for the given target locale", NEW_FR_SOURCE, this.cs.get(locFR).toString());
    }

    @Test
    public void setSourceCreatesNew() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.set(locES, this.newESContainer);
        Assert.assertEquals("setSource() should create a new variant source if none exists for the given target locale", NEW_ES_SOURCE, this.cs.get(locES).toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeSourceNullLocaleThrowsException() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.remove(null);
    }

    @Test
    public void removeSource() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.remove(locFR);
        Assert.assertEquals("removeSource(LocaleId) should remove any variant source for the given target locale", DEFAULT_SOURCE, this.cs.get(locFR).toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void localeHasVariantSourceNullLocaleThrowsException() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.hasVariant(null);
    }

    @Test
    public void localeHasVariantSourceTrue() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        Assert.assertTrue("hasVariantSource(LocaleId) should return true if there is a variant source for the given target locale", this.cs.hasVariant(locFR));
    }

    @Test
    public void localeHasVariantSourceFalse() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        Assert.assertFalse("hasVariantSource(LocaleId) should return false if there is no variant source for the given target locale", this.cs.hasVariant(locES));
    }

    @Test(expected=IllegalArgumentException.class)
    public void setVariantSourceContentWithNullLocale() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setContent(null, this.newDefaultFragment);
    }

    @Test
    public void setVariantSourceContentNewSource() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setContent(locES, this.newESFragment);
        Assert.assertEquals("setVariantSourceContent() should create a new variant source with the given content if none exists for the given target locale", NEW_ES_SOURCE, this.cs.get(locES).toString());
    }

    @Test
    public void setVariantSourceContentExistingSource() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setContent(locFR, this.newFRFragment);
        Assert.assertEquals("setSourceContent() should replace the content for the variant source of the given target locale", NEW_FR_SOURCE, this.cs.get(locFR).toString());
    }

    @Test
    public void getSegmentsReturnsIAlignedSegments() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        try {
            this.cs.getSegments(locFR);
        }
        catch (UnsupportedOperationException e) {
            Assert.fail("IAlignedSegments should be implemented");
        }
    }

    @Test
    public void getSourceSegmentsByLocaleNull() {
        this.cs = this.createVariantSegmentedSources();
        ISegments segs = this.cs.getSegments(null);
        Assert.assertEquals("getSourceSegments() should return the segments for the default source when a null target locale is given", DEFAULT_SEG_1, segs.get(0).toString());
        Assert.assertEquals("getSourceSegments() should return the segments for the default source when a null target locale is given", DEFAULT_SEG_2, segs.get(1).toString());
    }

    @Test
    public void getSourceSegmentsByLocaleVariantSource() {
        this.cs = this.createVariantSegmentedSources();
        ISegments segs = this.cs.getSegments(locFR);
        Assert.assertEquals("getSourceSegments() should return the segments for a variant source when one exists for the given locale", FR_SEG_1, segs.get(0).toString());
        Assert.assertEquals("getSourceSegments() should return the segments for a variant source when one exists for the given locale", FR_SEG_2, segs.get(1).toString());
    }

    @Test
    public void getSourceSegmentsByLocaleNoVariantSource() {
        this.cs = this.createVariantSegmentedSources();
        ISegments segs = this.cs.getSegments(locES);
        Assert.assertEquals("getSourceSegments() should return the segments for the default source when there is no variant source for the given locale", DEFAULT_SEG_1, segs.get(0).toString());
        Assert.assertEquals("getSourceSegments() should return the segments for the default source when there is no variant source for the given locale", DEFAULT_SEG_2, segs.get(1).toString());
    }

    @Test
    public void getSourceSegmentByLocaleNull() {
        this.cs = this.createVariantSegmentedSources();
        Assert.assertEquals("getSourceSegment() should return the given segment for the default soure if a null target locale is given", DEFAULT_SEG_2, this.cs.getSegment(null, SEGMENT_2_ID, true).toString());
    }

    @Test
    public void getSourceSegmentByLocaleVariantSource() {
        this.cs = this.createVariantSegmentedSources();
        Assert.assertEquals("getSourceSegment() should return the given segment for a  variant soure if one exists for the given target locale", FR_SEG_2, this.cs.getSegment(locFR, SEGMENT_2_ID, true).toString());
    }

    @Test
    public void getSourceSegmentByLocaleNoVariantSource() {
        this.cs = this.createVariantSegmentedSources();
        Assert.assertEquals("getSourceSegment() should return the given segment for thedefault soure if there is no variant source for the given target locale", DEFAULT_SEG_2, this.cs.getSegment(locES, SEGMENT_2_ID, true).toString());
    }

    @Test
    public void getTargetLocalesWithVariantSourceNone() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, null, null, null);
        Assert.assertEquals("getTargetLocalesWithVariantSource() should return an empty set if there are no locales with variant source", 0L, this.cs.getLocales().size());
    }

    @Test
    public void getTargetLocalesWithVariantSourceOne() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        Assert.assertEquals("getTargetLocalesWithVariantSource() should return a set of each locale id that has an associated variant source", 1L, this.cs.getLocales().size());
        Assert.assertTrue("getTargetLocalesWithVariantSource() should return the target locales that have an associated variant source", this.cs.getLocales().contains(locFR));
        Assert.assertFalse("getTargetLocalesWithVariantSource() should return only the target locales that have an associated variant source", this.cs.getLocales().contains(locES));
    }

    @Test
    public void getTargetLocalesWithVariantSourceSome() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, ES_SOURCE, null);
        Assert.assertEquals("getTargetLocalesWithVariantSource() should return a set of each locale id that has an associated variant source", 2L, this.cs.getLocales().size());
        Assert.assertTrue("getTargetLocalesWithVariantSource() should return all the target locales that have an associated variant source", this.cs.getLocales().contains(locFR));
        Assert.assertTrue("getTargetLocalesWithVariantSource() should return all the target locales that have an associated variant source", this.cs.getLocales().contains(locFR));
        Assert.assertFalse("getTargetLocalesWithVariantSource() should return only the target locales that have an associated variant source", this.cs.getLocales().contains(locDE));
    }

    @Test
    public void getSetSourcePropertyByLocaleNull() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setProperty(null, this.dp1);
        Assert.assertSame("setSourceProperty() should apply a property to the default source when given a null target locale", this.dp1, this.cs.getProperty(null, "property1"));
        Assert.assertNull("setSourceProperty() should not change properties for variant locales when a null target locale is given", this.cs.getProperty(locFR, "property1"));
    }

    @Test
    public void getSetSourcePropertyByLocaleVariantSource() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setProperty(locFR, this.fp1);
        Assert.assertSame("setSourceProperty() should set a property for the variant source if one exists for the given target locale", this.fp1, this.cs.getProperty(locFR, "property1"));
        Assert.assertNull("setSourceProperty() should not change properties for the default source when there is a variant source for the given target locale", this.cs.getProperty(null, "property1"));
    }

    @Test
    public void getSetSourcePropertyByLocaleNoVariantSource() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setProperty(locES, this.dp1);
        Assert.assertFalse("setSourceProperty() should not cause a new variant source to be created", this.cs.hasVariant(locES));
        Assert.assertSame("properties of the default source should be set by setSourceProperty() when there is no variant source for the given target locale", this.dp1, this.cs.getProperty(null, "property1"));
        Assert.assertSame("properties of the default source should be returned when there is no variant source for the given target locale", this.dp1, this.cs.getProperty(locES, "property1"));
    }

    @Test
    public void removeSourcePropertyByLocaleNull() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setProperty(null, this.dp1);
        this.cs.setProperty(locFR, this.fp1);
        this.cs.removeProperty(null, "property1");
        Assert.assertNull("removeSourceProperty() should remove properties from the default source when a null target locale is given", this.cs.getProperty(null, "property1"));
        Assert.assertNotNull("removeSourceProperty() should not remove properties from variant sources when a null target locale is given", this.cs.getProperty(locFR, "property1"));
    }

    @Test
    public void removeSourcePropertyByLocaleVariantSource() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setProperty(null, this.dp1);
        this.cs.setProperty(locFR, this.fp1);
        this.cs.removeProperty(locFR, "property1");
        Assert.assertNull("removeSourceProperty() should remove properties from a variant source when one exists for the given target locale", this.cs.getProperty(locFR, "property1"));
        Assert.assertNotNull("removeSourceProperty() should not remove properties from the default source when a variant source exists for the given target locale", this.cs.getProperty(null, "property1"));
    }

    @Test
    public void removeSourcePropertyByLocaleNoVariantSource() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setProperty(null, this.dp1);
        this.cs.setProperty(locFR, this.fp1);
        this.cs.removeProperty(locES, "property1");
        Assert.assertNull("removeSourceProperty() should remove properties from the default source when no variant source exists for the given target locale", this.cs.getProperty(null, "property1"));
    }

    @Test
    public void getSourcePropertyNamesByLocale() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setProperty(null, this.dp1);
        this.cs.setProperty(locFR, this.fp1);
        this.cs.setProperty(locFR, this.fp2);
        Assert.assertEquals("getSourcePropertyNames() should return property names for the default source when a null locale is given", 1L, this.cs.getPropertyNames(null).size());
        Assert.assertEquals("getSourcePropertyNames() should return property names for a variant source when one exists for the given locale", 2L, this.cs.getPropertyNames(locFR).size());
        Assert.assertEquals("getSourcePropertyNames() should return property names for the default source when there is no variant source for the given locale", 1L, this.cs.getPropertyNames(locES).size());
    }

    @Test
    public void getSourcePropertyNamesByLocaleNoProperties() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        Assert.assertEquals("getSourcePropertyNames() should return an empty set if there are no properties for the source of the given target locale", 0L, this.cs.getPropertyNames(locFR).size());
    }

    @Test
    public void hasSourcePropertyByLocale() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, null, null);
        this.cs.setProperty(null, this.dp1);
        this.cs.setProperty(locFR, this.fp2);
        Assert.assertTrue("hasSourceProperty() should check for properties of the default source when a null target locale is given", this.cs.hasProperty(null, "property1"));
        Assert.assertFalse("hasSourceProperty() should check for properties of the default source when a null target locale is given", this.cs.hasProperty(null, "property2"));
        Assert.assertFalse("hasSourceProperty() should check for properties of the variant source if one exists for the given target locale", this.cs.hasProperty(locFR, "property1"));
        Assert.assertTrue("hasSourceProperty() should check for properties of the variant source if one exists for the given target locale", this.cs.hasProperty(locFR, "property2"));
        Assert.assertTrue("hasSourceProperty() should check for properties of the default source if there is no variant source for the given target locale", this.cs.hasProperty(locES, "property1"));
        Assert.assertFalse("hasSourceProperty() should check for properties of the default source if there is no variant source for the given target locale", this.cs.hasProperty(locES, "property2"));
    }

    @Test
    public void propagateSourcePropertyFromDefaultToOne() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, ES_SOURCE, null);
        this.cs.setProperty(null, this.dp1);
        this.cs.propagateProperty(null, locFR, "property1", true);
        Assert.assertTrue("property should be copied from default source to the variant source of the given locale if present", this.cs.hasProperty(locFR, "property1"));
        Assert.assertFalse("the property should only be copied to the source for the specified target locale", this.cs.hasProperty(locES, "property1"));
    }

    @Test
    public void propagateSourcePropertyFromVariantToOne() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, ES_SOURCE, null);
        this.cs.setProperty(locFR, this.dp1);
        this.cs.propagateProperty(locFR, null, "property1", true);
        Assert.assertTrue("property should be copied from variant source to the default source", this.cs.hasProperty(null, "property1"));
        Assert.assertFalse("the property should only be copied to the source for the specified target locale", this.cs.hasProperty(locES, "property1"));
    }

    @Test
    public void propagateSourcePropertyFromDefaultToAll() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, ES_SOURCE, null);
        this.cs.setProperty(null, this.dp1);
        this.cs.propagateProperty(null, "property1", true);
        Assert.assertTrue("property should be copied from default source to all other sources", this.cs.hasProperty(locFR, "property1"));
        Assert.assertTrue("property should be copied from default source to all other sources", this.cs.hasProperty(locES, "property1"));
    }

    @Test
    public void propagateSourcePropertyFromVariantToAll() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, ES_SOURCE, null);
        this.cs.setProperty(locFR, this.fp1);
        this.cs.propagateProperty(locFR, "property1", true);
        Assert.assertTrue("property should be copied from french source to all other sources", this.cs.hasProperty(null, "property1"));
        Assert.assertTrue("property should be copied from french source to all other sources", this.cs.hasProperty(locES, "property1"));
    }

    @Test
    public void propagateAllSourcePropertiesFromDefaultToOne() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, ES_SOURCE, null);
        this.cs.setProperty(null, this.dp1);
        this.cs.setProperty(null, this.dp2);
        this.cs.propagateAllProperties(null, locFR, true);
        Assert.assertTrue("all properties should be copied from default source to the variant source of the given locale if present", this.cs.hasProperty(locFR, "property1"));
        Assert.assertTrue("all properties should be copied from default source to the variant source of the given locale if present", this.cs.hasProperty(locFR, "property2"));
        Assert.assertFalse("properties should only be copied to the source for the specified target locale", this.cs.hasProperty(locES, "property1"));
        Assert.assertFalse("properties should only be copied to the source for the specified target locale", this.cs.hasProperty(locES, "property2"));
    }

    @Test
    public void propagateAllSourcePropertiesFromVariantToOne() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, ES_SOURCE, null);
        this.cs.setProperty(locFR, this.dp1);
        this.cs.setProperty(locFR, this.dp2);
        this.cs.propagateAllProperties(locFR, null, true);
        Assert.assertTrue("all properties should be copied from french source to the default source", this.cs.hasProperty(locFR, "property1"));
        Assert.assertTrue("all properties should be copied from french source to the default source", this.cs.hasProperty(locFR, "property2"));
        Assert.assertFalse("properties should only be copied to the source for the specified target locale", this.cs.hasProperty(locES, "property1"));
        Assert.assertFalse("properties should only be copied to the source for the specified target locale", this.cs.hasProperty(locES, "property2"));
    }

    @Test
    public void propagateAllSourcePropertiesFromDefaultToAll() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, ES_SOURCE, null);
        this.cs.setProperty(null, this.dp1);
        this.cs.setProperty(null, this.dp2);
        this.cs.propagateAllProperties(null, true);
        Assert.assertTrue("all properties should be copied from default source to all other sources", this.cs.hasProperty(locFR, "property1"));
        Assert.assertTrue("all properties should be copied from default source to all other sources", this.cs.hasProperty(locFR, "property2"));
        Assert.assertTrue("all properties should be copied from default source to all other sources", this.cs.hasProperty(locES, "property1"));
        Assert.assertTrue("all properties should be copied from default source to all other sources", this.cs.hasProperty(locES, "property2"));
    }

    @Test
    public void propagateAllSourcePropertiesFromVariantToAll() {
        this.cs = this.createVariantSources(DEFAULT_SOURCE, FR_SOURCE, ES_SOURCE, null);
        this.cs.setProperty(locFR, this.dp1);
        this.cs.setProperty(locFR, this.dp2);
        this.cs.propagateAllProperties(locFR, true);
        Assert.assertTrue("all properties should be copied from default source to all other sources", this.cs.hasProperty(null, "property1"));
        Assert.assertTrue("all properties should be copied from default source to all other sources", this.cs.hasProperty(null, "property2"));
        Assert.assertTrue("all properties should be copied from default source to all other sources", this.cs.hasProperty(locES, "property1"));
        Assert.assertTrue("all properties should be copied from default source to all other sources", this.cs.hasProperty(locES, "property2"));
    }

    private VariantSources createVariantSegmentedSources() {
        VariantSources cSources = new VariantSources(new TextContainer(DEFAULT_SEG_1));
        cSources.get(null).getSegments().append(new Segment(SEGMENT_2_ID, new TextFragment(DEFAULT_SEG_2)), " a ");
        cSources.create(new TextContainer(FR_SEG_1), locFR, true);
        cSources.get(locFR).getSegments().append(new Segment(SEGMENT_2_ID, new TextFragment(FR_SEG_2)), " b ");
        return cSources;
    }

    private VariantSources createVariantSources(String defaultSourceString, String frenchSource, String spanishSource, String germanSource) {
        VariantSources cSources = new VariantSources(new TextContainer(defaultSourceString));
        if (frenchSource != null) {
            cSources.create(new TextContainer(frenchSource), locFR, true);
        }
        if (spanishSource != null) {
            cSources.create(new TextContainer(spanishSource), locES, true);
        }
        if (germanSource != null) {
            cSources.create(new TextContainer(germanSource), locDE, true);
        }
        return cSources;
    }
}

