/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ContentTypes {
    static final String CONTENT_TYPES_NS = "http://schemas.openxmlformats.org/package/2006/content-types";
    static final QName DEFAULT = new QName("http://schemas.openxmlformats.org/package/2006/content-types", "Default");
    static final QName OVERRIDE = new QName("http://schemas.openxmlformats.org/package/2006/content-types", "Override");
    static final QName PARTNAME_ATTR = new QName("PartName");
    static final QName CONTENTTYPE_ATTR = new QName("ContentType");
    static final QName EXTENSION_ATTR = new QName("Extension");
    private XMLInputFactory factory;
    private Map<String, String> defaults = new HashMap<String, String>();
    private Map<String, String> overrides = new HashMap<String, String>();

    public ContentTypes(XMLInputFactory factory) {
        this.factory = factory;
    }

    public String getContentType(String partName) {
        if (this.overrides.containsKey(partName = this.ensureWellformedPath(partName))) {
            return this.overrides.get(partName);
        }
        String suffix = this.getSuffix(partName);
        if (this.defaults.containsKey(suffix)) {
            return this.defaults.get(suffix);
        }
        return "application/octet-stream";
    }

    public void parseFromXML(Reader reader) throws XMLStreamException {
        XMLEventReader eventReader = this.factory.createXMLEventReader(reader);
        while (eventReader.hasNext()) {
            Attribute type;
            XMLEvent e = eventReader.nextEvent();
            if (!e.isStartElement()) continue;
            StartElement el = e.asStartElement();
            if (el.getName().equals(DEFAULT)) {
                Attribute ext = el.getAttributeByName(EXTENSION_ATTR);
                type = el.getAttributeByName(CONTENTTYPE_ATTR);
                if (ext == null || type == null) continue;
                this.defaults.put(ext.getValue(), type.getValue());
                continue;
            }
            if (!el.getName().equals(OVERRIDE)) continue;
            Attribute part = el.getAttributeByName(PARTNAME_ATTR);
            type = el.getAttributeByName(CONTENTTYPE_ATTR);
            if (part == null || type == null) continue;
            this.overrides.put(this.ensureWellformedPath(part.getValue()), type.getValue());
        }
    }

    private String getSuffix(String partName) {
        String suffix = partName;
        int i = suffix.lastIndexOf(46);
        if (i != -1) {
            suffix = suffix.substring(i + 1);
        }
        return suffix;
    }

    private String ensureWellformedPath(String p) {
        return p.startsWith("/") ? p : "/" + p;
    }
}

