/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.properties;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.filters.LocalizationDirectives;

public class Parameters
extends BaseParameters {
    public boolean useCodeFinder;
    public InlineCodeFinder codeFinder;
    public boolean escapeExtendedChars;
    public boolean useKeyCondition;
    public boolean extractOnlyMatchingKey;
    public String keyCondition;
    public boolean extraComments;
    public boolean commentsAreNotes;
    public LocalizationDirectives locDir = new LocalizationDirectives();
    public boolean convertLFandTab;
    public String subfilter;

    public Parameters() {
        this.codeFinder = new InlineCodeFinder();
        this.reset();
        this.toString();
    }

    @Override
    public void reset() {
        this.locDir.reset();
        this.escapeExtendedChars = true;
        this.convertLFandTab = true;
        this.useCodeFinder = true;
        this.codeFinder.reset();
        this.codeFinder.setSample("%s, %d, {1}, \\n, \\r, \\t, etc.");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]");
        this.codeFinder.addRule("(\\\\r\\\\n)|\\\\a|\\\\b|\\\\f|\\\\n|\\\\r|\\\\t|\\\\v");
        this.codeFinder.addRule("\\{\\d[^\\\\]*?\\}");
        this.codeFinder.addRule("\\<(/?)\\w+[^>]*?>");
        this.useKeyCondition = false;
        this.extractOnlyMatchingKey = true;
        this.keyCondition = ".*text.*";
        this.extraComments = false;
        this.commentsAreNotes = true;
        this.subfilter = null;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean("convertLFandTab", this.convertLFandTab);
        this.buffer.setBoolean("useLD", this.locDir.useLD());
        this.buffer.setBoolean("localizeOutside", this.locDir.localizeOutside());
        this.buffer.setBoolean("useKeyCondition", this.useKeyCondition);
        this.buffer.setBoolean("extractOnlyMatchingKey", this.extractOnlyMatchingKey);
        this.buffer.setString("keyCondition", this.keyCondition);
        this.buffer.setBoolean("extraComments", this.extraComments);
        this.buffer.setBoolean("commentsAreNotes", this.commentsAreNotes);
        this.buffer.setBoolean("escapeExtendedChars", this.escapeExtendedChars);
        this.buffer.setBoolean("useCodeFinder", this.useCodeFinder);
        this.buffer.setGroup("codeFinderRules", this.codeFinder.toString());
        this.buffer.setString("subfilter", this.subfilter);
        return this.buffer.toString();
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.convertLFandTab = this.buffer.getBoolean("convertLFandTab", this.convertLFandTab);
        boolean tmpBool1 = this.buffer.getBoolean("useLD", this.locDir.useLD());
        boolean tmpBool2 = this.buffer.getBoolean("localizeOutside", this.locDir.localizeOutside());
        this.locDir.setOptions(tmpBool1, tmpBool2);
        this.useKeyCondition = this.buffer.getBoolean("useKeyCondition", this.useKeyCondition);
        this.extractOnlyMatchingKey = this.buffer.getBoolean("extractOnlyMatchingKey", this.extractOnlyMatchingKey);
        this.keyCondition = this.buffer.getString("keyCondition", this.keyCondition);
        this.extraComments = this.buffer.getBoolean("extraComments", this.extraComments);
        this.commentsAreNotes = this.buffer.getBoolean("commentsAreNotes", this.commentsAreNotes);
        this.escapeExtendedChars = this.buffer.getBoolean("escapeExtendedChars", this.escapeExtendedChars);
        this.useCodeFinder = this.buffer.getBoolean("useCodeFinder", this.useCodeFinder);
        this.codeFinder.fromString(this.buffer.getGroup("codeFinderRules", ""));
        this.subfilter = this.buffer.getString("subfilter", this.subfilter);
    }

    public boolean isUseCodeFinder() {
        return this.useCodeFinder;
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.useCodeFinder = useCodeFinder;
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public void setCodeFinder(InlineCodeFinder codeFinder) {
        this.codeFinder = codeFinder;
    }

    public boolean isEscapeExtendedChars() {
        return this.escapeExtendedChars;
    }

    public void setEscapeExtendedChars(boolean escapeExtendedChars) {
        this.escapeExtendedChars = escapeExtendedChars;
    }

    public boolean isUseKeyCondition() {
        return this.useKeyCondition;
    }

    public void setUseKeyCondition(boolean useKeyCondition) {
        this.useKeyCondition = useKeyCondition;
    }

    public boolean isExtractOnlyMatchingKey() {
        return this.extractOnlyMatchingKey;
    }

    public void setExtractOnlyMatchingKey(boolean extractOnlyMatchingKey) {
        this.extractOnlyMatchingKey = extractOnlyMatchingKey;
    }

    public String getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String keyCondition) {
        this.keyCondition = keyCondition;
    }

    public boolean isExtraComments() {
        return this.extraComments;
    }

    public void setExtraComments(boolean extraComments) {
        this.extraComments = extraComments;
    }

    public boolean isCommentsAreNotes() {
        return this.commentsAreNotes;
    }

    public void setCommentsAreNotes(boolean commentsAreNotes) {
        this.commentsAreNotes = commentsAreNotes;
    }

    public LocalizationDirectives getLocDir() {
        return this.locDir;
    }

    public void setLocDir(LocalizationDirectives locDir) {
        this.locDir = locDir;
    }

    public boolean isConvertLFandTab() {
        return this.convertLFandTab;
    }

    public void setConvertLFandTab(boolean convertLFandTab) {
        this.convertLFandTab = convertLFandTab;
    }

    public String getSubfilter() {
        return this.subfilter;
    }

    public void setSubfilter(String subfilter) {
        this.subfilter = subfilter;
    }
}

