/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.DefaultEntityResolver;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.its.ITSFilter;
import net.sf.okapi.filters.its.Parameters;
import net.sf.okapi.filters.xml.XMLSkeletonWriter;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@UsingParameters(value=Parameters.class)
public class XMLFilter
extends ITSFilter {
    public XMLFilter() {
        super(false, "text/xml", -1L);
    }

    protected XMLFilter(String mimeType) {
        super(false, mimeType, -1L);
    }

    @Override
    public String getName() {
        return "okf_xml";
    }

    @Override
    public String getDisplayName() {
        return "XML Filter";
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), this.getMimeType(), this.getClass().getName(), "Generic XML", "Configuration for generic XML documents (default ITS rules).", null, ".xml;"));
        list.add(new FilterConfiguration(this.getName() + "-resx", this.getMimeType(), this.getClass().getName(), "RESX", "Configuration for Microsoft RESX documents (without binary data).", "resx.fprm", ".resx;"));
        list.add(new FilterConfiguration(this.getName() + "-MozillaRDF", this.getMimeType(), this.getClass().getName(), "Mozilla RDF", "Configuration for Mozilla RDF documents.", "MozillaRDF.fprm", ".rdf;"));
        list.add(new FilterConfiguration(this.getName() + "-JavaProperties", this.getMimeType(), this.getClass().getName(), "Java Properties XML", "Configuration for Java Properties files in XML.", "JavaProperties.fprm"));
        list.add(new FilterConfiguration(this.getName() + "-AndroidStrings", this.getMimeType(), this.getClass().getName(), "Android Strings", "Configuration for Android Strings XML documents.", "AndroidStrings.fprm"));
        list.add(new FilterConfiguration(this.getName() + "-WixLocalization", this.getMimeType(), this.getClass().getName(), "WiX Localization", "Configuration for WiX (Windows Installer XML) Localization files.", "WixLocalization.fprm", ".wxl;"));
        return list;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new XMLSkeletonWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(this.getMimeType(), "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    protected void initializeDocument() {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        fact.setValidating(false);
        fact.setExpandEntityReferences(!this.params.protectEntityRef);
        try {
            docBuilder = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OkapiIOException(e);
        }
        docBuilder.setEntityResolver(new DefaultEntityResolver());
        this.input.setEncoding("UTF-8");
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(this.input.getStream(), this.input.getEncoding());
        detector.detectBom();
        if (detector.isAutodetected()) {
            this.encoding = detector.getEncoding();
            if (this.encoding.equals("UTF-16LE") || this.encoding.equals("UTF-16BE")) {
                this.encoding = "UTF-16";
            }
            this.input.setEncoding(this.encoding);
        }
        try {
            InputSource is = new InputSource(this.input.getStream());
            this.doc = docBuilder.parse(is);
        }
        catch (SAXException e) {
            throw new OkapiIOException("Parsing error.\n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OkapiIOException("IO Error when reading the document.\n" + e.getMessage(), e);
        }
        this.encoding = this.doc.getXmlEncoding();
        if (this.encoding == null) {
            this.encoding = detector.getEncoding();
        }
        this.srcLang = this.input.getSourceLocale();
        if (this.srcLang == null) {
            throw new NullPointerException("Source language not set.");
        }
        this.hasUTF8BOM = detector.hasUtf8Bom();
        this.lineBreak = detector.getNewlineType().toString();
        if (this.input.getInputURI() != null) {
            this.docName = this.input.getInputURI().getPath();
        }
    }

    @Override
    protected void createStartDocumentSkeleton(StartDocument startDoc) {
        DocumentType dt;
        this.skel = new GenericSkeleton();
        if (!this.params.omitXMLDeclaration) {
            this.skel.add("<?xml version=\"" + this.doc.getXmlVersion() + "\"");
            this.skel.add(" encoding=\"");
            this.skel.addValuePlaceholder(startDoc, "encoding", LocaleId.EMPTY);
            this.skel.add("\"");
            startDoc.setProperty(new Property("encoding", this.encoding, false));
            if (this.doc.getXmlStandalone()) {
                this.skel.add(" standalone=\"yes\"");
            }
            this.skel.add("?>" + this.lineBreak);
        }
        if ((dt = this.doc.getDoctype()) != null) {
            this.rebuildDocTypeSection(dt);
        }
    }

    private void rebuildDocTypeSection(DocumentType dt) {
        StringBuilder tmp = new StringBuilder();
        if (dt.getPublicId() != null) {
            tmp.append(String.format("<!DOCTYPE %s PUBLIC \"%s\" \"%s\"", dt.getName(), dt.getPublicId(), dt.getSystemId()));
        } else if (dt.getSystemId() != null) {
            tmp.append(String.format("<!DOCTYPE %s SYSTEM \"%s\"", dt.getName(), dt.getSystemId()));
        } else if (dt.getInternalSubset() != null) {
            tmp.append(String.format("<!DOCTYPE %s", dt.getName()));
        }
        if (dt.getInternalSubset() != null) {
            tmp.append(" [");
            tmp.append(dt.getInternalSubset().replace("\n", this.lineBreak));
            tmp.append("]");
        }
        if (tmp.length() > 0) {
            tmp.append(">" + this.lineBreak);
            this.skel.add(tmp.toString());
        }
    }
}

