/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xmlstream;

import java.io.File;
import java.net.URL;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.filters.xmlstream.XmlStreamFilter;
import net.sf.okapi.filters.yaml.TaggedFilterConfiguration;

public class Parameters
extends BaseParameters {
    public static final String DEFAULT_PARAMETERS = "default.yml";
    public static final String DITA_PARAMETERS = "dita.yml";
    public static final String PROPERTY_XML_PARAMETERS = "javaPropertiesXml.yml";
    public static final String XML_ESCAPED_HTML = "xml_esc_html.yml";
    public static final String XML_CDATA_ESCAPED_HTML = "xml_cdata_esc_html.yml";
    public static final String IDD_ESCAPED_HTML = "idd_esc_html.yml";
    private TaggedFilterConfiguration taggedConfig;

    public Parameters() {
        this.reset();
    }

    public Parameters(URL configPath) {
        this.setTaggedConfig(new TaggedFilterConfiguration(configPath));
    }

    public Parameters(File configFile) {
        this.setTaggedConfig(new TaggedFilterConfiguration(configFile));
    }

    public Parameters(String configAsString) {
        this.setTaggedConfig(new TaggedFilterConfiguration(configAsString));
    }

    @Override
    public void fromString(String data) {
        this.taggedConfig = new TaggedFilterConfiguration(data);
    }

    @Override
    public String toString() {
        return this.taggedConfig.toString();
    }

    @Override
    public void reset() {
        this.taggedConfig = new TaggedFilterConfiguration(XmlStreamFilter.class.getResource(DEFAULT_PARAMETERS));
    }

    public TaggedFilterConfiguration getTaggedConfig() {
        return this.taggedConfig;
    }

    public void setTaggedConfig(TaggedFilterConfiguration taggedConfig) {
        this.taggedConfig = taggedConfig;
    }
}

