/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.omegat;

import java.awt.Dialog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IAlignCallback;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.ITranslateCallback;
import org.omegat.filters2.TranslationException;

abstract class AbstractOkapiFilter
implements org.omegat.filters2.IFilter {
    protected IParseCallback parseCallback;
    protected ITranslateCallback translateCallback;
    protected IAlignCallback alignCallback;
    protected String defaultInEncoding = "UTF-8";
    protected String defaultOutEncoding = "UTF-8";
    protected String supportedExtensions;
    private Boolean processOmegaT2_5 = null;
    private boolean version3_plus = false;
    private String filterConfigId;
    private FilterConfigurationMapper fcMapper;
    private String name;
    private PrintWriter glosWriter = null;
    private boolean triedGlossaryCreation = false;
    private File inputFile;
    private FilterContext filterContext;

    AbstractOkapiFilter() {
    }

    protected void initialize(String name, String filterClassName, String filterConfigId, String supportedExtensions) {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations(filterClassName);
        this.filterConfigId = filterConfigId;
        this.name = name;
        this.supportedExtensions = supportedExtensions;
    }

    @Override
    public void alignFile(File inFile, File outFile, Map<String, String> config, FilterContext context, IAlignCallback callback) throws Exception {
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> config) {
        return null;
    }

    @Override
    public String getFileFormatName() {
        return this.name;
    }

    @Override
    public String getFuzzyMark() {
        return "fuzzy";
    }

    @Override
    public String getHint() {
        return "";
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        return true;
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFile(File inFile, Map<String, String> config, FilterContext context, IParseCallback callback) throws Exception {
        this.parseCallback = callback;
        this.translateCallback = null;
        this.alignCallback = null;
        try {
            this.processFile(inFile, null, context);
            if (this.requirePrevNextFields()) {
                this.parseCallback.linkPrevNextSegments();
            }
        }
        finally {
            this.parseCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translateFile(File inFile, File outFile, Map<String, String> config, FilterContext context, ITranslateCallback callback) throws Exception {
        this.parseCallback = null;
        this.translateCallback = callback;
        this.alignCallback = null;
        try {
            if (this.doProcessFor2_5()) {
                this.translateCallback.setPass(1);
            }
            this.processFile(inFile, outFile, context);
            if (this.requirePrevNextFields()) {
                this.translateCallback.linkPrevNextSegments();
                this.translateCallback.setPass(2);
                this.processFile(inFile, outFile, context);
            }
        }
        finally {
            this.translateCallback = null;
        }
    }

    protected boolean requirePrevNextFields() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(File inFile, File outFile, FilterContext context) throws IOException, TranslationException {
        String outEncoding;
        String inEncoding;
        this.inputFile = inFile;
        this.filterContext = context;
        LocaleId srcLoc = LocaleId.ENGLISH;
        if (context.getSourceLang() != null) {
            srcLoc = LocaleId.fromString(context.getSourceLang().getLanguage());
        }
        LocaleId trgLoc = LocaleId.FRENCH;
        if (context.getTargetLang() != null) {
            trgLoc = LocaleId.fromString(context.getTargetLang().getLanguage());
        }
        if ((inEncoding = context.getInEncoding()) == null) {
            inEncoding = this.defaultInEncoding;
        }
        if ((outEncoding = context.getOutEncoding()) == null) {
            outEncoding = this.filterConfigId.startsWith("okf_ttx") ? "UTF-16" : this.defaultOutEncoding;
        }
        IFilter filter = null;
        IFilterWriter writer = null;
        try {
            filter = this.fcMapper.createFilter(this.filterConfigId);
            if (filter == null) {
                throw new RuntimeException(String.format("Could not create a filter for the configuration '%s'.", this.filterConfigId));
            }
            RawDocument rd = new RawDocument(inFile.toURI(), inEncoding, srcLoc, trgLoc);
            filter.open(rd);
            if (outFile != null) {
                writer = filter.createFilterWriter();
                writer.setOptions(trgLoc, outEncoding);
                writer.setOutput(outFile.getAbsolutePath());
            }
            while (filter.hasNext()) {
                Event event = filter.next();
                if (event.isTextUnit()) {
                    ITextUnit tu = event.getTextUnit();
                    if (!tu.isTranslatable()) continue;
                    boolean isFuzzy = false;
                    TextContainer tc = null;
                    if (tu.hasTarget(trgLoc)) {
                        tc = tu.getTarget(trgLoc);
                        if (tc.hasProperty("approved")) {
                            boolean bl = isFuzzy = !tc.getProperty("approved").getValue().equals("yes");
                        }
                        if (tc.isEmpty()) {
                            tc = null;
                        }
                    }
                    Segment trgSeg = null;
                    ISegments trgSegs = null;
                    if (tc == null) {
                        tc = tu.createTarget(trgLoc, false, 4);
                    }
                    trgSegs = tc.getSegments();
                    for (Segment srcSeg : tu.getSource().getSegments()) {
                        trgSeg = trgSegs.get(srcSeg.id);
                        if (writer == null) {
                            String comments = this.processComments(tu, srcSeg, trgSeg);
                            if (trgSeg == null || trgSeg.text.isEmpty()) {
                                this.parseCallback.addEntry(tu.getId() + "_" + srcSeg.id, this.toOmegat(srcSeg.text), null, false, comments, this);
                                continue;
                            }
                            this.parseCallback.addEntry(tu.getId() + "_" + srcSeg.id, this.toOmegat(srcSeg.text), this.toOmegat(trgSeg.text), isFuzzy, comments, this);
                            continue;
                        }
                        String trans = this.translateCallback.getTranslation(tu.getId() + "_" + srcSeg.id, this.toOmegat(srcSeg.text));
                        if (!Util.isEmpty(trans)) {
                            if (trgSeg == null) continue;
                            trgSeg.text = srcSeg.text.clone();
                            this.fromOmegat(trans, trgSeg.text);
                            continue;
                        }
                        trgSeg.text = new TextFragment();
                    }
                }
                if (writer == null) continue;
                writer.handleEvent(event);
            }
        }
        finally {
            if (filter != null) {
                filter.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (this.glosWriter != null) {
                this.glosWriter.close();
                this.glosWriter = null;
            }
            this.triedGlossaryCreation = false;
        }
    }

    protected String processComments(ITextUnit tu, Segment srcSeg, Segment trgSeg) {
        TextFragment tf = srcSeg.getContent();
        if (!tf.hasCode()) {
            return null;
        }
        String ct = tf.getCodedText();
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < ct.length(); ++i) {
            Double conf;
            CharSequence info;
            String term;
            GenericAnnotation ann;
            GenericAnnotations anns;
            Code c;
            if (!TextFragment.isMarker(ct.charAt(i)) || (c = tf.getCode(ct.charAt(++i))).getTagType() == TextFragment.TagType.CLOSING || (anns = c.getGenericAnnotations()) == null) continue;
            if (tmp == null) {
                tmp = new StringBuilder();
            }
            if ((ann = anns.getFirstAnnotation("its-term")) != null) {
                Double conf2;
                if (tmp.length() > 0) {
                    tmp.append("\n");
                }
                term = this.getSpan(ct, i + 1, c, tf);
                tmp.append("Term: '" + term + "'");
                info = ann.getString("termInfo");
                if (info != null) {
                    tmp.append(" " + (String)info);
                }
                if ((conf2 = ann.getDouble("termConfidence")) != null) {
                    tmp.append(" Confidence=" + Util.formatDouble(conf2));
                }
                this.writeToGlossary(term, (String)info);
            }
            if ((ann = anns.getFirstAnnotation("its-ta")) == null) continue;
            if (tmp.length() > 0) {
                tmp.append("\n");
            }
            term = this.getSpan(ct, i + 1, c, tf);
            tmp.append("TA: '" + term + "'");
            info = new StringBuilder();
            String str = ann.getString("taClass");
            if (str != null) {
                ((StringBuilder)info).append(" Class:" + str);
            }
            if ((str = ann.getString("taIdent")) != null) {
                ((StringBuilder)info).append(" Ident:" + str);
            }
            if ((str = ann.getString("taSource")) != null) {
                ((StringBuilder)info).append(" Src:" + str);
            }
            if ((conf = ann.getDouble("termConfidence")) != null) {
                ((StringBuilder)info).append(" Confidence=" + Util.formatDouble(conf));
            }
            tmp.append(info);
            this.writeToGlossary(term, ((StringBuilder)info).toString());
        }
        return Util.isEmpty(tmp) ? null : tmp.toString();
    }

    private String getSpan(String ct, int start, Code code, TextFragment tf) {
        int index = tf.getIndexForClosing(code.getId());
        if (index == -1) {
            return "";
        }
        for (int i = start; i < ct.length(); ++i) {
            if (!TextFragment.isMarker(ct.charAt(i)) || index != TextFragment.toIndex(ct.charAt(++i))) continue;
            StringBuilder tmp = new StringBuilder(ct.substring(start, i - 1));
            for (i = 0; i < tmp.length(); ++i) {
                if (!TextFragment.isMarker(tmp.charAt(i))) continue;
                tmp.delete(i, i + 1);
                --i;
            }
            return tmp.toString();
        }
        return "";
    }

    private String toOmegat(TextFragment tf) {
        return GenericContent.fromFragmentToLetterCoded(tf, true);
    }

    private void fromOmegat(String text, TextFragment frag) {
        GenericContent.fromLetterCodedToFragment(text, frag, true, true);
    }

    private boolean doProcessFor2_5() {
        if (this.processOmegaT2_5 == null) {
            try {
                String tmp = ResourceBundle.getBundle("org/omegat/Version").getString("version");
                this.processOmegaT2_5 = tmp.compareTo("2.5.0") >= 0;
                this.version3_plus = tmp.compareTo("3.0.0") >= 0;
            }
            catch (Throwable e) {
                this.processOmegaT2_5 = false;
                this.version3_plus = false;
            }
        }
        return this.processOmegaT2_5;
    }

    private void writeToGlossary(String term, String info) {
        if (!this.triedGlossaryCreation && this.version3_plus) {
            this.triedGlossaryCreation = true;
            try {
                String glosRoot = this.filterContext.getProjectProperties().getGlossaryRoot();
                File file = new File(new File(glosRoot), this.inputFile.getName() + ".utf8");
                this.glosWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.glosWriter != null) {
            this.glosWriter.println(term + "\t" + term);
            if (!Util.isEmpty(info)) {
                this.glosWriter.println("\t" + info);
            }
        }
    }
}

