/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.observer.BaseObservable;
import net.sf.okapi.common.observer.IObservable;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.lib.persistence.BeanMapper;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.IVersionDriver;
import net.sf.okapi.lib.persistence.ReferenceResolver;
import net.sf.okapi.lib.persistence.SessionState;
import net.sf.okapi.lib.persistence.VersionMapper;

public abstract class PersistenceSession
implements IPersistenceSession,
IObservable {
    private static final String ITEM_LABEL = "item";
    private String itemLabel = "item";
    private SessionState state = SessionState.IDLE;
    private ReferenceResolver refResolver = new ReferenceResolver(this);
    private BeanMapper beanMapper = new BeanMapper(this);
    private int itemCounter = 0;
    private Class<?> prevClass;
    private Class<? extends IPersistenceBean<?>> beanClass;
    private OutputStream outStream;
    private InputStream inStream;
    private String description;
    private Class<?> itemClass;
    private LinkedList<IPersistenceBean<?>> queue = new LinkedList();
    private boolean readingDone = false;
    private IVersionDriver versionDriver = null;
    private Annotations annotations = new Annotations();
    private IObservable delegatedObservable = new BaseObservable(this);

    protected abstract void writeBean(IPersistenceBean<?> var1, String var2);

    protected abstract String writeBeanToString(IPersistenceBean<?> var1);

    protected abstract <T extends IPersistenceBean<?>> T readBean(Class<T> var1, String var2);

    protected abstract <T extends IPersistenceBean<?>> T readBeanFromString(String var1, Class<T> var2);

    protected abstract void startWriting(OutputStream var1);

    protected abstract void endWriting(OutputStream var1);

    protected abstract void startReading(InputStream var1);

    protected abstract void endReading(InputStream var1);

    protected abstract String getDefItemLabel();

    protected abstract Class<?> getDefItemClass();

    protected abstract String getDefVersionId();

    public PersistenceSession() {
        this.registerVersions();
        this.setItemLabel(this.getDefItemLabel());
        this.setItemClass(this.getDefItemClass());
        this.setVersion(this.getDefVersionId());
    }

    @Override
    public void cacheBean(Object obj, IPersistenceBean<?> bean) {
        this.refResolver.cacheBean(obj, bean);
    }

    @Override
    public <T> IPersistenceBean<T> createBean(Class<T> classRef) {
        return this.refResolver.createBean(classRef);
    }

    @Override
    public <T> T deserialize(Class<T> classRef) {
        return this.deserialize(classRef, this.itemLabel);
    }

    private <T> IPersistenceBean<T> nextBean(Class<T> classRef, String name) {
        if (this.readingDone) {
            return null;
        }
        if (classRef != this.prevClass) {
            this.beanClass = this.beanMapper.getBeanClass(classRef);
            this.prevClass = classRef;
        }
        IPersistenceBean<?> bean = this.readBean(this.beanClass, name);
        this.notifyObservers(bean);
        this.readingDone = bean == null;
        return bean;
    }

    private <T> T deserialize(Class<T> classRef, String name) {
        Object obj;
        IPersistenceBean<Object> bean;
        if (this.state != SessionState.READING) {
            return null;
        }
        while (true) {
            if (this.queue.size() == 0) {
                if (this.readingDone) {
                    this.end();
                    return null;
                }
                bean = this.nextBean(classRef, name);
                if (this.readingDone) continue;
                this.refResolver.cacheBean(bean);
                this.queue.add(bean);
                continue;
            }
            bean = this.queue.peek();
            long refId = bean.getRefId();
            if (refId < 0L) {
                refId = -refId;
            }
            if ((obj = this.getObject(refId)) != null) {
                this.queue.poll();
                this.refResolver.releaseObject(obj);
                return classRef.cast(obj);
            }
            Set<Long> frame = this.refResolver.getFrame(refId);
            if (frame == null) break;
            do {
                bean = this.nextBean(classRef, name);
                if (this.readingDone) break;
                this.refResolver.cacheBean(bean);
                this.queue.add(bean);
            } while (!this.refResolver.isFrameAvailable(frame));
            for (Long rid : frame) {
                bean = this.refResolver.uncacheBean(rid);
                if (bean == null) {
                    throw new RuntimeException(String.format("PersistenceSession: bean %d not found in cache", rid));
                }
                if (rid < 0L) continue;
                this.refResolver.setRootId(rid);
                obj = classRef.cast(bean.get(classRef, this));
                this.refResolver.setRefIdForObject(obj, rid);
            }
            this.refResolver.removeFrame(frame);
        }
        bean = this.queue.poll();
        obj = bean.get(classRef, this);
        this.refResolver.releaseObject(obj);
        return classRef.cast(obj);
    }

    @Override
    public void end() {
        switch (this.state) {
            case IDLE: {
                return;
            }
            case READING: {
                this.readingDone = true;
                if (this.inStream == null) break;
                this.endReading(this.inStream);
                break;
            }
            case WRITING: {
                if (this.outStream == null) break;
                this.refResolver.updateFrames();
                this.endWriting(this.outStream);
            }
        }
        this.inStream = null;
        this.outStream = null;
        this.prevClass = null;
        this.beanClass = null;
        this.refResolver.reset();
        this.state = SessionState.IDLE;
        this.setVersion(this.getDefVersionId());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public long getRefIdForObject(Object obj) {
        return this.refResolver.getRefIdForObject(obj);
    }

    @Override
    public void setRefIdForObject(Object obj, long refId) {
        this.refResolver.setRefIdForObject(obj, refId);
    }

    @Override
    public void setReference(long parentRefId, long childRefId) {
        this.refResolver.setReference(parentRefId, childRefId);
    }

    @Override
    public String getItemClass() {
        return this.itemClass == null ? "" : this.itemClass.getName();
    }

    @Override
    public void serialize(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("PersistenceSession: cannot serialize a null object");
        }
        this.serialize(obj, String.format("%s%d", this.itemLabel, ++this.itemCounter));
    }

    @Override
    public void serialize(Object obj, String name) {
        if (this.state != SessionState.WRITING) {
            return;
        }
        if (obj == null) {
            throw new IllegalArgumentException("PersistenceSession: cannot serialize a null object");
        }
        long rid = this.refResolver.getRefIdForObject(obj);
        IPersistenceBean<?> bean = null;
        if (this.refResolver.isSerialized(obj)) {
            bean = this.refResolver.createAntiBean(obj.getClass(), rid);
        } else {
            bean = this.refResolver.uncacheBean(obj);
            if (bean == null && (bean = obj instanceof IPersistenceBean ? (IPersistenceBean<?>)obj : this.refResolver.createBean(obj.getClass())) == null) {
                return;
            }
            this.refResolver.setRootId(bean.getRefId());
            this.refResolver.setRefIdForObject(obj, bean.getRefId());
            bean.set(obj, this);
        }
        this.notifyObservers(bean);
        this.writeBean(bean, name);
    }

    @Override
    public void start(OutputStream outStream) {
        if (outStream == null) {
            throw new IllegalArgumentException("PersistenceSession: output stream cannot be null");
        }
        this.end();
        this.refResolver.reset();
        this.setVersion(this.getDefVersionId());
        this.outStream = outStream;
        this.itemCounter = 0;
        if (Util.isEmpty(this.itemLabel)) {
            this.itemLabel = ITEM_LABEL;
        }
        this.state = SessionState.WRITING;
        this.startWriting(outStream);
    }

    @Override
    public void start(InputStream inStream) {
        if (inStream == null) {
            throw new IllegalArgumentException("PersistenceSession: input stream cannot be null");
        }
        this.end();
        this.refResolver.reset();
        this.setVersion(this.getDefVersionId());
        this.inStream = inStream;
        this.readingDone = false;
        this.state = SessionState.READING;
        this.startReading(inStream);
    }

    @Override
    public IPersistenceBean<?> uncacheBean(Object obj) {
        return this.refResolver.uncacheBean(obj);
    }

    @Override
    public SessionState getState() {
        return this.state;
    }

    public String getItemLabel() {
        return this.itemLabel;
    }

    public void setItemLabel(String itemLabel) {
        this.itemLabel = itemLabel;
    }

    protected List<List<Long>> getFrames() {
        return this.refResolver.getFrames();
    }

    protected void setFrames(List<List<?>> frames) {
        this.refResolver.setFrames(frames);
    }

    public void setItemClass(Class<?> itemClass) {
        this.itemClass = itemClass;
    }

    @Override
    public Object getObject(long refId) {
        return this.refResolver.getObject(refId);
    }

    @Override
    public void setSerialized(Object obj) {
        this.refResolver.setSerialized(obj);
    }

    @Override
    public void addObserver(IObserver observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<IObserver> getObservers() {
        return this.delegatedObservable.getObservers();
    }

    @Override
    public Class<?> getClass(String objClassName) {
        return this.beanMapper.getClass(objClassName);
    }

    @Override
    public Class<?> getObjectClass(Class<? extends IPersistenceBean<?>> beanClassRef) {
        return this.beanMapper.getObjectClass(beanClassRef);
    }

    @Override
    public <T> Class<IPersistenceBean<T>> getBeanClass(Class<T> classRef) {
        return this.beanMapper.getBeanClass(classRef);
    }

    @Override
    public Class<? extends IPersistenceBean<?>> getBeanClass(String className) {
        return this.beanMapper.getBeanClass(className);
    }

    @Override
    public IPersistenceBean<?> getProxy(String objClassName) {
        return this.beanMapper.getProxy(objClassName);
    }

    @Override
    public IPersistenceBean<?> getProxy(Class<?> objClassRef) {
        return this.beanMapper.getProxy(objClassRef);
    }

    @Override
    public void registerBean(Class<?> classRef, Class<? extends IPersistenceBean<?>> beanClassRef) {
        this.beanMapper.registerBean(classRef, beanClassRef);
    }

    @Override
    public String getVersion() {
        return this.versionDriver == null ? "" : this.versionDriver.getVersionId();
    }

    public void setVersion(String versionId) {
        if (Util.isEmpty(versionId)) {
            throw new IllegalArgumentException(String.format("PersistenceSession: version id cannot be empty", new Object[0]));
        }
        if (this.versionDriver != null && versionId.equalsIgnoreCase(this.versionDriver.getVersionId())) {
            return;
        }
        this.versionDriver = VersionMapper.getDriver(versionId);
        if (this.versionDriver == null) {
            throw new RuntimeException(String.format("PersistenceSession: the version %s is not supported", versionId));
        }
        this.beanMapper.reset();
        this.versionDriver.registerBeans(this.beanMapper);
    }

    @Override
    public <T> T readObject(String content, Class<T> classRef) {
        this.refResolver.reset();
        this.beanClass = this.beanMapper.getBeanClass(classRef);
        if (this.beanClass == null) {
            throw new RuntimeException("PersistenceSession: no bean class found");
        }
        IPersistenceBean<?> bean = this.readBeanFromString(content, this.beanClass);
        this.notifyObservers(bean);
        this.refResolver.cacheBean(bean);
        return classRef.cast(bean.get(classRef, this));
    }

    @Override
    public String writeObject(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("PersistenceSession: cannot write a null object");
        }
        IPersistenceBean<?> bean = obj instanceof IPersistenceBean ? (IPersistenceBean<?>)obj : this.refResolver.createBean(obj.getClass());
        this.refResolver.setRootId(bean.getRefId());
        this.refResolver.setRefIdForObject(obj, bean.getRefId());
        bean.set(obj, this);
        this.notifyObservers(bean);
        return this.writeBeanToString(bean);
    }

    protected IPersistenceBean<Annotations> getAnnotationsBean() {
        this.refResolver.reset();
        IPersistenceBean<Annotations> bean = this.refResolver.createBean(Annotations.class);
        if (bean == null) {
            return null;
        }
        bean.set(this.annotations, this);
        return bean;
    }

    protected void setAnnotations(IPersistenceBean<Annotations> annotationsBean) {
        if (annotationsBean == null) {
            return;
        }
        this.annotations = annotationsBean.get(Annotations.class, this);
    }

    @Override
    public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        return this.annotations.get(annotationType);
    }

    @Override
    public void setAnnotation(IAnnotation annotation) {
        this.annotations.set(annotation);
    }

    @Override
    public Iterable<IAnnotation> getAnnotations() {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        return this.annotations;
    }

    protected void hardReset() {
        this.refResolver.hardReset();
    }
}

