/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;

public class ReferenceResolver {
    private static final String MSG1 = "ReferenceResolver: class %s is not registered";
    private static final String MSG2 = "ReferenceResolver: cannot instantiate %s";
    private static final String MSG3 = "ReferenceResolver: object references are broken, reference to a non-existing object";
    private static final String MSG4 = "ReferenceResolver.createAntiBean: objClassRef cannot be null";
    private static final String MSG5 = "ReferenceResolver.createAntiBean: refId cannot be 0";
    private static final String MSG6 = "ReferenceResolver: idCounter overflow";
    private static long idCounter = 0L;
    private long rootId = 0L;
    private IPersistenceSession session;
    private Map<Object, Long> refIdLookup = new ConcurrentHashMap<Object, Long>();
    private Map<Long, Object> objectLookup = new ConcurrentHashMap<Long, Object>();
    private Map<Long, Long> rootLookup = new ConcurrentHashMap<Long, Long>();
    private Map<Object, IPersistenceBean<?>> beanCache = new ConcurrentHashMap();
    private Map<Long, IPersistenceBean<?>> beanCache2 = new ConcurrentHashMap();
    private Map<Long, Set<Long>> references = new LinkedHashMap<Long, Set<Long>>();
    private Set<Set<Long>> frames = new TreeSet<Set<Long>>(new Comparator<Set<Long>>(){

        @Override
        public int compare(Set<Long> frame1, Set<Long> frame2) {
            long e2;
            if (frame1 == null || frame2 == null) {
                return 0;
            }
            if (frame1.size() < 1 || frame2.size() < 1) {
                return 0;
            }
            long e1 = frame1.iterator().next();
            if (e1 < (e2 = frame2.iterator().next().longValue())) {
                return -1;
            }
            if (e1 > e2) {
                return 1;
            }
            return 0;
        }
    });
    private Map<Long, Set<Long>> frameLookup = new ConcurrentHashMap<Long, Set<Long>>();
    private List<Object> serialized = new ArrayList<Object>();

    public ReferenceResolver(IPersistenceSession session) {
        this.session = session;
    }

    public void hardReset() {
        this.reset();
        idCounter = 0L;
        this.rootId = 0L;
    }

    public void reset() {
        this.refIdLookup.clear();
        this.objectLookup.clear();
        this.rootLookup.clear();
        this.beanCache.clear();
        this.beanCache2.clear();
        this.references.clear();
        this.frames.clear();
        this.frameLookup.clear();
        this.serialized.clear();
    }

    public void releaseObject(Object obj) {
        long refId = this.refIdLookup.remove(obj);
        this.beanCache.remove(obj);
        if (refId != 0L) {
            this.objectLookup.remove(refId);
            this.rootLookup.remove(refId);
            this.beanCache2.remove(refId);
        }
    }

    public void removeFrame(Set<Long> frame) {
        this.frames.remove(frame);
        for (Long rid : frame) {
            this.frameLookup.remove(rid);
        }
    }

    public static long generateRefId() {
        if (idCounter == Long.MAX_VALUE) {
            throw new RuntimeException(MSG6);
        }
        return ++idCounter;
    }

    public static void updateRefIdGenerator(long refId) {
        if (idCounter < refId) {
            idCounter = refId;
        }
    }

    public long getRefIdForObject(Object obj) {
        return this.refIdLookup.containsKey(obj) ? this.refIdLookup.get(obj) : 0L;
    }

    public Object getObject(long refId) {
        return this.objectLookup.get(refId);
    }

    public long getRootId(long refId) {
        if (refId < 0L) {
            return refId;
        }
        return this.rootLookup.containsKey(refId) ? this.rootLookup.get(refId) : 0L;
    }

    public void setRefIdForObject(Object obj, long refId) {
        if (obj == null) {
            return;
        }
        if (refId == 0L) {
            throw new RuntimeException(MSG3);
        }
        ReferenceResolver.updateRefIdGenerator(refId);
        this.refIdLookup.put(obj, refId);
        this.rootLookup.put(refId, this.rootId);
        this.objectLookup.put(refId, obj);
    }

    public void setReference(long parentRefId, long childRefId) {
        if (parentRefId == 0L || childRefId == 0L) {
            throw new RuntimeException(MSG3);
        }
        Set<Long> list = this.references.get(parentRefId);
        if (list == null) {
            list = new HashSet<Long>();
            this.references.put(parentRefId, list);
        }
        list.add(childRefId);
    }

    public Map<Long, Set<Long>> getReferences() {
        return this.references;
    }

    public Set<Long> getFrame(long refId) {
        return this.frameLookup.get(refId);
    }

    public void updateFrames() {
        this.frames.clear();
        this.frameLookup.clear();
        for (Long parentRefId : this.references.keySet()) {
            Set<Long> childRefs = this.references.get(parentRefId);
            if (childRefs == null) continue;
            for (Long childRefId : childRefs) {
                Set<Long> childFrame;
                Set<Long> parentFrame;
                long parentRoot = this.getRootId(parentRefId);
                long childRoot = this.getRootId(childRefId);
                if (parentRoot == 0L || childRoot == 0L) {
                    throw new RuntimeException(MSG3);
                }
                if (parentRoot == childRoot || (parentFrame = this.getFrame(parentRoot)) == (childFrame = this.getFrame(childRoot)) && parentFrame != null) continue;
                if (parentFrame == null && childFrame == null) {
                    TreeSet<Long> frame = new TreeSet<Long>();
                    frame.add(parentRoot);
                    frame.add(childRoot);
                    this.frames.add(frame);
                    this.frameLookup.put(parentRoot, frame);
                    this.frameLookup.put(childRoot, frame);
                    continue;
                }
                if (parentFrame == null && childFrame != null) {
                    childFrame.add(parentRoot);
                    this.frameLookup.put(parentRoot, childFrame);
                    continue;
                }
                if (parentFrame != null && childFrame == null) {
                    parentFrame.add(childRoot);
                    this.frameLookup.put(childRoot, parentFrame);
                    continue;
                }
                if (parentFrame == null || childFrame == null) continue;
                parentFrame.addAll(childFrame);
                this.frames.remove(childFrame);
                this.frameLookup.remove(childRoot);
            }
        }
    }

    public void setRootId(long rootId) {
        this.rootId = rootId;
    }

    public <T> IPersistenceBean<T> createBean(Class<T> classRef) {
        Class<IPersistenceBean<T>> beanClass = this.session.getBeanClass(classRef);
        if (beanClass == null) {
            throw new RuntimeException(String.format(MSG1, classRef.getName()));
        }
        IPersistenceBean<T> bean = null;
        try {
            bean = ClassUtil.instantiateClass(beanClass);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(MSG2, beanClass.getName()), e);
        }
        return bean;
    }

    public void cacheBean(Object obj, IPersistenceBean<?> bean) {
        this.beanCache.put(obj, bean);
    }

    public void cacheBean(IPersistenceBean<?> bean) {
        if (bean == null) {
            return;
        }
        this.beanCache2.put(bean.getRefId(), bean);
    }

    public IPersistenceBean<?> uncacheBean(Object obj) {
        IPersistenceBean<?> bean = this.beanCache.get(obj);
        this.beanCache.remove(obj);
        return bean;
    }

    public IPersistenceBean<?> uncacheBean(Long refId) {
        IPersistenceBean<?> bean = this.beanCache2.get(refId);
        this.beanCache2.remove(refId);
        return bean;
    }

    public List<List<Long>> getFrames() {
        ArrayList<List<Long>> frames = new ArrayList<List<Long>>();
        for (Set<Long> frame : this.frames) {
            ArrayList<Long> frameList = new ArrayList<Long>(frame);
            frames.add(frameList);
        }
        return frames;
    }

    public void setFrames(List<List<?>> frames) {
        this.frameLookup.clear();
        for (List<?> frame : frames) {
            TreeSet<Long> newFrame = new TreeSet<Long>();
            this.frames.add(newFrame);
            Long rid = null;
            for (Object refId : frame) {
                if (refId instanceof Long) {
                    rid = (Long)refId;
                } else if (refId instanceof Integer) {
                    rid = new Long(((Integer)refId).intValue());
                }
                newFrame.add(rid);
                this.frameLookup.put(rid, newFrame);
            }
        }
    }

    public boolean isFrameAvailable(Set<Long> frame) {
        for (Long refId : frame) {
            if (this.beanCache2.containsKey(refId)) continue;
            return false;
        }
        return true;
    }

    public <T> IPersistenceBean<T> createAntiBean(Class<T> objClassRef, long refId) {
        if (objClassRef == null) {
            throw new IllegalArgumentException(MSG4);
        }
        if (refId == 0L) {
            throw new IllegalArgumentException(MSG5);
        }
        ReferenceResolver.updateRefIdGenerator(refId);
        IPersistenceBean<T> res = this.createBean(objClassRef);
        if (refId > 0L) {
            refId = -refId;
        }
        res.setRefId(refId);
        this.setReference(refId, -refId);
        return res;
    }

    public boolean isSerialized(Object obj) {
        return this.serialized.contains(obj);
    }

    public void setSerialized(Object obj) {
        this.serialized.add(obj);
    }
}

