/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.preprocessing.filters.simplification;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private String filterConfigId;
    private boolean simplifyResources;
    private boolean simplifyCodes;

    public Parameters() {
        this.reset();
        this.toString();
    }

    @Override
    public void reset() {
        this.filterConfigId = "okf_xmlstream";
        this.simplifyResources = true;
        this.simplifyCodes = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.filterConfigId = this.buffer.getString("filterConfigId", this.filterConfigId);
        this.simplifyResources = this.buffer.getBoolean("simplifyResources", this.simplifyResources);
        this.simplifyCodes = this.buffer.getBoolean("simplifyCodes", this.simplifyCodes);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString("filterConfigId", this.filterConfigId);
        this.buffer.setBoolean("simplifyResources", this.simplifyResources);
        this.buffer.setBoolean("simplifyCodes", this.simplifyCodes);
        return this.buffer.toString();
    }

    public String getFilterConfigId() {
        return this.filterConfigId;
    }

    public void setFilterConfigId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    public boolean isSimplifyResources() {
        return this.simplifyResources;
    }

    public void setSimplifyResources(boolean simplifyResources) {
        this.simplifyResources = simplifyResources;
    }

    public boolean isSimplifyCodes() {
        return this.simplifyCodes;
    }

    public void setSimplifyCodes(boolean simplifyCodes) {
        this.simplifyCodes = simplifyCodes;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add("filterConfigId", "Filter configuration ID", null);
        desc.add("simplifyResources", "Simplify resources", "Simplify resources generated by the filter removing references in resources (resource flattening)");
        desc.add("simplifyCodes", "Simplify codes", "Merge adjacent inline codes in the source part of a text unit, moves leading and trailing codes to the skeleton");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("Simplification Filter Parameters", true, false);
        desc.addTextInputPart(parametersDescription.get("filterConfigId"));
        desc.addCheckboxPart(parametersDescription.get("simplifyResources"));
        desc.addCheckboxPart(parametersDescription.get("simplifyCodes"));
        return desc;
    }
}

