/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.lib.xliff.AMarker;
import net.sf.okapi.lib.xliff.CMarker;
import net.sf.okapi.lib.xliff.Candidate;
import net.sf.okapi.lib.xliff.DocumentData;
import net.sf.okapi.lib.xliff.ExtendedAttribute;
import net.sf.okapi.lib.xliff.ExtendedAttributes;
import net.sf.okapi.lib.xliff.ExtendedContent;
import net.sf.okapi.lib.xliff.ExtendedElement;
import net.sf.okapi.lib.xliff.ExtendedElements;
import net.sf.okapi.lib.xliff.Fragment;
import net.sf.okapi.lib.xliff.GlossEntry;
import net.sf.okapi.lib.xliff.GroupData;
import net.sf.okapi.lib.xliff.InsingnificantPartData;
import net.sf.okapi.lib.xliff.Note;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.SectionData;
import net.sf.okapi.lib.xliff.SkeletonData;
import net.sf.okapi.lib.xliff.Unit;
import net.sf.okapi.lib.xliff.Util;
import net.sf.okapi.lib.xliff.XLIFFEvent;
import net.sf.okapi.lib.xliff.XLIFFEventType;
import net.sf.okapi.lib.xliff.XLIFFReaderException;
import org.oasisopen.xliff.v2.Directionality;
import org.oasisopen.xliff.v2.IAMarker;
import org.oasisopen.xliff.v2.ICMarker;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IExtendedChild;
import org.oasisopen.xliff.v2.IExtendedElements;
import org.oasisopen.xliff.v2.IMarker;
import org.oasisopen.xliff.v2.INote;
import org.oasisopen.xliff.v2.IPart;
import org.oasisopen.xliff.v2.ISegment;
import org.oasisopen.xliff.v2.IWithCandidates;
import org.oasisopen.xliff.v2.IWithCustomProperties;
import org.oasisopen.xliff.v2.IWithGlossary;
import org.oasisopen.xliff.v2.IWithNotes;
import org.oasisopen.xliff.v2.MarkerType;
import org.oasisopen.xliff.v2.OriginalDataStyle;

public class XLIFFReader {
    private static final char REPCHAR = '\ufffd';
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private XMLStreamReader reader;
    private LinkedList<XLIFFEvent> queue;
    private DocumentData docData;
    private SectionData sectionData;
    private Stack<GroupData> groups;
    private boolean checkTargetOrder;
    private Unit unit;
    private ISegment segment;
    private IPart ignorable;
    private Stack<Boolean> preserveWS;
    private boolean reportUnsingnificantParts = false;
    private IExtendedElements fileExtElems;

    public void open(File file) {
        try {
            this.open(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new XLIFFReaderException("File not found. " + e.getMessage(), e);
        }
    }

    public void open(URI inputURI) {
        try {
            BufferedInputStream bis = new BufferedInputStream(inputURI.toURL().openStream());
            this.open(bis);
        }
        catch (Throwable e) {
            throw new XLIFFReaderException("Cannot open the XLIFF stream. " + e.getMessage(), e);
        }
    }

    public void open(String input) {
        this.open(new ByteArrayInputStream(input.getBytes()));
    }

    public void open(InputStream inputStream) {
        try {
            XMLInputFactory fact = XMLInputFactory.newInstance();
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            this.reader = fact.createXMLStreamReader(inputStream);
            this.groups = new Stack();
            this.preserveWS = new Stack();
            this.preserveWS.push(false);
            this.queue = new LinkedList();
            this.queue.add(new XLIFFEvent(XLIFFEventType.START_INPUT));
        }
        catch (XMLStreamException e) {
            throw new XLIFFReaderException("Cannot open the XLIFF stream. " + e.getMessage(), e);
        }
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (XMLStreamException e) {
            throw new XLIFFReaderException("Closing error. " + e.getMessage(), e);
        }
    }

    public boolean hasNext() {
        try {
            return this.reader.hasNext();
        }
        catch (XMLStreamException e) {
            throw new XLIFFReaderException("Reading error. " + e.getMessage(), e);
        }
    }

    public XLIFFEvent next() {
        if (this.queue.isEmpty()) {
            this.readNext();
        }
        if (this.queue.peek().getType() == XLIFFEventType.END_INPUT && this.preserveWS.size() != 1) {
            this.logger.warning(String.format("Stack for xml:space is at %d instead of 1.", this.preserveWS.size()));
        }
        return this.queue.poll();
    }

    public void setReportUnsingnificantParts(boolean reportUnsingnificantParts) {
        this.reportUnsingnificantParts = reportUnsingnificantParts;
    }

    private void readNext() {
        try {
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                switch (type) {
                    case 7: {
                        break;
                    }
                    case 8: {
                        this.queue.add(new XLIFFEvent(XLIFFEventType.END_INPUT));
                        return;
                    }
                    case 1: {
                        String tmp = this.reader.getLocalName();
                        String nsUri = this.reader.getNamespaceURI();
                        this.pushWSState();
                        if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                            if (tmp.equals("unit")) {
                                this.processUnit();
                                return;
                            }
                            if (tmp.equals("group")) {
                                this.processStartGroup();
                                return;
                            }
                            if (tmp.equals("file")) {
                                this.processStartSection();
                                return;
                            }
                            if (tmp.equals("xliff")) {
                                this.processXliff();
                                return;
                            }
                            if (tmp.equals("skeleton")) {
                                this.processSkeleton();
                                return;
                            }
                        }
                        this.fileExtElems = this.processExtendedElement(this.fileExtElems);
                        break;
                    }
                    case 2: {
                        String tmp = this.reader.getLocalName();
                        String nsUri = this.reader.getNamespaceURI();
                        this.popWSState();
                        if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                        if (tmp.equals("group")) {
                            this.queue.add(new XLIFFEvent(XLIFFEventType.END_GROUP));
                            this.groups.pop();
                            return;
                        }
                        if (tmp.equals("file")) {
                            this.queue.add(new XLIFFEvent(XLIFFEventType.END_FILE));
                            return;
                        }
                        if (!tmp.equals("xliff")) break;
                        this.queue.add(new XLIFFEvent(XLIFFEventType.END_XLIFF));
                        return;
                    }
                    case 4: 
                    case 6: {
                        if (this.reportUnsingnificantParts) {
                            this.queue.add(new XLIFFEvent(XLIFFEventType.INSIGNIFICANT_PART, new InsingnificantPartData(InsingnificantPartData.InsignificantPartType.TEXT, this.reader.getText())));
                            return;
                        }
                    }
                    case 5: {
                        if (!this.reportUnsingnificantParts) break;
                        this.queue.add(new XLIFFEvent(XLIFFEventType.INSIGNIFICANT_PART, new InsingnificantPartData(InsingnificantPartData.InsignificantPartType.COMMENT, "<!--" + this.reader.getText() + "-->")));
                        return;
                    }
                    case 3: {
                        if (!this.reportUnsingnificantParts) break;
                        this.queue.add(new XLIFFEvent(XLIFFEventType.INSIGNIFICANT_PART, new InsingnificantPartData(InsingnificantPartData.InsignificantPartType.PI, "<?" + this.reader.getText() + "?>")));
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new XLIFFReaderException("Reading error. " + e.getMessage(), e);
        }
    }

    private void pushWSState() {
        String tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "space");
        if (!Util.isNullOrEmpty(tmp)) {
            this.preserveWS.push(tmp.equals("preserve"));
        } else {
            this.preserveWS.push(this.preserveWS.peek());
        }
    }

    private void popWSState() {
        this.preserveWS.pop();
    }

    private void processXliff() {
        String tmp = this.reader.getAttributeValue(null, "version");
        this.cannotBeNullOrEmpty("version", tmp);
        if (!tmp.equals("2.0")) {
            throw new XLIFFReaderException("Not a 2.0 XLIFF document.");
        }
        this.docData = new DocumentData(tmp);
        tmp = this.reader.getAttributeValue(null, "srcLang");
        this.cannotBeNullOrEmpty("srcLang", tmp);
        this.docData.setSourceLanguage(tmp);
        tmp = this.reader.getAttributeValue(null, "tgtLang");
        if (this.cannotBeEmpty("tgtLang", tmp)) {
            this.docData.setTargetLanguage(tmp);
        }
        this.docData.setExtendedAttributes(this.gatherExtendedAttributes());
        this.queue.add(new XLIFFEvent(XLIFFEventType.START_XLIFF, this.docData));
    }

    private void processStartSection() {
        this.fileExtElems = null;
        this.sectionData = new SectionData("sectionId");
        String tmp = this.reader.getAttributeValue(null, "original");
        if (this.cannotBeEmpty("original", tmp)) {
            this.sectionData.setOriginal(tmp);
        }
        if (this.cannotBeEmpty("skeleton", tmp = this.reader.getAttributeValue(null, "skeleton"))) {
            this.sectionData.setSkeleton(tmp);
        }
        this.sectionData.setSourceDir(this.getDirectionality("srcDir", this.reader.getAttributeValue(null, "srcDir"), Directionality.LTR));
        this.sectionData.setTargetDir(this.getDirectionality("trgDir", this.reader.getAttributeValue(null, "trgDir"), Directionality.LTR));
        this.sectionData.setExtendedAttributes(this.gatherExtendedAttributes());
        this.queue.add(new XLIFFEvent(XLIFFEventType.START_FILE, this.sectionData));
    }

    private void processSkeleton() throws XMLStreamException {
        SkeletonData skelData = new SkeletonData("skelId");
        QName qn = new QName("urn:oasis:names:tc:xliff:document:2.0", "skeleton");
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    skelData.addChild(this.readExtendedElement());
                    break;
                }
                case 2: {
                    if (!this.reader.getName().equals(qn)) break;
                    this.popWSState();
                    this.queue.add(new XLIFFEvent(XLIFFEventType.SKELETON, skelData));
                    return;
                }
                case 4: 
                case 6: {
                    skelData.addChild(new ExtendedContent(this.reader.getText()));
                    break;
                }
                case 12: {
                    skelData.addChild(new ExtendedContent(this.reader.getText(), true));
                }
            }
        }
    }

    private void processStartGroup() {
        String tmp = this.reader.getAttributeValue(null, "id");
        this.cannotBeEmpty("id", tmp);
        GroupData gd = new GroupData(tmp);
        tmp = this.reader.getAttributeValue(null, "type");
        if (this.cannotBeEmpty("type", tmp)) {
            gd.setType(tmp);
        }
        gd.setExtendedAttributes(this.gatherExtendedAttributes());
        this.groups.push(gd);
        this.queue.add(new XLIFFEvent(XLIFFEventType.START_FILE, gd));
    }

    private int checkIntegerValue(String name, String value, int min, int max) {
        if (value == null) {
            return -1;
        }
        if (value.isEmpty()) {
            throw new XLIFFReaderException(String.format("Empty attribute '%s'", name));
        }
        try {
            int tmp = Integer.parseInt(value);
            if (tmp < min || tmp > max) {
                throw new XLIFFReaderException(String.format("Invalid value for attribute '%s'", name));
            }
            return tmp;
        }
        catch (NumberFormatException e) {
            throw new XLIFFReaderException(String.format("Invalid value for attribute '%s'", name));
        }
    }

    private float checkFloatValue(String name, String value, float min, float max) {
        if (value == null) {
            return -1.0f;
        }
        if (value.isEmpty()) {
            throw new XLIFFReaderException(String.format("Empty attribute '%s'", name));
        }
        try {
            float tmp = Float.parseFloat(value);
            if (tmp < min || tmp > max) {
                throw new XLIFFReaderException(String.format("Invalid value for attribute '%s'", name));
            }
            return tmp;
        }
        catch (NumberFormatException e) {
            throw new XLIFFReaderException(String.format("Invalid value for attribute '%s'", name));
        }
    }

    private void cannotBeNullOrEmpty(String name, String value) {
        if (Util.isNullOrEmpty(value)) {
            throw new XLIFFReaderException(String.format("Missing or empty attribute '%s'", name));
        }
    }

    private Directionality getDirectionality(String name, String value, Directionality defValue) {
        if (value == null) {
            return defValue;
        }
        if (value.isEmpty() || !value.equals("ltr") && !value.equals("rtl")) {
            throw new XLIFFReaderException(String.format("Invalid attribute value for '%s' (must be '%s' or '%s')", name, "ltr", "rtl"));
        }
        if (value.equals("ltr")) {
            return Directionality.LTR;
        }
        return Directionality.RTL;
    }

    private boolean getYesOrNo(String name, String value, boolean defValue) {
        if (value == null) {
            return defValue;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no")) {
            throw new XLIFFReaderException(String.format("Invalid attribute value for '%s' (must be '%s' or '%s')", name, "yes", "no"));
        }
        return value.equals("yes");
    }

    private boolean cannotBeEmpty(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            throw new XLIFFReaderException(String.format("Empty attribute '%s'", name));
        }
        return true;
    }

    private boolean canBeYesOrNo(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no")) {
            throw new XLIFFReaderException(String.format("Invalid attribute value for '%s' (must be '%s' or '%s')", name, "yes", "no"));
        }
        return true;
    }

    private void processUnit() throws XMLStreamException {
        String tmp = this.reader.getAttributeValue(null, "id");
        this.cannotBeNullOrEmpty("id", tmp);
        this.unit = new Unit(tmp);
        Map<String, String> unitODM = null;
        this.unit.setSourceDir(this.getDirectionality("srcDir", this.reader.getAttributeValue(null, "srcDir"), this.sectionData.getSourceDir()));
        this.unit.setTargetDir(this.getDirectionality("trgDir", this.reader.getAttributeValue(null, "trgDir"), this.sectionData.getTargetDir()));
        IExtendedElements unitExtElems = null;
        this.checkTargetOrder = false;
        this.unit.setExtendedAttributes(this.gatherExtendedAttributes());
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushWSState();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        if (tmp.equals("segment")) {
                            this.processPart(true);
                            break;
                        }
                        if (tmp.equals("ignorable")) {
                            this.processPart(false);
                            break;
                        }
                        if (tmp.equals("originalData")) {
                            unitODM = this.processOriginalData();
                            break;
                        }
                        if (tmp.equals("notes") || !tmp.equals("note")) break;
                        this.processNote(this.unit);
                        break;
                    }
                    if (nsUri.equals("urn:oasis:names:tc:xliff:matches:2.0")) {
                        if (!tmp.equals("match")) break;
                        this.processCandidate(this.unit, unitODM);
                        break;
                    }
                    if (nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0")) {
                        if (!tmp.equals("glossEntry")) break;
                        this.processGlossEntry(this.unit);
                        break;
                    }
                    if (nsUri.equals("urn:oasis:names:tc:xliff:metadata:2.0")) {
                        if (!tmp.equals("meta")) break;
                        this.processCustomProperty(this.unit);
                        break;
                    }
                    unitExtElems = this.processExtendedElement(unitExtElems);
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popWSState();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0") || !tmp.equals("unit")) break;
                    if (unitExtElems != null) {
                        this.unit.setExtendedElements(unitExtElems);
                    }
                    this.copyOriginalDataToCodes(this.unit.getDataStore(), unitODM);
                    if (this.checkTargetOrder) {
                        int max = this.unit.getPartCount();
                        int i = 0;
                        for (IPart part : this.unit) {
                            int order = part.getTargetOrder();
                            if (order > max) {
                                throw new XLIFFReaderException(String.format("Invalid target order '%d'.", order));
                            }
                            if (order > 0) {
                                for (int j = 0; j < max; ++j) {
                                    IPart part2 = this.unit.getPart(j);
                                    if (order != part2.getTargetOrder() || i == j) continue;
                                    throw new XLIFFReaderException(String.format("The parts %d and %d have the same target order: '%d'.", i + 1, j + 1, order));
                                }
                            }
                            ++i;
                        }
                    }
                    this.queue.add(new XLIFFEvent(XLIFFEventType.TEXT_UNIT, this.unit));
                    return;
                }
            }
        }
    }

    private void processCandidate(IWithCandidates parent, Map<String, String> originalDataMap) throws XMLStreamException {
        Candidate alt = new Candidate();
        Map<String, String> altODM = null;
        Part part = new Part(alt.getDataStore());
        float val = this.checkFloatValue("similarity", this.reader.getAttributeValue(null, "similarity"), 0.0f, 100.0f);
        if (val != -1.0f) {
            alt.setSimilarity(val);
        }
        alt.setType(this.reader.getAttributeValue(null, "type"));
        alt.setOrigin(this.reader.getAttributeValue(null, "origin"));
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushWSState();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                    if (tmp.equals("source")) {
                        this.processContent(part, false);
                        alt.setSource(part.getSource());
                        break;
                    }
                    if (tmp.equals("target")) {
                        this.processContent(part, true);
                        alt.setTarget(part.getTarget(false));
                        break;
                    }
                    if (!tmp.equals("originalData")) break;
                    altODM = this.processOriginalData();
                    break;
                }
                case 2: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popWSState();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:matches:2.0") || !tmp.equals("match")) break;
                    this.copyOriginalDataToCodes(alt.getDataStore(), altODM);
                    parent.addCandidate(alt);
                    return;
                }
            }
        }
    }

    private void processGlossEntry(IWithGlossary parent) throws XMLStreamException {
        String term = null;
        String translation = null;
        String definition = null;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushWSState();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0")) break;
                    if (tmp.equals("term")) {
                        term = this.getTextContent();
                        break;
                    }
                    if (tmp.equals("translation")) {
                        translation = this.getTextContent();
                        break;
                    }
                    if (!tmp.equals("definition")) break;
                    definition = this.getTextContent();
                    break;
                }
                case 2: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popWSState();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0") || !tmp.equals("glossEntry")) break;
                    if (Util.isNullOrEmpty(term)) {
                        throw new XLIFFReaderException("The element term must exist and not be empty.");
                    }
                    if (Util.isNullOrEmpty(translation) && Util.isNullOrEmpty(definition)) {
                        throw new XLIFFReaderException("You must have at least a translation or a definition for a term.");
                    }
                    parent.getGlossaryEntries().add(new GlossEntry(term, translation, definition));
                    return;
                }
            }
        }
    }

    private void processCustomProperty(IWithCustomProperties parent) throws XMLStreamException {
        String type = this.reader.getAttributeValue(null, "type");
        this.cannotBeNullOrEmpty("id", type);
        parent.getCustomProperties().put(type, this.getTextContent());
    }

    private String getTextContent() throws XMLStreamException {
        StringBuilder tmp = new StringBuilder();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: 
                case 12: {
                    tmp.append(this.reader.getText());
                    break;
                }
                case 2: {
                    this.popWSState();
                    return tmp.toString();
                }
            }
        }
        return null;
    }

    private void copyOriginalDataToCodes(IDataStore dataStore, Map<String, String> originalDataMap) {
        ICMarker code;
        String nid;
        if (dataStore == null) {
            return;
        }
        if (dataStore.hasSourceMarker()) {
            for (IMarker marker : dataStore.getSourceMarkers()) {
                if (marker.isAnnotation() || (nid = (code = (ICMarker)marker).getDataRef()) == null) continue;
                if (!originalDataMap.containsKey(nid)) {
                    throw new XLIFFReaderException(String.format("No original data found for the id '%s'.", nid));
                }
                code.setOriginalData(originalDataMap.get(nid));
            }
        }
        if (dataStore.hasTargetMarker()) {
            for (IMarker marker : dataStore.getTargetMarkers()) {
                if (marker.isAnnotation() || (nid = (code = (ICMarker)marker).getDataRef()) == null) continue;
                if (!originalDataMap.containsKey(nid)) {
                    throw new XLIFFReaderException(String.format("No original data found for the id '%s'.", nid));
                }
                code.setOriginalData(originalDataMap.get(nid));
            }
        }
    }

    private void processNote(IWithNotes parent) throws XMLStreamException {
        INote.AppliesTo at = INote.AppliesTo.DEFAULT;
        String tmp = this.reader.getAttributeValue(null, "appliesTo");
        if (this.cannotBeEmpty("appliesTo", tmp)) {
            if (tmp.equals("source")) {
                at = INote.AppliesTo.SOURCE;
            } else if (tmp.equals("target")) {
                at = INote.AppliesTo.TARGET;
            } else {
                throw new XLIFFReaderException(String.format("Invalid appliesTo value ('%s').", tmp));
            }
        }
        String id = this.reader.getAttributeValue(null, "id");
        StringBuilder sb = new StringBuilder();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    sb.append(this.reader.getText());
                    break;
                }
                case 1: {
                    this.pushWSState();
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popWSState();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0") || !tmp.equals("note")) break;
                    Note note = new Note(sb.toString(), at);
                    if (this.cannotBeEmpty("id", id)) {
                        note.setId(id);
                    }
                    parent.addNote(note);
                    return;
                }
            }
        }
    }

    private Map<String, String> processOriginalData() throws XMLStreamException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        StringBuilder content = new StringBuilder();
        String id = null;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    if (id == null) break;
                    content.append(this.reader.getText());
                    break;
                }
                case 1: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushWSState();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                    if (tmp.equals("data")) {
                        id = this.reader.getAttributeValue(null, "id");
                        this.cannotBeNullOrEmpty("id", id);
                        if (map.containsKey(id)) {
                            throw new XLIFFReaderException(String.format("Duplicated id ('%s') in original data table.", id));
                        }
                        content.setLength(0);
                        break;
                    }
                    if (!tmp.equals("cp")) break;
                    tmp = this.reader.getAttributeValue(null, "hex");
                    this.cannotBeNullOrEmpty("hex", tmp);
                    try {
                        int cp = Integer.valueOf(tmp, 16);
                        if (cp > 65535) {
                            content.append(Character.toChars(cp));
                            break;
                        }
                        content.append((char)cp);
                    }
                    catch (NumberFormatException e) {
                        this.logger.severe(String.format("Invalid code-point value in '%s': '%s'", "hex", tmp));
                        content.append('\ufffd');
                    }
                    break;
                }
                case 2: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popWSState();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                    if (tmp.equals("data")) {
                        map.put(id, content.toString());
                        id = null;
                        break;
                    }
                    if (!tmp.equals("originalData")) break;
                    return map;
                }
            }
        }
        return null;
    }

    private void processPart(boolean isSegment) throws XMLStreamException {
        String tmp;
        IPart part;
        Map<String, String> segmentODM = null;
        if (isSegment) {
            this.segment = this.unit.appendNewSegment();
            part = this.segment;
            tmp = this.reader.getAttributeValue(null, "id");
            if (this.cannotBeEmpty("id", tmp)) {
                this.segment.setId(tmp);
            }
            if (this.canBeYesOrNo("translate", tmp = this.reader.getAttributeValue(null, "translate"))) {
                this.segment.setTranslate(tmp.equals("yes"));
            }
            if (this.canBeYesOrNo("approved", tmp = this.reader.getAttributeValue(null, "approved"))) {
                this.segment.setApproved(tmp.equals("yes"));
            }
        } else {
            part = this.ignorable = this.unit.appendNewIgnorable();
        }
        part.setExtendedAttributes(this.gatherExtendedAttributes());
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushWSState();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        if (tmp.equals("source")) {
                            if (isSegment) {
                                this.processContent(this.segment, false);
                                break;
                            }
                            this.processContent(this.ignorable, false);
                            break;
                        }
                        if (tmp.equals("target")) {
                            if (isSegment) {
                                this.processContent(this.segment, true);
                            } else {
                                this.processContent(this.ignorable, true);
                            }
                            if (this.docData.getTargetLanguage() != null) break;
                            throw new XLIFFReaderException("No target language defined in a file with a target entry.");
                        }
                        if (!tmp.equals("note")) break;
                        this.processNote(this.segment);
                        break;
                    }
                    if (nsUri.equals("urn:oasis:names:tc:xliff:matches:2.0")) {
                        if (!tmp.equals("match")) break;
                        this.processCandidate(this.segment, segmentODM);
                        break;
                    }
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:metadata:2.0") || !tmp.equals("meta")) break;
                    this.processCustomProperty(isSegment ? this.segment : this.ignorable);
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popWSState();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0") || !tmp.equals("segment") && !tmp.equals("ignorable")) break;
                    return;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processContent(IPart partToFill, boolean isTarget) throws XMLStreamException {
        frag = new Fragment(partToFill.getDataStore(), isTarget);
        code = null;
        inTextContent = true;
        dataRef = null;
        pairs = new Stack<IMarker>();
        partToFill.setPreserveWS(this.preserveWS.peek());
        tmp = this.reader.getAttributeValue(null, "order");
        if (this.cannotBeEmpty("order", tmp)) {
            try {
                order = Integer.parseInt(tmp);
                partToFill.setTargetOrder(order);
                this.checkTargetOrder = true;
            }
            catch (NumberFormatException e) {
                throw new XLIFFReaderException(String.format("Invalid numeric value '%s' for order attribute.", new Object[]{tmp}));
            }
        }
        frag.setDir(this.getDirectionality("dir", this.reader.getAttributeValue(null, "dir"), Directionality.INHERITED));
        currentElem = null;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    if (inTextContent) {
                        frag.append(this.reader.getText());
                        break;
                    }
                    throw new XLIFFReaderException(String.format("The <%s> element must be empty.", new Object[]{currentElem}));
                }
                case 3: 
                case 5: {
                    break;
                }
                case 1: {
                    currentElem = tmp = this.reader.getLocalName();
                    if (!this.reader.getNamespaceURI().equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        throw new XLIFFReaderException("Only the core namespace is allowed in content.");
                    }
                    if (tmp.equals("sc")) {
                        tmp = this.reader.getAttributeValue(null, "id");
                        this.cannotBeNullOrEmpty("id", tmp);
                        this.canBeYesOrNo("isolated", this.reader.getAttributeValue(null, "isolated"));
                        code = frag.append(MarkerType.OPENING, tmp, null, this.getYesOrNo("canOverlap", this.reader.getAttributeValue(null, "canOverlap"), true));
                        this.setCommonAttributes(code);
                        dataRef = this.setDataRef(code, partToFill.getDataStore());
                        inTextContent = false;
                        break;
                    }
                    if (tmp.equals("ec")) {
                        isolated = this.reader.getAttributeValue(null, "isolated");
                        if (isolated != null) {
                            this.canBeYesOrNo("isolated", isolated);
                            tmp = this.reader.getAttributeValue(null, "id");
                            this.cannotBeNullOrEmpty("id", tmp);
                        } else {
                            tmp = this.reader.getAttributeValue(null, "startRef");
                            this.cannotBeNullOrEmpty("startRef", tmp);
                        }
                        code = frag.append(MarkerType.CLOSING, tmp, null, this.getYesOrNo("canOverlap", this.reader.getAttributeValue(null, "canOverlap"), true));
                        this.setCommonAttributes(code);
                        dataRef = this.setDataRef(code, partToFill.getDataStore());
                        inTextContent = false;
                        break;
                    }
                    if (tmp.equals("ph")) {
                        tmp = this.reader.getAttributeValue(null, "id");
                        this.cannotBeNullOrEmpty("id", tmp);
                        code = frag.appendPlaceholder(tmp, null);
                        this.setCommonAttributes(code);
                        dataRef = this.setDataRef(code, partToFill.getDataStore());
                        inTextContent = false;
                        break;
                    }
                    if (tmp.equals("pc")) {
                        id = this.reader.getAttributeValue(null, "id");
                        this.cannotBeNullOrEmpty("id", id);
                        code = frag.append(MarkerType.OPENING, id, null, this.getYesOrNo("canOverlap", this.reader.getAttributeValue(null, "canOverlap"), false));
                        code.setEquiv(this.reader.getAttributeValue(null, "equivStart"));
                        code.setDisp(this.reader.getAttributeValue(null, "dispStart"));
                        code.setSubFlows(this.reader.getAttributeValue(null, "subFlowsStart"));
                        this.setHintsAttributes(code);
                        tmp = this.reader.getAttributeValue(null, "dataRefStart");
                        if (this.cannotBeEmpty("dataRef", tmp)) {
                            dataRef = tmp;
                            code.setDataRef(dataRef);
                        }
                        code = null;
                        closing = new CMarker(MarkerType.CLOSING, id, null);
                        closing.setEquiv(this.reader.getAttributeValue(null, "equivEnd"));
                        closing.setDisp(this.reader.getAttributeValue(null, "dispEnd"));
                        closing.setSubFlows(this.reader.getAttributeValue(null, "subFlowsEnd"));
                        this.setHintsAttributes(closing);
                        tmp = this.reader.getAttributeValue(null, "dataRefEnd");
                        if (tmp != null && dataRef == null || tmp == null && dataRef != null) {
                            throw new XLIFFReaderException(String.format("Both '%s' and '%s' must be present or absent.", new Object[]{"dataRefStart", "dataRefEnd"}));
                        }
                        if (this.cannotBeEmpty("dataRef", tmp)) {
                            closing.setDataRef(tmp);
                        }
                        dataRef = null;
                        pairs.push(closing);
                        break;
                    }
                    if (tmp.equals("sm")) {
                        id = this.reader.getAttributeValue(null, "id");
                        this.cannotBeNullOrEmpty("id", id);
                        tmp = this.reader.getAttributeValue(null, "type");
                        this.cannotBeEmpty("type", tmp);
                        ann = new AMarker(id, true, tmp);
                        frag.append(ann);
                        ann.setValue(this.reader.getAttributeValue(null, "value"));
                        ann.setRef(this.reader.getAttributeValue(null, "ref"));
                        ann.setTranslate(this.reader.getAttributeValue(null, "translate"));
                        break;
                    }
                    if (tmp.equals("em")) {
                        tmp = this.reader.getAttributeValue(null, "startRef");
                        this.cannotBeNullOrEmpty("startRef", tmp);
                        ann = new AMarker(tmp, false, "TODO");
                        frag.append(ann);
                        break;
                    }
                    if (tmp.equals("mrk")) {
                        tmp = this.reader.getAttributeValue(null, "type");
                        this.cannotBeEmpty("type", tmp);
                        id = this.reader.getAttributeValue(null, "id");
                        this.cannotBeNullOrEmpty("id", id);
                        ann = new AMarker(id, true, tmp);
                        frag.append(ann);
                        ann.setValue(this.reader.getAttributeValue(null, "value"));
                        ann.setRef(this.reader.getAttributeValue(null, "ref"));
                        ann.setTranslate(this.reader.getAttributeValue(null, "translate"));
                        ann2 = new AMarker(id, false, tmp);
                        ann2.setRef(ann.getRef());
                        ann2.setValue(ann.getValue());
                        ann2.setTranslate(ann.getTranslate());
                        pairs.push(ann2);
                        break;
                    }
                    if (tmp.equals("cp")) {
                        tmp = this.reader.getAttributeValue(null, "hex");
                        this.cannotBeNullOrEmpty("hex", tmp);
                        try {
                            cp = Integer.valueOf(tmp, 16);
                            if (cp > 65535) {
                                chars = Character.toChars(cp);
                                if (inTextContent) {
                                    frag.append(chars[0]);
                                    frag.append(chars[1]);
                                    ** break;
                                }
                                throw new XLIFFReaderException(String.format("The <%s> element must be empty.", new Object[]{"cp"}));
                            }
                            if (inTextContent) {
                                frag.append((char)cp);
                                ** break;
                            }
                            throw new XLIFFReaderException(String.format("The <%s> element must be empty.", new Object[]{"cp"}));
lbl146:
                            // 2 sources

                            break;
                        }
                        catch (NumberFormatException e) {
                            this.logger.severe(String.format("Invalid code-point value in '%s': '%s'", new Object[]{"hex", tmp}));
                            if (inTextContent) {
                                frag.append('\ufffd');
                                break;
                            }
                            throw new XLIFFReaderException(String.format("The <%s> element must be empty.", new Object[]{"cp"}));
                        }
                    }
                    throw new XLIFFReaderException(String.format("Invalid element in inline content: '%s'", new Object[]{this.reader.getName().toString()}));
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    if (!this.reader.getNamespaceURI().equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        throw new XLIFFReaderException("Only the core namespace is allowed in content.");
                    }
                    if (tmp.equals("sc") || tmp.equals("ec") || tmp.equals("ph")) {
                        code.setOriginalDataStyle(dataRef == null ? OriginalDataStyle.NODATA : OriginalDataStyle.OUTSIDE);
                        inTextContent = true;
                        dataRef = null;
                        break;
                    }
                    if (tmp.equals("pc")) {
                        frag.append((ICMarker)pairs.pop());
                        break;
                    }
                    if (tmp.equals("mrk")) {
                        frag.append((IAMarker)pairs.pop());
                        break;
                    }
                    if (tmp.equals("source")) {
                        partToFill.setSource(frag);
                        this.popWSState();
                        return;
                    }
                    if (!tmp.equals("target")) break;
                    partToFill.setTarget(frag);
                    this.popWSState();
                    return;
                }
            }
        }
    }

    private void setCommonAttributes(ICMarker code) {
        code.setEquiv(this.reader.getAttributeValue(null, "equiv"));
        code.setDisp(this.reader.getAttributeValue(null, "disp"));
        code.setSubFlows(this.reader.getAttributeValue(null, "subFlows"));
        this.setHintsAttributes(code);
    }

    private void setHintsAttributes(ICMarker code) {
        String tmp = this.reader.getAttributeValue(null, "canDelete");
        if (this.canBeYesOrNo("canDelete", tmp)) {
            code.setCanDelete(tmp.equals("yes"));
        }
        if (this.canBeYesOrNo("canCopy", tmp = this.reader.getAttributeValue(null, "canCopy"))) {
            code.setCanCopy(tmp.equals("yes"));
        }
        if (this.canBeYesOrNo("canReorder", tmp = this.reader.getAttributeValue(null, "canReorder"))) {
            code.setCanReorder(tmp.equals("yes"));
        }
    }

    private String setDataRef(ICMarker code, IDataStore store) {
        String tmp = this.reader.getAttributeValue(null, "dataRef");
        if (this.cannotBeEmpty("dataRef", tmp)) {
            code.setDataRef(tmp);
            return tmp;
        }
        return null;
    }

    private ExtendedAttributes gatherExtendedAttributes() {
        int i;
        ExtendedAttributes attrs = null;
        for (i = 0; i < this.reader.getNamespaceCount(); ++i) {
            String namespaceURI = this.reader.getNamespaceURI(i);
            if (namespaceURI.equals("urn:oasis:names:tc:xliff:document:2.0") || namespaceURI.equals("urn:oasis:names:tc:xliff:matches:2.0")) continue;
            if (attrs == null) {
                attrs = new ExtendedAttributes();
            }
            attrs.setNamespace(this.reader.getNamespacePrefix(i), namespaceURI);
        }
        for (i = 0; i < this.reader.getAttributeCount(); ++i) {
            QName qname = this.reader.getAttributeName(i);
            if (qname.getNamespaceURI() == null || qname.getNamespaceURI().isEmpty() || qname.getNamespaceURI().equals("urn:oasis:names:tc:xliff:document:2.0")) continue;
            if (attrs == null) {
                attrs = new ExtendedAttributes();
            }
            attrs.setAttribute(new ExtendedAttribute(qname, this.reader.getAttributeValue(i)));
        }
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        return attrs;
    }

    private IExtendedElements processExtendedElement(IExtendedElements extElements) {
        if (extElements == null) {
            extElements = new ExtendedElements(this.reader.getNamespaceContext());
        }
        extElements.add(this.readExtendedElement());
        return extElements;
    }

    private ExtendedElement readExtendedElement() {
        try {
            ExtendedElement elem = new ExtendedElement(this.reader.getName(), this.reader.getNamespaceContext());
            elem.setExtendedAttributes(this.gatherExtendedAttributes());
            List<IExtendedChild> children = elem.getChildren();
            while (this.reader.hasNext()) {
                switch (this.reader.next()) {
                    case 1: {
                        this.pushWSState();
                        children.add(this.readExtendedElement());
                        break;
                    }
                    case 2: {
                        if (!this.reader.getName().equals(elem.getQName())) break;
                        this.popWSState();
                        return elem;
                    }
                    case 4: 
                    case 6: {
                        children.add(new ExtendedContent(this.reader.getText()));
                        break;
                    }
                    case 12: {
                        children.add(new ExtendedContent(this.reader.getText(), true));
                    }
                }
            }
            throw new IOException("Unexpected end of file.");
        }
        catch (Throwable e) {
            throw new XLIFFReaderException("Error adding an extended element. " + e.getMessage(), e);
        }
    }
}

