/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.enrycher;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String BASEURL = "baseUrl";
    private static final String MAXEVENTS = "maxEvents";
    private String baseUrl;
    private int maxEvents;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.setBaseUrl("http://aidemo.ijs.si/mlw");
        this.maxEvents = 20;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.baseUrl = this.buffer.getString(BASEURL, this.baseUrl);
        this.maxEvents = this.buffer.getInteger(MAXEVENTS, this.maxEvents);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(BASEURL, this.baseUrl);
        this.buffer.setInteger(MAXEVENTS, this.maxEvents);
        return this.buffer.toString();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = Util.ensureSeparator(baseUrl, true);
    }

    public int getMaxEvents() {
        return this.maxEvents;
    }

    public void setMaxEvents(int maxEvents) {
        this.maxEvents = maxEvents;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(BASEURL, "URL of the Enrycher Web service", null);
        desc.add(MAXEVENTS, "Events buffer", "Number of events to store before sending a query");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Enrycher", true, false);
        desc.addTextInputPart(paramsDesc.get(BASEURL));
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(MAXEVENTS));
        sip.setRange(1, 999);
        return desc;
    }
}

