/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.imagemodification;

import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String SCALEWIDTH = "scaleWidth";
    private static final String SCALEHEIGHT = "scaleHeight";
    private static final String FORMAT = "format";
    private static final String MAKEGRAY = "makeGray";
    private int scaleWidth;
    private int scaleHeight;
    private String format;
    private boolean makeGray;

    public Parameters() {
        this.reset();
    }

    public int getScaleWidth() {
        return this.scaleWidth;
    }

    public void setScaleWidth(int scaleWidth) {
        this.scaleWidth = scaleWidth;
    }

    public int getScaleHeight() {
        return this.scaleHeight;
    }

    public void setScaleHeight(int scaleHeight) {
        this.scaleHeight = scaleHeight;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean getMakeGray() {
        return this.makeGray;
    }

    public void setMakeGray(boolean makeGray) {
        this.makeGray = makeGray;
    }

    @Override
    public void reset() {
        this.scaleHeight = 50;
        this.scaleWidth = 50;
        this.format = "";
        this.makeGray = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.scaleHeight = this.buffer.getInteger(SCALEHEIGHT, this.scaleHeight);
        this.scaleWidth = this.buffer.getInteger(SCALEWIDTH, this.scaleWidth);
        this.format = this.buffer.getString(FORMAT, this.format);
        this.makeGray = this.buffer.getBoolean(MAKEGRAY, this.makeGray);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setInteger(SCALEHEIGHT, this.scaleHeight);
        this.buffer.setInteger(SCALEWIDTH, this.scaleWidth);
        this.buffer.setString(FORMAT, this.format);
        this.buffer.setBoolean(MAKEGRAY, this.makeGray);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SCALEHEIGHT, "Percentage of the original height", "Height percentage (must be greater than 0.");
        desc.add(SCALEWIDTH, "Percentage of the original width", "Width percentage (must be greater than 0.");
        desc.add(MAKEGRAY, "Convert to gray scale", null);
        desc.add(FORMAT, "Output format", "Format of the output files.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Image Modification", false, false);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(SCALEWIDTH));
        sip.setRange(1, 1000);
        sip = desc.addSpinInputPart(paramsDesc.get(SCALEHEIGHT));
        sip.setRange(1, 1000);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(MAKEGRAY));
        cbp.setVertical(true);
        ArrayList<String> available = new ArrayList<String>(Arrays.asList(ImageIO.getWriterFileSuffixes()));
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        names.add("<Same format as the original>");
        suffixes.add("");
        if (available.contains("png")) {
            names.add("PNG (Portable Network Graphics)");
            suffixes.add("png");
        }
        if (available.contains("jpg")) {
            names.add("JPEG (Joint Photographic Experts Group)");
            suffixes.add("jpg");
        }
        if (available.contains("bmp")) {
            names.add("BMP Bitmap");
            suffixes.add("bmp");
        }
        if (available.contains("gif")) {
            names.add("GIF (Graphics Interchange Format)");
            suffixes.add("gif");
        }
        ListSelectionPart lsp = desc.addListSelectionPart(paramsDesc.get(FORMAT), suffixes.toArray(new String[0]));
        lsp.setChoicesLabels(names.toArray(new String[0]));
        lsp.setVertical(true);
        lsp.setLabelFlushed(false);
        return desc;
    }
}

