/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.inconsistencycheck;

import java.io.File;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String CHECKINCONSISTENCIES = "checkInconststencies";
    private static final String CHECKPERFILE = "checkPerFile";
    private static final String OUTPUTPATH = "outputPath";
    private static final String DISPLAYOPTION = "displayOption";
    private static final String AUTOOPEN = "autoOpen";
    public static final String DISPLAYOPTION_ORIGINAL = "original";
    public static final String DISPLAYOPTION_GENERIC = "generic";
    public static final String DISPLAYOPTION_PLAIN = "plain";
    private boolean checkInconststencies;
    private boolean checkPerFile;
    private String outputPath;
    private String displayOption;
    private boolean autoOpen;

    public Parameters() {
        this.reset();
    }

    public boolean getCheckInconststencies() {
        return this.checkInconststencies;
    }

    public void setCheckInconststencies(boolean checkInconststencies) {
        this.checkInconststencies = checkInconststencies;
    }

    public boolean getCheckPerFile() {
        return this.checkPerFile;
    }

    public void setCheckPerFile(boolean checkPerFile) {
        this.checkPerFile = checkPerFile;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getDisplayOption() {
        return this.displayOption;
    }

    public void setDisplayOption(String displayOption) {
        this.displayOption = displayOption;
    }

    public boolean isAutoOpen() {
        return this.autoOpen;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.autoOpen = autoOpen;
    }

    @Override
    public void reset() {
        this.checkInconststencies = true;
        this.checkPerFile = false;
        this.outputPath = "${rootDir}" + File.separator + "inconsistency-report.xml";
        this.displayOption = DISPLAYOPTION_GENERIC;
        this.autoOpen = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.checkInconststencies = this.buffer.getBoolean(CHECKINCONSISTENCIES, this.checkInconststencies);
        this.checkPerFile = this.buffer.getBoolean(CHECKPERFILE, this.checkPerFile);
        this.outputPath = this.buffer.getString(OUTPUTPATH, this.outputPath);
        this.displayOption = this.buffer.getString(DISPLAYOPTION, this.displayOption);
        this.autoOpen = this.buffer.getBoolean(AUTOOPEN, this.autoOpen);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(CHECKINCONSISTENCIES, this.checkInconststencies);
        this.buffer.setBoolean(CHECKPERFILE, this.checkPerFile);
        this.buffer.setString(OUTPUTPATH, this.outputPath);
        this.buffer.setString(DISPLAYOPTION, this.displayOption);
        this.buffer.setParameter(AUTOOPEN, this.autoOpen);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(CHECKINCONSISTENCIES, "Check inconsistencies", null);
        desc.add(CHECKPERFILE, "Check for inconsistencies on a file-by-file basis", null);
        desc.add(OUTPUTPATH, "Path of the report file:", null);
        desc.add(DISPLAYOPTION, "Representation of the inline codes in the report", null);
        desc.add(AUTOOPEN, "Open the report file after completion", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Inconsistency Check", true, false);
        CheckboxPart master = desc.addCheckboxPart(paramDesc.get(CHECKINCONSISTENCIES));
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(CHECKPERFILE));
        cbp.setMasterPart(master, true);
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(OUTPUTPATH), "Inconsistency Report File", true);
        pip.setMasterPart(master, true);
        cbp = desc.addCheckboxPart(paramDesc.get(AUTOOPEN));
        cbp.setMasterPart(master, true);
        String[] values = new String[]{DISPLAYOPTION_ORIGINAL, DISPLAYOPTION_GENERIC, DISPLAYOPTION_PLAIN};
        String[] labels = new String[]{"Original codes", "Generic markers", "Plain text"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(DISPLAYOPTION), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(1);
        lsp.setMasterPart(master, true);
        return desc;
    }
}

