/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import opennlp.model.Event;
import opennlp.model.EventStream;

public class HashSumEventStream
implements EventStream {
    private final EventStream eventStream;
    private MessageDigest digest;

    public HashSumEventStream(EventStream eventStream) {
        this.eventStream = eventStream;
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean hasNext() throws IOException {
        return this.eventStream.hasNext();
    }

    public Event next() throws IOException {
        Event event = this.eventStream.next();
        try {
            this.digest.update(event.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding is not available!");
        }
        return event;
    }

    public BigInteger calculateHashSum() {
        return new BigInteger(1, this.digest.digest());
    }

    public void remove() {
    }
}

