/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import opennlp.tools.cmdline.tokenizer.TokenizerModelLoader;
import opennlp.tools.cmdline.tokenizer.TokenizerTrainerTool;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenizerEvaluator;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.ObjectStream;

public final class TokenizerMEEvaluatorTool
implements CmdLineTool {
    public String getName() {
        return "TokenizerMEEvaluator";
    }

    public String getShortDescription() {
        return "evaluator for the learnable tokenizer";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(EvaluatorParams.class);
    }

    public void run(String[] args) {
        if (!ArgumentParser.validateArguments(args, EvaluatorParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        EvaluatorParams params = ArgumentParser.parse(args, EvaluatorParams.class);
        Charset encoding = params.getEncoding();
        TokenizerModel model = (TokenizerModel)new TokenizerModelLoader().load(params.getModel());
        TokenEvaluationErrorListener missclassifiedListener = null;
        if (params.getMisclassified().booleanValue()) {
            missclassifiedListener = new TokenEvaluationErrorListener();
        }
        TokenizerEvaluator evaluator = new TokenizerEvaluator(new TokenizerME(model), missclassifiedListener);
        System.out.print("Evaluating ... ");
        File testData = params.getData();
        CmdLineUtil.checkInputFile("Test data", testData);
        ObjectStream<TokenSample> sampleStream = TokenizerTrainerTool.openSampleData("Test", testData, encoding);
        try {
            evaluator.evaluate(sampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            System.err.println("Reading test data error " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.out.println("done");
        System.out.println();
        System.out.println(evaluator.getFMeasure());
    }
}

