/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.Mean;
import opennlp.tools.util.model.ModelType;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSTaggerCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private POSDictionary tagDictionary;
    private Dictionary ngramDictionary;
    private Integer ngramCutoff;
    private Mean wordAccuracy = new Mean();
    private POSTaggerEvaluationMonitor[] listeners;

    @Deprecated
    public POSTaggerCrossValidator(String languageCode, ModelType modelType, POSDictionary tagDictionary, Dictionary ngramDictionary, int cutoff, int iterations) {
        this.languageCode = languageCode;
        this.params = ModelUtil.createTrainingParameters(iterations, cutoff);
        this.params.put("Algorithm", modelType.toString());
        this.tagDictionary = tagDictionary;
        this.ngramDictionary = ngramDictionary;
    }

    public POSTaggerCrossValidator(String languageCode, ModelType modelType, POSDictionary tagDictionary, Dictionary ngramDictionary) {
        this(languageCode, modelType, tagDictionary, ngramDictionary, 5, 100);
    }

    public POSTaggerCrossValidator(String languageCode, TrainingParameters trainParam, POSDictionary tagDictionary, POSTaggerEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = trainParam;
        this.tagDictionary = tagDictionary;
        this.ngramDictionary = null;
        this.ngramCutoff = null;
        this.listeners = listeners;
    }

    public POSTaggerCrossValidator(String languageCode, TrainingParameters trainParam, POSDictionary tagDictionary, Integer ngramCutoff, POSTaggerEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = trainParam;
        this.tagDictionary = tagDictionary;
        this.ngramDictionary = null;
        this.ngramCutoff = ngramCutoff;
        this.listeners = listeners;
    }

    public POSTaggerCrossValidator(String languageCode, TrainingParameters trainParam, POSDictionary tagDictionary, Dictionary ngramDictionary, POSTaggerEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = trainParam;
        this.tagDictionary = tagDictionary;
        this.ngramDictionary = ngramDictionary;
        this.ngramCutoff = null;
        this.listeners = listeners;
    }

    public void evaluate(ObjectStream<POSSample> samples, int nFolds) throws IOException, IOException {
        CrossValidationPartitioner<POSSample> partitioner = new CrossValidationPartitioner<POSSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<POSSample> trainingSampleStream = partitioner.next();
            Dictionary ngramDict = null;
            if (this.ngramDictionary == null) {
                if (this.ngramCutoff != null) {
                    System.err.print("Building ngram dictionary ... ");
                    try {
                        ngramDict = POSTaggerME.buildNGramDictionary(trainingSampleStream, this.ngramCutoff);
                        trainingSampleStream.reset();
                    }
                    catch (IOException e) {
                        CmdLineUtil.printTrainingIoError(e);
                        throw new TerminateToolException(-1);
                    }
                    System.err.println("done");
                }
            } else {
                ngramDict = this.ngramDictionary;
            }
            POSModel model = POSTaggerME.train(this.languageCode, trainingSampleStream, this.params, this.tagDictionary, ngramDict);
            POSEvaluator evaluator = new POSEvaluator(new POSTaggerME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.wordAccuracy.add(evaluator.getWordAccuracy(), evaluator.getWordCount());
        }
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }
}

