/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import org.junit.Assert;
import org.junit.Test;

public class BOMNewlineEncodingDetectorTest {
    private static final String CR_NEWLINES = "this \ris  atest with newlines";
    private static final String LF_NEWLINES = "this \nis  atest with newlines";
    private static final String CRLF_NEWLINES = "this \r\nis  atest with newlines";
    private static final String DEFINITIVE = "\ufffe has a BOM";
    private static final String NON_DEFINITIVE = "does not have a BOM";
    private static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static final byte[] UTF_7_BOM = new byte[]{43, 47, 118, 56};

    @Test
    public void staticGetNewlineType() {
        Assert.assertEquals((Object)BOMNewlineEncodingDetector.NewlineType.CR, (Object)BOMNewlineEncodingDetector.getNewlineType(CR_NEWLINES));
        Assert.assertEquals((Object)BOMNewlineEncodingDetector.NewlineType.LF, (Object)BOMNewlineEncodingDetector.getNewlineType(LF_NEWLINES));
        Assert.assertEquals((Object)BOMNewlineEncodingDetector.NewlineType.CRLF, (Object)BOMNewlineEncodingDetector.getNewlineType(CRLF_NEWLINES));
    }

    @Test
    public void getNewlineType() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(CR_NEWLINES.getBytes("UTF-8"));
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(is, "UTF-8");
        Assert.assertEquals((Object)BOMNewlineEncodingDetector.NewlineType.CR, (Object)detector.getNewlineType());
        is = new ByteArrayInputStream(LF_NEWLINES.getBytes("UTF-8"));
        detector = new BOMNewlineEncodingDetector(is, "UTF-8");
        Assert.assertEquals((Object)BOMNewlineEncodingDetector.NewlineType.LF, (Object)detector.getNewlineType());
        is = new ByteArrayInputStream(CRLF_NEWLINES.getBytes("UTF-8"));
        detector = new BOMNewlineEncodingDetector(is, "UTF-8");
        Assert.assertEquals((Object)BOMNewlineEncodingDetector.NewlineType.CRLF, (Object)detector.getNewlineType());
    }

    @Test
    public void isDefinitve() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DEFINITIVE.getBytes("UTF-16LE"));
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(is, "UTF-16LE");
        Assert.assertTrue(detector.isDefinitive());
        is = new ByteArrayInputStream(NON_DEFINITIVE.getBytes("UTF-8"));
        detector = new BOMNewlineEncodingDetector(is, "UTF-8");
        detector.detectBom();
        Assert.assertFalse(detector.isDefinitive());
    }

    @Test
    public void hasBom() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DEFINITIVE.getBytes("UTF-16"));
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(is, "UTF-16");
        detector.detectBom();
        Assert.assertTrue(detector.hasBom());
        is = new ByteArrayInputStream(NON_DEFINITIVE.getBytes("UTF-8"));
        detector = new BOMNewlineEncodingDetector(is, "UTF-8");
        detector.detectBom();
        Assert.assertFalse(detector.hasBom());
    }

    @Test
    public void hasUtf8Bom() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(UTF_8_BOM);
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(is, "UTF-8");
        detector.detectBom();
        Assert.assertTrue(detector.hasBom());
        Assert.assertTrue(detector.hasUtf8Bom());
    }

    @Test
    public void hasUtf7Bom() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(UTF_7_BOM);
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(is, "UTF-7");
        detector.detectBom();
        Assert.assertTrue(detector.hasBom());
        Assert.assertTrue(detector.hasUtf7Bom());
    }

    @Test
    public void removeBom() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DEFINITIVE.getBytes("UTF-16LE"));
        BOMNewlineEncodingDetector detector1 = new BOMNewlineEncodingDetector(is);
        detector1.detectAndRemoveBom();
        BOMNewlineEncodingDetector detector2 = new BOMNewlineEncodingDetector(is);
        detector2.detectBom();
        Assert.assertFalse(detector2.hasBom());
    }

    @Test
    public void resettingInvalidMarkException() throws IOException, URISyntaxException {
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(new FileInputStream(this.getClass().getResource("/strings.xml").toURI().getPath()));
        detector.detectBom();
        Assert.assertFalse(detector.hasBom());
        Assert.assertEquals("ISO-8859-1", detector.getEncoding());
        Assert.assertEquals((Object)BOMNewlineEncodingDetector.NewlineType.CRLF, (Object)detector.getNewlineType());
        detector = new BOMNewlineEncodingDetector(new FileInputStream(this.getClass().getResource("/Test.resx").toURI().getPath()));
        detector.detectBom();
        Assert.assertTrue(detector.hasBom());
        Assert.assertEquals("UTF-8", detector.getEncoding());
        Assert.assertEquals((Object)BOMNewlineEncodingDetector.NewlineType.CRLF, (Object)detector.getNewlineType());
    }
}

