/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.ClassUtil;
import org.junit.Assert;
import org.junit.Test;

public class ClassUtilTest {
    @Test
    public void testGetPackageName() {
        Assert.assertEquals("", ClassUtil.getPackageName(null));
        Assert.assertEquals("net.sf.okapi.common", ClassUtil.getPackageName(this.getClass()));
        Assert.assertEquals("java.lang", ClassUtil.getPackageName(new String().getClass()));
    }

    @Test
    public void testExtractPackageName() {
        Assert.assertEquals("", ClassUtil.extractPackageName(null));
        Assert.assertEquals("", ClassUtil.extractPackageName(""));
        Assert.assertEquals("", ClassUtil.extractPackageName("aaa/bbb/ccc"));
        Assert.assertEquals("aaa.bbb", ClassUtil.extractPackageName("aaa.bbb.ccc"));
        Assert.assertEquals("net.sf.okapi.common", ClassUtil.extractPackageName("net.sf.okapi.common.ClassUtil"));
    }

    @Test
    public void testQualifyName() {
        Assert.assertEquals("", ClassUtil.qualifyName("", null));
        Assert.assertEquals("", ClassUtil.qualifyName("", ""));
        Assert.assertEquals("", ClassUtil.qualifyName("package", ""));
        Assert.assertEquals("", ClassUtil.qualifyName("", "class"));
        Assert.assertEquals("package.class", ClassUtil.qualifyName("package", "class"));
        Assert.assertEquals("package.class", ClassUtil.qualifyName("package.", "class"));
        Assert.assertEquals("package.class", ClassUtil.qualifyName("package_class", "package.class"));
        Assert.assertEquals(".class", ClassUtil.qualifyName("package.", ".class"));
        Assert.assertEquals("java.lang.Integer", ClassUtil.qualifyName(new String().getClass(), "Integer"));
        Assert.assertEquals("java.lang.Integer", ClassUtil.qualifyName(ClassUtil.extractPackageName(new String().getClass().getName()), "Integer"));
        Assert.assertEquals("net.sf.okapi.common.UtilTest", ClassUtil.qualifyName(ClassUtil.extractPackageName(this.getClass().getName()), "UtilTest"));
        Assert.assertEquals("net.sf.okapi.common.UtilTest", ClassUtil.qualifyName(this, "UtilTest"));
    }

    @Test
    public void testInstantiateClass() {
        String defaultEncoding;
        URL url;
        try {
            ClassUtil.instantiateClass(BOMAwareInputStream.class);
            Assert.fail("InstantiationException should've been trown");
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            Assert.fail("IllegalAccessException shouldn't have been trown");
        }
        try {
            Assert.assertNull(ClassUtil.instantiateClass(BOMAwareInputStream.class, (Object[])null));
            Assert.fail("InstantiationException should've been trown");
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            Assert.fail("IllegalAccessException shouldn't have been trown");
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        FileInputStream input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNotNull(ClassUtil.instantiateClass(BOMAwareInputStream.class, input, defaultEncoding));
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        try {
            input = null;
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            Assert.assertNull(ClassUtil.instantiateClass(BOMAwareInputStream.class, input, 3));
            Assert.fail("RuntimeException should've been trown");
        }
        catch (IllegalAccessException e) {
            Assert.fail("IllegalAccessException shouldn't have been trown");
        }
        catch (RuntimeException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNull(ClassUtil.instantiateClass((String)null));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNull(ClassUtil.instantiateClass(""));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNull(ClassUtil.instantiateClass("foo.bar"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNull(ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream"));
            Assert.fail("InstantiationException should've been trown");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNotNull(ClassUtil.instantiateClass("java.lang.String"));
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        try {
            Assert.assertNull(ClassUtil.instantiateClass("net.sf.okapi.common.ClassUtilTest2", String.class.getClassLoader()));
            Assert.fail("IllegalArgumentException should've been trown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        try {
            Assert.assertNull(ClassUtil.instantiateClass("net.sf.okapi.common.ClassUtilTest2", ClassUtil.class.getClassLoader()));
            Assert.fail("InstantiationException should've been trown");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNotNull(ClassUtil.instantiateClass("net.sf.okapi.common.ClassUtilTest", this.getClass().getClassLoader()));
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNotNull(ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", input, defaultEncoding));
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        try {
            input = null;
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            Assert.assertNull(ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", input, 3));
            Assert.fail("RuntimeException should've been trown");
        }
        catch (RuntimeException e) {
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNotNull(ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", this.getClass().getClassLoader(), input, defaultEncoding));
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            Assert.assertNull(ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", this.getClass().getClassLoader(), input, 10));
        }
        catch (RuntimeException e) {
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNull(ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", String.class.getClassLoader(), input, defaultEncoding));
        }
        catch (RuntimeException e) {
        }
        catch (Exception e) {
            Assert.fail(e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNull(ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream2", this.getClass().getClassLoader(), input, defaultEncoding));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testResourcePath() {
        Assert.assertTrue(new File(ClassUtil.getResourcePath(this.getClass(), "/test_path1.txt")).exists());
        Assert.assertTrue(new File(ClassUtil.getResourcePath(this.getClass(), "test_path2.txt")).exists());
    }
}

