/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.LCIDUtil;
import net.sf.okapi.common.LocaleId;
import org.junit.Assert;
import org.junit.Test;

public class LCIDUtilTest {
    @Test
    public void testLCID() {
        Assert.assertEquals(1049L, LCIDUtil.getLCID("ru-ru"));
        Assert.assertEquals(1049L, LCIDUtil.getLCID("ru-RU"));
        Assert.assertEquals(1049L, LCIDUtil.getLCID("ru_RU"));
        Assert.assertEquals(1033L, LCIDUtil.getLCID("en-us"));
        Assert.assertEquals(1100L, LCIDUtil.getLCID("ml-IN"));
        Assert.assertEquals("ml-in", LCIDUtil.getTag(1100));
        Assert.assertEquals(7L, LCIDUtil.getLCID("de"));
        Assert.assertEquals(9L, LCIDUtil.getLCID("en"));
        Assert.assertEquals(10L, LCIDUtil.getLCID("es"));
        Assert.assertEquals(12L, LCIDUtil.getLCID("fr"));
        Assert.assertEquals(1096L, LCIDUtil.getLCID(new LocaleId("or", "in")));
        Assert.assertEquals("or-in", LCIDUtil.getTag(new LocaleId("or", "in")));
    }

    @Test
    public void testLookups() {
        for (LCIDUtil.LCIDDescr descr : LCIDUtil.getTagLookup().values()) {
            int lcid = descr.lcid;
            String tag = descr.tag;
            if (LCIDUtil.getLcidLookup().containsKey(tag)) continue;
            Assert.fail(String.format("LcidLookup has no entry for 0x%04x (%s)", lcid, descr.tag));
        }
    }

    public void listLcidLookup() {
        for (String tag : LCIDUtil.getLcidLookup().keySet()) {
            LCIDUtil.LCIDDescr descr = LCIDUtil.getLcidLookup().get(tag);
            System.out.println(tag + ":   " + this.getDescrStr(descr));
        }
    }

    private String getDescrStr(LCIDUtil.LCIDDescr descr) {
        return String.format("Lang: %20s Reg: %20s lcid: 0x%04x tag: %s", descr.language, descr.region, descr.lcid, descr.tag);
    }
}

