/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.HashSet;
import java.util.Set;
import net.sf.okapi.common.LocaleFilter;
import net.sf.okapi.common.LocaleId;
import org.junit.Assert;
import org.junit.Test;

public class LocaleFilterTest {
    private LocaleId locENUS = LocaleId.fromString("en-us");
    private LocaleId locENGB = LocaleId.fromString("en-gb");
    private LocaleId locENNZ = LocaleId.fromString("en-nz");
    private LocaleId locESEQ = LocaleId.fromString("es-eq");
    private LocaleId locESUS = LocaleId.fromString("es-us");
    private LocaleId locFRFR = LocaleId.fromString("fr-fr");
    private LocaleId locFRCA = LocaleId.fromString("fr-ca");
    private LocaleId locFRCH = LocaleId.fromString("fr-ch");
    private LocaleId locFRBE = LocaleId.fromString("fr-be");
    private LocaleId locDEDE = LocaleId.fromString("de-de");
    private LocaleId locDECH = LocaleId.fromString("de-ch");
    private LocaleId locENUS_WIN = new LocaleId("en", "us", "win");
    private LocaleId locDECH_WIN = new LocaleId("de", "ch", "win");
    private LocaleId locDECH_MAC = new LocaleId("de", "ch", "mac");

    @Test
    public void testMatches() {
        LocaleFilter filter = LocaleFilter.any();
        Assert.assertTrue(filter.matches(LocaleId.EMPTY));
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertFalse(LocaleFilter.anyExcept(this.locFRCA, this.locENUS).matches(this.locFRCA));
        Assert.assertFalse(LocaleFilter.anyExcept(this.locFRCA, this.locENUS).matches(this.locENUS));
        Assert.assertTrue(LocaleFilter.anyExcept(this.locFRCA, this.locENUS).matches(this.locESUS));
        Assert.assertTrue(LocaleFilter.anyOf(this.locFRCA, this.locENUS).matches(this.locFRCA));
        Assert.assertFalse(LocaleFilter.anyOf(this.locFRCA, this.locENUS).matches(this.locESUS));
        Assert.assertFalse(LocaleFilter.none().matches(this.locESUS));
        Assert.assertFalse(LocaleFilter.none().matches(this.locENUS));
        filter = LocaleFilter.none().include(this.locENUS, this.locDECH_WIN).includeLanguage("fr");
        Assert.assertFalse(filter.matches(this.locDEDE));
        filter = LocaleFilter.any().include(this.locENUS, this.locDECH_WIN).includeLanguage("fr");
        Assert.assertTrue(filter.matches(this.locDEDE));
    }

    @Test
    public void testFilter() {
        Set<LocaleId> filtered = LocaleFilter.anyOf(this.locFRFR, this.locFRCA, this.locFRCH).filter(this.locFRCA, this.locFRBE, this.locENUS);
        Assert.assertEquals(1L, filtered.size());
        Assert.assertTrue(filtered.contains(this.locFRCA));
        Assert.assertFalse(filtered.contains(this.locFRBE));
    }

    @Test
    public void testConstructor() {
        LocaleFilter filter = new LocaleFilter();
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locFRCA));
    }

    @Test
    public void testInclude() {
        LocaleFilter filter = LocaleFilter.none();
        Assert.assertFalse(filter.matches(this.locENUS));
        filter.include(this.locENUS);
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locFRCA));
        filter.include(this.locFRFR, this.locFRCA, this.locESUS);
        Assert.assertTrue(filter.matches(this.locFRFR));
        Assert.assertFalse(filter.matches(this.locFRCH));
        Assert.assertFalse(filter.matches(this.locFRBE));
        HashSet<LocaleId> set = new HashSet<LocaleId>();
        set.add(this.locFRBE);
        filter.include(set);
        Assert.assertTrue(filter.matches(this.locFRBE));
        filter.reset();
        filter.includePattern("en-.*");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locFRCA));
        Assert.assertFalse(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locESEQ));
        Assert.assertEquals(1L, filter.getPatternIncludes().size());
        filter.includePattern(".*-us");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locESEQ));
        Assert.assertEquals(2L, filter.getPatternIncludes().size());
        filter.reset();
        Assert.assertEquals(0L, filter.getPatternIncludes().size());
        filter.includePattern("e.*-us");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locESEQ));
        Assert.assertFalse(filter.matches(this.locFRCA));
        Assert.assertEquals(1L, filter.getPatternIncludes().size());
        filter.reset();
        filter.includeLanguage("en");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locESUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locESEQ));
        Assert.assertFalse(filter.matches(this.locFRCA));
        Assert.assertEquals(1L, filter.getLanguageIncludes().size());
        filter.includeLanguage("es", "fr");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locESEQ));
        Assert.assertTrue(filter.matches(this.locFRCA));
        Assert.assertFalse(filter.matches(this.locDEDE));
        Assert.assertFalse(filter.matches(this.locDECH));
        Assert.assertEquals(3L, filter.getLanguageIncludes().size());
        filter.reset();
        filter.includeRegion("us");
        Assert.assertEquals(1L, filter.getRegionIncludes().size());
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locESEQ));
        Assert.assertFalse(filter.matches(this.locFRCA));
        filter.includeRegion("ch", "gb");
        Assert.assertEquals(3L, filter.getRegionIncludes().size());
        Assert.assertTrue(filter.matches(this.locFRCH));
        Assert.assertTrue(filter.matches(this.locDECH));
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locESEQ));
        filter.reset();
        filter.includeUserPart("ats");
        Assert.assertEquals(1L, filter.getUserPartIncludes().size());
        Assert.assertTrue(filter.matches(LocaleId.fromPOSIXLocale("de_AT.UTF-8@ATS")));
        Assert.assertFalse(filter.matches(LocaleId.fromPOSIXLocale("sr@latin")));
        filter.includeUserPart("mac", "latin");
        Assert.assertEquals(3L, filter.getUserPartIncludes().size());
        Assert.assertTrue(filter.matches(LocaleId.fromPOSIXLocale("es_us@mac")));
        Assert.assertTrue(filter.matches(LocaleId.fromPOSIXLocale("sr@latin")));
        Assert.assertFalse(filter.matches(LocaleId.fromPOSIXLocale("en_us@win")));
        filter.reset();
        LocaleFilter filter2 = LocaleFilter.none();
        filter2.include(this.locENUS);
        Assert.assertFalse(filter.matches(this.locENUS));
        filter.include(filter2);
        Assert.assertTrue(filter.matches(this.locENUS));
    }

    @Test
    public void testExclude() {
        LocaleFilter filter = LocaleFilter.any();
        Assert.assertTrue(filter.matches(this.locENUS));
        filter.exclude(this.locENUS);
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locFRCA));
        filter.exclude(this.locFRFR, this.locFRCA, this.locESUS);
        Assert.assertFalse(filter.matches(this.locFRFR));
        Assert.assertTrue(filter.matches(this.locFRCH));
        Assert.assertTrue(filter.matches(this.locFRBE));
        HashSet<LocaleId> set = new HashSet<LocaleId>();
        set.add(this.locFRBE);
        filter.exclude(set);
        Assert.assertFalse(filter.matches(this.locFRBE));
        filter.reset();
        filter.excludePattern("en-.*");
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locFRCA));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertTrue(filter.matches(this.locESEQ));
        Assert.assertEquals(1L, filter.getPatternExcludes().size());
        filter.excludePattern(".*-us");
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locESEQ));
        Assert.assertEquals(2L, filter.getPatternExcludes().size());
        filter.reset();
        Assert.assertEquals(0L, filter.getPatternExcludes().size());
        filter.excludePattern("e.*-us");
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locESUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locESEQ));
        Assert.assertTrue(filter.matches(this.locFRCA));
        Assert.assertEquals(1L, filter.getPatternExcludes().size());
        filter.reset();
        filter.excludeLanguage("en");
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locESEQ));
        Assert.assertTrue(filter.matches(this.locFRCA));
        Assert.assertEquals(1L, filter.getLanguageExcludes().size());
        filter.excludeLanguage("es", "fr");
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locESEQ));
        Assert.assertFalse(filter.matches(this.locFRCA));
        Assert.assertTrue(filter.matches(this.locDEDE));
        Assert.assertTrue(filter.matches(this.locDECH));
        Assert.assertEquals(3L, filter.getLanguageExcludes().size());
        filter.reset();
        filter.excludeRegion("us");
        Assert.assertEquals(1L, filter.getRegionExcludes().size());
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locESUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locESEQ));
        Assert.assertTrue(filter.matches(this.locFRCA));
        filter.excludeRegion("ch", "gb");
        Assert.assertEquals(3L, filter.getRegionExcludes().size());
        Assert.assertFalse(filter.matches(this.locFRCH));
        Assert.assertFalse(filter.matches(this.locDECH));
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locESEQ));
        filter.reset();
        filter.excludeUserPart("ats");
        Assert.assertEquals(1L, filter.getUserPartExcludes().size());
        Assert.assertFalse(filter.matches(LocaleId.fromPOSIXLocale("de_AT.UTF-8@ATS")));
        Assert.assertTrue(filter.matches(LocaleId.fromPOSIXLocale("sr@latin")));
        filter.excludeUserPart("mac", "latin");
        Assert.assertEquals(3L, filter.getUserPartExcludes().size());
        Assert.assertFalse(filter.matches(LocaleId.fromPOSIXLocale("es_us@mac")));
        Assert.assertFalse(filter.matches(LocaleId.fromPOSIXLocale("sr@latin")));
        Assert.assertTrue(filter.matches(LocaleId.fromPOSIXLocale("en_us@win")));
        filter.reset();
        LocaleFilter filter2 = LocaleFilter.none();
        filter2.include(this.locENUS);
        Assert.assertTrue(filter.matches(this.locENUS));
        filter.exclude(filter2);
        Assert.assertFalse(filter.matches(this.locENUS));
    }

    @Test
    public void testFromString() {
        LocaleFilter filter = new LocaleFilter();
        filter.fromString("*");
        Assert.assertTrue(filter.matches(this.locENUS));
        filter.fromString("!*");
        Assert.assertFalse(filter.matches(this.locENUS));
        filter.fromString("en");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locESUS));
        filter.fromString("*-*");
        Assert.assertTrue(filter.matches(this.locENUS));
        filter.fromString("!*-*");
        Assert.assertFalse(filter.matches(this.locENUS));
        filter.fromString("*-us");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        filter.fromString("en-*");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locESUS));
        filter.fromString("en-us");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        filter.fromString("*-*-*");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        Assert.assertTrue(filter.matches(this.locDECH_MAC));
        filter.fromString("!*-*-*");
        Assert.assertFalse(filter.matches(this.locENUS));
        filter.fromString("*-*-win");
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        Assert.assertTrue(filter.matches(this.locENUS_WIN));
        Assert.assertFalse(filter.matches(this.locDECH_MAC));
        filter.fromString("*-ch-*");
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        Assert.assertTrue(filter.matches(this.locDECH_MAC));
        Assert.assertFalse(filter.matches(this.locENUS_WIN));
        filter.fromString("*-ch-win");
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        Assert.assertFalse(filter.matches(this.locDECH_MAC));
        filter.fromString("de-*-*");
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        Assert.assertTrue(filter.matches(this.locDECH_MAC));
        Assert.assertFalse(filter.matches(this.locENUS_WIN));
        filter.fromString("de-*-win");
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        Assert.assertFalse(filter.matches(this.locDECH_MAC));
        Assert.assertFalse(filter.matches(this.locENUS_WIN));
        filter.fromString("de-ch-*");
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        Assert.assertTrue(filter.matches(this.locDECH_MAC));
        Assert.assertFalse(filter.matches(this.locENUS_WIN));
        filter.fromString("de-ch-win");
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        Assert.assertFalse(filter.matches(this.locDECH_MAC));
        Assert.assertFalse(filter.matches(this.locENUS_WIN));
        filter.fromString("en !en-nz");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locENUS_WIN));
        Assert.assertFalse(filter.matches(this.locENNZ));
        Assert.assertFalse(filter.matches(this.locDECH));
        filter.fromString("!en-nz");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locENUS_WIN));
        Assert.assertFalse(filter.matches(this.locENNZ));
        Assert.assertTrue(filter.matches(this.locDECH));
        Assert.assertTrue(filter.matches(this.locDEDE));
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        filter.fromString("en !en-nz en-nz");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locENUS_WIN));
        Assert.assertTrue(filter.matches(this.locENNZ));
        Assert.assertFalse(filter.matches(this.locDECH));
        Assert.assertFalse(filter.matches(this.locDEDE));
        Assert.assertFalse(filter.matches(this.locDECH_WIN));
        filter.fromString("!en-nz en-nz");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locENUS_WIN));
        Assert.assertTrue(filter.matches(this.locENNZ));
        Assert.assertTrue(filter.matches(this.locDECH));
        Assert.assertTrue(filter.matches(this.locDEDE));
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        filter.fromString("@e[ns]-.+");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locENUS_WIN));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertTrue(filter.matches(this.locENNZ));
        Assert.assertFalse(filter.matches(this.locDECH));
        Assert.assertFalse(filter.matches(this.locDEDE));
        Assert.assertFalse(filter.matches(this.locDECH_WIN));
        filter.fromString("!@e[ns]-.+");
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locENUS_WIN));
        Assert.assertFalse(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locENNZ));
        Assert.assertTrue(filter.matches(this.locDECH));
        Assert.assertTrue(filter.matches(this.locDEDE));
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
        filter.fromString("@en-.+ @es-.+");
        Assert.assertTrue(filter.matches(this.locENUS));
        Assert.assertTrue(filter.matches(this.locENGB));
        Assert.assertTrue(filter.matches(this.locENUS_WIN));
        Assert.assertTrue(filter.matches(this.locESUS));
        Assert.assertTrue(filter.matches(this.locENNZ));
        Assert.assertFalse(filter.matches(this.locDECH));
        Assert.assertFalse(filter.matches(this.locDEDE));
        Assert.assertFalse(filter.matches(this.locDECH_WIN));
        filter.fromString("!@en-.+ !@es-.+");
        Assert.assertFalse(filter.matches(this.locENUS));
        Assert.assertFalse(filter.matches(this.locENGB));
        Assert.assertFalse(filter.matches(this.locENUS_WIN));
        Assert.assertFalse(filter.matches(this.locESUS));
        Assert.assertFalse(filter.matches(this.locENNZ));
        Assert.assertTrue(filter.matches(this.locDECH));
        Assert.assertTrue(filter.matches(this.locDEDE));
        Assert.assertTrue(filter.matches(this.locDECH_WIN));
    }

    @Test
    public void testToString() {
        Assert.assertEquals("", LocaleFilter.any().toString());
        Assert.assertEquals("!*", LocaleFilter.none().toString());
        Assert.assertEquals("* en-us", LocaleFilter.any().include(this.locENUS).toString());
        Assert.assertEquals("!en-us !de-ch-win", LocaleFilter.anyExcept(this.locENUS, this.locDECH_WIN).toString());
        Assert.assertEquals("en-us de-ch-win", LocaleFilter.anyOf(this.locENUS, this.locDECH_WIN).toString());
        Assert.assertEquals("en-us de-ch-win", LocaleFilter.build("en-us !de-ch-win de-ch-win").toString());
        Assert.assertEquals("en-us de-ch-win !de-ch", LocaleFilter.build("en-us !de-ch de-ch-win").toString());
        Assert.assertEquals("en-us de-ch-win fr", LocaleFilter.none().include(this.locENUS, this.locDECH_WIN).includeLanguage("fr").toString());
        Assert.assertEquals("* en-us de-ch-win fr", LocaleFilter.any().include(this.locENUS, this.locDECH_WIN).includeLanguage("fr").toString());
        Assert.assertEquals("!en-us !de-ch-win fr", LocaleFilter.any().exclude(this.locENUS, this.locDECH_WIN).includeLanguage("fr").toString());
        Assert.assertEquals("fr !en-us !de-ch-win", LocaleFilter.none().exclude(this.locENUS, this.locDECH_WIN).includeLanguage("fr").toString());
        Assert.assertEquals("!* !en-us !de-ch-win", LocaleFilter.none().exclude(this.locENUS, this.locDECH_WIN).toString());
        Assert.assertEquals("@pattern", LocaleFilter.none().includePattern("pattern").toString());
        Assert.assertEquals("@pattern ^8", LocaleFilter.none().includePattern("pattern", 8).toString());
        Assert.assertEquals("!@pattern", LocaleFilter.any().excludePattern("pattern").toString());
        Assert.assertEquals("!@pattern ^8", LocaleFilter.any().excludePattern("pattern", 8).toString());
        Assert.assertEquals("!@pattern1 ^8 !@pattern2 !@pattern3 ^2", LocaleFilter.any().excludePattern("pattern1", 8).excludePattern("pattern2").excludePattern("pattern3", 2).toString());
    }

    @Test
    public void testIncludeAfterExclude() {
        LocaleFilter filter = new LocaleFilter();
        Assert.assertTrue(filter.matches(this.locENUS));
        filter.exclude(this.locENUS);
        Assert.assertFalse(filter.matches(this.locENUS));
        filter.include(this.locENUS);
        Assert.assertTrue(filter.matches(this.locENUS));
        filter.excludeLanguage("en");
        Assert.assertFalse(filter.matches(this.locENUS));
        filter.includeLanguage("en");
        Assert.assertTrue(filter.matches(this.locENUS));
        filter.excludeRegion("us");
        Assert.assertFalse(filter.matches(this.locENUS));
        filter.includeRegion("us");
        Assert.assertTrue(filter.matches(this.locENUS));
        filter.excludeUserPart("mac");
        Assert.assertFalse(filter.matches(LocaleId.fromPOSIXLocale("es_us@mac")));
        filter.includeUserPart("mac");
        Assert.assertTrue(filter.matches(LocaleId.fromPOSIXLocale("es_us@mac")));
        filter.excludePattern("en-.*");
        Assert.assertFalse(filter.matches(this.locENUS));
        filter.includePattern("en-.*");
        Assert.assertTrue(filter.matches(this.locENUS));
    }
}

