/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.ParameterDescriptor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParametersTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLoadParametersFromString() {
        String snippet = "#v1\nparamBool1.b=false\nparamInt1.i=456";
        StringParameters params = new StringParameters();
        params.fromString(snippet);
        Assert.assertFalse(params.getBoolean("paramBool1"));
        Assert.assertEquals(456L, params.getInteger("paramInt1"));
        Assert.assertEquals("", params.getString("paramStr1"));
        Assert.assertEquals("", params.getString("password1"));
    }

    @Test
    public void testWhitespaces() {
        String snippet = "#v1\nparamBool1.b  =  true  \nparamInt1.i  =  456 \nparamStr1  = AB  C  \npassword1=psw";
        StringParameters params = new StringParameters();
        params.fromString(snippet);
        Assert.assertTrue(params.getBoolean("paramBool1"));
        Assert.assertEquals(456L, params.getInteger("paramInt1"));
        Assert.assertEquals(" AB  C  ", params.getString("paramStr1"));
        Assert.assertEquals("psw", params.getString("password1"));
    }

    @Test
    public void testLoadParametersFromWindowsFile() throws URISyntaxException {
        StringParameters params = new StringParameters();
        URL url = ParametersTest.class.getResource("/ParamTest01.txt");
        params.load(url.toURI(), false);
        Assert.assertFalse(params.getBoolean("paramBool1"));
        Assert.assertEquals(789L, params.getInteger("paramInt1"));
        Assert.assertEquals("TestOK", params.getString("paramStr1"));
    }

    @Test
    public void testParameterDescriptor() {
        TestClass ts = new TestClass();
        ParameterDescriptor pd = new ParameterDescriptor("text", ts, "displayName", "shortDescription");
        Assert.assertEquals("displayName", pd.getDisplayName());
        Assert.assertEquals("shortDescription", pd.getShortDescription());
        Assert.assertEquals(String.class, pd.getType());
        Assert.assertEquals("text", pd.getName());
        Assert.assertEquals(ts, pd.getParent());
        Assert.assertNotNull(pd.getReadMethod());
        Assert.assertNotNull(pd.getWriteMethod());
    }

    @Test
    public void testParametersDescription() {
        TestClass ts = new TestClass();
        ParametersDescription desc = new ParametersDescription(ts);
        desc.add("text", "displayName", "shortDescription");
        desc.add("flag", "Flag", "A flag");
        ParameterDescriptor pd = desc.get("text");
        Assert.assertEquals(2L, desc.getDescriptors().size());
        Assert.assertEquals(pd, desc.getDescriptors().get("text"));
        pd = desc.get("flag");
        Assert.assertEquals(pd, desc.getDescriptors().get("flag"));
        Assert.assertEquals(Boolean.TYPE, pd.getType());
    }

    @Test
    public void testGetFromName() {
        StringParameters params = new StringParameters();
        params.setString("paramStr1", "qwerty");
        params.setBoolean("paramBool1", false);
        params.setInteger("paramInt1", 98765);
        Assert.assertEquals("qwerty", params.getString("paramStr1"));
        Assert.assertEquals(false, params.getBoolean("paramBool1"));
        Assert.assertEquals(98765L, params.getInteger("paramInt1"));
    }

    @Test
    public void testSetFromName() {
        StringParameters params = new StringParameters();
        params.setString("paramStr1", "qwerty");
        params.setBoolean("paramBool1", false);
        params.setInteger("paramInt1", 98765);
        Assert.assertEquals("qwerty", params.getString("paramStr1"));
        Assert.assertEquals(false, params.getBoolean("paramBool1"));
        params.setString("paramStr1", "newValue");
        params.setBoolean("paramBool1", true);
        Assert.assertEquals("newValue", params.getString("paramStr1"));
        Assert.assertEquals(true, params.getBoolean("paramBool1"));
        Assert.assertEquals(98765L, params.getInteger("paramInt1"));
        params.setInteger("paramInt1", 12345678);
        Assert.assertEquals(12345678L, params.getInteger("paramInt1"));
    }

    @Test
    public void testPreserveUnaffectedDefaults() {
        TestParameters params = new TestParameters();
        Assert.assertTrue(params.getBoolean("foo"));
        Assert.assertTrue(params.getBoolean("bar"));
        params.fromString("#v1\nfoo.b = false");
        Assert.assertFalse(params.getBoolean("foo"));
        Assert.assertTrue(params.getBoolean("bar"));
    }

    @Test
    public void testInitializeFromData() {
        TestParameters params = new TestParameters("#v1\nfoo.b = false");
        Assert.assertFalse(params.getBoolean("foo"));
        Assert.assertTrue(params.getBoolean("bar"));
    }

    @Test
    public void testSidesEffect() {
        TestParameters params = new TestParameters();
        Assert.assertEquals(true, params.getBoolean("foo"));
        Assert.assertEquals(true, params.getBoolean("bar"));
        params.setBoolean("foo", false);
        Assert.assertEquals(false, params.getBoolean("foo"));
        Assert.assertEquals(true, params.getBoolean("bar"));
        params.setBoolean("bar", false);
        Assert.assertEquals(false, params.getBoolean("foo"));
        Assert.assertEquals(false, params.getBoolean("bar"));
    }

    @Test
    public void testClearBufferBeforeLoadingFromString() {
        TestParameters params = new TestParameters();
        params.setBoolean("TEST", true);
        params.fromString("#v1\nfoo.b = false");
        Assert.assertFalse(params.getBoolean("TEST"));
    }

    class TestParameters
    extends StringParameters {
        static final String FOO = "foo";
        static final String BAR = "bar";

        TestParameters() {
        }

        TestParameters(String data) {
            super(data);
        }

        @Override
        public void reset() {
            super.reset();
            this.setBoolean(FOO, true);
            this.setBoolean(BAR, true);
        }
    }

    class TestClass {
        private String text;
        private boolean flag;

        TestClass() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }
    }
}

