/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.okapi.common.FileCompare;

public class ZipFileCompare {
    private FileCompare fc = new FileCompare();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareFiles(String type, String out, String gold, String encoding, boolean ignoreEmtpyLines) {
        ZipFile goldZipFile = null;
        ZipFile outZipFile = null;
        Enumeration<? extends ZipEntry> outEntries = null;
        Enumeration<? extends ZipEntry> goldEntries = null;
        try {
            ZipEntry ze;
            HashMap<String, ZipEntry> outZipMap = new HashMap<String, ZipEntry>();
            HashMap<String, ZipEntry> goldZipMap = new HashMap<String, ZipEntry>();
            try {
                File outZip = new File(out);
                outZipFile = new ZipFile(outZip);
                outEntries = outZipFile.entries();
            }
            catch (Exception e) {
                System.err.println("ZipCompare:  Output file " + out + " not found.\n");
                boolean bl = false;
                if (outZipFile != null) {
                    try {
                        outZipFile.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (goldZipFile != null) {
                    try {
                        goldZipFile.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return bl;
            }
            try {
                File goldZip = new File(gold);
                goldZipFile = new ZipFile(goldZip);
                goldEntries = goldZipFile.entries();
            }
            catch (Exception e) {
                System.err.println("ZipCompare:  Gold file " + gold + " not found.\n");
                boolean bl = false;
                if (outZipFile != null) {
                    try {
                        outZipFile.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                if (goldZipFile != null) {
                    try {
                        goldZipFile.close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
                return bl;
            }
            while (outEntries.hasMoreElements()) {
                ze = outEntries.nextElement();
                outZipMap.put(ze.getName(), ze);
            }
            while (goldEntries.hasMoreElements()) {
                ze = goldEntries.nextElement();
                goldZipMap.put(ze.getName(), ze);
            }
            if (outZipMap.keySet().size() != goldZipMap.keySet().size()) {
                System.err.println("Difference in number of files:");
                System.err.println(" out: " + outZipMap.keySet().size());
                System.err.println("gold: " + goldZipMap.keySet().size() + "\n");
                boolean ze2 = false;
                return ze2;
            }
            if (!outZipMap.keySet().equals(goldZipMap.keySet())) {
                System.err.println("Filenames do not match between the zipfiles\n");
                boolean ze2 = false;
                return ze2;
            }
            boolean failure = false;
            int identicals = 0;
            try {
                for (String filename : outZipMap.keySet()) {
                    ZipEntry oze = (ZipEntry)outZipMap.get(filename);
                    ZipEntry gze = (ZipEntry)goldZipMap.get(filename);
                    System.out.println("Comparing file: " + filename);
                    InputStream ois = outZipFile.getInputStream(oze);
                    InputStream gis = goldZipFile.getInputStream(gze);
                    boolean same = type.equals("PerLine") ? this.fc.compareFilesPerLines(ois, gis, "UTF-8") : (type.equals("PerLineIgnoreEmpty") ? this.fc.compareFilesPerLines(ois, gis, "UTF-8", ignoreEmtpyLines) : this.fc.filesExactlyTheSame(ois, gis));
                    if (same) {
                        ++identicals;
                        continue;
                    }
                    System.err.println("Output and Gold Entry " + filename + " differ\n");
                    if (failure) continue;
                    failure = true;
                }
            }
            catch (Exception e) {
                System.err.println("Error opening/reading file\n");
                boolean filename = false;
                if (outZipFile != null) {
                    try {
                        outZipFile.close();
                    }
                    catch (IOException e6) {
                        e6.printStackTrace();
                    }
                }
                if (goldZipFile != null) {
                    try {
                        goldZipFile.close();
                    }
                    catch (IOException e7) {
                        e7.printStackTrace();
                    }
                }
                return filename;
            }
            if (!failure) {
                System.out.println("\nAll " + identicals + " pass comparison.\n");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (outZipFile != null) {
                try {
                    outZipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (goldZipFile != null) {
                try {
                    goldZipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean compareFilesPerLines(String out, String gold, String encoding) {
        return this.compareFiles("PerLine", out, gold, encoding, false);
    }

    public boolean compareFilesPerLines(String out, String gold, String encoding, boolean ignoreEmtpyLines) {
        return this.compareFiles("PerLineIgnoreEmpty", out, gold, encoding, ignoreEmtpyLines);
    }

    public boolean filesExactlyTheSame(String out, String gold) {
        return this.compareFiles("ExactlyTheSame", out, gold, null, false);
    }
}

