/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;

public class JSONEncoder
implements IEncoder {
    private CharsetEncoder chsEnc = Charset.forName("UTF-8").newEncoder();
    private boolean escapeExtendedChars = false;
    private String lineBreak = "\n";

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.chsEnc = Charset.forName(encoding).newEncoder();
        this.lineBreak = lineBreak;
        if (params != null) {
            this.escapeExtendedChars = params.getBoolean("escapeExtendedChars");
        }
    }

    @Override
    public String encode(String text, EncoderContext context) {
        StringBuilder escaped = new StringBuilder();
        block8: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch > '\u007f') {
                if (Character.isHighSurrogate(ch)) {
                    int cp = text.codePointAt(i++);
                    String tmp = new String(Character.toChars(cp));
                    if (this.escapeExtendedChars || this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                        escaped.append(String.format("\\u%04x\\u%04x", tmp.charAt(0), (int)tmp.charAt(1)));
                        continue;
                    }
                    escaped.append(tmp);
                    continue;
                }
                if (this.escapeExtendedChars || this.chsEnc != null && !this.chsEnc.canEncode(ch)) {
                    escaped.append(String.format("\\u%04x", ch));
                    continue;
                }
                escaped.append(String.valueOf(ch));
                continue;
            }
            switch (ch) {
                case '\b': {
                    escaped.append("\\b");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    escaped.append('\\');
                }
                default: {
                    escaped.append(ch);
                }
            }
        }
        return escaped.toString();
    }

    @Override
    public String encode(char value, EncoderContext context) {
        if (value > '\u007f') {
            if (this.escapeExtendedChars || !this.chsEnc.canEncode(value)) {
                return String.format("\\u%04x", value);
            }
            return String.valueOf(value);
        }
        switch (value) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\"': 
            case '/': 
            case '\\': {
                return "\\" + value;
            }
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (value > 127) {
            if (Character.isSupplementaryCodePoint(value)) {
                String tmp = new String(Character.toChars(value));
                if (this.escapeExtendedChars || !this.chsEnc.canEncode(tmp)) {
                    return String.format("\\u%04x\\u%04x", tmp.charAt(0), (int)tmp.charAt(1));
                }
                return tmp;
            }
            if (this.escapeExtendedChars || this.chsEnc != null && !this.chsEnc.canEncode((char)value)) {
                return String.format("\\u%04x", value);
            }
            return String.valueOf((char)value);
        }
        switch (value) {
            case 8: {
                return "\\b";
            }
            case 12: {
                return "\\f";
            }
            case 10: {
                return "\\n";
            }
            case 13: {
                return "\\r";
            }
            case 9: {
                return "\\t";
            }
            case 34: 
            case 47: 
            case 92: {
                return "\\" + (char)value;
            }
        }
        return String.valueOf((char)value);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }
}

