/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.io.File;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.StubFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterConfigurationTest {
    private FilterConfiguration fc1;
    private FilterConfiguration fc2;

    @Before
    public void setUp() throws Exception {
        this.fc1 = new FilterConfiguration("config1", "text/x-properties", "net.sf.okapi.filters.xml.XMLFilter", "Config1", "Description for Config1.");
        this.fc2 = new FilterConfiguration("config2", "text/x-properties", "net.sf.okapi.filters.xml.XMLFilter", "Config2", "Description for Config2.");
        this.fc2.custom = true;
    }

    @Test
    public void simpleOverrideTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc1);
        FilterConfiguration cfg = fcm.getDefaultConfiguration("text/x-properties");
        Assert.assertEquals(cfg.configId, "config1");
        fcm.removeConfiguration(cfg.configId);
        fcm.addConfiguration(this.fc2);
        cfg = fcm.getDefaultConfiguration("text/x-properties");
        Assert.assertEquals(cfg.configId, "config2");
    }

    @Test
    public void simpleConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc1);
        FilterConfiguration cfg = fcm.getConfiguration(this.fc1.configId);
        Assert.assertNotNull(cfg);
        Assert.assertEquals(cfg, this.fc1);
    }

    @Test
    public void getDefaultFromMimeTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations(StubFilter.class.getName());
        FilterConfiguration cfg = fcm.getDefaultConfiguration("text/foo");
        Assert.assertNotNull("config should not be null", cfg);
        Assert.assertEquals("The Config ID", "foobar", cfg.configId);
    }

    @Test
    public void getFilterConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc1);
        List<FilterConfiguration> list = fcm.getFilterConfigurations(this.fc1.filterClass);
        Assert.assertNotNull(list);
        Assert.assertEquals(1L, list.size());
    }

    @Test
    public void getMimeConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc1);
        List<FilterConfiguration> list = fcm.getMimeConfigurations(this.fc1.mimeType);
        Assert.assertNotNull(list);
        Assert.assertEquals(1L, list.size());
    }

    @Test
    public void clearConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc2);
        fcm.addConfiguration(this.fc1);
        Assert.assertNotNull(fcm.getConfiguration(this.fc1.configId));
        Assert.assertNotNull(fcm.getConfiguration(this.fc2.configId));
        fcm.clearConfigurations(false);
        Assert.assertNull(fcm.getConfiguration(this.fc1.configId));
        Assert.assertNull(fcm.getConfiguration(this.fc2.configId));
    }

    @Test
    public void clearCustomConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc2);
        fcm.addConfiguration(this.fc1);
        Assert.assertNotNull(fcm.getConfiguration(this.fc1.configId));
        Assert.assertNotNull(fcm.getConfiguration(this.fc2.configId));
        fcm.clearConfigurations(true);
        Assert.assertNotNull(fcm.getConfiguration(this.fc1.configId));
        Assert.assertNull(fcm.getConfiguration(this.fc2.configId));
    }

    @Test
    public void createFilterTestWithDefaultFilter() {
        String configId = "foobar";
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations(StubFilter.class.getName());
        FilterConfiguration cfg = fcm.getConfiguration(configId);
        IFilter filter = fcm.createFilter(configId);
        Assert.assertNotNull("filter should not be null", filter);
        Assert.assertEquals(filter.getClass().getName(), cfg.filterClass);
    }

    @Test
    public void createFilterTestWithNonDefaultFilter() {
        String configId = "foobar-srt";
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations(StubFilter.class.getName());
        FilterConfiguration cfg = fcm.getConfiguration(configId);
        IFilter filter = fcm.createFilter(configId);
        Assert.assertNotNull("filter should not be null", filter);
        Assert.assertEquals(filter.getClass().getName(), cfg.filterClass);
    }

    @Test
    public void removeFilterTest() {
        String configId = "foobar-srt";
        String filterClass = "net.sf.okapi.common.filters.StubFilter";
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations(filterClass);
        FilterConfiguration cfg = fcm.getConfiguration(configId);
        Assert.assertNotNull(cfg);
        fcm.removeConfigurations(filterClass);
        cfg = fcm.getConfiguration(configId);
        Assert.assertNull("Config should have not been found.", cfg);
    }

    @Test
    public void createEditorTest() {
        String configId = "foobar-srt";
        String editorClass = "net.sf.okapi.common.filters.StubEditor";
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations("net.sf.okapi.common.filters.StubFilter");
        IFilter filter = fcm.createFilter(configId);
        Assert.assertNotNull(filter);
        IParameters params = filter.getParameters();
        fcm.addEditor(editorClass, params.getClass().getName());
        IParametersEditor editor = fcm.createConfigurationEditor(configId);
        Assert.assertNotNull("Editor should have been created.", editor);
        Assert.assertEquals("Editor class name.", editorClass, editor.getClass().getName());
    }

    @Test
    public void testCustomConfigurationFromPath() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations("net.sf.okapi.common.filters.StubFilter");
        FilterConfiguration existingFc = fcm.getConfiguration("foobar");
        Assert.assertNotNull(existingFc);
        String root = TestUtil.getParentDir(this.getClass(), "/foobar@myConfig.fprm");
        File f = new File(root + "foobar@myConfig.fprm");
        Assert.assertNotNull(f);
        String configId = Util.getFilename(f.getAbsolutePath(), false);
        fcm.addCustomConfiguration(configId);
        Assert.assertNotNull(fcm.getConfiguration(configId));
    }
}

