/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Test;

public class ITSContentTest {
    @Test
    public void extendedMatchTest() {
        Assert.assertTrue(ITSContent.isExtendedMatch("*-CH", "de-CH"));
        Assert.assertTrue(ITSContent.isExtendedMatch("*-CH", "fr-ch"));
        Assert.assertTrue(ITSContent.isExtendedMatch("de-*-DE, fr", "de-de"));
        Assert.assertTrue(ITSContent.isExtendedMatch("fr, de-*-DE", "de-Latn-de"));
        Assert.assertTrue(ITSContent.isExtendedMatch("za ,  de-*-DE , po-pl  ", "de-DE-x-goethe"));
        Assert.assertTrue(ITSContent.isExtendedMatch("za, de-*-DE,   po-pl", "de-DE"));
        Assert.assertTrue(ITSContent.isExtendedMatch("za, de-*, po-pl", "de"));
        Assert.assertTrue(ITSContent.isExtendedMatch("de-*, de", "de"));
        Assert.assertTrue(ITSContent.isExtendedMatch("de-*-DE", "de-DE"));
        Assert.assertTrue(ITSContent.isExtendedMatch("de-*-DE", "de-de"));
        Assert.assertTrue(ITSContent.isExtendedMatch("de-*-DE", "de-Latn-DE"));
        Assert.assertTrue(ITSContent.isExtendedMatch("de-*-DE", "de-Latf-DE"));
        Assert.assertTrue(ITSContent.isExtendedMatch("de-*-DE", "de-DE-x-goethe"));
        Assert.assertTrue(ITSContent.isExtendedMatch("de-*-DE", "de-Latn-DE-1996"));
        Assert.assertTrue(ITSContent.isExtendedMatch("de-*-DE", "de-Deva-DE"));
        Assert.assertFalse(ITSContent.isExtendedMatch("de-*-DE", "de"));
        Assert.assertFalse(ITSContent.isExtendedMatch("de-*-DE", "de-x-DE"));
        Assert.assertFalse(ITSContent.isExtendedMatch("de-*-DE", "de-Deva"));
        Assert.assertFalse(ITSContent.isExtendedMatch("", "fr"));
        Assert.assertTrue(ITSContent.isExtendedMatch("*", "fr"));
    }

    @Test
    public void testGetAnnotatorRef() {
        TextUnit tu = new TextUnit("id");
        GenericAnnotation ann = new GenericAnnotation("its-annotators", "annotatorsValue", "translate|uri1");
        GenericAnnotations.addAnnotations(tu, new GenericAnnotations(ann));
        Assert.assertEquals("uri1", ITSContent.getAnnotatorRef("translate", tu));
        Assert.assertEquals(null, ITSContent.getAnnotatorRef("invalidDataCategory", tu));
        ann.setString("annotatorsValue", "mt-confidence|uri2 ");
        Assert.assertEquals("uri2", ITSContent.getAnnotatorRef("mt-confidence", tu));
        ann.setString("annotatorsValue", "mt-confidence|uri3 text-analysis|uri4 translate|uri5");
        Assert.assertEquals("uri3", ITSContent.getAnnotatorRef("mt-confidence", tu));
        Assert.assertEquals("uri4", ITSContent.getAnnotatorRef("text-analysis", tu));
        Assert.assertEquals("uri5", ITSContent.getAnnotatorRef("translate", tu));
        ann.setString("annotatorsValue", "domain| text-analysis|");
        Assert.assertEquals("", ITSContent.getAnnotatorRef("domain", tu));
        Assert.assertEquals("", ITSContent.getAnnotatorRef("text-analysis", tu));
    }
}

