/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TMXWriterTest {
    static final File TMX_File = new File("target/test-classes/tmxwritertest_tmxfile.tmx");
    TMXWriter tmxWriter;
    StringWriter strWriter;
    private LocaleId locEN = LocaleId.fromString("en");
    private LocaleId locFR = LocaleId.fromString("fr");
    private LocaleId locKR = LocaleId.fromString("kr");
    private static final String expectedHeaderTmx = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><tmx version=\"1.4\"><header creationtool=\"pensieve\" creationtoolversion=\"0.0.1\" segtype=\"sentence\" o-tmf=\"pensieve_format\" adminlang=\"en\" srclang=\"en\" datatype=\"unknown\"></header><body>";
    private static final String expectedFooterTmx = "</body></tmx>";

    @Before
    public void setUp() {
        this.strWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(this.strWriter);
        this.tmxWriter = new TMXWriter(xmlWriter);
        this.createTmxHeader();
    }

    @Test
    public void constructorStringPath() {
        TMX_File.delete();
        this.tmxWriter = new TMXWriter(TMX_File.getPath());
        Assert.assertTrue("tmx file should have been created", TMX_File.exists());
    }

    @Test
    public void writeStartDocumentWithFile() throws IOException {
        TMX_File.delete();
        this.tmxWriter = new TMXWriter(TMX_File.getPath());
        this.createTmxHeader();
        this.tmxWriter.close();
        String tmx = TestUtil.getFileAsString(TMX_File);
        this.testHeader(tmx);
    }

    @Test
    public void constructorWithXmlWriter() {
        this.tmxWriter.close();
        String tmx = this.strWriter.toString();
        this.testHeader(tmx);
    }

    @Test
    public void emptyDocument() {
        this.tmxWriter.writeEndDocument();
        String tmx = this.stripNewLinesAndReturns(this.strWriter.toString());
        Assert.assertEquals("Header and Footer Only", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><tmx version=\"1.4\"><header creationtool=\"pensieve\" creationtoolversion=\"0.0.1\" segtype=\"sentence\" o-tmf=\"pensieve_format\" adminlang=\"en\" srclang=\"en\" datatype=\"unknown\"></header><body></body></tmx>", tmx);
    }

    @Test
    public void testTmxTuNoAttributes() {
        ITextUnit tu = this.createTextUnit("id", "SourceContent", "TargetContent", null);
        this.tmxWriter.writeTUFull(tu);
        this.testTu(tu, this.strWriter.toString());
    }

    @Test
    public void testTmxTuNoAttributesWithSrcLangAll() {
        ITextUnit tu = this.createTextUnit("id", "SourceContent", "TargetContent", null);
        LocaleId srcLocAll = new LocaleId("*all*", false);
        this.tmxWriter.writeTUFull(tu, srcLocAll);
        String tmx = this.strWriter.toString();
        tmx = this.stripNewLinesAndReturns(tmx);
        String properties = this.getProps(tu);
        String targetTuvs = this.getTargetTuvs(tu);
        String expectedTMX = "<tu tuid=\"" + tu.getName() + "\">" + properties + "<tuv xml:lang=\"*all*\">" + "<seg>" + tu.getSource().getSegments().getFirstContent().toText() + "</seg>" + "</tuv>" + targetTuvs + "</tu>";
        Assert.assertEquals("TU Element", expectedHeaderTmx + expectedTMX, tmx);
    }

    @Test
    public void tmxWithTargetAttributes() {
        ITextUnit tu = this.createTextUnitWithTransAttributes("id", "SourceContent", "TargetContent", new String[][]{{"creationdate", "20120822T110210Z"}, {"changeid", "0"}, {"changedate", "20130501T065729Z"}});
        LocaleId srcLocAll = new LocaleId("*all*", false);
        XMLWriter xmlWriter = new XMLWriter(this.strWriter);
        TMXWriter w = new TMXWriter(xmlWriter);
        w.setWriteAllPropertiesAsAttributes(true);
        w.writeTUFull(tu, srcLocAll);
        String tmx = this.strWriter.toString();
        tmx = this.stripNewLinesAndReturns(tmx);
        String properties = this.getProps(tu);
        String targetTuvs = this.getTargetTuvsWithAttributes(tu);
        String expectedTMX = "<tu tuid=\"" + tu.getName() + "\">" + "<tuv xml:lang=\"*all*\">" + "<seg>" + tu.getSource().getSegments().getFirstContent().toText() + "</seg>" + "</tuv>" + targetTuvs + "</tu>";
        Assert.assertEquals("TU Element", expectedTMX, tmx);
    }

    @Test
    public void testTmxTuSingleProp() {
        ITextUnit tu = this.createTextUnit("id", "SourceContent", "TargetContent", new String[][]{{"prop1", "value1"}});
        this.tmxWriter.writeTUFull(tu);
        this.testTu(tu, this.strWriter.toString());
    }

    @Test
    public void testTmxTuMultiProp() {
        ITextUnit tu = this.createTextUnit("id", "SourceContent", "TargetContent", new String[][]{{"prop1", "value1"}, {"prop2", "value2"}});
        this.tmxWriter.writeTUFull(tu);
        this.testTu(tu, this.strWriter.toString());
    }

    @Test
    public void testTmxTuMultiLang() {
        ITextUnit tu = this.createTextUnit("id", "SourceContent", "TargetContent", new String[][]{{"prop1", "value1"}, {"prop2", "value2"}});
        tu.setTargetContent(this.locKR, new TextFragment("KoreanTarget"));
        this.tmxWriter.writeTUFull(tu);
        this.testTu(tu, this.strWriter.toString());
    }

    private void testHeader(String tmx) {
        tmx = this.stripNewLinesAndReturns(tmx);
        Assert.assertEquals("TMX Header", expectedHeaderTmx, tmx);
    }

    private void testTu(ITextUnit tu, String tmx) {
        tmx = this.stripNewLinesAndReturns(tmx);
        String properties = this.getProps(tu);
        String targetTuvs = this.getTargetTuvs(tu);
        String expectedTMX = "<tu tuid=\"" + tu.getName() + "\">" + properties + "<tuv xml:lang=\"en\">" + "<seg>" + tu.getSource().getSegments().getFirstContent().toText() + "</seg>" + "</tuv>" + targetTuvs + "</tu>";
        Assert.assertEquals("TU Element", expectedHeaderTmx + expectedTMX, tmx);
    }

    private String getProps(ITextUnit tu) {
        String properties = "";
        for (String propName : tu.getPropertyNames()) {
            properties = properties + "<prop type=\"" + propName + "\">" + tu.getProperty(propName) + "</prop>";
        }
        return properties;
    }

    private String getTargetTuvs(ITextUnit tu) {
        String targetTuvs = "";
        for (LocaleId langName : tu.getTargetLocales()) {
            targetTuvs = targetTuvs + "<tuv xml:lang=\"" + langName + "\">" + "<seg>" + tu.getTargetSegments(langName).getFirstContent().toText() + "</seg>" + "</tuv>";
        }
        return targetTuvs;
    }

    private String getTargetTuvsWithAttributes(ITextUnit tu) {
        String targetTuvs = "";
        for (LocaleId langName : tu.getTargetLocales()) {
            targetTuvs = targetTuvs + "<tuv xml:lang=\"" + langName + "\"" + " creationdate=\"20120822T110210Z\" changeid=\"0\" changedate=\"20130501T065729Z\">" + "<seg>" + tu.getTargetSegments(langName).getFirstContent().toText() + "</seg>" + "</tuv>";
        }
        return targetTuvs;
    }

    private ITextUnit createTextUnit(String id, String sourceContent, String targetContent, String[][] attributes) {
        TextUnit tu = new TextUnit(id);
        tu.setName(id);
        tu.setSourceContent(new TextFragment(sourceContent));
        tu.setTargetContent(this.locFR, new TextFragment(targetContent));
        if (attributes != null) {
            for (String[] kvp : attributes) {
                tu.setProperty(new Property(kvp[0], kvp[1]));
            }
        }
        return tu;
    }

    private ITextUnit createTextUnitWithTransAttributes(String id, String sourceContent, String targetContent, String[][] attributes) {
        TextUnit tu = new TextUnit(id);
        tu.setName(id);
        tu.setSourceContent(new TextFragment(sourceContent));
        tu.setTargetContent(this.locFR, new TextFragment(targetContent));
        TextContainer t = tu.getTarget(this.locFR);
        if (attributes != null) {
            for (String[] kvp : attributes) {
                t.setProperty(new Property(kvp[0], kvp[1]));
            }
        }
        return tu;
    }

    private void createTmxHeader() {
        this.tmxWriter.writeStartDocument(this.locEN, this.locFR, "pensieve", "0.0.1", "sentence", "pensieve_format", "unknown");
    }

    private String stripNewLinesAndReturns(String tmx) {
        return tmx.replaceAll("[\\n\\r]+", "");
    }
}

