/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.EnumSet;
import java.util.LinkedList;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.AlignedPair;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Test;

public class AlignedSegmentsTest {
    private static final LocaleId locFR = LocaleId.FRENCH;
    private static final LocaleId locES = LocaleId.SPANISH;
    private static final LocaleId locEL = LocaleId.fromString("el-GR");
    private static final String TU1 = "tu1";
    private GenericContent fmt = new GenericContent();

    @Test
    public void loopThroughSegments() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        for (Segment srcSeg : as) {
            Segment trgSeg;
            if (srcSeg.id.equals("0")) {
                Assert.assertEquals("Part 1.", srcSeg.text.toString());
                trgSeg = as.getCorrespondingTarget(srcSeg, locFR, EnumSet.of(IAlignedSegments.VariantOptions.CANCEL_IF_MULTIPLE_TARGETS), IAlignedSegments.COPY_TO_NONE);
                Assert.assertEquals("Trg 1.", trgSeg.text.toString());
                continue;
            }
            Assert.assertEquals("Part 2.", srcSeg.text.toString());
            trgSeg = as.getCorrespondingTarget(srcSeg, locES, EnumSet.of(IAlignedSegments.VariantOptions.CANCEL_IF_MULTIPLE_TARGETS), IAlignedSegments.COPY_TO_NONE);
            Assert.assertEquals("Objetivo 2.", trgSeg.text.toString());
        }
    }

    @Test
    public void getSegmentsTest() {
        TextUnit tu = new TextUnit(TU1);
        tu.setSourceContent(new TextFragment("text"));
        IAlignedSegments as = tu.getAlignedSegments();
        Assert.assertNotNull(as);
    }

    @Test
    public void removeSegmentsTest() {
        ITextUnit tu = this.createSegmentedTU();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg = as.getSource(0, locFR);
        Assert.assertEquals("0", seg.id);
        as.remove(seg, locFR, IAlignedSegments.MODIFY_ALL);
        seg = as.getSource(0, locFR);
        Assert.assertEquals("s2", seg.id);
    }

    @Test
    public void removeSegmentsWithTargetTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg = as.getSource(0, locFR);
        Assert.assertEquals("0", seg.id);
        as.remove(seg, locFR, IAlignedSegments.MODIFY_ALL);
        ISegments segs = tu.getTargetSegments(locFR);
        seg = segs.get(0);
        Assert.assertEquals("s2", seg.id);
    }

    @Test
    public void insertSourceSegmentTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg1 = new Segment("newId");
        as.insert(1, seg1, null, locFR, IAlignedSegments.MODIFY_ALL, EnumSet.of(IAlignedSegments.CopyOptions.COPY_TO_SOURCE));
        Segment seg2 = as.getSource(1, locFR);
        Assert.assertSame(seg1, seg2);
        Segment seg3 = as.getSource(2, locFR);
        Assert.assertEquals("s2", seg3.id);
        Segment seg4 = as.getCorrespondingTarget(seg2, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals(seg1.id, seg4.id);
    }

    @Test
    public void insertSourceSegmentChangeIdTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg1 = new Segment("s2");
        as.insert(1, seg1, null, locFR, IAlignedSegments.MODIFY_ALL, EnumSet.of(IAlignedSegments.CopyOptions.COPY_TO_SOURCE));
        Segment seg2 = as.getSource(1, locFR);
        Assert.assertSame(seg1, seg2);
        Assert.assertEquals("1", seg2.id);
        Segment seg4 = as.getCorrespondingTarget(seg2, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals(seg1.id, seg4.id);
    }

    @Test
    public void insertSegmentsChangeIdTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment insertSrcSeg = new Segment("s2");
        Segment insertTrgSeg = new Segment("zzId", new TextFragment("[text]"));
        as.insert(1, insertSrcSeg, insertTrgSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_SOURCE_AND_TARGET);
        Segment srcAtInsertedIndex = as.getSource(1, locFR);
        Assert.assertSame("The given source should be inserted at the index (not a copy)", insertSrcSeg, srcAtInsertedIndex);
        Assert.assertEquals("1", srcAtInsertedIndex.id);
        Segment trgAtInsertedIndex = as.getCorrespondingTarget(srcAtInsertedIndex, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals("[text]", trgAtInsertedIndex.toString());
        Assert.assertEquals(insertSrcSeg.id, trgAtInsertedIndex.id);
    }

    @Test
    public void splitSourceSegmentTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment srcSeg = as.getSource(1, locFR);
        Segment newSrcSeg = as.splitSource(locFR, srcSeg, 5, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull(newSrcSeg);
        Assert.assertEquals("2.", newSrcSeg.text.toString());
        Assert.assertEquals("Part ", srcSeg.text.toString());
        Segment newTrgSeg = as.getCorrespondingTarget(newSrcSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull(newTrgSeg);
        Assert.assertTrue(newTrgSeg.text.isEmpty());
        Assert.assertEquals("[Part 1.] a [Part ][2.]", this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals("[Trg 1.] a [Trg 2.][]", this.fmt.printSegmentedContent(tu.getTarget(locFR), true));
        Assert.assertEquals("[Objetivo 1.] a [Objetivo 2.][]", this.fmt.printSegmentedContent(tu.getTarget(locES), true));
    }

    @Test
    public void splitTargetSegmentTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment trgSeg = tu.getTargetSegments(locFR).get(1);
        Segment newTrgSeg = as.splitTarget(locFR, trgSeg, 4, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull(newTrgSeg);
        Assert.assertEquals("2.", newTrgSeg.text.toString());
        Assert.assertEquals("Trg ", trgSeg.text.toString());
        Segment newSrcSeg = as.getCorrespondingSource(newTrgSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull(newSrcSeg);
        Assert.assertTrue(newSrcSeg.text.isEmpty());
        Assert.assertEquals("[Part 1.] a [Part 2.][]", this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals("[Trg 1.] a [Trg ][2.]", this.fmt.printSegmentedContent(tu.getTarget(locFR), true));
        Assert.assertEquals("[Objetivo 1.] a [Objetivo 2.][]", this.fmt.printSegmentedContent(tu.getTarget(locES), true));
    }

    @Test
    public void setSourceTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment newSeg = new Segment("newId", new TextFragment("newText"));
        as.setSegment(1, newSeg, locFR, EnumSet.of(IAlignedSegments.VariantOptions.MODIFY_SOURCE), IAlignedSegments.MODIFY_ALL);
        Segment seg = as.getSource(1, locFR);
        Assert.assertEquals("newText", seg.toString());
        Assert.assertEquals("newId", seg.id);
        seg = as.getCorrespondingTarget(newSeg, locES, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals("newId", seg.id);
        seg = as.getCorrespondingTarget(newSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals("newId", seg.id);
    }

    @Test
    public void setTargetTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment newSeg = new Segment("newId", new TextFragment("newText"));
        as.setSegment(1, newSeg, locFR, EnumSet.of(IAlignedSegments.VariantOptions.MODIFY_TARGET), IAlignedSegments.MODIFY_ALL);
        Segment seg = as.getSource(1, locFR);
        Assert.assertEquals("newId", seg.id);
        seg = as.getCorrespondingTarget(seg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals("newText", seg.toString());
        seg = as.getCorrespondingTarget(newSeg, locES, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull(seg);
        Assert.assertEquals("newId", seg.id);
    }

    @Test
    public void getSourceTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Assert.assertEquals("Part 2.", as.getSource((int)1, (LocaleId)AlignedSegmentsTest.locFR).text.toString());
    }

    @Test
    public void getCorrespondingTargetTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment srcSeg = as.getSource(1, locFR);
        Segment trgSeg = as.getCorrespondingTarget(srcSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals("Trg 2.", trgSeg.text.toString());
        trgSeg = as.getCorrespondingTarget(trgSeg, locES, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals("Objetivo 2.", trgSeg.text.toString());
    }

    @Test
    public void getCorrespondingSourceTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment srcSeg1 = as.getSource(1, locFR);
        Segment trgSeg = as.getCorrespondingTarget(srcSeg1, locES, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Segment srcSeg2 = as.getCorrespondingSource(trgSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertSame(srcSeg1, srcSeg2);
    }

    @Test
    public void joinWithNextTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        as.append(new Segment("nId", new TextFragment("newSrcText")), new Segment("nId", new TextFragment("newTrgText")), locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_SOURCE_AND_TARGET);
        Assert.assertEquals("[Part 1.] a [Part 2.][newSrcText]", this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals("[Trg 1.] a [Trg 2.][newTrgText]", this.fmt.printSegmentedContent(tu.getTarget(locFR), true));
        Assert.assertEquals("[Objetivo 1.] a [Objetivo 2.][]", this.fmt.printSegmentedContent(tu.getTarget(locES), true));
        Segment srcSeg = as.getSource(1, locFR);
        as.joinWithNext(srcSeg, locFR, IAlignedSegments.MODIFY_ALL);
        Assert.assertEquals("[Part 1.] a [Part 2.newSrcText]", this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals("[Trg 1.] a [Trg 2.newTrgText]", this.fmt.printSegmentedContent(tu.getTarget(locFR), true));
        Assert.assertEquals("[Objetivo 1.] a [Objetivo 2.]", this.fmt.printSegmentedContent(tu.getTarget(locES), true));
        srcSeg = as.getSource(0, locFR);
        as.joinWithNext(srcSeg, locFR, IAlignedSegments.MODIFY_ALL);
        Assert.assertEquals("[Part 1. a Part 2.newSrcText]", this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals("[Trg 1. a Trg 2.newTrgText]", this.fmt.printSegmentedContent(tu.getTarget(locFR), true));
        Assert.assertEquals("[Objetivo 1. a Objetivo 2.]", this.fmt.printSegmentedContent(tu.getTarget(locES), true));
    }

    @Test
    public void joinAllTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        as.joinAll(locFR, IAlignedSegments.MODIFY_ALL);
        Assert.assertEquals("[Part 1. a Part 2.]", this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals("[Trg 1. a Trg 2.]", this.fmt.printSegmentedContent(tu.getTarget(locFR), true));
        Assert.assertEquals("[Objetivo 1. a Objetivo 2.]", this.fmt.printSegmentedContent(tu.getTarget(locES), true));
    }

    @Test
    public void appendSegmentTest1() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg = new Segment("nId", new TextFragment("newSrcText"));
        as.append(seg, null, locFR, IAlignedSegments.MODIFY_ALL, EnumSet.of(IAlignedSegments.CopyOptions.COPY_TO_SOURCE));
        Assert.assertEquals("newSrcText", as.getSource(2, locFR).toString());
        Assert.assertEquals("nId", as.getCorrespondingTarget((Segment)seg, (LocaleId)AlignedSegmentsTest.locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE).id);
        Assert.assertEquals("[Part 1.] a [Part 2.][newSrcText]", this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals("[Trg 1.] a [Trg 2.][]", this.fmt.printSegmentedContent(tu.getTarget(locFR), true));
        Assert.assertEquals("[Objetivo 1.] a [Objetivo 2.][]", this.fmt.printSegmentedContent(tu.getTarget(locES), true));
    }

    @Test
    public void appendSegmentTest2() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg = new Segment("nId", new TextFragment("newSrcText"));
        as.append(seg, new Segment("nId", new TextFragment("newTrgText")), locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_SOURCE_AND_TARGET);
        Assert.assertEquals("newSrcText", as.getSource(2, locFR).toString());
        Assert.assertEquals("nId", as.getCorrespondingTarget((Segment)seg, (LocaleId)AlignedSegmentsTest.locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE).id);
        Assert.assertEquals("newTrgText", as.getCorrespondingTarget(seg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE).toString());
        Assert.assertEquals("[Part 1.] a [Part 2.][newSrcText]", this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals("[Trg 1.] a [Trg 2.][newTrgText]", this.fmt.printSegmentedContent(tu.getTarget(locFR), true));
        Assert.assertEquals("[Objetivo 1.] a [Objetivo 2.][]", this.fmt.printSegmentedContent(tu.getTarget(locES), true));
    }

    @Test
    public void alignWithAlignedPairs() {
        LinkedList<AlignedPair> alignedPairs = new LinkedList<AlignedPair>();
        Object[] source = new String[]{"apSource 1.", "apSource 2.", "apSource 3."};
        Object[] target = new String[]{"apTarg 1.", "apTarg 2.", "apTarg 3."};
        Segment srcSeg = new Segment("sA", new TextFragment(source[0]));
        Segment trgSeg = new Segment("sAlpha", new TextFragment(target[0]));
        alignedPairs.add(new AlignedPair(srcSeg, trgSeg, locEL));
        srcSeg = new Segment("sB", new TextFragment(source[1]));
        trgSeg = new Segment("sBeta", new TextFragment(target[1]));
        alignedPairs.add(new AlignedPair(srcSeg, trgSeg, locEL));
        srcSeg = new Segment("sC", new TextFragment(source[2]));
        trgSeg = new Segment("sChuppa?", new TextFragment(target[2]));
        alignedPairs.add(new AlignedPair(srcSeg, trgSeg, locEL));
        ITextUnit tu = this.createSegmentedTUAndTarget();
        tu.getAlignedSegments().align(alignedPairs, locEL);
        Assert.assertTrue("a new variant source should be created if none is present for the given locale", tu.getVariantSources().hasVariant(locEL));
        Assert.assertTrue("a new target should be created if nont is present for the given locale", tu.hasTarget(locEL));
        Object[] actualSources = new String[]{tu.getVariantSources().get(locEL).getSegments().get(0).toString(), tu.getVariantSources().get(locEL).getSegments().get(1).toString(), tu.getVariantSources().get(locEL).getSegments().get(2).toString()};
        Assert.assertArrayEquals("the source segments of the aligned pairs should be used in the source content", source, actualSources);
        Object[] actualTargets = new String[]{tu.getTarget(locEL).getSegments().get(0).toString(), tu.getTarget(locEL).getSegments().get(1).toString(), tu.getTarget(locEL).getSegments().get(2).toString()};
        Assert.assertArrayEquals("the target segments of the aligned pairs should be used in the target content", target, actualTargets);
        Assert.assertEquals("the target should have a status of ALIGNED after the align() method is called", (Object)AlignmentStatus.ALIGNED, (Object)tu.getTarget(locEL).getSegments().getAlignmentStatus());
        Assert.assertEquals("the default source should not be changed by this method", "Part 1.", tu.getSource().getFirstSegment().toString());
        Assert.assertEquals("the default source should not be changed by this method", "Trg 1.", tu.getTarget(locFR).getFirstSegment().toString());
        Assert.assertEquals("the default source should not be changed by this method", "Objetivo 1.", tu.getTarget(locES).getFirstSegment().toString());
    }

    @Test
    public void alignCollapseAll() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        tu.getAlignedSegments().alignCollapseAll(locFR, IAlignedSegments.MODIFY_AS_VARIANT);
        Assert.assertTrue("a variant source should exist after calling a method with MODIFY_AS_VARIANT", tu.hasVariantSources());
        Assert.assertTrue("the source content should be one segment after alignCollapseAll()", tu.getVariantSources().get(locFR).contentIsOneSegment());
        Assert.assertFalse("the target should not be flagged as segmented after it has been collapsed", tu.getVariantSources().get(locFR).hasBeenSegmented());
        Assert.assertTrue("the target content should be one segment after alignCollapseAll()", tu.getTarget(locFR).contentIsOneSegment());
        Assert.assertFalse("the target should not be flagged as segmented after it has been collapsed", tu.getTarget(locFR).hasBeenSegmented());
        Assert.assertEquals("the target should be marked as ALIGNED after alignCollapseAll()", (Object)AlignmentStatus.ALIGNED, (Object)tu.getTarget(locFR).getSegments().getAlignmentStatus());
        Assert.assertFalse("the default source should not be changed when the method is called with MODIFY_AS_VARIANT", tu.getSource().contentIsOneSegment());
        Assert.assertFalse("targets of other locales should not be changed when the method is called with MODIFY_AS_VARIANT", tu.getTarget(locES).contentIsOneSegment());
        Assert.assertEquals("other targets should not be marked as ALIGNED when the method is called with MODIFY_AS_VARIANT", (Object)AlignmentStatus.NOT_ALIGNED, (Object)tu.getTarget(locES).getSegments().getAlignmentStatus());
    }

    private ITextUnit createSegmentedTU() {
        TextUnit tu = new TextUnit("id", "Part 1.");
        tu.getSource().getSegments().append(new Segment("s2", new TextFragment("Part 2.")), " a ");
        return tu;
    }

    private ITextUnit createSegmentedTUAndTarget() {
        ITextUnit tu = this.createSegmentedTU();
        ISegments segs = tu.getTargetSegments(locFR);
        segs.get((int)0).text.append("Trg 1.");
        segs.get((int)1).text.append("Trg 2.");
        segs = tu.getTargetSegments(locES);
        segs.get((int)0).text.append("Objetivo 1.");
        segs.get((int)1).text.append("Objetivo 2.");
        return tu;
    }
}

