/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.InvalidPositionException;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import org.junit.Assert;
import org.junit.Test;

public class TextContainerTest {
    private GenericContent fmt = new GenericContent();

    @Test
    public void testDefaultConstructor() {
        TextContainer tc = new TextContainer();
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertEquals("", tc.getCodedText());
        Assert.assertEquals("0", tc.getSegments().get((int)0).id);
    }

    @Test
    public void testStringConstructor() {
        TextContainer tc = new TextContainer("");
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertEquals("", tc.getCodedText());
        Assert.assertEquals("0", tc.getSegments().get((int)0).id);
        tc = new TextContainer("text");
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertEquals("text", tc.getCodedText());
        Assert.assertEquals("0", tc.getSegments().get((int)0).id);
    }

    @Test
    public void testTextFragmentConstructor() {
        TextFragment tf = new TextFragment("abc");
        TextContainer tc = new TextContainer(tf);
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertEquals("abc", tc.getCodedText());
        Assert.assertEquals("0", tc.getSegments().get((int)0).id);
        Assert.assertSame(tf, tc.getSegments().getFirstContent());
    }

    @Test
    public void testTextSegmentConstructor() {
        Segment seg = new Segment("qwerty", new TextFragment("xyz"));
        TextContainer tc = new TextContainer(seg);
        ISegments segments = tc.getSegments();
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertEquals("xyz", tc.getFirstContent().toText());
        Assert.assertEquals("qwerty", segments.get((int)0).id);
        Assert.assertSame(seg.text, segments.getFirstContent());
    }

    @Test
    public void testTextSegmentWithNullsConstructor() {
        Segment seg = new Segment(null, null);
        seg.text = null;
        TextContainer tc = new TextContainer(seg);
        ISegments segments = tc.getSegments();
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertEquals("", tc.getFirstContent().toText());
        Assert.assertEquals("0", segments.get((int)0).id);
        Assert.assertSame(seg.text, segments.getFirstContent());
    }

    @Test
    public void testSegmentsWithCodePlusOneChar() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "BR", "<br/>");
        tf.append(".");
        TextContainer tc = new TextContainer(tf);
        ISegments segments = tc.getSegments();
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("<br/>.", segments.get(0).toString());
    }

    @Test
    public void testCounts() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("i1", new TextFragment("Hello")));
        tc.append(new TextPart(" the "));
        tc.append(new Segment("i2", new TextFragment("World")));
        Assert.assertEquals(3L, tc.count());
        Assert.assertEquals(2L, tc.getSegments().count());
    }

    @Test
    public void testSegmentsWithJustCode() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "BR", "<br/>");
        TextContainer tc = new TextContainer(tf);
        ISegments segments = tc.getSegments();
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("<br/>", segments.get(0).toString());
    }

    @Test
    public void testTextPartIterator() {
        TextContainer tc = this.createMultiSegmentContent();
        int i = -1;
        for (TextPart part : tc) {
            switch (++i) {
                case 0: {
                    Assert.assertEquals("text1", part.text.toText());
                    Assert.assertTrue(part.isSegment());
                    break;
                }
                case 1: {
                    Assert.assertEquals(" ", part.text.toText());
                    Assert.assertFalse(part.isSegment());
                    break;
                }
                case 2: {
                    Assert.assertEquals("text2", part.text.toText());
                    Assert.assertTrue(part.isSegment());
                }
            }
        }
    }

    @Test
    public void testSegmentIterator() {
        TextContainer tc = new TextContainer("[s1]");
        for (Segment seg : tc.getSegments()) {
            Assert.assertEquals("[s1]", seg.text.toText());
        }
        ISegments segments = tc.getSegments();
        segments.append(new TextFragment("[s2]"));
        segments.append(new TextFragment("[s3]"));
        segments.append(new TextFragment("[s4]"));
        StringBuilder tmp = new StringBuilder();
        for (Segment seg : tc.getSegments()) {
            tmp.append(seg.text.toText());
        }
        Assert.assertEquals("[s1][s2][s3][s4]", tmp.toString());
    }

    @Test
    public void testSegmentsWithTwoCodes() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "BR1", "<br1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "BR2", "<br2/>");
        TextContainer tc = new TextContainer(tf);
        ISegments segments = tc.getSegments();
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("<br1/><br2/>", segments.get(0).toString());
    }

    @Test
    public void testHasBeenSegmented() {
        TextContainer tc = new TextContainer("seg1");
        ISegments segments = tc.getSegments();
        Assert.assertFalse(tc.hasBeenSegmented());
        segments.append(new Segment("1", new TextFragment("seg2")));
        Assert.assertTrue(tc.hasBeenSegmented());
        segments.joinAll();
        Assert.assertFalse(tc.hasBeenSegmented());
        segments.append(new TextFragment("seg3"));
        Assert.assertTrue(tc.hasBeenSegmented());
    }

    @Test
    public void testSegmentsWithOneChar() {
        TextContainer tc = new TextContainer(new TextFragment("z"));
        ISegments segments = tc.getSegments();
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("z", segments.get(0).toString());
    }

    @Test
    public void testSegmentsEmpty() {
        TextContainer tc = new TextContainer();
        ISegments segments = tc.getSegments();
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("0", segments.get((int)0).id);
    }

    @Test
    public void testCloneDeepCopy() {
        TextContainer tc = new TextContainer("text");
        Property p1 = new Property("name", "value", true);
        tc.setProperty(p1);
        AltTranslationsAnnotation ann1 = new AltTranslationsAnnotation();
        ann1.add(LocaleId.ENGLISH, LocaleId.FRENCH, null, new TextFragment("src"), new TextFragment("trg"), MatchType.EXACT, 99, "origin");
        tc.setAnnotation(ann1);
        TextContainer tc2 = tc.clone();
        Assert.assertEquals(tc.getFirstContent().toText(), tc2.getFirstContent().toText());
        Assert.assertNotSame(tc.getFirstContent(), tc2.getFirstContent());
        Assert.assertEquals("name property", p1.getValue(), tc2.getProperty("name").getValue());
        Assert.assertNotSame("properties should not be the same reference due to clone", p1, tc2.getProperty("name"));
        AltTranslationsAnnotation ann2 = tc2.getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertNotNull(ann2);
        Assert.assertEquals(99L, ann2.getFirst().getCombinedScore());
        Assert.assertEquals("origin", ann2.getLast().getOrigin());
    }

    @Test
    public void testIsEmpty() {
        TextContainer tc = new TextContainer();
        Assert.assertTrue(tc.isEmpty());
        tc.getLastContent().append('z');
        Assert.assertFalse(tc.isEmpty());
        tc.setContent(new TextFragment());
        Assert.assertTrue(tc.isEmpty());
        tc.setContent(new TextFragment("text"));
        Assert.assertFalse(tc.isEmpty());
    }

    @Test
    public void testGetFirstSegmentContent() {
        TextContainer tc = new TextContainer("text");
        Assert.assertEquals("text", tc.getSegments().getFirstContent().toText());
    }

    @Test
    public void testCloningDistinction() {
        TextContainer tc = new TextContainer("text");
        TextContainer tc2 = tc.clone();
        Assert.assertNotSame(tc, tc2);
        Assert.assertNotSame(tc.getSegments().getFirstContent(), tc2.getSegments().getFirstContent());
        Assert.assertEquals(tc.toString(), tc2.toString());
    }

    @Test
    public void testHasTextWithText() {
        TextContainer tc = new TextContainer("text");
        Assert.assertTrue(tc.hasText(true, false));
        Assert.assertTrue(tc.hasText(true, true));
        Assert.assertFalse(tc.hasText(false, true));
        Assert.assertFalse(tc.hasText(false, false));
    }

    @Test
    public void testHasTextNoText() {
        TextContainer tc = new TextContainer("");
        Assert.assertFalse(tc.hasText(true, false));
        Assert.assertFalse(tc.hasText(true, true));
        Assert.assertFalse(tc.hasText(false, true));
        Assert.assertFalse(tc.hasText(false, false));
    }

    @Test
    public void testHasTextSpaces() {
        TextContainer tc = new TextContainer("  \t");
        Assert.assertFalse(tc.hasText(false, false));
        Assert.assertFalse(tc.hasText(true, false));
        Assert.assertTrue(tc.hasText(true, true));
        Assert.assertFalse(tc.hasText(false, true));
    }

    @Test
    public void testHasTextCodeOnly() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        TextContainer tc = new TextContainer(tf);
        Assert.assertFalse(tc.hasText(false, false));
        Assert.assertFalse(tc.hasText(true, false));
        Assert.assertFalse(tc.hasText(true, true));
        Assert.assertFalse(tc.hasText(false, true));
    }

    @Test
    public void testHasTextSpacesAndCode() {
        TextFragment tf = new TextFragment("  \t");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        TextContainer tc = new TextContainer(tf);
        Assert.assertFalse(tc.hasText(false, false));
        Assert.assertFalse(tc.hasText(true, false));
        Assert.assertTrue(tc.hasText(true, true));
        Assert.assertFalse(tc.hasText(false, true));
    }

    @Test(expected=InvalidPositionException.class)
    public void testCreateSegmentNegativeSpan() {
        TextContainer tc = new TextContainer("text");
        tc.getSegments().create(3, 1);
    }

    @Test(expected=InvalidPositionException.class)
    public void testCreateSegmentBadRangeOrder() {
        TextContainer tc = new TextContainer("text");
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(2, 4));
        ranges.add(new Range(0, 2));
        tc.getSegments().create(ranges);
    }

    @Test
    public void testCreateSegmentEmptySpan() {
        TextContainer tc = new TextContainer("text");
        ISegments segments = tc.getSegments();
        Assert.assertEquals(1L, segments.count());
        segments.create(1, 1);
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("[text]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.hasBeenSegmented());
    }

    @Test
    public void testCreateSegmentOneCharSpan() {
        TextContainer tc = new TextContainer("text");
        tc.getSegments().create(1, 2);
        Assert.assertEquals("t[e]xt", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasBeenSegmented());
    }

    @Test
    public void testCreateSegmentAllContent() {
        TextContainer tc = new TextContainer("text");
        Assert.assertFalse(tc.hasBeenSegmented());
        tc.getSegments().create(0, -1);
        Assert.assertEquals("[text]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasBeenSegmented());
    }

    @Test(expected=InvalidPositionException.class)
    public void testCreateSegmentWithPHCodesStartInMarker() {
        TextFragment tf = new TextFragment("t1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "BR1", "<br1/>");
        tf.append("t2");
        tf.append(TextFragment.TagType.PLACEHOLDER, "BR2", "<br2/>");
        TextContainer tc = new TextContainer(tf);
        Assert.assertEquals("t1<br1/>t2<br2/>", tc.toString());
        tc.getSegments().create(3, -1);
    }

    @Test
    public void testCreateSegmentOnExistingSegment() {
        TextContainer tc = new TextContainer("seg1 seg2");
        Assert.assertFalse(tc.hasBeenSegmented());
        tc.getSegments().create(0, 4);
        Assert.assertEquals("[seg1] seg2", this.fmt.printSegmentedContent(tc, true));
        tc.getSegments().create(0, 9);
        Assert.assertEquals("[seg1 seg2]", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testCreateSegmentWithPHCodes() {
        TextFragment tf = new TextFragment("t1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "BR1", "<br1/>");
        tf.append("t2");
        tf.append(TextFragment.TagType.PLACEHOLDER, "BR2", "<br2/>");
        TextContainer tc = new TextContainer(tf);
        ISegments segments = tc.getSegments();
        Assert.assertEquals("t1<br1/>t2<br2/>", tc.toString());
        segments.create(4, 8);
        Assert.assertEquals("t1<1/>[t2<2/>]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("t2<2/>", this.fmt.setContent(segments.get((int)0).text).toString());
    }

    @Test
    public void testCreateSegmentWithPairedCodes() {
        TextFragment tf = new TextFragment("t1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("t2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        TextContainer tc = new TextContainer(tf);
        ISegments segments = tc.getSegments();
        Assert.assertEquals("t1<b>t2</b>", tc.toString());
        segments.create(2, 8);
        Assert.assertEquals("t1[<b>t2</b>]", this.fmt.printSegmentedContent(tc, true, true));
        Assert.assertEquals("<1>t2</1>", this.fmt.setContent(segments.get((int)0).text).toString());
    }

    @Test
    public void testCreateSegmentWithSplitCodes() {
        TextFragment tf = new TextFragment("t1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("t2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        TextContainer tc = new TextContainer(tf);
        ISegments segments = tc.getSegments();
        Assert.assertEquals("t1<b>t2</b>", tc.toString());
        segments.create(4, -1);
        Assert.assertEquals("t1<b>[t2</b>]", this.fmt.printSegmentedContent(tc, true, true));
        Assert.assertEquals("t2<e1/>", this.fmt.setContent(segments.get((int)0).text).toString());
    }

    @Test
    public void testCreateMultiSegmentsWithSplitCodes() {
        TextFragment tf = new TextFragment("t1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("t2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("t3");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        TextContainer tc = new TextContainer(tf);
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[t1<1>t2</1>t3<2/>]", this.fmt.printSegmentedContent(tc, true));
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(0, 4));
        ranges.add(new Range(4, -1));
        segments.create(ranges);
        Assert.assertEquals("[t1<b1/>][t2<e1/>t3<2/>]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("t1<b1/>", this.fmt.setContent(segments.get((int)0).text).toString());
        Assert.assertEquals("t2<e1/>t3<2/>", this.fmt.setContent(segments.get((int)1).text).toString());
    }

    @Test
    public void testSameFirstAndLastSegments() {
        TextContainer tc = new TextContainer("text");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("text", segments.getFirstContent().toText());
        Assert.assertSame(segments.getFirstContent(), segments.getLastContent());
        Assert.assertFalse(tc.hasBeenSegmented());
    }

    @Test
    public void testGetSameSegment() {
        TextContainer tc = this.createMultiSegmentContent();
        ISegments segments = tc.getSegments();
        Assert.assertEquals("text1", segments.getFirstContent().toText());
        Assert.assertSame(segments.getFirstContent(), segments.get((int)0).text);
    }

    @Test
    public void testGetLastSegment() {
        TextContainer tc = this.createMultiSegmentContent();
        ISegments segments = tc.getSegments();
        Assert.assertEquals("text2", segments.getLastContent().toText());
        Assert.assertSame(segments.getLastContent(), segments.get((int)1).text);
    }

    @Test
    public void testRemovePart() {
        TextContainer tc = this.createMultiSegmentContent();
        Assert.assertEquals("[text1] [text2]", this.fmt.printSegmentedContent(tc, true));
        tc.remove(2);
        Assert.assertEquals("[text1] ", this.fmt.printSegmentedContent(tc, true));
        tc.remove(0);
        Assert.assertEquals("[] ", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testHasTextHolderIsSpacesSegmentIsText() {
        TextContainer tc = new TextContainer(" text ");
        tc.getSegments().create(1, 5);
        Assert.assertEquals(" [text] ", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.hasText(false, false));
        Assert.assertTrue(tc.hasText(true, false));
        Assert.assertTrue(tc.hasText(true, true));
        Assert.assertTrue(tc.hasText(false, true));
    }

    @Test
    public void testHasTextHolderIsTextSegmentIsSpaces() {
        TextContainer tc = new TextContainer("T    T");
        tc.getSegments().create(1, 5);
        Assert.assertEquals("T[    ]T", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasText(false, false));
        Assert.assertTrue(tc.hasText(true, false));
        Assert.assertTrue(tc.hasText(true, true));
        Assert.assertTrue(tc.hasText(false, true));
    }

    @Test
    public void testHasTextHolderIsSpacesSegmentIsSpaces() {
        TextContainer tc = new TextContainer("      ");
        tc.getSegments().create(1, 5);
        Assert.assertEquals(" [    ] ", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.hasText(false, false));
        Assert.assertFalse(tc.hasText(true, false));
        Assert.assertTrue(tc.hasText(true, true));
        Assert.assertTrue(tc.hasText(false, true));
    }

    @Test
    public void testHasTextOnlySegmentsWithSpaces() {
        TextContainer tc = new TextContainer("        ");
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(0, 4));
        ranges.add(new Range(4, 8));
        tc.getSegments().create(ranges);
        Assert.assertEquals("[    ][    ]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.hasText(false, false));
        Assert.assertFalse(tc.hasText(true, false));
        Assert.assertTrue(tc.hasText(true, true));
        Assert.assertFalse(tc.hasText(false, true));
    }

    @Test
    public void testHasTextWithContentIsSegmentWithText() {
        TextContainer tc = new TextContainer("text");
        tc.getSegments().create(0, 4);
        Assert.assertEquals("[text]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.hasText(false, false));
        Assert.assertTrue(tc.hasText(true, false));
        Assert.assertTrue(tc.hasText(true, true));
        Assert.assertFalse(tc.hasText(false, true));
    }

    @Test
    public void testHasTextWithContentIsSegmentWithSpaces() {
        TextContainer tc = new TextContainer("    ");
        tc.getSegments().create(0, 4);
        Assert.assertEquals("[    ]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.hasText(false, false));
        Assert.assertFalse(tc.hasText(true, false));
        Assert.assertTrue(tc.hasText(true, true));
        Assert.assertFalse(tc.hasText(false, true));
    }

    @Test
    public void testSetContent() {
        TextContainer tc = this.createMultiSegmentContent();
        Assert.assertEquals("[text1] [text2]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.contentIsOneSegment());
        tc.setContent(new TextFragment("new text"));
        Assert.assertEquals("[new text]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.contentIsOneSegment());
    }

    @Test
    public void testGetSetProperties() {
        TextContainer tc = new TextContainer();
        Set<String> list = tc.getPropertyNames();
        Assert.assertNotNull(list);
        Assert.assertTrue(list.size() == 0);
        Property p1 = new Property("name", "value", false);
        tc.setProperty(p1);
        Assert.assertTrue(tc.hasProperty("name"));
        Property p2 = tc.getProperty("name");
        Assert.assertSame(p1, p2);
        Assert.assertEquals(p2.getValue(), "value");
        Assert.assertFalse(p2.isReadOnly());
        list = tc.getPropertyNames();
        Assert.assertEquals(list.size(), 1L);
        for (String name : list) {
            p1 = tc.getProperty(name);
            Assert.assertEquals(p1.toString(), "value");
            Assert.assertSame(p1, p2);
        }
    }

    @Test
    public void testAppendSimpleSegmentToEmpty() {
        TextContainer tc = new TextContainer();
        ISegments segments = tc.getSegments();
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertEquals(1L, segments.count());
        segments.append(new TextFragment("seg"));
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("seg", segments.get(0).toString());
    }

    @Test
    public void testAppendSimpleSegmentToEmptyWithOption() {
        TextContainer tc = new TextContainer();
        ISegments segments = tc.getSegments();
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertEquals(1L, segments.count());
        segments.append(new TextFragment("seg"), false);
        Assert.assertEquals(2L, segments.count());
        Assert.assertEquals("", segments.get(0).toString());
        Assert.assertEquals("seg", segments.get(1).toString());
    }

    @Test
    public void testAppendSimpleSegmentToInitialEmpty() {
        TextContainer tc = new TextContainer();
        ISegments segments = tc.getSegments();
        Assert.assertFalse(tc.hasBeenSegmented());
        segments.append(new TextFragment(), !tc.hasBeenSegmented());
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("", segments.get(0).toString());
        segments.append(new TextFragment(), !tc.hasBeenSegmented());
        Assert.assertEquals("", segments.get(0).toString());
        Assert.assertEquals("", segments.get(1).toString());
    }

    @Test
    public void testAppendSimpleSegmentToNonEmpty() {
        TextContainer tc = new TextContainer("seg1");
        ISegments segments = tc.getSegments();
        Assert.assertEquals(1L, segments.count());
        segments.append(new TextFragment("seg2"));
        Assert.assertEquals(2L, segments.count());
        Assert.assertEquals("seg1", segments.get(0).toString());
        Assert.assertEquals("seg2", segments.get(1).toString());
    }

    @Test
    public void testAutoID() {
        TextContainer tc = new TextContainer("seg1");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("0", segments.get((int)0).id);
        segments.append(new Segment("0", new TextFragment("seg2")));
        Assert.assertEquals("1", segments.get((int)1).id);
        segments.append(new Segment("id1", new TextFragment("seg3")));
        Assert.assertEquals("id1", segments.get((int)2).id);
        segments.append(new Segment("1", new TextFragment("seg4")));
        Assert.assertEquals("2", segments.get((int)3).id);
        segments.append(new Segment("10", new TextFragment("seg5")));
        Assert.assertEquals("10", segments.get((int)4).id);
        segments.append(new Segment("id1", new TextFragment("seg6")));
        Assert.assertEquals("11", segments.get((int)5).id);
    }

    @Test
    public void testAppendSeveralSegments() {
        TextContainer tc = this.createMultiSegmentContent();
        ISegments segments = tc.getSegments();
        Assert.assertEquals(2L, segments.count());
        Assert.assertEquals("text1", segments.get(0).toString());
        Assert.assertEquals("text2", segments.get(1).toString());
        Assert.assertEquals("[text1] [text2]", this.fmt.printSegmentedContent(tc, true));
        segments.append(new TextFragment("add1"));
        segments.append(new Segment("segid", new TextFragment("add2")));
        Assert.assertEquals("[text1] [text2][add1][add2]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("0", segments.get((int)2).id);
        Assert.assertEquals("segid", segments.get((int)3).id);
    }

    @Test
    public void testContentIsOneSegmentDefault() {
        TextContainer tc = new TextContainer();
        Assert.assertEquals("[]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.contentIsOneSegment());
    }

    @Test
    public void ContentIsOneSegment1Segment() {
        TextContainer tc = new TextContainer("text");
        Assert.assertEquals("[text]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.contentIsOneSegment());
    }

    @Test
    public void ContentIsOneSegmentSpaceInHolder() {
        TextContainer tc = new TextContainer("text ");
        tc.getSegments().create(0, 4);
        Assert.assertEquals("[text] ", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.contentIsOneSegment());
    }

    @Test
    public void ContentIsOneSegment2Segments() {
        TextContainer tc = new TextContainer("seg1");
        ISegments segments = tc.getSegments();
        segments.append(new Segment("s2", new TextFragment("seg2")));
        Assert.assertEquals("[seg1][seg2]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.contentIsOneSegment());
    }

    @Test
    public void testMergingSegments() {
        TextContainer tc = this.createMultiSegmentContent();
        tc.getSegments().joinAll();
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertEquals("[text1 text2]", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testJoinAllAndGetRanges() {
        TextContainer tc = this.createMultiSegmentContent();
        Assert.assertEquals("[text1] [text2]", this.fmt.printSegmentedContent(tc, true));
        ArrayList<Range> ranges = new ArrayList<Range>();
        tc.getSegments().joinAll(ranges);
        Assert.assertNotNull(ranges);
        Assert.assertEquals(2L, ranges.size());
        Assert.assertEquals(0L, ranges.get((int)0).start);
        Assert.assertEquals(5L, ranges.get((int)0).end);
        Assert.assertEquals(6L, ranges.get((int)1).start);
        Assert.assertEquals(11L, ranges.get((int)1).end);
    }

    @Test
    public void testMergingAndResplitting() {
        TextContainer tc = this.createMultiSegmentContent();
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[text1] [text2]", this.fmt.printSegmentedContent(tc, true));
        ArrayList<Range> ranges = new ArrayList<Range>();
        tc.getSegments().joinAll(ranges);
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("[text1 text2]", this.fmt.printSegmentedContent(tc, true));
        segments.create(ranges);
        Assert.assertEquals(2L, segments.count());
        Assert.assertEquals("[text1] [text2]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("text1", segments.get(0).toString());
        Assert.assertEquals("text2", segments.get(1).toString());
    }

    @Test
    public void testGetSegmentFromId() {
        TextContainer tc = this.createMultiSegmentContent();
        ISegments segments = tc.getSegments();
        Assert.assertSame(segments.get(0), segments.get("s1"));
        Assert.assertSame(segments.get(1), segments.get("s2"));
        segments.get((int)1).id = "newId";
        Assert.assertSame(segments.get(1), segments.get("newId"));
    }

    @Test
    public void testGetSegmentFromIdAfterReindex() {
        TextContainer tc = this.createMultiSegmentContent();
        ISegments segments = tc.getSegments();
        Assert.assertSame(segments.get(0), segments.get("s1"));
        Assert.assertSame(segments.get(1), segments.get("s2"));
        tc.changePart(1);
        Assert.assertSame(segments.get(0), segments.get("s1"));
        Assert.assertSame(segments.get(1), segments.get("0"));
        Assert.assertSame(segments.get(2), segments.get("s2"));
        Assert.assertEquals("text2", segments.get((String)"s2").text.toText());
        Assert.assertEquals(" ", segments.get((String)"0").text.toText());
    }

    @Test
    public void testJoinSegmentWithNextOnUnsegmented() {
        TextContainer tc = new TextContainer("text");
        ISegments segments = tc.getSegments();
        segments.get((int)0).id = "id1";
        segments.joinWithNext(0);
        Assert.assertEquals("id1", segments.get((int)0).id);
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertTrue(tc.contentIsOneSegment());
    }

    @Test
    public void testJoinSegmentWithNext() {
        TextContainer tc = this.createMultiSegmentContent();
        ISegments segments = tc.getSegments();
        segments.append(new TextFragment("seg3"));
        segments.get((int)1).id = "id2";
        Assert.assertEquals(3L, segments.count());
        Assert.assertEquals("[text1] [text2][seg3]", this.fmt.printSegmentedContent(tc, true));
        segments.joinWithNext(1);
        Assert.assertEquals("[text1] [text2seg3]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("id2", segments.get((int)1).id);
        Assert.assertFalse(tc.contentIsOneSegment());
        Assert.assertTrue(tc.hasBeenSegmented());
        segments.joinWithNext(0);
        Assert.assertEquals("[text1 text2seg3]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("s1", segments.get((int)0).id);
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertTrue(tc.hasBeenSegmented());
    }

    @Test
    public void testJoinPartWithNextPartsSimple() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.joinWithNext(1, 1);
        Assert.assertEquals("[text1<1/>] text2<2/>", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testJoinPartWithNextPartsTwoParts() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.joinWithNext(0, 2);
        Assert.assertEquals("[text1<1/> text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc = this.createMultiSegmentContentWithCodes();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.joinWithNext(0, -1);
        Assert.assertEquals("[text1<1/> text2<2/>]", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testJoinPartWithNextPartsEnsureSegment() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.changePart(0);
        Assert.assertEquals("text1<1/> [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.joinWithNext(0, 2);
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertEquals("[text1<1/> text2<2/>]", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testChangePartSegmentToNonSegment() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.changePart(0);
        Assert.assertEquals("text1<1/> [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testChangePartNonSegmentToSegment() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.changePart(1);
        Assert.assertEquals("[text1<1/>][ ][text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("2", segments.get((int)1).id);
    }

    @Test
    public void testChangePartOnlySegmentToNonSegment() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.changePart(0);
        Assert.assertEquals("text1<1/> [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.changePart(2);
        Assert.assertEquals("text1<1/> [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testMergingSegmentsWithCodes() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        ISegments segments = tc.getSegments();
        segments.joinAll();
        Assert.assertEquals(1L, segments.count());
        TextFragment tf = segments.getFirstContent();
        Assert.assertEquals("text1<br/> text2<br/>", tc.toString());
        Assert.assertEquals("text1<br/> text2<br/>", tf.toText());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals(2L, codes.size());
        Assert.assertEquals(1L, codes.get((int)0).id);
        Assert.assertEquals(2L, codes.get((int)1).id);
    }

    @Test
    public void testMergingAndResplittingWithCodes() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        ArrayList<Range> ranges = new ArrayList<Range>();
        segments.joinAll(ranges);
        Assert.assertEquals(1L, segments.count());
        Assert.assertEquals("[text1<1/> text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        List<Code> codes = segments.getFirstContent().getCodes();
        Assert.assertEquals(2L, codes.size());
        Assert.assertEquals(1L, codes.get((int)0).id);
        Assert.assertEquals(2L, codes.get((int)1).id);
        segments.create(ranges);
        Assert.assertEquals(2L, segments.count());
        Assert.assertEquals("text1<br/>", segments.get(0).toString());
        Assert.assertEquals("text2<br/>", segments.get(1).toString());
    }

    @Test
    public void testSplitPartNewSegmentOnLeft() {
        TextContainer tc = new TextContainer("part1part2");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[part1part2]", this.fmt.printSegmentedContent(tc, true));
        tc.split(0, 0, 5, true);
        Assert.assertEquals("[part1][part2]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertFalse(tc.contentIsOneSegment());
        Assert.assertEquals("0", segments.get((int)1).id);
        Assert.assertEquals("1", segments.get((int)0).id);
    }

    @Test
    public void testSplitPartNewNonSegmentOnLeft() {
        TextContainer tc = new TextContainer("part1part2");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[part1part2]", this.fmt.printSegmentedContent(tc, true));
        tc.split(0, 0, 5, false);
        Assert.assertEquals("part1[part2]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertFalse(tc.contentIsOneSegment());
        Assert.assertEquals("0", segments.get((int)0).id);
    }

    @Test
    public void testSplitPartNewSegmentOnRight() {
        TextContainer tc = new TextContainer("part1part2");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[part1part2]", this.fmt.printSegmentedContent(tc, true));
        tc.split(0, 5, -1, true);
        Assert.assertEquals("[part1][part2]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertFalse(tc.contentIsOneSegment());
        Assert.assertEquals("0", segments.get((int)0).id);
        Assert.assertEquals("1", segments.get((int)1).id);
    }

    @Test
    public void testSplitPartNonSegmentOnRight() {
        TextContainer tc = new TextContainer("part1part2");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[part1part2]", this.fmt.printSegmentedContent(tc, true));
        tc.split(0, 5, -1, false);
        Assert.assertEquals("[part1]part2", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertFalse(tc.contentIsOneSegment());
        Assert.assertEquals("0", segments.get((int)0).id);
    }

    @Test
    public void testSplitPartWithoutSpan() {
        TextContainer tc = new TextContainer("part1part2");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[part1part2]", this.fmt.printSegmentedContent(tc, true));
        tc.split(0, 5, 5, false);
        Assert.assertEquals("[part1][part2]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertFalse(tc.contentIsOneSegment());
        Assert.assertEquals("0", segments.get((int)0).id);
        Assert.assertEquals("1", segments.get((int)1).id);
    }

    @Test
    public void testSplitNewSegmentAtMiddle() {
        TextContainer tc = new TextContainer("part1part2part3");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[part1part2part3]", this.fmt.printSegmentedContent(tc, true));
        tc.split(0, 5, 10, true);
        Assert.assertEquals("[part1][part2][part3]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertFalse(tc.contentIsOneSegment());
        Assert.assertEquals("0", segments.get((int)0).id);
        Assert.assertEquals("1", segments.get((int)1).id);
        Assert.assertEquals("2", segments.get((int)2).id);
    }

    @Test
    public void testSplitNewNonSegmentAtMiddle() {
        TextContainer tc = new TextContainer("part1part2part3");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[part1part2part3]", this.fmt.printSegmentedContent(tc, true));
        tc.split(0, 5, 10, false);
        Assert.assertEquals("[part1]part2[part3]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertFalse(tc.contentIsOneSegment());
        Assert.assertEquals("0", segments.get((int)0).id);
        Assert.assertFalse(tc.get(1).isSegment());
        Assert.assertEquals("1", segments.get((int)1).id);
    }

    @Test
    public void testVariousSplitsAndJoins() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        tc.split(2, 0, 2, false);
        Assert.assertEquals("[text1<1/>] te[xt2<2/>]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("te", tc.get(2).toString());
        tc.split(0, 5, -1, true);
        Assert.assertEquals("[text1][<1/>] te[xt2<2/>]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("2", segments.get((int)1).id);
        segments.joinWithNext(1);
        Assert.assertEquals("[text1][<1/> text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("0", segments.get((int)0).id);
        Assert.assertEquals("2", segments.get((int)1).id);
    }

    @Test
    public void testSplitResultingInNoChanges() {
        TextContainer tc = new TextContainer("text");
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[text]", this.fmt.printSegmentedContent(tc, true));
        tc.split(0, 0, 0, true);
        tc.split(0, 4, 4, true);
        tc.split(0, 4, -1, true);
        tc.split(0, 0, -1, true);
        tc.split(0, 0, 4, true);
        Assert.assertEquals("[text]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertEquals("0", segments.get((int)0).id);
    }

    @Test
    public void testCompareTo_OneAndOneSame() {
        TextContainer tc1 = new TextContainer("text");
        TextContainer tc2 = new TextContainer("text");
        Assert.assertEquals(0L, tc1.compareTo(tc2, true));
        Assert.assertEquals(0L, tc1.compareTo(tc2, false));
    }

    @Test
    public void testCompareTo_OneAndOneDifferentInText() {
        TextContainer tc1 = new TextContainer("text1");
        TextContainer tc2 = new TextContainer("text2");
        Assert.assertEquals(-1L, tc1.compareTo(tc2, true));
        Assert.assertEquals(-1L, tc1.compareTo(tc2, false));
        tc1 = new TextContainer("text2");
        tc2 = new TextContainer("text1");
        Assert.assertEquals(1L, tc1.compareTo(tc2, true));
        Assert.assertEquals(1L, tc1.compareTo(tc2, false));
    }

    @Test
    public void testCompareTo_TwoOnTwoSame() {
        TextContainer tc1 = this.createMultiSegmentContent();
        TextContainer tc2 = this.createMultiSegmentContent();
        Assert.assertEquals(0L, tc1.compareTo(tc2, true));
        Assert.assertEquals(0L, tc1.compareTo(tc2, false));
    }

    @Test
    public void testCompareTo_OneOnTwoSameText() {
        TextContainer tc1 = new TextContainer("text1 text2");
        TextContainer tc2 = this.createMultiSegmentContent();
        Assert.assertFalse(0 == tc1.compareTo(tc2, true));
        Assert.assertFalse(0 == tc1.compareTo(tc2, false));
    }

    @Test
    public void testCompareTo_TwoOnTwoDifferenceInCodes() {
        TextContainer tc1 = this.createMultiSegmentContentWithCodes();
        TextContainer tc2 = this.createMultiSegmentContentWithCodes();
        tc2.get((int)0).getContent().getCode((int)0).data = new StringBuilder("<XYZ/>");
        Assert.assertFalse(0 == tc1.compareTo(tc2, true));
        Assert.assertTrue(0 == tc1.compareTo(tc2, false));
    }

    @Test
    public void testCompareTo_TwoOnTwoNoDifferenceInCodes() {
        TextContainer tc2;
        TextContainer tc1 = this.createMultiSegmentContentWithCodes();
        Assert.assertTrue(0 == tc1.compareTo(tc2 = this.createMultiSegmentContentWithCodes(), true));
        Assert.assertTrue(0 == tc1.compareTo(tc2, false));
    }

    @Test
    public void testUnwrap_All() {
        TextContainer tc1 = new TextContainer(" \t \n");
        TextContainer tc2 = tc1.clone();
        TextContainer tc3 = tc1.clone();
        TextContainer tc4 = tc1.clone();
        tc1.unwrap(true, true);
        Assert.assertEquals("[]", this.fmt.printSegmentedContent(tc1, true));
        tc2.unwrap(false, true);
        Assert.assertEquals("[ ]", this.fmt.printSegmentedContent(tc2, true));
        tc3.unwrap(true, false);
        Assert.assertEquals("[]", this.fmt.printSegmentedContent(tc3, true));
        tc4.unwrap(false, false);
        Assert.assertEquals("[ ]", this.fmt.printSegmentedContent(tc4, true));
    }

    @Test
    public void testUnwrap_Simple() {
        TextContainer tc1 = new TextContainer(" a b\tc \n\t");
        TextContainer tc2 = tc1.clone();
        TextContainer tc3 = tc1.clone();
        TextContainer tc4 = tc1.clone();
        tc1.unwrap(true, true);
        Assert.assertEquals("[a b c]", this.fmt.printSegmentedContent(tc1, true));
        tc2.unwrap(false, true);
        Assert.assertEquals("[ a b c ]", this.fmt.printSegmentedContent(tc2, true));
        tc3.unwrap(true, false);
        Assert.assertEquals("[a b c]", this.fmt.printSegmentedContent(tc3, true));
        tc4.unwrap(false, false);
        Assert.assertEquals("[ a b c ]", this.fmt.printSegmentedContent(tc4, true));
    }

    @Test
    public void testUnwrap_Parts1SegNoText() {
        TextContainer tc1 = new TextContainer();
        tc1.append(new TextFragment(" \t "));
        tc1.append(new TextFragment(" "));
        tc1.append(new TextFragment("  "));
        tc1.append(new TextFragment(" \n"));
        TextContainer tc2 = tc1.clone();
        TextContainer tc3 = tc1.clone();
        TextContainer tc4 = tc1.clone();
        Assert.assertEquals("[ \t ]    \n", this.fmt.printSegmentedContent(tc1, true));
        tc1.unwrap(true, true);
        Assert.assertEquals("[]", this.fmt.printSegmentedContent(tc1, true));
        tc2.unwrap(false, true);
        Assert.assertEquals("[ ]", this.fmt.printSegmentedContent(tc2, true));
        tc3.unwrap(true, false);
        Assert.assertEquals("[]", this.fmt.printSegmentedContent(tc3, true));
        tc4.unwrap(false, false);
        Assert.assertEquals("[ ] ", this.fmt.printSegmentedContent(tc4, true));
    }

    @Test
    public void testUnwrap_MixedPartsWithText() {
        TextContainer tc1 = new TextContainer();
        ISegments segments = tc1.getSegments();
        tc1.append(new TextFragment(" \tt1 "));
        tc1.append(new TextFragment("   "));
        segments.append(new TextFragment("t2"));
        tc1.append(new TextFragment("  "));
        segments.append(new TextFragment(" t3\n\n"));
        tc1.append(new TextFragment("  "));
        TextContainer tc2 = tc1.clone();
        TextContainer tc3 = tc1.clone();
        TextContainer tc4 = tc1.clone();
        Assert.assertEquals("[ \tt1 ]   [t2]  [ t3\n\n]  ", this.fmt.printSegmentedContent(tc1, true));
        tc1.unwrap(true, true);
        Assert.assertEquals("[t1 ][t2] [t3]", this.fmt.printSegmentedContent(tc1, true));
        tc2.unwrap(false, true);
        Assert.assertEquals("[ t1 ][t2] [t3 ]", this.fmt.printSegmentedContent(tc2, true));
        tc3.unwrap(true, false);
        Assert.assertEquals("[t1 ][t2] [t3]", this.fmt.printSegmentedContent(tc3, true));
        tc4.unwrap(false, false);
        Assert.assertEquals("[ t1 ][t2] [t3 ]", this.fmt.printSegmentedContent(tc4, true));
    }

    @Test
    public void testUnwrap_MixedPartsWithText2() {
        TextContainer tc1 = new TextContainer();
        ISegments segments = tc1.getSegments();
        segments.append(new TextFragment("t1"));
        tc1.append(new TextFragment(" "));
        TextContainer tc2 = tc1.clone();
        TextContainer tc3 = tc1.clone();
        TextContainer tc4 = tc1.clone();
        Assert.assertEquals(2L, tc1.count());
        Assert.assertEquals("[t1] ", this.fmt.printSegmentedContent(tc1, true));
        tc1.unwrap(true, true);
        Assert.assertEquals("[t1]", this.fmt.printSegmentedContent(tc1, true));
        tc2.unwrap(false, true);
        Assert.assertEquals("[t1] ", this.fmt.printSegmentedContent(tc2, true));
        tc3.unwrap(true, false);
        Assert.assertEquals("[t1]", this.fmt.printSegmentedContent(tc3, true));
        tc4.unwrap(false, false);
        Assert.assertEquals("[t1] ", this.fmt.printSegmentedContent(tc4, true));
    }

    @Test
    public void testUnwrap_MixedPartsEmpties() {
        TextContainer tc1 = new TextContainer();
        ISegments segments = tc1.getSegments();
        tc1.append(" ", false);
        Assert.assertEquals("[] ", this.fmt.printSegmentedContent(tc1, true));
        segments.append(new TextFragment(""), false);
        Assert.assertEquals("[] []", this.fmt.printSegmentedContent(tc1, true));
        tc1.append("\n", false);
        Assert.assertEquals("[] []\n", this.fmt.printSegmentedContent(tc1, true));
        segments.append(new TextFragment(""), false);
        Assert.assertEquals("[] []\n[]", this.fmt.printSegmentedContent(tc1, true));
        tc1.append("\n", false);
        Assert.assertEquals("[] []\n[]\n", this.fmt.printSegmentedContent(tc1, true));
        TextContainer tc2 = tc1.clone();
        TextContainer tc3 = tc1.clone();
        TextContainer tc4 = tc1.clone();
        tc1.unwrap(true, true);
        Assert.assertEquals("[][][]", this.fmt.printSegmentedContent(tc1, true));
        tc2.unwrap(false, true);
        Assert.assertEquals("[][][]", this.fmt.printSegmentedContent(tc2, true));
        tc3.unwrap(true, false);
        Assert.assertEquals("[] [] []", this.fmt.printSegmentedContent(tc3, true));
        tc4.unwrap(false, false);
        Assert.assertEquals("[] [] [] ", this.fmt.printSegmentedContent(tc4, true));
    }

    @Test
    public void testUnwrap_MixedParts() {
        TextContainer tc1 = new TextContainer();
        ISegments segments = tc1.getSegments();
        tc1.append(" ", false);
        Assert.assertEquals("[] ", this.fmt.printSegmentedContent(tc1, true));
        segments.append(new TextFragment("  t1 "), false);
        Assert.assertEquals("[] [  t1 ]", this.fmt.printSegmentedContent(tc1, true));
        segments.append(new TextFragment("  t2"), false);
        Assert.assertEquals("[] [  t1 ][  t2]", this.fmt.printSegmentedContent(tc1, true));
        TextContainer tc2 = tc1.clone();
        TextContainer tc3 = tc1.clone();
        TextContainer tc4 = tc1.clone();
        tc1.unwrap(true, true);
        Assert.assertEquals("[][t1 ][t2]", this.fmt.printSegmentedContent(tc1, true));
        tc2.unwrap(false, true);
        Assert.assertEquals("[][t1 ][t2]", this.fmt.printSegmentedContent(tc2, true));
        tc3.unwrap(true, false);
        Assert.assertEquals("[] [t1 ][t2]", this.fmt.printSegmentedContent(tc3, true));
        tc4.unwrap(false, false);
        Assert.assertEquals("[] [t1 ][t2]", this.fmt.printSegmentedContent(tc4, true));
    }

    @Test
    public void testSegments() {
        String originalText = "[seg1][seg2] [seg3]";
        TextContainer tc = new TextContainer(originalText);
        ISegments segments = tc.getSegments();
        Assert.assertFalse(tc.hasBeenSegmented());
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(0, 6));
        ranges.add(new Range(6, 12));
        ranges.add(new Range(13, -1));
        segments.create(ranges);
        Assert.assertEquals(4L, tc.count());
        Assert.assertEquals(3L, segments.count());
        Assert.assertEquals("[seg1]", segments.get(0).toString());
        Assert.assertEquals("[seg2]", segments.get(1).toString());
        Assert.assertEquals("[seg3]", segments.get(2).toString());
        segments.joinAll();
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertEquals(originalText, tc.toString());
    }

    @Test
    public void testSegmentRemoval() {
        String originalText = "[seg1][seg2] [seg3]";
        TextContainer tc = new TextContainer(originalText);
        ISegments segments = tc.getSegments();
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(0, 6));
        ranges.add(new Range(6, 12));
        ranges.add(new Range(13, 19));
        segments.create(ranges);
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertEquals("[seg2]", segments.get(1).toString());
        tc.remove(segments.getPartIndex(1));
        Assert.assertEquals("[seg3]", segments.get(1).toString());
        tc.remove(segments.getPartIndex(0));
        Assert.assertEquals("[seg3]", segments.get(0).toString());
        tc.remove(segments.getPartIndex(0));
        Assert.assertEquals("", segments.get(0).toString());
    }

    @Test
    public void testSegmentsFromArray() {
        String originalText = "[seg1][seg2] [seg3]";
        TextContainer tc = new TextContainer(originalText);
        ISegments segments = tc.getSegments();
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(0, 6));
        ranges.add(new Range(6, 12));
        ranges.add(new Range(13, 19));
        segments.create(ranges);
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertEquals("[seg1]", segments.get(0).toString());
        Assert.assertEquals("[seg2]", segments.get(1).toString());
        Assert.assertEquals("[seg3]", segments.get(2).toString());
        Assert.assertEquals(3L, segments.count());
        segments.joinWithNext(0);
        Assert.assertEquals(2L, segments.count());
        segments.joinWithNext(0);
        Assert.assertEquals(1L, segments.count());
        Assert.assertTrue(tc.contentIsOneSegment());
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertEquals(originalText, tc.toString());
        segments.create(ranges);
        Assert.assertEquals(3L, segments.count());
        Assert.assertEquals(3L, segments.count());
        segments.joinWithNext(0);
        segments.joinWithNext(0);
        Assert.assertEquals(originalText, tc.toString());
    }

    @Test
    public void testStorage_WithoutCodes() {
        TextContainer tc1 = this.createMultiSegmentContent();
        String data = TextContainer.contentToString(tc1);
        TextContainer tc2 = TextContainer.stringToContent(data);
        Assert.assertEquals("[text1] [text2]", this.fmt.printSegmentedContent(tc2, true));
        Assert.assertTrue(tc2.hasBeenSegmented());
        Assert.assertEquals("text1 text2", tc2.toString());
    }

    @Test
    public void testStorage_WithCodes() {
        TextContainer tc1 = this.createMultiSegmentContentWithCodes();
        String data = TextContainer.contentToString(tc1);
        TextContainer tc2 = TextContainer.stringToContent(data);
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc2, true));
        Assert.assertTrue(tc2.hasBeenSegmented());
        Assert.assertEquals("text1<br/> text2<br/>", tc2.toString());
    }

    @Test
    public void testSplitStorage_WithoutCodes() {
        TextContainer tc1 = this.createMultiSegmentContent();
        String[] data = TextContainer.contentToSplitStorage(tc1);
        TextContainer tc2 = TextContainer.splitStorageToContent(data[0], data[1]);
        Assert.assertEquals("[text1] [text2]", this.fmt.printSegmentedContent(tc2, true));
        Assert.assertTrue(tc2.hasBeenSegmented());
        Assert.assertEquals("text1 text2", tc2.toString());
    }

    @Test
    public void testSplitStorage_WithCodes() {
        TextContainer tc1 = this.createMultiSegmentContentWithCodes();
        String[] data = TextContainer.contentToSplitStorage(tc1);
        TextContainer tc2 = TextContainer.splitStorageToContent(data[0], data[1]);
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc2, true));
        Assert.assertTrue(tc2.hasBeenSegmented());
        Assert.assertEquals("text1<br/> text2<br/>", tc2.toString());
    }

    @Test
    public void testAppendPart_AsPart() {
        TextContainer tc = new TextContainer();
        tc.append(new TextPart("n0"));
        tc.append(new Segment(null, new TextFragment("s1")));
        tc.changePart(0);
        Assert.assertEquals("n0[s1]", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testAppendPart_AsStringAndTextFragment() {
        TextContainer tc = new TextContainer();
        tc.append("p0");
        tc.append(new TextFragment("p1"));
        tc.changePart(0);
        Assert.assertEquals("[p0]p1", this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testGetPartIndex_Found() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        Assert.assertEquals(2L, tc.getSegments().count());
        Assert.assertEquals(2L, tc.getSegments().getPartIndex(1));
    }

    @Test
    public void testGetPartIndex_NotFound() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        Assert.assertEquals(-1L, tc.getSegments().getPartIndex(3));
    }

    @Test
    public void testSwapSegments() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        ISegments segments = tc.getSegments();
        Assert.assertEquals("[text1<1/>] [text2<2/>]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("0", segments.get((int)0).id);
        Assert.assertEquals("1", segments.get((int)1).id);
        tc.getSegments().swap(0, 1);
        Assert.assertEquals("[text2<2/>] [text1<1/>]", this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals("1", segments.get((int)0).id);
        Assert.assertEquals("0", segments.get((int)1).id);
    }

    @Test
    public void testGetSegmentIndex() {
        TextContainer tc = this.createMultiSegmentContentWithCodes();
        ISegments segments = tc.getSegments();
        Assert.assertEquals("1", segments.get((int)tc.getSegments().getIndex((String)"1")).id);
    }

    @Test
    public void testInsertSegment() {
        TextContainer tc = this.createMultiSegmentContent();
        ISegments segs = tc.getSegments();
        segs.insert(1, new Segment("s2", new TextFragment("[new-seg]")));
        Segment seg = segs.get(1);
        Assert.assertEquals("[new-seg]", seg.toString());
        Assert.assertFalse("s2".equals(seg.id));
        Assert.assertEquals("s2", segs.get((int)2).id);
    }

    @Test
    public void testSetSegment() {
        TextContainer tc = this.createMultiSegmentContent();
        ISegments segs = tc.getSegments();
        segs.set(1, new Segment("s1", new TextFragment("[new-seg]")));
        Segment seg = segs.get(1);
        Assert.assertEquals("[new-seg]", seg.toString());
        Assert.assertEquals("0", seg.id);
        Assert.assertEquals("[new-seg]", seg.text.toString());
    }

    @Test
    public void testGetFirstSegment() {
        Segment seg = new Segment("qwerty", new TextFragment("xyz"));
        TextContainer tc = new TextContainer(seg);
        Assert.assertNotNull(tc.getFirstSegment());
        Assert.assertSame(seg, tc.getFirstSegment());
    }

    @Test
    public void testGetSegmented() {
        TextContainer tc = new TextContainer();
        Assert.assertFalse(tc.hasBeenSegmented());
    }

    @Test
    public void testPartsAddition() {
        TextContainer tc = new TextContainer();
        tc.append(new TextPart("tp"), true);
        tc.append(new Segment("seg1"), false);
        tc.append(new Segment("seg2"), false);
        Assert.assertEquals(3L, tc.count());
        Assert.assertEquals(3L, tc.getSegments().count());
        tc = new TextContainer();
        tc.append(new TextPart("tp"), true);
        tc.append(new Segment("seg1"), false);
        tc.append(new Segment("seg2"), false);
        tc.changePart(0);
        Assert.assertEquals(3L, tc.count());
        Assert.assertEquals(2L, tc.getSegments().count());
        tc = new TextContainer();
        tc.append(new Segment("seg1"), true);
        tc.append(new Segment("seg2"), false);
        tc.insert(0, new TextPart("tp"));
        Assert.assertEquals(3L, tc.count());
        Assert.assertEquals(2L, tc.getSegments().count());
        tc = new TextContainer(new TextPart("tp"), new Segment("seg1"), new Segment("seg2"));
        Assert.assertEquals(3L, tc.count());
        Assert.assertEquals(2L, tc.getSegments().count());
        Assert.assertFalse(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(tc.get(2).isSegment());
        tc = new TextContainer(new TextPart("tp"));
        Assert.assertEquals(1L, tc.count());
        Assert.assertEquals(1L, tc.getSegments().count());
        Assert.assertTrue(tc.get(0).isSegment());
        tc = new TextContainer(new Segment("seg1"));
        Assert.assertEquals(1L, tc.count());
        Assert.assertEquals(1L, tc.getSegments().count());
        Assert.assertTrue(tc.get(0).isSegment());
        tc = new TextContainer(new TextPart("tp1"), new TextPart("tp2"), new TextPart("tp3"));
        Assert.assertEquals(3L, tc.count());
        Assert.assertEquals(1L, tc.getSegments().count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertFalse(tc.get(1).isSegment());
        Assert.assertFalse(tc.get(2).isSegment());
        tc = new TextContainer(new Segment("seg1"), new Segment("seg2"), new Segment("seg3"));
        Assert.assertEquals(3L, tc.count());
        Assert.assertEquals(3L, tc.getSegments().count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(tc.get(2).isSegment());
    }

    private TextContainer createMultiSegmentContent() {
        TextFragment tf = new TextFragment("text1 text2");
        TextContainer tc = new TextContainer(tf);
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(0, 5, "s1"));
        ranges.add(new Range(6, 11, "s2"));
        tc.getSegments().create(ranges);
        return tc;
    }

    private TextContainer createMultiSegmentContentWithCodes() {
        TextFragment tf = new TextFragment("text1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        TextContainer tc = new TextContainer(tf);
        tc.append(new TextFragment(" "));
        tf = new TextFragment("text2");
        Code code = tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>", 2);
        tc.getSegments().append(tf);
        return tc;
    }
}

