/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.crosslanguage;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    protected static final String SERVERURL = "serverURL";
    protected static final String USER = "user";
    protected static final String APIKEY = "apiKey";
    protected static final String PASSWORD = "password";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    public String getUser() {
        return this.getString(USER);
    }

    public void setUser(String user) {
        this.setString(USER, user);
    }

    public String getApiKey() {
        return this.getString(APIKEY);
    }

    public void setApiKey(String apiKey) {
        this.setString(APIKEY, apiKey);
    }

    public String getServerURL() {
        return this.getString(SERVERURL);
    }

    public void setServerURL(String serverURL) {
        this.setString(SERVERURL, serverURL);
    }

    public String getPassword() {
        return this.getString(PASSWORD);
    }

    public void setPassword(String password) {
        this.setString(PASSWORD, password);
    }

    @Override
    public void reset() {
        super.reset();
        this.setUser("myUsername");
        this.setApiKey("myApiKey");
        this.setServerURL("http://gateway.crosslang.com:8080/services/clGateway?wsdl");
        this.setPassword("");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SERVERURL, "Server URL", "The full URL of the server (e.g. http://gateway.crosslang.com:8080/services/clGateway?wsdl");
        desc.add(USER, "User name", "The login name to use");
        desc.add(APIKEY, "API key", "The API key for the given user, engine and language pair");
        desc.add(PASSWORD, "Password", "The login passowrd");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("CrossLanguage MT Connector Settings");
        desc.addTextInputPart(paramsDesc.get(SERVERURL));
        desc.addTextInputPart(paramsDesc.get(USER));
        desc.addTextInputPart(paramsDesc.get(APIKEY));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        return desc;
    }
}

