/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.moses;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeNormalize {
    public static String processSingleLine(String normalized) {
        String deNormalized = normalized;
        deNormalized = DeNormalize.capitalizeNameTitleAbbrvs(deNormalized);
        deNormalized = DeNormalize.replaceBracketTokens(deNormalized);
        deNormalized = DeNormalize.joinPunctuationMarks(deNormalized);
        deNormalized = DeNormalize.joinHyphen(deNormalized);
        deNormalized = DeNormalize.joinContractions(deNormalized);
        deNormalized = DeNormalize.capitalizeLineFirstLetter(deNormalized);
        return deNormalized;
    }

    public static String capitalizeLineFirstLetter(String line) {
        String result = null;
        Pattern regexp = Pattern.compile("[^\\p{Punct}\\p{Space}\u00a1\u00bf]");
        Matcher matcher = regexp.matcher(line);
        if (matcher.find()) {
            String match = matcher.group(0);
            result = line.replaceFirst(match, match.toUpperCase());
        } else {
            result = line;
        }
        return result;
    }

    public static String joinPunctuationMarks(String line) {
        String result = line;
        result = result.replace(" ,", ",");
        result = result.replace(" .", ".");
        result = result.replace(" !", "!");
        result = result.replace("\u00a1 ", "\u00a1");
        result = result.replace(" ?", "?");
        result = result.replace("\u00bf ", "\u00bf");
        result = result.replace(" )", ")");
        result = result.replace(" ]", "]");
        result = result.replace(" }", "}");
        result = result.replace("( ", "(");
        result = result.replace("[ ", "[");
        result = result.replace("{ ", "{");
        return result;
    }

    public static String joinHyphen(String line) {
        return line.replace(" - ", "-");
    }

    public static String joinContractions(String line) {
        String result = line;
        for (String suffix : new String[]{"'d", "'ll", "'m", "n't", "'re", "'s", "'ve"}) {
            result = result.replace(" " + suffix, suffix);
        }
        return result;
    }

    public static String capitalizeNameTitleAbbrvs(String line) {
        String result = line;
        for (String title : new String[]{"dr", "miss", "mr", "mrs", "ms", "prof"}) {
            result = result.replaceAll("\\b" + title + "\\b", Character.toUpperCase(title.charAt(0)) + title.substring(1));
        }
        result = result.replaceAll("\\bphd\\b", "PhD");
        result = result.replaceAll("\\bmphil\\b", "MPhil");
        return result;
    }

    public static String capitalizeI(String line) {
        return line.replaceAll("\\bi\\b", "I");
    }

    public static String replaceBracketTokens(String line) {
        String result = line;
        result = result.replaceAll("(?iu)-lrb-", "(");
        result = result.replaceAll("(?iu)-rrb-", ")");
        result = result.replaceAll("(?iu)-lsb-", "[");
        result = result.replaceAll("(?iu)-rsb-", "]");
        result = result.replaceAll("(?iu)-lcb-", "{");
        result = result.replaceAll("(?iu)-rcb-", "}");
        return result;
    }
}

