/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.moses;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.htmlparser.jericho.CharacterReference;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.moses.DeNormalize;
import net.sf.okapi.connectors.moses.Parameters;
import net.sf.okapi.connectors.moses.SimpleTokenizer;
import net.sf.okapi.lib.translation.BaseConnector;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class MosesMTConnector
extends BaseConnector {
    private static final Logger LOGGER = Logger.getLogger(MosesMTConnector.class.getName());
    private Parameters params = new Parameters();
    private XmlRpcClient client;
    private HashMap<String, String> mosesParams;
    private Object[] xmlRpcParams;
    private List<QueryResult> hits = new LinkedList<QueryResult>();
    private XmlRpcClientConfigImpl config;
    private SimpleTokenizer tokenizer;

    public MosesMTConnector() {
        this.client = new XmlRpcClient();
        this.config = new XmlRpcClientConfigImpl();
        this.mosesParams = new HashMap();
        this.xmlRpcParams = new Object[]{null};
    }

    @Override
    public String getName() {
        return "Moses-MT";
    }

    @Override
    public String getSettingsDisplay() {
        return "Server: " + this.params.getServerURL();
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void open() {
        this.close();
        this.tokenizer = new SimpleTokenizer(this.getTargetLanguage());
        try {
            this.config.setServerURL(new URL(this.params.getServerURL()));
        }
        catch (MalformedURLException e) {
            throw new OkapiIOException(String.format("Cannot connect to the following URL: %s", this.params.getServerURL()), e);
        }
        this.client.setConfig(this.config);
        this.mosesParams.put("align", "true");
        this.mosesParams.put("report-all-factors", "true");
    }

    @Override
    public void close() {
        this.hits.clear();
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public int query(TextFragment text) {
        this.hits.clear();
        if (!text.hasText(false)) {
            return 0;
        }
        QueryResult qRes = new QueryResult();
        this.mosesParams.put("text", this.mosesPreprocess(text.getText()));
        this.xmlRpcParams[0] = this.mosesParams;
        try {
            HashMap mt = (HashMap)this.client.execute("translate", this.xmlRpcParams);
            String textTranslation = (String)mt.get("text");
            qRes.weight = this.getWeight();
            qRes.source = text;
            if (text.hasCode()) {
                qRes.target = new TextFragment(this.mosesPostProcess(textTranslation));
                for (Code c : text.getClonedCodes()) {
                    qRes.target.append(c);
                }
                qRes.target.alignCodeIds(text);
            } else {
                qRes.target = new TextFragment(this.mosesPostProcess(textTranslation));
            }
            qRes.setCombinedScore(QueryResult.COMBINEDSCORE_UNDEFINED);
            qRes.setQuality(QueryResult.QUALITY_UNDEFINED);
            qRes.setFuzzyScore(95);
            qRes.origin = this.getName();
            qRes.matchType = MatchType.MT;
        }
        catch (XmlRpcException e) {
            throw new OkapiIOException(String.format("Error calling moses server translate for: %s", text.toString()), e);
        }
        this.hits.add(qRes);
        return 1;
    }

    @Override
    public boolean hasNext() {
        return !this.hits.isEmpty();
    }

    @Override
    public QueryResult next() {
        return this.hits.remove(0);
    }

    private String mosesPreprocess(String text) {
        String postProcessText = this.tokenizer.tokenize(text);
        postProcessText = postProcessText.toLowerCase(this.getTargetLanguage().toJavaLocale());
        return postProcessText;
    }

    private String mosesPostProcess(String text) {
        String t = CharacterReference.decode(text);
        t = DeNormalize.processSingleLine(t).replaceAll("\\s+", " ").trim();
        t = t.replaceAll("(\\|UNK)+", "");
        return t;
    }
}

