/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.opentran;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.TextMatcher;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OpenTranTMConnector
extends BaseConnector
implements ITMQuery {
    private List<QueryResult> results;
    private int current = -1;
    private int maxHits = 12;
    private int threshold = 60;
    private TextMatcher matcher;
    private ScoreComparer scorComp = new ScoreComparer();

    @Override
    public String getName() {
        return "OpenTran";
    }

    @Override
    public String getSettingsDisplay() {
        return "REST services at http://open-tran.eu";
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public void open() {
    }

    @Override
    public int query(String plainText) {
        return this.restQuery(plainText, false);
    }

    private int restQuery(String plainText, boolean hasCode) {
        this.results = new ArrayList<QueryResult>();
        this.current = -1;
        try {
            URL url = new URL("http://" + this.srcCode + "." + this.trgCode + ".open-tran.eu/json/suggest/" + URLEncoder.encode(plainText, "UTF-8").replace("+", "%20"));
            URLConnection conn = url.openConnection();
            JSONParser parser = new JSONParser();
            JSONArray array = (JSONArray)parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            int count = 0;
            block5: for (int i = 0; i < array.size(); ++i) {
                Map map = (Map)array.get(i);
                String text = (String)map.get("text");
                JSONArray projects = (JSONArray)map.get("projects");
                for (int p = 0; p < projects.size(); ++p) {
                    Map pairs = (Map)projects.get(p);
                    QueryResult qr = new QueryResult();
                    qr.weight = this.getWeight();
                    qr.target = new TextFragment(text);
                    qr.source = new TextFragment((String)pairs.get("orig_phrase"));
                    String tmp = (String)pairs.get("path");
                    if (!Util.isEmpty(tmp)) {
                        qr.origin = tmp;
                    }
                    this.results.add(qr);
                    if (++count == this.maxHits) break block5;
                }
            }
            this.fixupResults(plainText, hasCode);
            if (this.results.size() > 0) {
                this.current = 0;
            }
            return this.results.size();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("URL error when querying.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding error when querying.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO error when querying.", e);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error when parsing JSON results.", e);
        }
    }

    @Override
    public int query(TextFragment text) {
        return this.restQuery(TextUnitUtil.getText(text, null), text.hasCode());
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void clearAttributes() {
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        super.setLanguages(sourceLocale, targetLocale);
        this.matcher = new TextMatcher(sourceLocale, sourceLocale);
    }

    @Override
    public void setMaximumHits(int max) {
        this.maxHits = max;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public int getMaximumHits() {
        return this.maxHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toPOSIXLocaleId();
        if (!code.startsWith("zh") && code.length() > 2) {
            code = code.substring(0, 2);
        }
        return code;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }

    private void fixupResults(String plainText, boolean hasCodes) {
        if (this.results.size() == 0) {
            return;
        }
        List<String> tokens = this.matcher.prepareBaseTokens(plainText);
        Iterator<QueryResult> iter = this.results.iterator();
        while (iter.hasNext()) {
            QueryResult qr = iter.next();
            qr.setFuzzyScore(this.matcher.compareToBaseTokens(plainText, tokens, qr.source));
            if (hasCodes && qr.getFuzzyScore() > 99) {
                qr.setFuzzyScore(qr.getFuzzyScore() - 1);
            }
            if (qr.getFuzzyScore() < this.threshold) {
                iter.remove();
                continue;
            }
            if (qr.getFuzzyScore() >= 100) {
                qr.matchType = MatchType.EXACT;
                continue;
            }
            if (qr.getFuzzyScore() <= 0) continue;
            qr.matchType = MatchType.FUZZY;
        }
        Collections.sort(this.results, this.scorComp);
    }

    class ScoreComparer
    implements Comparator<QueryResult> {
        ScoreComparer() {
        }

        @Override
        public int compare(QueryResult arg0, QueryResult arg1) {
            return arg0.getFuzzyScore() > arg1.getFuzzyScore() ? -1 : (arg0.getFuzzyScore() == arg1.getFuzzyScore() ? 0 : 1);
        }
    }
}

