/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.promt;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    protected static final String HOST = "host";
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";

    public String getHost() {
        return this.getString(HOST);
    }

    public void setHost(String host) {
        this.setString(HOST, host);
    }

    public String getUsername() {
        return this.getString(USERNAME);
    }

    public void setUsername(String username) {
        this.setString(USERNAME, username);
    }

    public String getPassword() {
        return this.getString(PASSWORD);
    }

    public void setPassword(String password) {
        this.setString(PASSWORD, password);
    }

    public Parameters() {
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void reset() {
        super.reset();
        this.setHost("ptsdemo.promt.ru/");
        this.setUsername("");
        this.setPassword("");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(HOST, "Host server", "The root URL of the host server (e.g. http://ptsdemo.promt.ru/");
        desc.add(USERNAME, "User name (optional)", "The login name to use");
        desc.add(PASSWORD, "Password (if needed)", "The password for the given user name");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("ProMT Connector Settings");
        desc.addTextInputPart(paramsDesc.get(HOST));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(USERNAME));
        tip.setAllowEmpty(true);
        tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        tip.setAllowEmpty(true);
        return desc;
    }
}

