/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.AbstractTranslator;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ContentTypes;
import net.sf.okapi.filters.openxml.ExcelAnalyzer;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLZipFilterWriter;
import net.sf.okapi.filters.openxml.Presentation;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.YamlParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=ConditionalParameters.class)
public class OpenXMLFilter
implements IFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final int MSWORD = 1;
    public static final int MSEXCEL = 2;
    public static final int MSPOWERPOINT = 3;
    public static final int MSWORDCHART = 4;
    public static final int MSEXCELCOMMENT = 5;
    public static final int MSWORDDOCPROPERTIES = 6;
    private final String MIMETYPE = "text/xml";
    private final String docId = "sd";
    private ZipFile zipFile;
    private ZipEntry entry;
    private NextAction nextAction;
    private URI docURI;
    private Enumeration<? extends ZipEntry> entries;
    private int subDocId;
    private LinkedList<Event> queue;
    private LocaleId srcLang;
    private OpenXMLContentFilter openXMLContentFilter;
    private ConditionalParameters cparams = null;
    private int nZipType = 1;
    private int nFileType = 1;
    private boolean bSquishable = true;
    private AbstractTranslator translator = null;
    private LocaleId sOutputLanguage = LocaleId.fromString("en-us");
    private boolean canceled = false;
    private boolean bPreferenceTranslateDocProperties = true;
    private boolean bPreferenceTranslateComments = true;
    private boolean bPreferenceTranslatePowerpointNotes = true;
    private boolean bPreferenceTranslatePowerpointMasters = true;
    private boolean bPreferenceTranslateWordHeadersFooters = true;
    private boolean bPreferenceTranslateWordAllStyles = true;
    private boolean bPreferenceTranslateWordHidden = false;
    private boolean bMinedHiddenStyles = false;
    private boolean bPreferenceTranslateExcelExcludeColors = false;
    private boolean bPreferenceTranslateExcelExcludeColumns = false;
    private TreeSet tsExcludeWordStyles = null;
    private TreeSet<String> tsExcelExcludedColors;
    private TreeSet<String> tsExcelExcludedStyles = null;
    private TreeSet<String> tsExcelExcludedColumns;
    private int nExcelOriginalSharedStringCount;
    private boolean bProcessedExcelSheets = true;
    private String sCurrentExcelSheet = "";
    private boolean bHaveWordContentTypes = false;
    private YamlParameters yparams = null;
    private String encoding = "UTF-8";
    private EncoderManager encoderManager;
    private ContentTypes contentTypes;
    private XMLInputFactory factory = XMLInputFactory.newInstance();
    static final String CONTENT_TYPES_PART = "[Content_Types].xml";

    public OpenXMLFilter() {
        this.cparams = new ConditionalParameters();
        this.readParams();
    }

    public OpenXMLFilter(AbstractTranslator translator, LocaleId sOutputLanguage) {
        this.translator = translator;
        this.sOutputLanguage = sOutputLanguage;
        this.cparams = new ConditionalParameters();
        this.readParams();
    }

    private void readParams() {
        try {
            this.bPreferenceTranslateDocProperties = this.cparams.getTranslateDocProperties();
            this.bPreferenceTranslateComments = this.cparams.getTranslateComments();
            this.bPreferenceTranslatePowerpointNotes = this.cparams.getTranslatePowerpointNotes();
            this.bPreferenceTranslatePowerpointMasters = this.cparams.getTranslatePowerpointMasters();
            this.bPreferenceTranslateWordHeadersFooters = this.cparams.getTranslateWordHeadersFooters();
            this.bPreferenceTranslateWordAllStyles = this.cparams.getTranslateWordAllStyles();
            this.bPreferenceTranslateWordHidden = this.cparams.getTranslateWordHidden();
            this.bPreferenceTranslateExcelExcludeColors = this.cparams.getTranslateExcelExcludeColors();
            this.bPreferenceTranslateExcelExcludeColumns = this.cparams.getTranslateExcelExcludeColumns();
            this.tsExcelExcludedColors = this.cparams.tsExcelExcludedColors;
            this.tsExcelExcludedColumns = this.cparams.tsExcelExcludedColumns;
            this.tsExcludeWordStyles = this.cparams.tsExcludeWordStyles;
            this.nFileType = this.cparams.nFileType;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.nextAction = NextAction.DONE;
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing zipped output file.");
        }
        if (this.openXMLContentFilter != null) {
            this.openXMLContentFilter.close();
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new OpenXMLZipFilterWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
            this.encoderManager.setMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "net.sf.okapi.common.encoder.OpenXMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getName() {
        return "okf_openxml";
    }

    @Override
    public String getDisplayName() {
        return "OpenXML Filter";
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/xml", this.getClass().getName(), "Microsoft Office Document", "Microsoft Office documents (DOCX, XLSX, PPTX).", null, ".docx;.pptx;.xlsx;"));
        return list;
    }

    @Override
    public IParameters getParameters() {
        return this.cparams;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null && !this.queue.isEmpty() || this.nextAction != NextAction.DONE;
    }

    @Override
    public Event next() {
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        switch (this.nextAction) {
            case OPENZIP: {
                return this.openZipFile();
            }
            case NEXTINZIP: {
                return this.nextInZipFile();
            }
            case NEXTINSUBDOC: {
                return this.nextInSubDocument();
            }
        }
        throw new RuntimeException("Invalid next() call.");
    }

    @Override
    public void open(RawDocument input) {
        if (input == null) {
            throw new RuntimeException("RawDocument is null");
        }
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        if (input == null) {
            throw new RuntimeException("RawDocument is null");
        }
        this.resetBooleans();
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), input.getEncoding(), generateSkeleton);
        if (input.getInputCharSequence() != null) {
            this.open(input.getInputCharSequence());
        } else if (input.getInputURI() != null) {
            this.open(input.getInputURI());
            this.LOGGER.debug("\nOpening {}", (Object)input.getInputURI().toString());
        } else if (input.getStream() != null) {
            this.open(input.getStream());
        } else {
            throw new RuntimeException("InputResource has no input defined.");
        }
    }

    public void open(RawDocument input, boolean generateSkeleton, boolean bSquishable) {
        if (input == null) {
            throw new RuntimeException("RawDocument is null");
        }
        this.resetBooleans();
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), input.getEncoding(), generateSkeleton);
        if (input.getInputCharSequence() != null) {
            this.open(input.getInputCharSequence());
        } else if (input.getInputURI() != null) {
            this.open(input.getInputURI(), bSquishable);
            this.LOGGER.debug("\nOpening {}", (Object)input.getInputURI().toString());
        } else if (input.getStream() != null) {
            this.open(input.getStream());
        } else {
            throw new RuntimeException("InputResource has no input defined.");
        }
    }

    public void open(InputStream input) {
        throw new UnsupportedOperationException("Method is not supported for this filter.");
    }

    private void open(CharSequence inputText) {
        throw new UnsupportedOperationException("Method is not supported for this filter.");
    }

    private void open(URI inputURI) {
        this.open(inputURI, true);
    }

    public void open(URI inputURI, boolean bSquishable) {
        this.close();
        this.resetBooleans();
        this.docURI = inputURI;
        this.nextAction = NextAction.OPENZIP;
        this.queue = new LinkedList();
        this.openXMLContentFilter = new OpenXMLContentFilter();
        this.bSquishable = bSquishable;
        if (this.cparams != null) {
            this.readParams();
        }
        this.LOGGER.debug("\nOpening {}", (Object)inputURI.toString());
    }

    public void setOptions(LocaleId sourceLanguage, String defaultEncoding, boolean generateSkeleton) {
        this.setOptions(sourceLanguage, null, defaultEncoding, generateSkeleton);
    }

    public void setOptions(LocaleId sourceLanguage, LocaleId targetLanguage, String defaultEncoding, boolean generateSkeleton) {
        this.srcLang = sourceLanguage;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.cparams = (ConditionalParameters)params;
        this.readParams();
    }

    private Enumeration<? extends ZipEntry> getZipFileEntries() {
        ArrayList<? extends ZipEntry> list = Collections.list(this.zipFile.entries());
        if (this.nZipType == 1) {
            Collections.sort(list, new ZipEntryComparator());
        }
        return Collections.enumeration(list);
    }

    private Event openZipFile() {
        try {
            File fZip = new File(this.docURI.getPath());
            this.zipFile = new ZipFile(fZip, 1);
            this.entries = this.getZipFileEntries();
            this.nZipType = -1;
            while (this.entries.hasMoreElements()) {
                this.entry = this.entries.nextElement();
                String sEntryName = this.entry.getName();
                int iCute = 0;
                iCute = sEntryName.indexOf("/");
                if (iCute <= 0) continue;
                String sZipType = sEntryName.substring(0, iCute);
                if (sZipType.equals("xl")) {
                    this.nZipType = 2;
                    break;
                }
                if (sZipType.equals("word")) {
                    this.nZipType = 1;
                    break;
                }
                if (!sZipType.equals("ppt")) continue;
                this.nZipType = 3;
                break;
            }
            if (this.nZipType == -1) {
                throw new OkapiBadFilterInputException("MS Office 2007 filter tried to open a file that is not aMicrosoft Office 2007 Word, Excel, or Powerpoint file.");
            }
            if (this.nZipType == 2 && (this.bPreferenceTranslateExcelExcludeColors || this.bPreferenceTranslateExcelExcludeColumns)) {
                ExcelAnalyzer ea = new ExcelAnalyzer(this.zipFile);
                this.tsExcelExcludedStyles = ea.analyzeExcelGetStylesOfExcludedColors(this.tsExcelExcludedColors);
                this.openXMLContentFilter.setTsExcelExcludedStyles(this.tsExcelExcludedStyles);
                this.nExcelOriginalSharedStringCount = ea.analyzeExcelGetSharedStringsCount();
                this.openXMLContentFilter.initTmSharedStrings(this.nExcelOriginalSharedStringCount);
                this.bProcessedExcelSheets = false;
            }
            this.entries = this.getZipFileEntries();
            this.initializeContentTypes();
            this.entries = this.sortPPTXSlides(this.entries);
            this.openXMLContentFilter.setBPreferenceTranslateWordHidden(this.bPreferenceTranslateWordHidden);
            this.subDocId = 0;
            this.nextAction = NextAction.NEXTINZIP;
            StartDocument startDoc = new StartDocument("sd");
            startDoc.setName(this.docURI.getPath());
            startDoc.setLocale(this.srcLang);
            startDoc.setMimeType("text/xml");
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setLineBreak("\n");
            startDoc.setEncoding(this.encoding, false);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile, null);
            return new Event(EventType.START_DOCUMENT, startDoc, skel);
        }
        catch (ZipException e) {
            throw new OkapiIOException("Error opening zipped input file.");
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading zipped input file.", e);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Error parsing XML content", e);
        }
    }

    private Reader getPartReader(String partName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(partName);
        if (entry == null) {
            throw new OkapiBadFilterInputException("File is missing " + partName);
        }
        return new InputStreamReader(this.zipFile.getInputStream(entry), this.encoding);
    }

    private void initializeContentTypes() throws XMLStreamException, IOException {
        this.contentTypes = new ContentTypes(this.factory);
        this.contentTypes.parseFromXML(this.getPartReader(CONTENT_TYPES_PART));
    }

    private Enumeration<? extends ZipEntry> sortPPTXSlides(Enumeration<? extends ZipEntry> entries) throws XMLStreamException, IOException {
        if (this.nZipType != 3) {
            return entries;
        }
        Relationships rels = new Relationships(this.factory);
        rels.parseFromXML("ppt/_rels/presentation.xml.rels", this.getPartReader("ppt/_rels/presentation.xml.rels"));
        Presentation pres = new Presentation(this.factory, rels);
        pres.parseFromXML(this.getPartReader("ppt/presentation.xml"));
        List<String> slideParts = pres.getSlidePartNames();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        Collections.sort(entryList, new ZipEntryComparator(slideParts));
        return Collections.enumeration(entryList);
    }

    private Event nextInZipFile() {
        while (this.entries.hasMoreElements()) {
            this.entry = this.entries.nextElement();
            String sEntryName = this.entry.getName();
            String sDocType = this.contentTypes.getContentType("/" + sEntryName);
            int iCute = sDocType.lastIndexOf(46, sDocType.length() - 1);
            if (iCute > 0) {
                sDocType = sDocType.substring(iCute + 1);
            }
            if (this.nZipType == 2) {
                this.openXMLContentFilter.setBPreferenceTranslateExcelExcludeColors(this.bPreferenceTranslateExcelExcludeColors);
                this.openXMLContentFilter.setBPreferenceTranslateExcelExcludeColumns(this.bPreferenceTranslateExcelExcludeColumns);
                if (this.bPreferenceTranslateExcelExcludeColors) {
                    this.openXMLContentFilter.setTsExcelExcludedStyles(this.tsExcelExcludedStyles);
                }
                if (this.bPreferenceTranslateExcelExcludeColumns) {
                    this.openXMLContentFilter.setTsExcelExcludedColumns(this.tsExcelExcludedColumns);
                }
                if (this.bPreferenceTranslateExcelExcludeColors || this.bPreferenceTranslateExcelExcludeColumns) {
                    if (!(this.bProcessedExcelSheets || sEntryName.equals(CONTENT_TYPES_PART) || sDocType.equals("worksheet+xml"))) {
                        this.resetExcel();
                        continue;
                    }
                    if (this.bProcessedExcelSheets && (sEntryName.equals(CONTENT_TYPES_PART) || sDocType.equals("worksheet+xml"))) continue;
                    if (sDocType.equals("worksheet+xml")) {
                        iCute = sEntryName.indexOf(".xml");
                        if (iCute > -1) {
                            this.sCurrentExcelSheet = sEntryName.substring(0, iCute);
                            iCute = this.sCurrentExcelSheet.indexOf("worksheets/sheet");
                            if (iCute > -1) {
                                this.sCurrentExcelSheet = this.sCurrentExcelSheet.substring(iCute + 16);
                                this.openXMLContentFilter.setSCurrentExcelSheet(this.sCurrentExcelSheet);
                            } else {
                                this.openXMLContentFilter.setSCurrentExcelSheet("");
                            }
                        } else {
                            this.openXMLContentFilter.setSCurrentExcelSheet("");
                        }
                    }
                }
            }
            if (this.nZipType == 1) {
                if (!this.bHaveWordContentTypes) {
                    if (!sEntryName.equals(CONTENT_TYPES_PART)) continue;
                    this.bHaveWordContentTypes = true;
                    this.entries = this.getZipFileEntries();
                } else if (!this.bMinedHiddenStyles) {
                    if (!sEntryName.equals("word/styles.xml")) continue;
                    this.bMinedHiddenStyles = true;
                    this.entries = this.getZipFileEntries();
                } else if (sEntryName.equals(CONTENT_TYPES_PART) || sEntryName.equals("word/styles.xml")) continue;
            }
            boolean bInMainFile = sEntryName.endsWith(".xml") && (this.nZipType == 1 && sDocType.equals("main+xml") || this.nZipType == 3 && sDocType.equals("slide+xml"));
            this.openXMLContentFilter.setBInMainFile(bInMainFile);
            boolean bInSettingsFile = sDocType.equals("settings+xml");
            this.openXMLContentFilter.setBInSettingsFile(bInSettingsFile);
            if (bInMainFile && (this.bSquishable || this.nZipType != 1)) {
                this.LOGGER.debug("\n\n<<<<<<< {} : {} >>>>>>>", (Object)sEntryName, (Object)sDocType);
                this.nFileType = this.nZipType;
                this.openXMLContentFilter.setUpConfig(this.nFileType);
                this.yparams = (YamlParameters)this.openXMLContentFilter.getParameters();
                Event ually = this.openSubDocument(true);
                this.resetExcel();
                return ually;
            }
            if (sEntryName.equals(CONTENT_TYPES_PART) || sEntryName.endsWith(".xml") && (this.nZipType == 1 && (sDocType.equals("main+xml") || sDocType.equals("footnotes+xml") || sDocType.equals("endnotes+xml") || sDocType.startsWith("diagramData") || sDocType.startsWith("header") && this.bPreferenceTranslateWordHeadersFooters || sDocType.equals("footer+xml") && this.bPreferenceTranslateWordHeadersFooters || sDocType.equals("comments+xml") && this.bPreferenceTranslateComments || sDocType.equals("chart+xml") || sEntryName.equals("word/styles.xml") && !this.bPreferenceTranslateWordHidden || sDocType.equals("settings+xml") || sDocType.equals("core-properties+xml") && this.bPreferenceTranslateDocProperties || sDocType.equals("glossary+xml")) || this.nZipType == 2 && (sDocType.equals("sharedStrings+xml") || sDocType.equals("worksheet+xml") && (this.bPreferenceTranslateExcelExcludeColors || this.bPreferenceTranslateExcelExcludeColumns) || sDocType.equals("comments+xml") && this.bPreferenceTranslateDocProperties || sDocType.equals("table+xml")) || this.nZipType == 3 && (sDocType.equals("notesSlide+xml") && this.bPreferenceTranslatePowerpointNotes || sDocType.equals("slideMaster+xml") && this.bPreferenceTranslatePowerpointMasters) || sDocType.startsWith("diagramData"))) {
                this.nFileType = this.nZipType == 1 && sDocType.equals("chart+xml") ? 4 : (this.nZipType == 1 && sDocType.equals("core-properties+xml") ? 6 : (this.nZipType == 2 && sDocType.equals("comments+xml") ? 5 : this.nZipType));
                this.openXMLContentFilter.setUpConfig(this.nFileType);
                this.yparams = (YamlParameters)this.openXMLContentFilter.getParameters();
                this.LOGGER.debug("<<<<<<< {} : {} >>>>>>>", (Object)sEntryName, (Object)sDocType);
                Event ually = this.openSubDocument(false);
                this.resetExcel();
                return ually;
            }
            this.nFileType = this.nZipType;
            this.openXMLContentFilter.setUpConfig(this.nFileType);
            this.yparams = (YamlParameters)this.openXMLContentFilter.getParameters();
            DocumentPart dp = new DocumentPart(this.entry.getName(), false);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile, this.entry);
            Event ually = new Event(EventType.DOCUMENT_PART, dp, skel);
            this.resetExcel();
            return ually;
        }
        this.close();
        Ending ending = new Ending("ed");
        return new Event(EventType.END_DOCUMENT, ending);
    }

    private Event openSubDocument(boolean bSquishing) {
        Event event;
        this.openXMLContentFilter.close();
        this.openXMLContentFilter.setParameters(this.yparams);
        try {
            BufferedInputStream bis;
            InputStream isInputStream = this.zipFile.getInputStream(this.entry);
            if (bSquishing) {
                PipedOutputStream pios = new PipedOutputStream();
                PipedInputStream squishedInputStream = (PipedInputStream)this.openXMLContentFilter.combineRepeatedFormat(isInputStream, pios);
                bis = new BufferedInputStream(squishedInputStream);
            } else {
                bis = new BufferedInputStream(isInputStream);
            }
            this.openXMLContentFilter.open(new RawDocument(bis, "UTF-8", this.srcLang));
            if (!this.bPreferenceTranslateWordHidden || !this.bPreferenceTranslateWordAllStyles) {
                this.openXMLContentFilter.setTsExcludeWordStyles(this.tsExcludeWordStyles);
            }
            event = this.openXMLContentFilter.next();
            this.LOGGER.trace(this.openXMLContentFilter.getParameters().toString());
        }
        catch (IOException e) {
            throw new OkapiIOException("Error streaming input.");
        }
        StartSubDocument sd = new StartSubDocument("sd", String.valueOf(++this.subDocId));
        String naym = this.entry.getName();
        sd.setName(naym);
        this.cparams.nFileType = this.nFileType;
        ConditionalParameters cparamNew = this.cparams.clone();
        sd.setFilterParameters(cparamNew);
        this.nextAction = NextAction.NEXTINSUBDOC;
        ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getResource().getSkeleton(), this.zipFile, this.entry);
        return new Event(EventType.START_SUBDOCUMENT, sd, skel);
    }

    private Event nextInSubDocument() {
        if (this.openXMLContentFilter.hasNext()) {
            Event event = this.openXMLContentFilter.next();
            switch (event.getEventType()) {
                case TEXT_UNIT: {
                    if (this.translator != null) {
                        this.translator.addToReferents(event);
                        ITextUnit tu = event.getTextUnit();
                        TextFragment tfSource = tu.getSource().getFirstContent();
                        String torg = this.translator.translate(tfSource, this.LOGGER, this.nFileType);
                        TextFragment tfTarget = tfSource.clone();
                        tfTarget.setCodedText(torg);
                        TextContainer tc = new TextContainer();
                        tc.setContent(tfTarget);
                        tu.setTarget(this.sOutputLanguage, tc);
                        tfSource = null;
                    }
                    this.openXMLContentFilter.displayOneEvent(event);
                    return event;
                }
                case END_DOCUMENT: {
                    if (!this.bPreferenceTranslateWordHidden) {
                        this.tsExcludeWordStyles = this.openXMLContentFilter.getTsExcludeWordStyles();
                    }
                    Ending ending = new Ending(String.valueOf(this.subDocId));
                    this.nextAction = NextAction.NEXTINZIP;
                    ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getResource().getSkeleton(), this.zipFile, this.entry);
                    return new Event(EventType.END_SUBDOCUMENT, ending, skel);
                }
                case DOCUMENT_PART: 
                case START_GROUP: 
                case START_SUBFILTER: {
                    if (this.translator == null) break;
                    this.translator.addToReferents(event);
                }
            }
            this.openXMLContentFilter.displayOneEvent(event);
            return event;
        }
        return null;
    }

    public int getNZipType() {
        return this.nZipType;
    }

    public OpenXMLContentFilter getOpenXMLContentFilter() {
        return this.openXMLContentFilter;
    }

    private void resetExcel() {
        if (!this.bProcessedExcelSheets && !this.entries.hasMoreElements()) {
            this.entries = this.getZipFileEntries();
            this.bProcessedExcelSheets = true;
        }
    }

    private void resetBooleans() {
        this.bHaveWordContentTypes = false;
        this.bMinedHiddenStyles = false;
    }

    @Override
    public void cancel() {
    }

    public void setBPreferenceTranslateDocProperties(boolean bPreferenceTranslateDocProperties) {
        this.bPreferenceTranslateDocProperties = bPreferenceTranslateDocProperties;
    }

    public boolean getBPreferenceTranslateDocProperties() {
        return this.bPreferenceTranslateDocProperties;
    }

    public void setBPreferenceTranslateComments(boolean bPreferenceTranslateComments) {
        this.bPreferenceTranslateComments = bPreferenceTranslateComments;
    }

    public boolean getBPreferenceTranslateComments() {
        return this.bPreferenceTranslateComments;
    }

    public void setBPreferenceTranslatePowerpointNotes(boolean bPreferenceTranslatePowerpointNotes) {
        this.bPreferenceTranslatePowerpointNotes = bPreferenceTranslatePowerpointNotes;
    }

    public boolean getBPreferenceTranslatePowerpointNotes() {
        return this.bPreferenceTranslatePowerpointNotes;
    }

    public void setBPreferenceTranslatePowerpointMasters(boolean bPreferenceTranslatePowerpointMasters) {
        this.bPreferenceTranslatePowerpointMasters = bPreferenceTranslatePowerpointMasters;
    }

    public boolean getBPreferenceTranslatePowerpointMasters() {
        return this.bPreferenceTranslatePowerpointMasters;
    }

    public void setBPreferenceTranslateWordHeadersFooters(boolean bPreferenceTranslateWordHeadersFooters) {
        this.bPreferenceTranslateWordHeadersFooters = bPreferenceTranslateWordHeadersFooters;
    }

    public boolean getBPreferenceTranslateWordHeadersFooters() {
        return this.bPreferenceTranslateWordHeadersFooters;
    }

    public void setBPreferenceTranslateWordHidden(boolean bPreferenceTranslateWordHidden) {
        this.bPreferenceTranslateWordHidden = bPreferenceTranslateWordHidden;
    }

    public boolean getBPreferenceTranslateWordHidden() {
        return this.bPreferenceTranslateWordHidden;
    }

    public void setBPreferenceTranslateWordAllStyles(boolean bPreferenceTranslateWordAllStyles) {
        this.bPreferenceTranslateWordAllStyles = bPreferenceTranslateWordAllStyles;
    }

    public boolean getBPreferenceTranslateWordAllStyles() {
        return this.bPreferenceTranslateWordAllStyles;
    }

    class ZipEntryComparator
    implements Comparator<ZipEntry> {
        List<String> names = Arrays.asList("[Content_Types].xml", "word/styles.xml", "_rels/.rels", "word/_rels/document.xml.rels", "word/document.xml");

        ZipEntryComparator() {
        }

        ZipEntryComparator(List<String> additionalPartNames) {
            this.names = new ArrayList<String>(this.names);
            this.names.addAll(additionalPartNames);
        }

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            int index1 = this.names.indexOf(o1.getName());
            int index2 = this.names.indexOf(o2.getName());
            if (index1 == -1) {
                index1 = Integer.MAX_VALUE;
            }
            if (index2 == -1) {
                index2 = Integer.MAX_VALUE;
            }
            if (index1 < index2) {
                return -1;
            }
            if (index1 > index2) {
                return 1;
            }
            return 0;
        }
    }

    private static enum NextAction {
        OPENZIP,
        NEXTINZIP,
        NEXTINSUBDOC,
        DONE;

    }
}

