/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff.its;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.filters.xliff.its.IITSDataStore;
import net.sf.okapi.filters.xliff.its.ITSDefaultDataStore;
import net.sf.okapi.filters.xliff.its.ITSLQI;
import net.sf.okapi.filters.xliff.its.ITSLQICollection;
import net.sf.okapi.filters.xliff.its.ITSProvenance;
import net.sf.okapi.filters.xliff.its.ITSProvenanceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITSStandoffManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static int FILE_NUM = 0;
    private ITSLQICollection currentLQICollection = null;
    private ITSProvenanceCollection currentProvCollection = null;
    private HashSet<String> parsedFiles = new HashSet();
    private IITSDataStore dataStore;
    private String itsId = "its" + ITSStandoffManager.getFileNum();

    public ITSStandoffManager() {
        this(new ITSDefaultDataStore());
    }

    public ITSStandoffManager(IITSDataStore dataStore) {
        this.dataStore = dataStore;
        this.dataStore.initialize(this.itsId);
    }

    private static synchronized int getFileNum() {
        return FILE_NUM++;
    }

    public File parseXLIFF(XMLEventReader reader, String resource, String encoding) {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile(resource.replaceAll("[^\\w\\._\\-]+", "_") + ".xlf.tmp", null);
            FileOutputStream tmp = new FileOutputStream(tmpFile);
            XMLEventWriter writer = xmlOutputFactory.createXMLEventWriter(tmp, encoding);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                writer.add(event);
                switch (event.getEventType()) {
                    case 1: {
                        StartElement se = event.asStartElement();
                        this.handleStartElement(se, resource);
                        break;
                    }
                    case 2: {
                        EndElement end = event.asEndElement();
                        this.handleEndElement(end);
                        break;
                    }
                }
            }
            reader.close();
            writer.close();
        }
        catch (XMLStreamException ex) {
            this.logger.error("Failed to parse XLIFF for ITS annotations", ex);
        }
        catch (IOException ex) {
            this.logger.error("Failed to create temporary file for copy of XLIFF Filter InputStream.", ex);
        }
        this.parsedFiles.add(resource);
        return tmpFile;
    }

    private void handleStartElement(StartElement se, String resource) {
        Iterator attrs = se.getAttributes();
        String namespace = se.getName().getPrefix();
        String tagName = se.getName().getLocalPart();
        if (namespace.equals("its")) {
            if ("locQualityIssues".equals(tagName)) {
                this.currentLQICollection = new ITSLQICollection(attrs, resource);
            } else if ("locQualityIssue".equals(tagName)) {
                this.currentLQICollection.addLQI(attrs);
            } else if ("provenanceRecords".equals(tagName)) {
                this.currentProvCollection = new ITSProvenanceCollection(attrs, resource);
            } else if ("provenanceRecord".equals(tagName)) {
                this.currentProvCollection.addProv(attrs);
            }
        }
    }

    private void handleEndElement(EndElement end) {
        String namespace = end.getName().getPrefix();
        String tagName = end.getName().getLocalPart();
        if (namespace.equals("its")) {
            if ("locQualityIssues".equals(tagName)) {
                this.dataStore.save(this.currentLQICollection);
            } else if ("provenanceRecords".equals(tagName)) {
                this.dataStore.save(this.currentProvCollection);
            }
        }
    }

    public <T extends GenericAnnotations> void addLQIAnnotation(T anns, String uri) {
        ITSLQICollection results = this.dataStore.getLQIByURI(uri);
        if (results != null) {
            anns.setData(results.getURI());
            Iterator<ITSLQI> collection = results.iterator();
            while (collection.hasNext()) {
                ITSLQI lqi = collection.next();
                anns.add(lqi.getAnnotation());
            }
        } else {
            this.logger.warn("Failed to resolve LQI reference for '{}'.", (Object)uri);
        }
    }

    public <T extends GenericAnnotations> void addProvAnnotation(T anns, String uri) {
        ITSProvenanceCollection results = this.dataStore.getProvByURI(uri);
        if (results != null) {
            anns.setData(results.getURI());
            Iterator<ITSProvenance> collection = results.iterator();
            while (collection.hasNext()) {
                ITSProvenance prov = collection.next();
                GenericAnnotation ann = anns.add("its-prov");
                if (prov.getPerson() != null) {
                    ann.setString("provPerson", prov.getPerson());
                }
                if (prov.getOrg() != null) {
                    ann.setString("provOrg", prov.getOrg());
                }
                if (prov.getTool() != null) {
                    ann.setString("provTool", prov.getTool());
                }
                if (prov.getRevPerson() != null) {
                    ann.setString("provRevPerson", prov.getRevPerson());
                }
                if (prov.getRevOrg() != null) {
                    ann.setString("provRevOrg", prov.getRevOrg());
                }
                if (prov.getRevTool() != null) {
                    ann.setString("provRevTool", prov.getRevTool());
                }
                if (prov.getProvRef() == null) continue;
                ann.setString("provRef", prov.getProvRef());
            }
        } else {
            this.logger.warn("Failed to resolve ITS Provenance reference for '{}'.", (Object)uri);
        }
    }

    public boolean alreadyParsed(String resource) {
        return this.parsedFiles.contains(resource);
    }

    public Collection<String> getStoredLQIRefs() {
        return this.dataStore.getStoredLQIURIs();
    }

    public Collection<String> getStoredProvRefs() {
        return this.dataStore.getStoredProvURIs();
    }
}

