/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.omegat;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.okapi.common.Util;

public class DefaultOptions
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> options;
    final JRadioButton rdDefault;
    final JRadioButton rdCustom;
    final JTextField edPath;
    final JButton btGetPath;

    public DefaultOptions(final Dialog parent, final Map<String, String> options, String defaultConfigId) {
        super(parent, "Okapi Filter Options", true);
        this.setDefaultCloseOperation(2);
        this.options = options == null ? new HashMap<String, String>() : options;
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        OptionsListener optListner = new OptionsListener();
        this.rdDefault = new JRadioButton(String.format("Use the default filter settings (%s)", defaultConfigId));
        this.rdDefault.addActionListener(optListner);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(10, 10, 0, 10);
        cp.add((Component)this.rdDefault, c);
        this.rdCustom = new JRadioButton("Use the follwing filter parameters file:");
        this.rdCustom.addActionListener(optListner);
        c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 1;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 10);
        cp.add((Component)this.rdCustom, c);
        ButtonGroup grpOptions = new ButtonGroup();
        grpOptions.add(this.rdDefault);
        grpOptions.add(this.rdCustom);
        String path = options.get("useCustom");
        String def = options.get("useDefault");
        if (def == null || !def.equals("yes")) {
            if (Util.isEmpty(path)) {
                this.rdDefault.setSelected(true);
            } else {
                this.rdCustom.setSelected(true);
            }
        } else {
            this.rdDefault.setSelected(true);
        }
        JPanel pnlPath = new JPanel(new GridBagLayout());
        this.edPath = new JTextField();
        c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        pnlPath.add((Component)this.edPath, c);
        if (!Util.isEmpty(path)) {
            this.edPath.setText(path);
        }
        this.btGetPath = new JButton("...");
        this.btGetPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser dlg = new JFileChooser();
                dlg.setDialogTitle("Select a Filter Parameters File");
                dlg.setFileFilter(new FileNameExtensionFilter("Filter Parameters Files (*.fprm)", ".fprm".substring(1)));
                String path = DefaultOptions.this.edPath.getText();
                if (!Util.isEmpty(path)) {
                    dlg.setSelectedFile(new File(path));
                }
                if (dlg.showOpenDialog(null) == 0) {
                    DefaultOptions.this.edPath.setText(dlg.getSelectedFile().getAbsolutePath());
                }
            }
        });
        c = new GridBagConstraints();
        c.anchor = 22;
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 0, 0);
        pnlPath.add((Component)this.btGetPath, c);
        c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 10, 5, 10);
        cp.add((Component)pnlPath, c);
        optListner.actionPerformed(null);
        JPanel pnlAction = new JPanel(new GridLayout(1, 2, 5, 0));
        JButton btOK = new JButton("OK");
        btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultOptions.this.rdDefault.isSelected()) {
                    options.put("useDefault", "yes");
                }
                String path = DefaultOptions.this.edPath.getText();
                if (DefaultOptions.this.rdCustom.isSelected()) {
                    if (Util.isEmpty(path)) {
                        JOptionPane.showMessageDialog(parent, "You must specify a path.", "Missing Path", 0);
                        DefaultOptions.this.edPath.requestFocusInWindow();
                        return;
                    }
                    options.put("useDefault", "no");
                }
                options.put("useCustom", path);
                DefaultOptions.this.dispose();
            }
        });
        pnlAction.add(btOK);
        JButton btCancel = new JButton("Cancel");
        btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultOptions.this.dispose();
            }
        });
        pnlAction.add(btCancel);
        c = new GridBagConstraints();
        c.anchor = 22;
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 3;
        c.insets = new Insets(0, 10, 10, 10);
        cp.add((Component)pnlAction, c);
        this.pack();
        this.setMinimumSize(new Dimension(600, this.getSize().height));
        this.setMaximumSize(new Dimension(600, this.getSize().height));
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        if (this.rdDefault.isSelected()) {
            this.rdDefault.requestFocusInWindow();
        } else {
            this.rdCustom.requestFocusInWindow();
        }
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    class OptionsListener
    implements ActionListener {
        OptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DefaultOptions.this.edPath.setEnabled(DefaultOptions.this.rdCustom.isSelected());
            DefaultOptions.this.btGetPath.setEnabled(DefaultOptions.this.rdCustom.isSelected());
        }
    }
}

