/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.annotation.IssueAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.terminology.simpletb.SimpleTB;
import net.sf.okapi.lib.verification.BlacklistChecker;
import net.sf.okapi.lib.verification.BlacklistTB;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.LanguageToolConnector;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternItem;
import net.sf.okapi.lib.verification.TermChecker;

class QualityChecker {
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private List<PatternItem> patterns;
    private LanguageToolConnector ltConn;
    private TermChecker termChecker;
    private BlacklistChecker blacklistChecker;
    private Parameters params;
    private List<Issue> issues;
    private URI currentDocId;
    private String currentSubDocId;
    private List<String> sigList;
    private Pattern patDoubledWords;
    private String doubledWordExceptions;
    private CharsetEncoder encoder1;
    private CharsetEncoder encoder2;
    private Pattern extraCharsAllowed;
    private Pattern corruption;
    private boolean monolingual;
    private Pattern itsAllowedChars;
    private String itsAllowedCharsPattern;
    private static final Pattern WORDCHARS = Pattern.compile("[\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}\\p{Nd}]");

    QualityChecker() {
    }

    void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        Object ta;
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        this.params = params;
        this.issues = issues;
        this.patterns = params.getPatterns();
        for (PatternItem item : this.patterns) {
            if (!item.enabled) continue;
            item.compile();
        }
        this.ltConn = null;
        if (params.getCheckWithLT()) {
            this.ltConn = new LanguageToolConnector();
            this.ltConn.initialize(targetLocale, sourceLocale, params.getServerURL(), params.getTranslateLTMsg(), params.getLtBilingualMode(), params.getLtTranslationSource(), params.getLtTranslationTarget(), params.getLtTranslationServiceKey());
        }
        this.patDoubledWords = null;
        if (params.getDoubledWord()) {
            this.patDoubledWords = Pattern.compile("\\b([\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}\\p{Nd}]+)[\\t\\n\\f\\r\\p{Z}]+\\1\\b", 2);
            this.doubledWordExceptions = ";" + params.getDoubledWordExceptions().toLowerCase() + ";";
        }
        this.corruption = null;
        if (params.getCorruptedCharacters()) {
            this.corruption = Pattern.compile("\\u00C3[\\u00A4-\\u00B6]|\\u00C3\\u201E|\\u00C3\\u2026|\\u00C3\\u2013");
        }
        this.encoder1 = null;
        this.extraCharsAllowed = null;
        if (params.getCheckCharacters()) {
            String charsetName = params.getCharset();
            if (!Util.isEmpty(charsetName)) {
                this.encoder1 = Charset.forName(charsetName).newEncoder();
            }
            if (!params.getExtraCharsAllowed().isEmpty()) {
                this.extraCharsAllowed = Pattern.compile(params.getExtraCharsAllowed());
            }
        }
        this.encoder2 = null;
        this.itsAllowedChars = null;
        this.itsAllowedCharsPattern = "\u0000";
        this.termChecker = null;
        if (params.getCheckTerms()) {
            this.termChecker = new TermChecker();
            ta = new SimpleTB(this.srcLoc, this.trgLoc);
            ((SimpleTB)ta).guessAndImport(new File(params.getTermsPath()));
            this.termChecker.initialize((SimpleTB)ta, this.srcLoc, this.trgLoc, params.getStringMode(), params.getBetweenCodes());
        }
        this.blacklistChecker = null;
        if (params.getCheckBlacklist()) {
            this.blacklistChecker = new BlacklistChecker();
            ta = new BlacklistTB();
            ((BlacklistTB)ta).guessAndImport(new File(params.getBlacklistPath()));
            this.blacklistChecker.initialize((BlacklistTB)ta);
        }
    }

    void processStartDocument(StartDocument sd, List<String> sigList) {
        this.currentDocId = new File(sd.getName()).toURI();
        this.sigList = sigList;
        this.monolingual = !sd.isMultilingual();
        this.currentSubDocId = null;
    }

    void processStartSubDocument(StartSubDocument ssd) {
        this.currentSubDocId = ssd.getName();
        if (this.currentSubDocId == null) {
            this.currentSubDocId = ssd.getId();
        }
    }

    private boolean hasMeaningfullText(TextFragment frag) {
        return WORDCHARS.matcher(frag.getCodedText()).find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTextUnit(ITextUnit tu) {
        GenericAnnotations anns;
        Property prop;
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.trgLoc);
        this.harvestExistingAnnotations(srcCont, tu, false);
        this.harvestExistingAnnotations(trgCont, tu, true);
        if (this.params.getCheckStorageSize()) {
            this.checkStorageSize(tu, srcCont, true);
        }
        if (this.params.getCheckAllowedCharacters()) {
            this.checkITSAllowedChars(tu, srcCont, true);
        }
        if (trgCont == null) {
            if (!this.monolingual) {
                this.reportIssue(IssueType.MISSING_TARGETTU, tu, null, "Missing translation.", 0, -1, 0, -1, 100.0, srcCont.toString(), "", null);
                this.addAnnotation(tu.getSource(), null, IssueType.MISSING_TARGETTU, "Missing translation", 0, -1, 0, -1, 100.0, null);
            }
            return;
        }
        if (this.params.getCheckStorageSize()) {
            this.checkStorageSize(tu, trgCont, false);
        }
        if (this.params.getCheckAllowedCharacters()) {
            this.checkITSAllowedChars(tu, trgCont, false);
        }
        if (this.params.getScope() != 0 && ((prop = trgCont.getProperty("approved")) != null && prop.getValue().equals("yes") ? this.params.getScope() == 2 : this.params.getScope() == 1)) {
            return;
        }
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        Property prop2 = trgCont.getProperty("hashiddentext");
        if (prop2 != null) {
            try (Scanner scan = null;){
                scan = new Scanner(prop2.getValue());
                scan.useDelimiter(";");
                TextFragment tf = trgCont.getUnSegmentedContentCopy();
                int start = TextFragment.fromFragmentToString(tf, scan.nextInt());
                int end = TextFragment.fromFragmentToString(tf, scan.nextInt());
                this.reportIssue(IssueType.SUSPECT_PATTERN, tu, null, "Target content has at least one hidden part.", 0, -1, start, end, 100.0, srcCont.toString(), trgCont.toString(), null);
                this.addAnnotation(trgCont, null, IssueType.SUSPECT_PATTERN, "Target content has at least one hidden part.", 0, -1, start, end, 100.0, null);
            }
        }
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg = trgSegs.get(srcSeg.getId());
            if (trgSeg == null) {
                this.reportIssue(IssueType.MISSING_TARGETSEG, tu, srcSeg.getId(), "The source segment has no corresponding target segment.", 0, -1, 0, -1, 100.0, srcSeg.toString(), "", null);
                this.addAnnotation(srcCont, srcSeg.getId(), IssueType.MISSING_TARGETSEG, "The source segment has no corresponding target segment.", 0, -1, 0, -1, 100.0, null);
                continue;
            }
            if (this.params.getEmptyTarget() && trgSeg.text.isEmpty() && !srcSeg.text.isEmpty()) {
                this.reportIssue(IssueType.EMPTY_TARGETSEG, tu, srcSeg.getId(), "The target segment is empty, but its source is not empty.", 0, -1, 0, -1, 100.0, srcSeg.toString(), "", null);
                this.addAnnotation(srcCont, srcSeg.getId(), IssueType.EMPTY_TARGETSEG, "The target segment is empty, but its source is not empty.", 0, -1, 0, -1, 100.0, null);
                continue;
            }
            if (this.params.getEmptySource() && srcSeg.text.isEmpty() && !trgSeg.text.isEmpty()) {
                this.reportIssue(IssueType.EMPTY_SOURCESEG, tu, srcSeg.getId(), "The target segment is not empty, but its source is empty.", 0, -1, 0, -1, 100.0, srcSeg.toString(), "", null);
                this.addAnnotation(srcCont, srcSeg.getId(), IssueType.EMPTY_SOURCESEG, "The target segment is not empty, but its source is empty.", 0, -1, 0, -1, 100.0, null);
                continue;
            }
            if (this.params.getCodeDifference()) {
                this.checkInlineCodes(srcSeg, trgSeg, tu, trgCont);
            }
            if (this.params.getTargetSameAsSource() && (this.params.getTargetSameAsSourceForSameLanguage() || !this.srcLoc.sameLanguageAs(this.trgLoc)) && this.hasMeaningfullText(srcSeg.text) && srcSeg.text.compareTo(trgSeg.text, this.params.getTargetSameAsSourceWithCodes()) == 0) {
                boolean warn = true;
                if (this.patterns != null) {
                    for (PatternItem item : this.patterns) {
                        Matcher m;
                        String ctext = srcSeg.text.getCodedText();
                        if (!item.enabled || !item.target.equals("<same>") || !(m = item.getSourcePattern().matcher(ctext)).find()) continue;
                        warn = !ctext.equals(m.group());
                        break;
                    }
                }
                if (warn) {
                    this.reportIssue(IssueType.TARGET_SAME_AS_SOURCE, tu, srcSeg.getId(), "Translation is the same as the source.", 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), null);
                    this.addAnnotation(srcCont, srcSeg.getId(), IssueType.TARGET_SAME_AS_SOURCE, "Translation is the same as the source.", 0, -1, 0, -1, 50.0, null);
                }
            }
            if (this.params.getCheckPatterns()) {
                this.checkPatterns(srcSeg, trgSeg, tu);
            }
            if (this.termChecker != null && this.termChecker.verify(this.currentDocId, this.currentSubDocId, tu, srcSeg, trgSeg) > 0) {
                for (Issue issue : this.termChecker.getIssues()) {
                    this.reportIssue(issue, tu, srcSeg.toString(), trgSeg.toString(), null);
                    this.addAnnotation(srcCont, issue.getSegId(), issue.getIssueType(), issue.getMessage(), issue.getSourceStart(), issue.getSourceEnd(), issue.getTargetStart(), issue.getTargetEnd(), issue.getSeverity(), issue.getCodes());
                }
            }
            if (this.blacklistChecker != null && this.blacklistChecker.verify(this.currentDocId, this.currentSubDocId, tu, trgSeg) > 0) {
                for (Issue issue : this.blacklistChecker.getIssues()) {
                    this.reportIssue(issue, tu, srcSeg.toString(), trgSeg.toString(), null);
                    this.addAnnotation(srcCont, issue.getSegId(), issue.getIssueType(), issue.getMessage(), issue.getSourceStart(), issue.getSourceEnd(), issue.getTargetStart(), issue.getTargetEnd(), issue.getSeverity(), issue.getCodes());
                }
            }
            if (this.params.getCheckMaxCharLength() || this.params.getCheckMinCharLength() || this.params.getCheckAbsoluteMaxCharLength()) {
                this.checkLengths(srcSeg, trgSeg, tu);
            }
            this.checkSuspectPatterns(srcSeg, trgSeg, tu);
            if (this.ltConn == null || this.ltConn.checkSegment(this.currentDocId, this.currentSubDocId, srcSeg, trgSeg, tu) <= 0) continue;
            for (Issue issue : this.ltConn.getIssues()) {
                this.reportIssue(issue, tu, srcSeg.toString(), trgSeg.toString(), null);
                this.addAnnotation(srcCont, issue.getSegId(), issue.getIssueType(), issue.getMessage(), issue.getSourceStart(), issue.getSourceEnd(), issue.getTargetStart(), issue.getTargetEnd(), issue.getSeverity(), issue.getCodes());
                if (issue.getSourceEnd() != -99) continue;
                this.ltConn = null;
            }
        }
        for (Segment trgSeg : trgSegs) {
            Segment srcSeg = srcSegs.get(trgSeg.getId());
            if (srcSeg != null) continue;
            this.reportIssue(IssueType.EXTRA_TARGETSEG, tu, trgSeg.getId(), String.format("Extra target segment (id=%s).", trgSeg.getId()), 0, -1, 0, -1, 100.0, "", trgSeg.toString(), null);
            this.addAnnotation(trgCont, trgSeg.getId(), IssueType.EXTRA_TARGETSEG, String.format("Extra target segment (id=%s).", trgSeg.getId()), 0, -1, 0, -1, 100.0, null);
        }
        String srcOri = null;
        srcOri = srcCont.contentIsOneSegment() ? srcCont.toString() : srcCont.getUnSegmentedContentCopy().toText();
        String trgOri = null;
        trgOri = trgCont.contentIsOneSegment() ? trgCont.toString() : trgCont.getUnSegmentedContentCopy().toText();
        if (this.params.getCorruptedCharacters()) {
            this.checkCorruptedCharacters(srcOri, trgOri, tu, trgCont);
        }
        this.checkWhiteSpaces(srcOri, trgOri, tu);
        if (this.params.getCheckCharacters()) {
            this.checkCharacters(srcOri, trgOri, tu, trgCont);
        }
        if ((anns = srcCont.getAnnotation(GenericAnnotations.class)) != null) {
            anns.setData(Util.makeId(UUID.randomUUID().toString()));
        }
        if ((anns = trgCont.getAnnotation(GenericAnnotations.class)) != null) {
            anns.setData(Util.makeId(UUID.randomUUID().toString()));
        }
    }

    private void checkCharacters(String srcOri, String trgOri, ITextUnit tu, TextContainer trgCont) {
        StringBuilder badChars = new StringBuilder();
        int pos = -1;
        int badChar = 0;
        int count = 0;
        for (int i = 0; i < trgOri.length(); ++i) {
            Matcher m;
            char ch = trgOri.charAt(i);
            if (this.encoder1 == null ? this.extraCharsAllowed != null && (m = this.extraCharsAllowed.matcher(trgOri.subSequence(i, i + 1))).find() : this.encoder1.canEncode(ch) || this.extraCharsAllowed != null && (m = this.extraCharsAllowed.matcher(trgOri.subSequence(i, i + 1))).find()) continue;
            if (++count > 1) {
                if (badChars.indexOf(String.valueOf(ch)) != -1) continue;
                badChars.append(ch);
                continue;
            }
            pos = i;
            badChar = ch;
        }
        if (pos > -1) {
            if (count > 1) {
                this.reportIssue(IssueType.ALLOWED_CHARACTERS, tu, null, String.format("The character '%c' (U+%04X) is not allowed in the target text. Other forbidden characters found: ", badChar, badChar) + badChars.toString(), 0, -1, pos, pos + 1, 50.0, srcOri, trgOri, null);
                this.addAnnotation(trgCont, null, IssueType.ALLOWED_CHARACTERS, String.format("The character '%c' (U+%04X) is not allowed in the target text. Other forbidden characters found: ", badChar, badChar) + badChars.toString(), 0, -1, pos, pos + 1, 50.0, null);
            } else {
                this.reportIssue(IssueType.ALLOWED_CHARACTERS, tu, null, String.format("The character '%c' (U+%04X) is not allowed in the target text.", badChar, badChar), 0, -1, pos, pos + 1, 50.0, srcOri, trgOri, null);
                this.addAnnotation(trgCont, null, IssueType.ALLOWED_CHARACTERS, String.format("The character '%c' (U+%04X) is not allowed in the target text.", badChar, badChar), 0, -1, pos, pos + 1, 50.0, null);
            }
        }
    }

    private void harvestExistingAnnotations(TextContainer tc, ITextUnit tu, boolean isTarget) {
        if (tc == null) {
            return;
        }
        GenericAnnotations anns = tc.getAnnotation(GenericAnnotations.class);
        if (anns == null) {
            return;
        }
        List<GenericAnnotation> list = anns.getAnnotations("its-lqi");
        for (GenericAnnotation ann : list) {
            IssueAnnotation issue = ann instanceof IssueAnnotation ? (IssueAnnotation)ann : new IssueAnnotation(ann);
            this.reportIssue(issue.getIssueType(), tu, issue.getSegId(), issue.getComment(), issue.getSourceStart(), issue.getSourceEnd(), issue.getTargetStart(), issue.getTargetEnd(), Double.valueOf(issue.getSeverity()).intValue(), isTarget ? "" : tc.toString(), isTarget ? tc.toString() : "", issue.getCodesAsList());
        }
    }

    private ArrayList<Code> stripNoiseCodes(Segment seg) {
        ArrayList<Code> list = new ArrayList<Code>(seg.text.getCodes());
        Iterator<Code> iter = list.iterator();
        while (iter.hasNext()) {
            Code code = iter.next();
            if (this.params.getTypesToIgnore().indexOf(code.getType() + ";") == -1) continue;
            iter.remove();
        }
        return list;
    }

    private String buildCodeList(List<Code> list) {
        StringBuilder tmp = new StringBuilder();
        for (Code code : list) {
            if (tmp.length() > 0) {
                tmp.append(", ");
            }
            if (code.getData().isEmpty()) {
                tmp.append(code.getOuterData().replaceAll("></x>", "/>"));
                continue;
            }
            tmp.append("\"" + code.getData() + "\"");
        }
        return tmp.toString();
    }

    private void checkInlineCodes(Segment srcSeg, Segment trgSeg, ITextUnit tu, TextContainer trgCont) {
        Iterator<Code> iter;
        ArrayList<Code> srcList = this.stripNoiseCodes(srcSeg);
        ArrayList<Code> trgList = this.stripNoiseCodes(trgSeg);
        if (srcList.size() == 0 && trgList.size() == 0) {
            return;
        }
        String srcOC = this.buildOpenCloseSequence(srcList);
        String trgOC = this.buildOpenCloseSequence(trgList);
        boolean checkOC = true;
        Iterator<Code> srcIter = srcList.iterator();
        block0: while (srcIter.hasNext()) {
            Code srcCode = srcIter.next();
            Iterator<Code> trgIter = trgList.iterator();
            while (trgIter.hasNext()) {
                Code trgCode = trgIter.next();
                if (trgCode.getData().isEmpty() && srcCode.getData().isEmpty()) {
                    if (trgCode.getId() != srcCode.getId() || !trgCode.getType().equals(srcCode.getType())) continue;
                    trgIter.remove();
                    srcIter.remove();
                    continue block0;
                }
                if (!trgCode.getData().equals(srcCode.getData())) continue;
                trgIter.remove();
                srcIter.remove();
                continue block0;
            }
        }
        if (!srcList.isEmpty()) {
            iter = srcList.iterator();
            while (iter.hasNext()) {
                if (!this.params.missingCodesAllowed.contains(iter.next().getData())) continue;
                iter.remove();
            }
        }
        if (!srcList.isEmpty()) {
            this.reportIssue(IssueType.MISSING_CODE, tu, srcSeg.getId(), "Missing codes in the target: " + this.buildCodeList(srcList), 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), srcList);
            this.addAnnotation(trgCont, srcSeg.getId(), IssueType.MISSING_CODE, "Missing codes in the target: " + this.buildCodeList(srcList), 0, -1, 0, -1, 50.0, srcList);
            checkOC = false;
        }
        if (!trgList.isEmpty()) {
            iter = trgList.iterator();
            while (iter.hasNext()) {
                if (!this.params.extraCodesAllowed.contains(iter.next().getData())) continue;
                iter.remove();
            }
        }
        if (!trgList.isEmpty()) {
            this.reportIssue(IssueType.EXTRA_CODE, tu, srcSeg.getId(), "Extra codes in the target: " + this.buildCodeList(trgList), 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), trgList);
            this.addAnnotation(trgCont, srcSeg.getId(), IssueType.MISSING_CODE, "Extra codes in the target: " + this.buildCodeList(trgList), 0, -1, 0, -1, 50.0, srcList);
            checkOC = false;
        }
        if (checkOC) {
            int j = 0;
            boolean done = false;
            for (int i = 0; i < srcOC.length(); ++i) {
                block16: {
                    if (srcOC.charAt(i) == 'p') continue;
                    while (true) {
                        if (trgOC.length() <= j) {
                            this.reportIssue(IssueType.SUSPECT_CODE, tu, srcSeg.getId(), "Suspect sequence of opening and closing target codes.", 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), trgList);
                            done = true;
                            break block16;
                        }
                        if (trgOC.charAt(j) != 'p') break;
                        ++j;
                    }
                    if (trgOC.charAt(j) != srcOC.charAt(i)) {
                        this.reportIssue(IssueType.SUSPECT_CODE, tu, srcSeg.getId(), String.format("Suspect sequence of opening and closing codes in the target (code %d).", i + 1), 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), trgList);
                        done = true;
                    } else {
                        ++j;
                    }
                }
                if (done) break;
            }
        }
    }

    private String buildOpenCloseSequence(ArrayList<Code> list) {
        StringBuilder sb = new StringBuilder();
        for (Code code : list) {
            switch (code.getTagType()) {
                case OPENING: {
                    sb.append("o");
                    break;
                }
                case CLOSING: {
                    sb.append("c");
                    break;
                }
                case PLACEHOLDER: {
                    String tmp = code.getData();
                    int ch = 112;
                    if (!Util.isEmpty(tmp) && this.params.getGuessOpenClose()) {
                        if (tmp.startsWith("</")) {
                            ch = 99;
                        } else if (tmp.startsWith("<")) {
                            ch = 111;
                        }
                        if (tmp.endsWith("/>")) {
                            ch = 112;
                        }
                    }
                    sb.append((char)ch);
                }
            }
        }
        return sb.toString();
    }

    private void checkCorruptedCharacters(String srcOri, String trgOri, ITextUnit tu, TextContainer trgCont) {
        Matcher m = this.corruption.matcher(trgOri);
        if (m.find()) {
            this.reportIssue(IssueType.SUSPECT_PATTERN, tu, null, String.format("Possible corrupted characters in the target (for example: \"%s\").", m.group()), 0, -1, m.start(), m.end(), 100.0, srcOri, trgOri, null);
            this.addAnnotation(trgCont, null, IssueType.SUSPECT_PATTERN, String.format("Possible corrupted characters in the target (for example: \"%s\").", m.group()), 0, -1, m.start(), m.end(), 100.0, null);
        }
    }

    private boolean isSpaceWeCareAbout(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    private void checkWhiteSpaces(String srcOri, String trgOri, ITextUnit tu) {
        if (this.params.getLeadingWS()) {
            int i;
            for (i = 0; i < srcOri.length() && this.isSpaceWeCareAbout(srcOri.charAt(i)); ++i) {
                if (srcOri.length() > i) {
                    if (trgOri.charAt(i) == srcOri.charAt(i)) continue;
                    this.reportIssue(IssueType.MISSINGORDIFF_LEADINGWS, tu, null, String.format("Missing or different leading white space at position %d.", i), i, i + 1, 0, -1, 1.0, srcOri, trgOri, null);
                    break;
                }
                this.reportIssue(IssueType.MISSING_LEADINGWS, tu, null, String.format("Missing leading white space at position %d.", i), i, i + 1, 0, -1, 1.0, srcOri, trgOri, null);
            }
            for (i = 0; i < trgOri.length() && this.isSpaceWeCareAbout(trgOri.charAt(i)); ++i) {
                if (srcOri.length() > i) {
                    if (srcOri.charAt(i) == trgOri.charAt(i)) continue;
                    this.reportIssue(IssueType.EXTRAORDIFF_LEADINGWS, tu, null, String.format("Extra or different leading white space at position %d.", i), 0, -1, i, i + 1, 1.0, srcOri, trgOri, null);
                    break;
                }
                this.reportIssue(IssueType.EXTRA_LEADINGWS, tu, null, String.format("Extra leading white space at position %d.", i), 0, -1, i, i + 1, 1.0, srcOri, trgOri, null);
            }
        }
        if (this.params.getTrailingWS()) {
            int i;
            int j = trgOri.length() - 1;
            for (i = srcOri.length() - 1; i >= 0 && this.isSpaceWeCareAbout(srcOri.charAt(i)); --i) {
                if (j >= 0) {
                    if (trgOri.charAt(j) != srcOri.charAt(i)) {
                        this.reportIssue(IssueType.MISSINGORDIFF_TRAILINGWS, tu, null, String.format("Missing or different trailing white space at position %d", i), i, i + 1, 0, -1, 1.0, srcOri, trgOri, null);
                        break;
                    }
                } else {
                    this.reportIssue(IssueType.MISSING_TRAILINGWS, tu, null, String.format("Missing trailing white space at position %d.", i), i, i + 1, 0, -1, 1.0, srcOri, trgOri, null);
                }
                --j;
            }
            j = srcOri.length() - 1;
            for (i = trgOri.length() - 1; i >= 0 && this.isSpaceWeCareAbout(trgOri.charAt(i)); --i) {
                if (j >= 0) {
                    if (srcOri.charAt(j) != trgOri.charAt(i)) {
                        this.reportIssue(IssueType.EXTRAORDIFF_TRAILINGWS, tu, null, String.format("Extra or different trailing white space at position %d.", i), 0, -1, i, i + 1, 1.0, srcOri, trgOri, null);
                        break;
                    }
                } else {
                    this.reportIssue(IssueType.EXTRA_TRAILINGWS, tu, null, String.format("Extra white trailing space at position %d.", i), 0, -1, i, i + 1, 1.0, srcOri, trgOri, null);
                }
                --j;
            }
        }
    }

    private void checkLengths(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        double d;
        int n;
        int srcLen = TextUnitUtil.getText(srcSeg.text, null).length();
        int trgLen = TextUnitUtil.getText(trgSeg.text, null).length();
        if (this.params.getCheckAbsoluteMaxCharLength() && trgLen > this.params.getAbsoluteMaxCharLength()) {
            n = trgLen - this.params.getAbsoluteMaxCharLength();
            this.reportIssue(IssueType.TARGET_LENGTH, tu, srcSeg.getId(), String.format("The target is longer than %d (by %d).", this.params.getAbsoluteMaxCharLength(), n), 0, -1, this.params.getAbsoluteMaxCharLength(), trgLen, 100.0, srcSeg.toString(), trgSeg.toString(), null);
        }
        if (this.params.getCheckMaxCharLength()) {
            if (srcLen <= this.params.getMaxCharLengthBreak()) {
                n = srcLen == 0 ? 0 : srcLen * this.params.getMaxCharLengthBelow() / 100;
            } else {
                int n2 = n = srcLen == 0 ? 0 : srcLen * this.params.getMaxCharLengthAbove() / 100;
            }
            if (trgLen > n) {
                d = (double)trgLen / (srcLen == 0 ? 1.0 : (double)srcLen) * 100.0;
                this.reportIssue(IssueType.TARGET_LENGTH, tu, srcSeg.getId(), String.format("The target is suspiciously longer than its source (%.2f%% of the source).", d), 0, -1, 0, -1, 1.0, srcSeg.toString(), trgSeg.toString(), null);
            }
        }
        if (this.params.getCheckMinCharLength()) {
            if (srcLen <= this.params.getMinCharLengthBreak()) {
                n = srcLen == 0 ? 0 : srcLen * this.params.getMinCharLengthBelow() / 100;
            } else {
                int n3 = n = srcLen == 0 ? 0 : srcLen * this.params.getMinCharLengthAbove() / 100;
            }
            if (trgSeg.text.getCodedText().length() < n) {
                d = (double)trgLen / (srcLen == 0 ? 1.0 : (double)srcLen) * 100.0;
                this.reportIssue(IssueType.TARGET_LENGTH, tu, srcSeg.getId(), String.format("The target is suspiciously shorter than its source (%.2f%% of the source).", d), 0, -1, 0, -1, 1.0, srcSeg.toString(), trgSeg.toString(), null);
            }
        }
    }

    private void checkStorageSize(ITextUnit tu, TextContainer tc, boolean isSource) {
        if (tc == null) {
            return;
        }
        GenericAnnotations anns = tc.getAnnotation(GenericAnnotations.class);
        if (anns == null) {
            return;
        }
        GenericAnnotation ga = anns.getFirstAnnotation("its-storagesize");
        if (ga == null) {
            return;
        }
        try {
            CharBuffer cbuf;
            int max = ga.getInteger("storagesizeSize");
            String enc = ga.getString("storagesizeEncoding");
            if (this.encoder2 == null || !this.encoder2.charset().name().equals(enc)) {
                this.encoder2 = Charset.forName(enc).newEncoder();
            }
            String lb = ga.getString("storagesizeLinebreak");
            TextFragment tf = tc.contentIsOneSegment() ? tc.getFirstContent() : tc.getUnSegmentedContentCopy();
            String tmp = TextUnitUtil.getText(tf);
            if (lb.equals("crlf")) {
                tmp = tmp.replaceAll("\n", "\r\n");
            }
            if (!this.encoder2.canEncode((CharSequence)(cbuf = CharBuffer.wrap(tmp)))) {
                this.reportIssue(isSource ? IssueType.SOURCE_LENGTH : IssueType.TARGET_LENGTH, tu, null, String.format("Cannot encode one or more characters of the %s using %s.", isSource ? "source" : "target", enc), 0, -1, 0, -1, 100.0, isSource ? tc.toString() : "N/A", isSource ? "N/A" : tc.toString(), null);
                this.addAnnotation(tc, null, isSource ? IssueType.SOURCE_LENGTH : IssueType.TARGET_LENGTH, String.format("Cannot encode one or more characters of the %s using %s.", isSource ? "source" : "target", enc), 0, -1, 0, -1, 100.0, null);
                return;
            }
            ByteBuffer buf = this.encoder2.encode(cbuf);
            int len = buf.limit();
            String bom = "";
            if (len > 2) {
                bom = bom + buf.get(0);
                if ((bom = bom + buf.get(1)).equals("-2-1") || bom.equals("-1-2")) {
                    len -= 2;
                }
                if (len > 3) {
                    bom = bom + buf.get(2);
                    if ((bom = bom + buf.get(3)).endsWith("00-2-1")) {
                        len -= 4;
                    } else if (bom.equals("-1-200")) {
                        len -= 2;
                    }
                }
            }
            if (len > max) {
                this.reportIssue(isSource ? IssueType.SOURCE_LENGTH : IssueType.TARGET_LENGTH, tu, null, String.format("Number of bytes in the %s (using %s) is: %d. Number allowed: %d.", isSource ? "source" : "target", enc, len, max), 0, -1, 0, -1, 100.0, isSource ? tc.toString() : "N/A", isSource ? "N/A" : tc.toString(), null);
                this.addAnnotation(tc, null, isSource ? IssueType.SOURCE_LENGTH : IssueType.TARGET_LENGTH, String.format("Number of bytes in the %s (using %s) is: %d. Number allowed: %d.", isSource ? "source" : "target", enc, len, max), 0, -1, 0, -1, 100.0, null);
            }
        }
        catch (Throwable e) {
            this.reportIssue(isSource ? IssueType.SOURCE_LENGTH : IssueType.TARGET_LENGTH, tu, null, "Problem when trying use use ITS storage size property: " + e.getMessage(), 0, -1, 0, -1, 100.0, isSource ? tc.toString() : "N/A", isSource ? "N/A" : tc.toString(), null);
        }
    }

    private void checkITSAllowedChars(ITextUnit tu, TextContainer tc, boolean isSource) {
        if (tc == null) {
            return;
        }
        GenericAnnotations anns = tc.getAnnotation(GenericAnnotations.class);
        if (anns == null) {
            return;
        }
        GenericAnnotation ga = anns.getFirstAnnotation("its-allowedchars");
        if (ga == null) {
            return;
        }
        try {
            TextFragment tf;
            String tmp;
            Matcher m;
            String pattern = ga.getString("allowedcharsValue");
            if (this.itsAllowedChars == null || !this.itsAllowedCharsPattern.equals(pattern)) {
                this.itsAllowedCharsPattern = pattern;
                if (pattern.startsWith("[^")) {
                    pattern = "[" + pattern.substring(2);
                } else if (pattern.startsWith("[")) {
                    pattern = "[^" + pattern.substring(1);
                } else {
                    throw new RuntimeException("Pattern should start with '[' or '[^'.");
                }
                this.itsAllowedChars = Pattern.compile(pattern);
            }
            if (!(m = this.itsAllowedChars.matcher(tmp = TextUnitUtil.getText(tf = tc.contentIsOneSegment() ? tc.getFirstContent() : tc.getUnSegmentedContentCopy()))).find()) {
                return;
            }
            int ss = isSource ? TextFragment.fromFragmentToString(tf, m.start()) : 0;
            int ts = !isSource ? TextFragment.fromFragmentToString(tf, m.start()) : 0;
            int se = isSource ? TextFragment.fromFragmentToString(tf, m.end()) : -1;
            int te = !isSource ? TextFragment.fromFragmentToString(tf, m.end()) : -1;
            this.reportIssue(IssueType.ALLOWED_CHARACTERS, tu, null, String.format("Character not allowed: '%s' (pattern: '%s'", m.group(), this.itsAllowedCharsPattern), ss, se, ts, te, 100.0, isSource ? tc.toString() : "N/A", isSource ? "N/A" : tc.toString(), null);
            this.addAnnotation(tc, null, IssueType.ALLOWED_CHARACTERS, String.format("Character not allowed: '%s' (pattern: '%s'", m.group(), this.itsAllowedCharsPattern), ss, se, ts, te, 100.0, null);
        }
        catch (Throwable e) {
            this.reportIssue(IssueType.ALLOWED_CHARACTERS, tu, null, String.format("Error when trying to check ITS allowed characters pattern '%s'. " + e.getMessage(), this.itsAllowedCharsPattern), 0, -1, 0, -1, 100.0, isSource ? tc.toString() : "N/A", isSource ? "N/A" : tc.toString(), null);
        }
    }

    private void checkSuspectPatterns(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        String trgCText = trgSeg.text.getCodedText();
        if (this.params.getDoubledWord()) {
            Matcher m = this.patDoubledWords.matcher(trgCText);
            while (m.find()) {
                if (this.doubledWordExceptions.indexOf(";" + m.group(1).toLowerCase() + ";") != -1) continue;
                this.reportIssue(IssueType.SUSPECT_PATTERN, tu, srcSeg.getId(), String.format("Double word: \"%s\" found in the target.", m.group()), 0, -1, TextFragment.fromFragmentToString(trgSeg.text, m.start()), TextFragment.fromFragmentToString(trgSeg.text, m.end()), 100.0, srcSeg.toString(), trgSeg.toString(), null);
            }
        }
    }

    private void checkPatterns(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        String msg;
        boolean expectSame;
        boolean found;
        int end;
        int start;
        String srcCText = srcSeg.text.getCodedText();
        for (PatternItem item : this.patterns) {
            if (!item.enabled || !item.fromSource) continue;
            Matcher srcM = item.getSourcePattern().matcher(srcCText);
            StringBuilder trgCTextCopy = new StringBuilder(trgSeg.text.getCodedText());
            int from = 0;
            while (srcM.find(from)) {
                String srcPart = srcCText.substring(srcM.start(), srcM.end());
                start = 0;
                end = 0;
                found = false;
                expectSame = item.target.equals("<same>");
                if (expectSame) {
                    start = trgCTextCopy.indexOf(srcPart);
                    boolean bl = found = start != -1;
                    if (found) {
                        end = start + srcPart.length();
                    }
                } else {
                    Matcher trgM = item.getTargetPattern().matcher(trgCTextCopy);
                    found = trgM.find();
                    if (found) {
                        start = trgM.start();
                        end = trgM.end();
                    }
                }
                if (found) {
                    trgCTextCopy.delete(start, end);
                } else {
                    msg = expectSame ? String.format("The source part \"%s\" is not in the target", srcPart) : String.format("The source part \"%s\" has no correspondance in the target", srcPart);
                    if (!Util.isEmpty(item.description)) {
                        msg = msg + " (from rule: " + item.description + ").";
                    }
                    this.reportIssue(IssueType.UNEXPECTED_PATTERN, tu, srcSeg.getId(), msg, TextFragment.fromFragmentToString(srcSeg.text, srcM.start()), TextFragment.fromFragmentToString(srcSeg.text, srcM.end()), 0, -1, item.severity, srcSeg.toString(), trgSeg.toString(), null);
                    this.addAnnotation(tu.getSource(), null, IssueType.UNEXPECTED_PATTERN, msg, TextFragment.fromFragmentToString(srcSeg.text, srcM.start()), TextFragment.fromFragmentToString(srcSeg.text, srcM.end()), 0, -1, item.severity, null);
                }
                from = srcM.end();
            }
        }
        String trgCText = trgSeg.text.getCodedText();
        for (PatternItem item : this.patterns) {
            if (!item.enabled || item.fromSource) continue;
            Matcher trgM = item.getTargetPattern().matcher(trgCText);
            StringBuilder srcCTextCopy = new StringBuilder(srcSeg.text.getCodedText());
            while (trgM.find()) {
                String trgPart = trgCText.substring(trgM.start(), trgM.end());
                start = 0;
                end = 0;
                found = false;
                expectSame = item.source.equals("<same>");
                if (expectSame) {
                    start = srcCTextCopy.indexOf(trgPart);
                    boolean bl = found = start != -1;
                    if (found) {
                        end = start + trgPart.length();
                    }
                } else {
                    Matcher srcM = item.getSourcePattern().matcher(srcCTextCopy);
                    found = srcM.find();
                    if (found) {
                        start = srcM.start();
                        end = srcM.end();
                    }
                }
                if (found) {
                    srcCTextCopy.delete(start, end);
                    continue;
                }
                msg = expectSame ? String.format("The target part \"%s\" is not in the source.", trgPart) : String.format("The target part \"%s\" has no correspondance in the source.", trgPart);
                this.reportIssue(IssueType.UNEXPECTED_PATTERN, tu, srcSeg.getId(), msg, 0, -1, TextFragment.fromFragmentToString(trgSeg.text, trgM.start()), TextFragment.fromFragmentToString(trgSeg.text, trgM.end()), item.severity, srcSeg.toString(), trgSeg.toString(), null);
            }
        }
    }

    private void addAnnotation(TextContainer tc, String segId, IssueType issueType, String comment, int srcStart, int srcEnd, int trgStart, int trgEnd, double severity, List<Code> codes) {
        IssueAnnotation ann = new IssueAnnotation(issueType, comment, severity, segId, srcStart, srcEnd, trgStart, trgEnd, codes);
        ITSLQIAnnotations.addAnnotations(tc, ann);
    }

    private void reportIssue(IssueType issueType, ITextUnit tu, String segId, String message, int srcStart, int srcEnd, int trgStart, int trgEnd, double severity, String srcOri, String trgOri, List<Code> codes) {
        Issue issue = new Issue(this.currentDocId, this.currentSubDocId, issueType, tu.getId(), segId, message, srcStart, srcEnd, trgStart, trgEnd, severity, tu.getName());
        issue.setCodes(codes);
        this.issues.add(issue);
        issue.setEnabled(true);
        issue.setSource(srcOri);
        issue.setTarget(trgOri);
        if (this.sigList != null) {
            issue.setEnabled(!this.sigList.contains(issue.getSignature()));
        }
    }

    private void reportIssue(Issue init, ITextUnit tu, String srcOri, String trgOri, Object extra) {
        Issue issue = new Issue(this.currentDocId, this.currentSubDocId, init.getIssueType(), tu.getId(), init.getSegId(), init.getMessage(), init.getSourceStart(), init.getSourceEnd(), init.getTargetStart(), init.getTargetEnd(), init.getSeverity(), tu.getName());
        issue.setCodes(init.getCodes());
        this.issues.add(issue);
        issue.setEnabled(true);
        issue.setSource(srcOri);
        issue.setTarget(trgOri);
        if (this.sigList != null) {
            issue.setEnabled(!this.sigList.contains(issue.getSignature()));
        }
    }
}

