/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.formatconversion;

import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.Util;

public class TableFilterWriterParameters
extends StringParameters {
    public static final String INLINE_ORIGINAL = "original";
    public static final String INLINE_TMX = "tmx";
    public static final String INLINE_XLIFF = "xliff";
    public static final String INLINE_XLIFFGX = "xliffgx";
    public static final String INLINE_GENERIC = "generic";
    static final String INLINEFORMAT = "inlineFormat";
    static final String USEDOUBLEQUOTES = "useDoubleQuotes";
    static final String SEPARATOR = "separator";

    public String getInlineFormat() {
        return this.getString(INLINEFORMAT);
    }

    public void setInlineFormat(String inlineFormat) {
        this.setString(INLINEFORMAT, inlineFormat);
    }

    public boolean getUseDoubleQuotes() {
        return this.getBoolean(USEDOUBLEQUOTES);
    }

    public void setUseDoubleQuotes(boolean useDoubleQuotes) {
        this.setBoolean(USEDOUBLEQUOTES, useDoubleQuotes);
    }

    public String getSeparator() {
        return this.getString(SEPARATOR);
    }

    public void setSeparator(String separator) {
        this.setString(SEPARATOR, separator);
    }

    @Override
    public void reset() {
        super.reset();
        this.setInlineFormat(INLINE_ORIGINAL);
        this.setUseDoubleQuotes(false);
        this.setSeparator("\t");
    }

    public void fromArguments(String format, String inlineFormat) {
        if (!Util.isEmpty(format)) {
            if (format.equals("csv")) {
                this.setSeparator(",");
                this.setUseDoubleQuotes(true);
            } else if (format.equals("tab")) {
                this.setSeparator("\t");
                this.setUseDoubleQuotes(false);
            } else {
                throw new RuntimeException(String.format("Invalid option '%s' in format options.", format));
            }
        }
        if (!Util.isEmpty(inlineFormat)) {
            if (inlineFormat.equals(INLINE_GENERIC) || inlineFormat.equals(INLINE_TMX) || inlineFormat.equals(INLINE_XLIFF) || inlineFormat.equals(INLINE_XLIFFGX) || inlineFormat.equals(INLINE_ORIGINAL)) {
                this.setInlineFormat(inlineFormat);
            } else {
                throw new RuntimeException(String.format("Invalid option '%s' in codes options.", inlineFormat));
            }
        }
    }
}

