/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.omegat;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Options
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String PLACEHOLDERMODE = "placeholderMode";
    private static final String ALLOWSEGMENTATION = "allowSegmentation";
    private static final String INCLUDEPOSTPROCESSINGHOOK = "includePostProcessingHook";
    private static final String CUSTOMPOSTPROCESSINGHOOK = "customPostProcessingHook";

    @Override
    public void reset() {
        super.reset();
        this.setPlaceholderMode(true);
        this.setAllowSegmentation(true);
        this.setIncludePostProcessingHook(true);
        this.setCustomPostProcessingHook("");
    }

    public boolean getPlaceholderMode() {
        return this.getBoolean(PLACEHOLDERMODE);
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.setBoolean(PLACEHOLDERMODE, placeholderMode);
    }

    public boolean getAllowSegmentation() {
        return this.getBoolean(ALLOWSEGMENTATION);
    }

    public boolean getIncludePostProcessingHook() {
        return this.getBoolean(INCLUDEPOSTPROCESSINGHOOK);
    }

    public String getCustomPostProcessingHook() {
        return this.getString(CUSTOMPOSTPROCESSINGHOOK);
    }

    public void setAllowSegmentation(boolean allowSegmentation) {
        this.setBoolean(ALLOWSEGMENTATION, allowSegmentation);
    }

    public void setIncludePostProcessingHook(boolean includePostProcessingHook) {
        this.setBoolean(INCLUDEPOSTPROCESSINGHOOK, includePostProcessingHook);
    }

    public void setCustomPostProcessingHook(String customPostProcessingHook) {
        this.setString(CUSTOMPOSTPROCESSINGHOOK, customPostProcessingHook);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PLACEHOLDERMODE, "Use <g></g> and <x/> notation", null);
        desc.add(ALLOWSEGMENTATION, "Allow segmentation in the OmegaT project", "Allow or not segmentation in the project. Ignored if there is a segmentation step.");
        desc.add(INCLUDEPOSTPROCESSINGHOOK, "Include post-processing hook", "Set up the project so that OmegaT's \"Create Translated Documents\" command will automatically trigger Okapi's Translation Kit Post-Processing pipeline.");
        desc.add(CUSTOMPOSTPROCESSINGHOOK, "Custom hook", "A custom CLI command to be used as the post-processing hook (leave blank to use default hook).");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("OmegaT Project", true, false);
        desc.addCheckboxPart(paramsDesc.get(PLACEHOLDERMODE));
        desc.addCheckboxPart(paramsDesc.get(ALLOWSEGMENTATION));
        desc.addCheckboxPart(paramsDesc.get(INCLUDEPOSTPROCESSINGHOOK));
        desc.addTextInputPart(paramsDesc.get(CUSTOMPOSTPROCESSINGHOOK)).setAllowEmpty(true);
        return desc;
    }
}

