/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.opc;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;

public class OPCPackageUtil {
    public static List<PackagePart> getCoreParts(OPCPackage pack) {
        ArrayList<PackagePart> res = new ArrayList<PackagePart>();
        for (PackageRelationship rel : pack.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument")) {
            try {
                res.add(pack.getPart(PackagingURIHelper.createPartName(rel.getTargetURI())));
            }
            catch (InvalidFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return res;
    }

    public static PackagePart getCorePart(OPCPackage pack) {
        ArrayList<PackagePart> res = new ArrayList<PackagePart>();
        for (PackageRelationship rel : pack.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument")) {
            try {
                res.add(pack.getPart(PackagingURIHelper.createPartName(rel.getTargetURI())));
            }
            catch (InvalidFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return res.size() > 0 ? (PackagePart)res.get(0) : null;
    }

    private static PackagePart getPartByRelationshipType(PackagePart part, String relationshipType) {
        try {
            PackageRelationshipCollection rels = part.getRelationshipsByType(relationshipType);
            if (rels.size() == 0) {
                return null;
            }
            OPCPackage pack = part.getPackage();
            return pack.getPart(PackagingURIHelper.createPartName(rels.getRelationship(0).getTargetURI()));
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static PackagePart getSourcePart(PackagePart part) {
        return OPCPackageUtil.getPartByRelationshipType(part, "http://schemas.okapi.org/2010/relationships/source");
    }

    public static PackagePart getResourcesPart(PackagePart part) {
        return OPCPackageUtil.getPartByRelationshipType(part, "http://schemas.okapi.org/2010/relationships/resources");
    }
}

