/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.reader;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    static final String GENERATE_TARGETS = "generateTargets";
    static final String USE_APPROVED_ONLY = "useApprovedOnly";
    static final String UPDATE_APPROVED_FLAG = "updateApprovedFlag";
    static final String GROUP_BY_PACKAGE_PATH = "groupByPackagePath";

    @Override
    public void reset() {
        super.reset();
        this.setGenerateTargets(true);
        this.setUseApprovedOnly(false);
        this.setUpdateApprovedFlag(true);
        this.setGroupByPackagePath(true);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(GENERATE_TARGETS, "Generate target files in the output directory", "Generate targets");
        desc.add(USE_APPROVED_ONLY, "Update target only if translation was approved", "Use only approved translation");
        desc.add(UPDATE_APPROVED_FLAG, "Update the approved flag if translation was approved", "Update approved flag");
        desc.add(GROUP_BY_PACKAGE_PATH, "Group target files by their paths in the package", "Group targets");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("XLIFF Kit Reader Options", true, false);
        desc.addCheckboxPart(parametersDescription.get(GENERATE_TARGETS));
        desc.addCheckboxPart(parametersDescription.get(USE_APPROVED_ONLY));
        desc.addCheckboxPart(parametersDescription.get(UPDATE_APPROVED_FLAG));
        desc.addCheckboxPart(parametersDescription.get(GROUP_BY_PACKAGE_PATH));
        return desc;
    }

    public void setGenerateTargets(boolean generateTargets) {
        this.setBoolean(GENERATE_TARGETS, generateTargets);
    }

    public boolean isGenerateTargets() {
        return this.getBoolean(GENERATE_TARGETS);
    }

    public void setUseApprovedOnly(boolean useApprovedOnly) {
        this.setBoolean(USE_APPROVED_ONLY, useApprovedOnly);
    }

    public boolean isUseApprovedOnly() {
        return this.getBoolean(USE_APPROVED_ONLY);
    }

    public void setUpdateApprovedFlag(boolean updateApprovedFlag) {
        this.setBoolean(UPDATE_APPROVED_FLAG, updateApprovedFlag);
    }

    public boolean isUpdateApprovedFlag() {
        return this.getBoolean(UPDATE_APPROVED_FLAG);
    }

    public boolean isGroupByPackagePath() {
        return this.getBoolean(GROUP_BY_PACKAGE_PATH);
    }

    public void setGroupByPackagePath(boolean groupByPackagePath) {
        this.setBoolean(GROUP_BY_PACKAGE_PATH, groupByPackagePath);
    }
}

