/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.writer;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.steps.xliffkit.writer.XLIFFKitWriterStep;

@EditorFor(value=XLIFFKitWriterStep.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    static final String PLACEHOLDERMODE = "placeholderMode";
    static final String COPYSOURCE = "copySource";
    static final String MESSAGE = "message";
    static final String INCLUDE_NO_TRANSLATE = "includeNoTranslate";
    static final String SET_APPROVED_AS_NO_TRANSLATE = "setApprovedAsNoTranslate";
    static final String OUTPUT_URI = "outputURI";
    static final String INCLUDE_SOURCE = "includeSource";
    static final String INCLUDE_ORIGINAL = "includeOriginal";
    static final String INCLUDE_CODE_ATTRS = "includeCodeAttrs";

    @Override
    public void reset() {
        super.reset();
        this.setPlaceholderMode(false);
        this.setCopySource(true);
        this.setIncludeNoTranslate(true);
        this.setSetApprovedAsNoTranslate(true);
        this.setMessage("");
        this.setOutputURI("");
        this.setIncludeSource(true);
        this.setIncludeOriginal(false);
        this.setIncludeCodeAttrs(false);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        if (!this.isIncludeNoTranslate()) {
            this.setSetApprovedAsNoTranslate(false);
        }
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PLACEHOLDERMODE, "Use the <g></g> and <x/> notation", null);
        desc.add(COPYSOURCE, "Copy source text in target if no target is available", null);
        desc.add(INCLUDE_NO_TRANSLATE, "Include non-translatable text units", "Include non-translatables");
        desc.add(SET_APPROVED_AS_NO_TRANSLATE, "Set approved entries as non-translatable", "Approved as non-translatable");
        desc.add(MESSAGE, "Description of the XLIFF file", "Description");
        desc.add(OUTPUT_URI, "Directory of the T-kit file", "T-kit Path");
        desc.add(INCLUDE_SOURCE, "Include source files in the T-kit file", "Include source");
        desc.add(INCLUDE_ORIGINAL, "Include original files in the T-kit file", "Include originals");
        desc.add(INCLUDE_CODE_ATTRS, "Include original files in the T-kit file", "Include originals");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("XLIFF Kit Writer Options", true, false);
        desc.addCheckboxPart(parametersDescription.get(PLACEHOLDERMODE));
        desc.addCheckboxPart(parametersDescription.get(COPYSOURCE));
        desc.addCheckboxPart(parametersDescription.get(INCLUDE_NO_TRANSLATE));
        desc.addCheckboxPart(parametersDescription.get(SET_APPROVED_AS_NO_TRANSLATE));
        desc.addTextInputPart(parametersDescription.get(MESSAGE));
        desc.addTextInputPart(parametersDescription.get(OUTPUT_URI));
        desc.addCheckboxPart(parametersDescription.get(INCLUDE_SOURCE));
        desc.addCheckboxPart(parametersDescription.get(INCLUDE_ORIGINAL));
        desc.addCheckboxPart(parametersDescription.get(INCLUDE_CODE_ATTRS));
        return desc;
    }

    public boolean isPlaceholderMode() {
        return this.getBoolean(PLACEHOLDERMODE);
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.setBoolean(PLACEHOLDERMODE, placeholderMode);
    }

    public boolean isIncludeNoTranslate() {
        return this.getBoolean(INCLUDE_NO_TRANSLATE);
    }

    public void setIncludeNoTranslate(boolean includeNoTranslate) {
        this.setBoolean(INCLUDE_NO_TRANSLATE, includeNoTranslate);
    }

    public boolean isSetApprovedAsNoTranslate() {
        return this.getBoolean(SET_APPROVED_AS_NO_TRANSLATE);
    }

    public void setSetApprovedAsNoTranslate(boolean setApprovedAsNoTranslate) {
        this.setBoolean(SET_APPROVED_AS_NO_TRANSLATE, setApprovedAsNoTranslate);
    }

    public String getMessage() {
        return this.getString(MESSAGE);
    }

    public void setMessage(String message) {
        this.setString(MESSAGE, message);
    }

    public String getOutputURI() {
        return this.getString(OUTPUT_URI);
    }

    public void setOutputURI(String outputURI) {
        this.setString(OUTPUT_URI, outputURI);
    }

    public boolean isIncludeSource() {
        return this.getBoolean(INCLUDE_SOURCE);
    }

    public void setIncludeSource(boolean includeSource) {
        this.setBoolean(INCLUDE_SOURCE, includeSource);
    }

    public boolean isIncludeOriginal() {
        return this.getBoolean(INCLUDE_ORIGINAL);
    }

    public void setIncludeOriginal(boolean includeOriginal) {
        this.setBoolean(INCLUDE_ORIGINAL, includeOriginal);
    }

    public void setCopySource(boolean copySource) {
        this.setBoolean(COPYSOURCE, copySource);
    }

    public boolean isCopySource() {
        return this.getBoolean(COPYSOURCE);
    }

    public void setIncludeCodeAttrs(boolean includeCodeAttrs) {
        this.setBoolean(INCLUDE_CODE_ATTRS, includeCodeAttrs);
    }

    public boolean isIncludeCodeAttrs() {
        return this.getBoolean(INCLUDE_CODE_ATTRS);
    }
}

