/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtElements;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.InvalidMarkerOrderException;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Notes;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Tags;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.lang.Language;

public class Util {
    private static final String VBAR = "|";

    public static boolean isNoE(String string) {
        return string == null || string.isEmpty();
    }

    public static String toXML(String text, boolean attribute) {
        if (text == null) {
            return "null";
        }
        StringBuilder tmp = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '&') {
                tmp.append("&amp;");
                continue;
            }
            if (ch == '<') {
                tmp.append("&lt;");
                continue;
            }
            if (attribute && ch == '\"') {
                tmp.append("&quot;");
                continue;
            }
            tmp.append(ch);
        }
        return tmp.toString();
    }

    public static String toSafeXML(String text) {
        if (text == null) {
            return "null";
        }
        StringBuilder tmp = new StringBuilder(text.length());
        block5: for (int i = 0; i < text.length(); ++i) {
            int cp = text.codePointAt(i);
            switch (cp) {
                case 38: {
                    tmp.append("&amp;");
                    continue block5;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block5;
                }
                case 9: 
                case 10: 
                case 13: {
                    tmp.append((char)cp);
                    continue block5;
                }
                default: {
                    if (cp > 31 && cp < 55296) {
                        tmp.append((char)cp);
                        continue block5;
                    }
                    if (cp > 55295) {
                        if (cp < 57344 || cp == 65534 || cp == 65535) {
                            tmp.append(String.format("<cp hex=\"%04X\"/>", cp));
                            continue block5;
                        }
                        tmp.append(Character.toChars(cp));
                        ++i;
                        continue block5;
                    }
                    tmp.append(String.format("<cp hex=\"%04X\"/>", cp));
                    continue block5;
                }
            }
        }
        return tmp.toString();
    }

    public static int compareAllowingNull(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean checkValueList(String allowedValues, String value, String name) {
        if (value == null) {
            return false;
        }
        if ((";" + allowedValues + ";").indexOf(";" + value + ";") == -1) {
            throw new InvalidParameterException(String.format("The value '%s' is not allowed for '%s'.", value, name));
        }
        return true;
    }

    public static List<String> createFixedSequences(List<CTag> list, boolean errorOnMissingFirstNo) {
        ArrayList<String> sequences = new ArrayList<String>();
        StringBuilder tmp = new StringBuilder();
        boolean inSeq = false;
        int count = 0;
        block10: for (int i = 0; i < list.size(); ++i) {
            CTag c = list.get(i);
            String candidate = (c.getTagType() == TagType.CLOSING ? "c" : "z") + c.getId() + VBAR;
            if (inSeq) {
                switch (c.getCanReorder()) {
                    case YES: {
                        sequences.add(tmp.toString());
                        if (count == 1) {
                            // empty if block
                        }
                        inSeq = false;
                        break;
                    }
                    case FIRSTNO: {
                        sequences.add(tmp.toString());
                        if (count == 1) {
                            // empty if block
                        }
                        tmp.setLength(0);
                        count = 0;
                    }
                    case NO: {
                        tmp.append(candidate);
                        ++count;
                    }
                }
                continue;
            }
            switch (c.getCanReorder()) {
                case YES: {
                    continue block10;
                }
                case NO: {
                    if (errorOnMissingFirstNo) {
                        throw new InvalidParameterException(String.format("Marker id='%s' in has canReorder='no' but starts a sequence and should have canReorder='firstNo'.", c.getId()));
                    }
                }
                case FIRSTNO: {
                    tmp.setLength(0);
                    tmp.append(candidate);
                    count = 1;
                    inSeq = true;
                }
            }
        }
        if (inSeq) {
            sequences.add(tmp.toString());
            if (count == 1) {
                // empty if block
            }
        }
        return sequences;
    }

    public static void verifyReordering(List<CTag> original, List<CTag> toVerify, boolean errorOnMissingFirstNo) {
        List<String> oriSequences = Util.createFixedSequences(original, errorOnMissingFirstNo);
        List<String> newSequences = Util.createFixedSequences(toVerify, errorOnMissingFirstNo);
        for (int i = 0; i < oriSequences.size(); ++i) {
            String ori = oriSequences.get(i);
            if (!newSequences.contains(ori)) {
                String startId = ori.substring(1, ori.indexOf(VBAR));
                throw new InvalidMarkerOrderException(String.format("The sequence of inline codes that cannot be re-ordered starting with the tag id='%s' has been modified.", startId));
            }
            newSequences.remove(ori);
        }
    }

    public static boolean isValidNmtoken(String value) {
        int cp;
        if (Util.isNoE(value)) {
            return false;
        }
        int length = value.length();
        block3: for (int i = 0; i < length; i += Character.charCount(cp)) {
            cp = value.codePointAt(i);
            switch (cp) {
                case 45: 
                case 46: 
                case 58: 
                case 95: 
                case 183: {
                    continue block3;
                }
                default: {
                    if (cp >= 65 && cp <= 90 || cp >= 97 && cp <= 122 || cp >= 48 && cp <= 57 || cp >= 192 && cp <= 214 || cp >= 216 && cp <= 246 || cp >= 248 && cp <= 767 || cp >= 880 && cp <= 893 || cp >= 895 && cp <= 8191 || cp >= 8204 && cp <= 8205 || cp >= 8304 && cp <= 8591 || cp >= 11264 && cp <= 12271 || cp >= 12289 && cp <= 55295 || cp >= 63744 && cp <= 64975 || cp >= 65008 && cp <= 65533 || cp >= 768 && cp <= 879 || cp >= 8255 && cp <= 8256 || cp >= 65536 && cp <= 983039) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public static void removeExtensions(Object object) {
        Iterator<Object> iter;
        if (object instanceof IWithExtAttributes) {
            iter = ((IWithExtAttributes)object).getExtAttributes().iterator();
            while (iter.hasNext()) {
                ExtAttribute attr = (ExtAttribute)iter.next();
                if (attr.isModule()) continue;
                iter.remove();
            }
        }
        if (object instanceof IWithExtElements) {
            iter = ((IWithExtElements)object).getExtElements().iterator();
            while (iter.hasNext()) {
                ExtElement elem = (ExtElement)iter.next();
                if (elem.isModule()) continue;
                iter.remove();
            }
        }
        if (object instanceof IWithNotes) {
            Notes notes = ((IWithNotes)object).getNotes();
            Util.removeExtensions(notes);
            for (Note note : notes) {
                Util.removeExtensions(note);
            }
        }
        if (object instanceof Unit) {
            Unit unit = (Unit)object;
            Tags markers = unit.getStore().getSourceTags();
            for (Tag m : markers) {
                if (!m.isMarker()) continue;
                Util.removeExtensions(m);
            }
            markers = unit.getStore().getTargetTags();
            for (Tag m : markers) {
                if (!m.isMarker()) continue;
                Util.removeExtensions(m);
            }
        }
    }

    public static void removeModules(Object object, String moduleSuffix) {
        Iterator<Object> iter;
        if (object instanceof IWithExtAttributes) {
            iter = ((IWithExtAttributes)object).getExtAttributes().iterator();
            while (iter.hasNext()) {
                ExtAttribute attr = (ExtAttribute)iter.next();
                if (!Util.isModule(attr.getNamespaceURI(), moduleSuffix)) continue;
                iter.remove();
            }
        }
        if (object instanceof IWithExtElements) {
            iter = ((IWithExtElements)object).getExtElements().iterator();
            while (iter.hasNext()) {
                ExtElement elem = (ExtElement)iter.next();
                if (!Util.isModule(elem.getQName().getNamespaceURI(), moduleSuffix)) continue;
                iter.remove();
            }
        }
        if (object instanceof IWithNotes) {
            Notes notes = ((IWithNotes)object).getNotes();
            Util.removeModules(notes, moduleSuffix);
            for (Note note : notes) {
                Util.removeModules(note, moduleSuffix);
            }
        }
        if (object instanceof Unit) {
            Unit unit = (Unit)object;
            Tags tags = unit.getStore().getSourceTags();
            for (Tag m : tags) {
                if (!m.isMarker()) continue;
                Util.removeModules(m, moduleSuffix);
            }
            tags = unit.getStore().getTargetTags();
            for (Tag m : tags) {
                if (!m.isMarker()) continue;
                Util.removeModules(m, moduleSuffix);
            }
        }
    }

    public static boolean isModule(String nsUri, String moduleSuffix) {
        if (nsUri.startsWith("urn:oasis:names:tc:xliff:")) {
            if (moduleSuffix != null) {
                return nsUri.endsWith(moduleSuffix);
            }
            return true;
        }
        return false;
    }

    public static boolean isValidInXML(int cp) {
        if (cp > 31 && cp < 55296) {
            return true;
        }
        if (cp > 55295) {
            if (cp < 57344) {
                return false;
            }
            if (cp == 65534 || cp == 65535) {
                return false;
            }
            return cp <= 0x10FFFF;
        }
        switch (cp) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public static void validateCopyOf(Unit unit) {
        for (int i = 0; i < 2; ++i) {
            Tags tags;
            if (i == 0) {
                tags = unit.getStore().getSourceTags();
            } else {
                if (!unit.getStore().hasTargetTag()) break;
                tags = unit.getStore().getTargetTags();
            }
            for (Tag tag : tags) {
                CTag ctag;
                String copyRef;
                if (tag.isMarker() || (copyRef = (ctag = (CTag)tag).getCopyOf()) == null) continue;
                if (ctag.getDataRef() != null) {
                    throw new XLIFFException(String.format("Code id='%s' cannot, at the same time, be a copy of code id='%s' and have original data (data id='%s').", ctag.getId(), copyRef, ctag.getDataRef()));
                }
                CTag ori = (CTag)unit.getStore().getTag(copyRef, ctag.getTagType());
                if (ori == null) {
                    throw new XLIFFException(String.format("The code id='%s' is a copy of a code that does not exists (copyOf='%s').", ctag.getId(), copyRef));
                }
                if (ori.getCanCopy()) continue;
                throw new XLIFFException(String.format("The code id='%s' is a copy of a code that must not be copied (copyOf='%s').", ctag.getId(), copyRef));
            }
        }
    }

    public static String validateLang(String lang) {
        if (Util.isNoE(lang)) {
            return "Null or empty value.";
        }
        try {
            Language.THE_INSTANCE.checkValid(lang);
        }
        catch (Throwable e) {
            if (e.getMessage().startsWith("Warning:")) {
                return null;
            }
            return e.getMessage();
        }
        return null;
    }

    public static boolean supports(String nsUri) {
        switch (nsUri) {
            case "urn:oasis:names:tc:xliff:matches:2.0": 
            case "urn:oasis:names:tc:xliff:glossary:2.0": 
            case "urn:oasis:names:tc:xliff:metadata:2.0": 
            case "urn:oasis:names:tc:xliff:validation:2.0": 
            case "urn:oasis:names:tc:xliff:changetracking:2.0": {
                return true;
            }
        }
        return false;
    }
}

