/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.document.BeforeAndAfter;
import net.sf.okapi.lib.xliff2.document.EventIterator;
import net.sf.okapi.lib.xliff2.document.GroupNode;
import net.sf.okapi.lib.xliff2.document.GroupOrUnitNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.reader.URIContext;

public class FileNode
extends BeforeAndAfter {
    private StartFileData startData;
    private Skeleton skelData;
    private MidFileData midData;
    private LinkedHashMap<String, GroupOrUnitNode> nodes;

    public FileNode(StartFileData data) {
        this.startData = data;
        this.nodes = new LinkedHashMap();
    }

    public StartFileData getStartData() {
        return this.startData;
    }

    public void setMidData(MidFileData data) {
        this.midData = data;
    }

    public MidFileData getMidData() {
        return this.midData;
    }

    public void setSkeletonData(Skeleton data) {
        this.skelData = data;
    }

    public Skeleton getSkeletonData() {
        return this.skelData;
    }

    public UnitNode add(UnitNode node) {
        this.nodes.put("u" + node.get().getId(), node);
        return node;
    }

    public GroupNode add(GroupNode node) {
        String id = node.get().getId();
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        this.nodes.put("g" + id, node);
        return node;
    }

    public List<UnitNode> getUnitNodes() {
        ArrayList<UnitNode> unitNodes = new ArrayList<UnitNode>();
        for (String nodeKey : this.nodes.keySet()) {
            GroupOrUnitNode node = this.nodes.get(nodeKey);
            if (node.isUnit()) {
                unitNodes.add((UnitNode)node);
                continue;
            }
            GroupNode groupNode = (GroupNode)node;
            unitNodes.addAll(groupNode.getUnitNodes());
        }
        return unitNodes;
    }

    public UnitNode getUnitNode(String id) {
        UnitNode item = (UnitNode)this.nodes.get("u" + id);
        if (item != null) {
            return item;
        }
        for (GroupOrUnitNode node : this.nodes.values()) {
            if (node.isUnit() || (item = ((GroupNode)node).getUnitNode(id)) == null) continue;
            return item;
        }
        return null;
    }

    public GroupNode getGroupNode(String id) {
        GroupNode item = (GroupNode)this.nodes.get("g" + id);
        if (item != null) {
            return item;
        }
        for (GroupOrUnitNode node : this.nodes.values()) {
            if (node.isUnit() || (item = ((GroupNode)node).getGroupNode(id)) == null) continue;
            return item;
        }
        return null;
    }

    public Iterator<Event> createEventIterator(Stack<URIContext> uriContext) {
        EventIterator ei = new EventIterator(){
            private Iterator<GroupOrUnitNode> iter;
            private Iterator<Event> eventIter;
            private int state;
            {
                this.iter = FileNode.this.nodes.values().iterator();
                this.eventIter = null;
                this.state = 0;
            }

            @Override
            public boolean hasNext() {
                switch (this.state) {
                    case 0: {
                        return true;
                    }
                    case -1: {
                        return false;
                    }
                    case 1: {
                        if (FileNode.this.skelData != null) {
                            return true;
                        }
                        this.state = 2;
                    }
                    case 2: {
                        if (FileNode.this.midData != null) {
                            return true;
                        }
                        this.state = 3;
                    }
                }
                if (this.eventIter != null) {
                    if (this.eventIter.hasNext()) {
                        return true;
                    }
                    this.eventIter = null;
                }
                if (this.iter.hasNext()) {
                    return true;
                }
                this.state = 4;
                return true;
            }

            @Override
            public Event next() {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                        ((URIContext)this.uriContext.peek()).setFileId(FileNode.this.startData.getId());
                        return new Event(EventType.START_FILE, (URIContext)this.uriContext.peek(), FileNode.this.startData);
                    }
                    case 1: {
                        this.state = 2;
                        return new Event(EventType.SKELETON, (URIContext)this.uriContext.peek(), FileNode.this.skelData);
                    }
                    case 2: {
                        this.state = 3;
                        return new Event(EventType.MID_FILE, (URIContext)this.uriContext.peek(), FileNode.this.midData);
                    }
                    case 4: {
                        this.state = -1;
                        this.uriContext.pop();
                        return new Event(EventType.END_FILE, null);
                    }
                }
                if (this.eventIter != null) {
                    return this.eventIter.next();
                }
                GroupOrUnitNode node = this.iter.next();
                if (node.isUnit()) {
                    this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                    ((URIContext)this.uriContext.peek()).setUnitId(((UnitNode)node).get().getId());
                    Event event = new Event(EventType.TEXT_UNIT, (URIContext)this.uriContext.peek(), ((UnitNode)node).get());
                    this.uriContext.pop();
                    return event;
                }
                this.eventIter = ((GroupNode)node).createEventIterator(this.uriContext);
                this.eventIter.hasNext();
                return this.eventIter.next();
            }
        };
        ei.setURIContext(uriContext);
        return ei;
    }
}

