/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.document;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.lib.xliff2.URIParser;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.EventIterator;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.GroupNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.reader.URIContext;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriterException;

public class XLIFFDocument {
    private StartXliffData docData;
    private LinkedHashMap<String, FileNode> files;
    private File docFile;
    private String lb = System.getProperty("line.separator");

    public void load(File file) {
        this.load(file, null, null, 255);
    }

    public void load(File file, int validation) {
        this.load(file, null, null, validation);
    }

    public void load(URI inputURI, int validation) {
        this.load(null, inputURI, null, validation);
    }

    public void load(String input, int validation) {
        this.load(null, null, input, validation);
    }

    private void load(File file, URI inputURI, String input, int validation) {
        this.docFile = null;
        this.files = new LinkedHashMap();
        FileNode currentFile = null;
        GroupNode currentGroup = null;
        try (XLIFFReader reader = new XLIFFReader(validation);){
            if (file != null) {
                this.docFile = file;
                reader.open(file);
            } else if (inputURI != null) {
                reader.open(inputURI);
            } else if (input != null) {
                reader.open(input);
            }
            while (reader.hasNext()) {
                Event event = reader.next();
                switch (event.getType()) {
                    case START_XLIFF: {
                        this.docData = event.getStartXliffData();
                        break;
                    }
                    case START_FILE: {
                        currentFile = new FileNode(event.getStartFileData());
                        this.files.put(currentFile.getStartData().getId(), currentFile);
                        break;
                    }
                    case MID_FILE: {
                        currentFile.setMidData(event.getMidFileData());
                        break;
                    }
                    case END_FILE: {
                        currentFile = null;
                        break;
                    }
                    case SKELETON: {
                        currentFile.setSkeletonData(event.getSkeletonData());
                        break;
                    }
                    case START_GROUP: {
                        if (currentGroup == null) {
                            currentGroup = currentFile.add(new GroupNode(null, event.getStartGroupData()));
                            break;
                        }
                        currentGroup = currentGroup.add(new GroupNode(currentGroup, event.getStartGroupData()));
                        break;
                    }
                    case END_GROUP: {
                        currentGroup = currentGroup.getParent();
                        break;
                    }
                    case TEXT_UNIT: {
                        if (currentGroup == null) {
                            currentFile.add(new UnitNode(event.getUnit()));
                            break;
                        }
                        currentGroup.add(new UnitNode(event.getUnit()));
                        break;
                    }
                    case INSIGNIFICANT_PART: {
                        break;
                    }
                }
            }
        }
    }

    public void saveAs(File outputFile) {
        try {
            this.save(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)), StandardCharsets.UTF_8));
            this.docFile = outputFile;
        }
        catch (Throwable e) {
            throw new XLIFFWriterException("Cannot save the document.", e);
        }
    }

    public void save() {
        try {
            if (this.docFile == null) {
                throw new XLIFFWriterException("No file specified (use saveAs() instead).");
            }
            this.save(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.docFile)), StandardCharsets.UTF_8));
        }
        catch (Throwable e) {
            throw new XLIFFWriterException("Cannot save the document.", e);
        }
    }

    public void save(Writer outputWriter) {
        try (XLIFFWriter writer = new XLIFFWriter();){
            writer.setLineBreak(this.lb);
            writer.create(outputWriter, null, null);
            Iterator<Event> iter = this.createEventIterator();
            while (iter.hasNext()) {
                writer.writeEvent(iter.next());
            }
        }
    }

    public StartXliffData getStartXliffData() {
        return this.docData;
    }

    public FileNode getFileNode(String id) {
        return this.files.get(id);
    }

    public List<String> getFileNodeIds() {
        return new ArrayList<String>(this.files.keySet());
    }

    public GroupNode getGroupNode(String fileId, String groupId) {
        FileNode fn = this.files.get(fileId);
        if (fn == null) {
            return null;
        }
        return fn.getGroupNode(groupId);
    }

    public UnitNode getUnitNode(String fileId, String unitId) {
        FileNode fn = this.files.get(fileId);
        if (fn == null) {
            return null;
        }
        return fn.getUnitNode(unitId);
    }

    public Iterator<Event> createEventIterator() {
        EventIterator ei = new EventIterator(){
            private Iterator<FileNode> fileIter;
            private Iterator<Event> eventIter;
            private int state;
            {
                this.fileIter = XLIFFDocument.this.files.values().iterator();
                this.eventIter = null;
                this.state = 0;
            }

            @Override
            public boolean hasNext() {
                switch (this.state) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return true;
                    }
                    case 5: {
                        return true;
                    }
                    case -1: {
                        return false;
                    }
                }
                if (this.eventIter != null) {
                    if (this.eventIter.hasNext()) {
                        return true;
                    }
                    this.eventIter = null;
                }
                if (this.fileIter.hasNext()) {
                    this.eventIter = this.fileIter.next().createEventIterator(this.uriContext);
                    this.eventIter.hasNext();
                    return true;
                }
                this.state = 4;
                return true;
            }

            @Override
            public Event next() {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        this.uriContext.push(new URIContext());
                        return new Event(EventType.START_DOCUMENT, null);
                    }
                    case 1: {
                        this.state = 2;
                        return new Event(EventType.START_XLIFF, null, XLIFFDocument.this.docData);
                    }
                    case 4: {
                        this.state = 5;
                        return new Event(EventType.END_XLIFF, null);
                    }
                    case 5: {
                        this.state = -1;
                        return new Event(EventType.END_DOCUMENT, null);
                    }
                }
                return this.eventIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove is not supported.");
            }
        };
        ei.setURIContext(new Stack<URIContext>());
        return ei;
    }

    public Object fetchReference(URIParser up) {
        String scope = up.getScope();
        if (scope.isEmpty()) {
            return null;
        }
        char refType = up.getRefType();
        Object obj = null;
        FileNode fn = null;
        block13: for (int i = 0; i < scope.length(); ++i) {
            switch (scope.charAt(i)) {
                case 'f': {
                    fn = this.getFileNode(up.getFileId());
                    if (fn == null) {
                        return null;
                    }
                    if (refType == 'f') {
                        return fn.getStartData();
                    }
                    if (up.getRefContainer() != 'f' || !(refType == 'n' ? (obj = URIContext.searchNotes(fn.getMidData(), up.getNoteId())) != null : refType == 'x' && (obj = URIContext.searchExtensions(fn.getMidData(), up.getExtensionInfo())) != null)) continue block13;
                    return obj;
                }
                case 'g': {
                    GroupNode gn = fn.getGroupNode(up.getGroupId());
                    if (gn == null) {
                        return null;
                    }
                    if (refType == 'g') {
                        return gn.get();
                    }
                    if (up.getRefContainer() != 'g' || !(refType == 'n' ? (obj = URIContext.searchNotes(gn.get(), up.getNoteId())) != null : refType == 'x' && (obj = URIContext.searchExtensions(gn.get(), up.getExtensionInfo())) != null)) continue block13;
                    return obj;
                }
                case 'u': {
                    UnitNode un = fn.getUnitNode(up.getUnitId());
                    if (un == null) {
                        return null;
                    }
                    switch (refType) {
                        case 'u': {
                            return un.get();
                        }
                        case 's': {
                            obj = URIContext.searchInlineSource(un.get(), up.getSourceInlineId());
                            if (obj == null) break;
                            return obj;
                        }
                        case 't': {
                            obj = URIContext.searchInlineTarget(un.get(), up.getTargetInlineId());
                            if (obj == null) break;
                            return obj;
                        }
                        case 'n': {
                            if (up.getRefContainer() != 'u' || (obj = URIContext.searchNotes(un.get(), up.getNoteId())) == null) break;
                            return obj;
                        }
                        case 'x': {
                            if (up.getRefContainer() != 'u' || (obj = URIContext.searchUnit(un.get(), up.getExtensionInfo())) == null) break;
                            return obj;
                        }
                        case 'd': {
                            obj = URIContext.searchData(un.get(), up.getDataId());
                            if (obj == null) break;
                            return obj;
                        }
                    }
                    continue block13;
                }
            }
        }
        return null;
    }

    public List<Unit> getUnits() {
        ArrayList<Unit> list = new ArrayList<Unit>();
        Iterator<Event> iter = this.createEventIterator();
        while (iter.hasNext()) {
            Event event = iter.next();
            if (!event.isUnit()) continue;
            list.add(event.getUnit());
        }
        return list;
    }

    public File getFile() {
        return this.docFile;
    }

    public void setLineBreak(String lineBreak) {
        this.lb = lineBreak;
    }
}

